/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.maven;

import java.io.File;
import org.apache.maven.plugins.annotations.Parameter;
import org.spdx.maven.ArtifactOf;
import org.spdx.maven.SpdxDefaultFileInformation;
import org.spdx.rdfparser.license.AnyLicenseInfo;
import org.spdx.rdfparser.license.LicenseInfoFactory;
import org.spdx.rdfparser.model.DoapProject;
import org.spdx.spdxspreadsheet.InvalidLicenseStringException;

public class PathSpecificSpdxInfo {
    @Parameter(required=true)
    File directoryOrFile;
    @Parameter
    private String fileComment;
    @Parameter
    private String[] fileContributors;
    @Parameter
    private String fileCopyright;
    @Parameter
    private String fileLicenseComment;
    @Parameter
    private String fileNotice;
    @Parameter
    private String fileConcludedLicense;
    @Parameter
    private String licenseInformationInFile;
    @Parameter
    private ArtifactOf[] fileArtifactOfs;

    public SpdxDefaultFileInformation getDefaultFileInformation(SpdxDefaultFileInformation defaults) throws InvalidLicenseStringException {
        SpdxDefaultFileInformation retval = new SpdxDefaultFileInformation();
        if (this.fileArtifactOfs != null) {
            DoapProject[] artifactOfs = new DoapProject[this.fileArtifactOfs.length];
            for (int i = 0; i < artifactOfs.length; ++i) {
                artifactOfs[i] = new DoapProject(this.fileArtifactOfs[i].getName(), this.fileArtifactOfs[i].getHomePage().toString());
            }
            retval.setArtifactOf(artifactOfs);
        } else {
            retval.setArtifactOf(defaults.getArtifactOf());
        }
        if (this.fileComment != null) {
            retval.setComment(this.fileComment);
        } else {
            retval.setComment(defaults.getComment());
        }
        if (this.fileConcludedLicense != null) {
            AnyLicenseInfo concludedLicense = null;
            concludedLicense = LicenseInfoFactory.parseSPDXLicenseString((String)this.fileConcludedLicense.trim());
            retval.setConcludedLicense(concludedLicense);
        } else {
            retval.setConcludedLicense(defaults.getConcludedLicense());
        }
        if (this.fileContributors != null) {
            retval.setContributors(this.fileContributors);
        } else {
            retval.setContributors(defaults.getContributors());
        }
        if (this.fileCopyright != null) {
            retval.setCopyright(this.fileCopyright);
        } else {
            retval.setCopyright(defaults.getCopyright());
        }
        if (this.fileLicenseComment != null) {
            retval.setLicenseComment(this.fileLicenseComment);
        } else {
            retval.setLicenseComment(defaults.getLicenseComment());
        }
        if (this.fileNotice != null) {
            retval.setNotice(this.fileNotice);
        } else {
            retval.setNotice(defaults.getNotice());
        }
        if (this.licenseInformationInFile != null) {
            AnyLicenseInfo declaredLicense = null;
            declaredLicense = LicenseInfoFactory.parseSPDXLicenseString((String)this.licenseInformationInFile.trim());
            retval.setDeclaredLicense(declaredLicense);
        } else {
            retval.setDeclaredLicense(defaults.getDeclaredLicense());
        }
        return retval;
    }

    public String getPath() {
        return this.directoryOrFile.getPath();
    }
}

