/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.maven;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Contributor;
import org.apache.maven.model.License;
import org.apache.maven.model.Model;
import org.apache.maven.model.Resource;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.shared.model.fileset.FileSet;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.spdx.maven.LicenseManager;
import org.spdx.maven.LicenseManagerException;
import org.spdx.maven.LicenseMapperException;
import org.spdx.maven.MavenToSpdxLicenseMapper;
import org.spdx.maven.SpdxCollectionException;
import org.spdx.maven.SpdxDefaultFileInformation;
import org.spdx.maven.SpdxFileCollector;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.SPDXDocumentFactory;
import org.spdx.rdfparser.SpdxPackageVerificationCode;
import org.spdx.rdfparser.license.AnyLicenseInfo;
import org.spdx.rdfparser.license.SpdxNoAssertionLicense;
import org.spdx.rdfparser.model.Checksum;
import org.spdx.rdfparser.model.DoapProject;
import org.spdx.rdfparser.model.ExternalDocumentRef;
import org.spdx.rdfparser.model.ExternalSpdxElement;
import org.spdx.rdfparser.model.Relationship;
import org.spdx.rdfparser.model.SpdxDocument;
import org.spdx.rdfparser.model.SpdxElement;
import org.spdx.rdfparser.model.SpdxFile;
import org.spdx.rdfparser.model.SpdxItem;
import org.spdx.rdfparser.model.SpdxPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpdxDependencyInformation {
    private Log log;
    private List<Relationship> relationships = new ArrayList<Relationship>();
    private Map<String, ExternalDocumentRef> externalDocuments = new HashMap<String, ExternalDocumentRef>();
    private LicenseManager licenseManager;

    public SpdxDependencyInformation(Log log, LicenseManager licenseManager) {
        this.log = log;
        this.licenseManager = licenseManager;
    }

    public void addMavenDependency(Artifact dependency) throws LicenseMapperException {
        String scope = dependency.getScope();
        Relationship.RelationshipType relType = this.scopeToRelationshipType(scope, dependency.isOptional());
        if (relType == Relationship.RelationshipType.relationshipType_other) {
            this.log.warn((CharSequence)("Could not determine the SPDX relationship type for dependency artifact ID " + dependency.getArtifactId() + " scope " + scope));
        }
        SpdxElement dependencyPackage = this.createSpdxPackage(dependency);
        Relationship relationship = new Relationship(dependencyPackage, relType, "Relationship based on Maven POM file dependency information");
        this.relationships.add(relationship);
    }

    private Relationship.RelationshipType scopeToRelationshipType(String scope, boolean optional) {
        if (scope == null) {
            return Relationship.RelationshipType.relationshipType_other;
        }
        if (optional) {
            return Relationship.RelationshipType.relationshipType_optionalComponentOf;
        }
        if (scope.equals("compile") || scope.equals("runtime")) {
            return Relationship.RelationshipType.relationshipType_dynamicLink;
        }
        if (scope.equals("test")) {
            return Relationship.RelationshipType.relationshipType_testcaseOf;
        }
        return Relationship.RelationshipType.relationshipType_other;
    }

    private SpdxElement createSpdxPackage(Artifact artifact) throws LicenseMapperException {
        File spdxFile = this.artifactFileToSpdxFile(artifact.getFile());
        this.log.debug((CharSequence)("Dependency " + artifact.getArtifactId() + "Looking for SPDX file " + spdxFile.getAbsolutePath()));
        if (spdxFile != null && spdxFile.exists()) {
            try {
                this.log.debug((CharSequence)("Dependency " + artifact.getArtifactId() + "Dependency information collected from SPDX file " + spdxFile.getAbsolutePath()));
                SpdxDocument spdxDoc = SPDXDocumentFactory.createSpdxDocument((String)spdxFile.getPath());
                return this.createExternalSpdxPackageReference(spdxDoc, spdxFile, "DocumentRef-" + artifact.getArtifactId());
            }
            catch (IOException e) {
                this.log.error((CharSequence)("IO error reading SPDX document for dependency artifact ID " + artifact.getArtifactId() + ":" + e.getMessage() + ".  Using POM file information for creating SPDX package data."));
            }
            catch (InvalidSPDXAnalysisException e) {
                this.log.error((CharSequence)("Invalid SPDX analysis exception reading SPDX document for dependency artifact ID " + artifact.getArtifactId() + ":" + e.getMessage() + ".  Using POM file information for creating SPDX package data."));
            }
            catch (SpdxCollectionException e) {
                this.log.error((CharSequence)("Unable to create file checksum for external SPDX document for dependency artifact ID " + artifact.getArtifactId() + ":" + e.getMessage() + ".  Using POM file information for creating SPDX package data."));
            }
        }
        File pomFile = this.artifactFileToPomFile(artifact.getFile());
        this.log.debug((CharSequence)("Dependency " + artifact.getArtifactId() + "Looking for POM file " + pomFile.getAbsolutePath()));
        if (pomFile != null && pomFile.exists()) {
            try {
                this.log.debug((CharSequence)("Dependency " + artifact.getArtifactId() + "Collecting information from POM file " + pomFile.getAbsolutePath()));
                return this.createSpdxPackage(pomFile);
            }
            catch (IOException e) {
                this.log.error((CharSequence)("IO Error reading POM file for dependency artifact ID " + artifact.getArtifactId() + ":" + e.getMessage()));
            }
            catch (XmlPullParserException e) {
                this.log.error((CharSequence)("Parser Error reading POM file for dependency artifact ID " + artifact.getArtifactId() + ":" + e.getMessage()));
            }
            catch (SpdxCollectionException e) {
                this.log.error((CharSequence)("SPDX File Collection Error reading POM file for dependency artifact ID " + artifact.getArtifactId() + ":" + e.getMessage()));
            }
            catch (NoSuchAlgorithmException e) {
                this.log.error((CharSequence)("Verification Code Error reading POM file for dependency artifact ID " + artifact.getArtifactId() + ":" + e.getMessage()));
            }
            this.log.warn((CharSequence)("No POM file found for dependency artifact ID " + artifact.getArtifactId() + ".  A minimal SPDX package will be created."));
        }
        this.log.debug((CharSequence)("Dependency " + artifact.getArtifactId() + "Using only artifact information to create dependent package"));
        SpdxPackage pkg = new SpdxPackage(artifact.getArtifactId(), (AnyLicenseInfo)new SpdxNoAssertionLicense(), new AnyLicenseInfo[]{new SpdxNoAssertionLicense()}, "UNSPECIFIED", (AnyLicenseInfo)new SpdxNoAssertionLicense(), "NOASSERTION", new SpdxFile[0], new SpdxPackageVerificationCode("cf23df2207d99a74fbe169e3eba035e633b65d94", new String[0]));
        pkg.setComment("This package was created for a Maven dependency.  No SPDX or license information could be found in the Maven POM file.");
        pkg.setVersionInfo(artifact.getBaseVersion());
        return pkg;
    }

    private SpdxElement createExternalSpdxPackageReference(SpdxDocument spdxDoc, File spdxFile, String externalRefId) throws SpdxCollectionException, InvalidSPDXAnalysisException {
        SpdxItem[] describedItems;
        ExternalDocumentRef externalRef = this.externalDocuments.get(this.fixExternalRefId(externalRefId));
        if (externalRef == null) {
            String sha1 = SpdxFileCollector.generateSha1(spdxFile);
            Checksum cksum = new Checksum(Checksum.ChecksumAlgorithm.checksumAlgorithm_sha1, sha1);
            externalRef = new ExternalDocumentRef(spdxDoc, cksum, externalRefId);
            this.externalDocuments.put(externalRefId, externalRef);
        }
        if ((describedItems = spdxDoc.getDocumentDescribes()) == null || describedItems.length == 0) {
            throw new InvalidSPDXAnalysisException("SPDX document does not contain any described items.");
        }
        SpdxItem itemDescribed = describedItems[0];
        if (describedItems.length > 1) {
            for (SpdxItem item : describedItems) {
                if (!(item instanceof SpdxPackage)) continue;
                itemDescribed = item;
                break;
            }
        }
        return new ExternalSpdxElement(externalRef + ":" + itemDescribed.getId());
    }

    private String fixExternalRefId(String externalRefId) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < externalRefId.length(); ++i) {
            if (this.validExternalRefIdChar(externalRefId.charAt(i))) {
                sb.append(externalRefId.charAt(i));
                continue;
            }
            sb.append("-");
        }
        return sb.toString();
    }

    private boolean validExternalRefIdChar(char ch) {
        return ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch == '.' || ch == '-';
    }

    private SpdxPackage createSpdxPackage(File pomFile) throws IOException, XmlPullParserException, SpdxCollectionException, NoSuchAlgorithmException, LicenseMapperException {
        MavenXpp3Reader pomReader = new MavenXpp3Reader();
        Model model = pomReader.read((Reader)ReaderFactory.newXmlReader((File)pomFile));
        SpdxDefaultFileInformation fileInfo = new SpdxDefaultFileInformation();
        String packageName = model.getName();
        if (packageName == null || packageName.isEmpty()) {
            packageName = model.getArtifactId();
        }
        List contributors = model.getContributors();
        ArrayList<String> fileContributorList = new ArrayList<String>();
        if (contributors != null) {
            for (Contributor contributor : contributors) {
                fileContributorList.add(contributor.getName());
            }
        }
        String copyright = "UNSPECIFIED";
        String notice = "UNSPECIFIED";
        String downloadLocation = "NOASSERTION";
        AnyLicenseInfo declaredLicense = this.mavenLicensesToSpdxLicense(model.getLicenses());
        fileInfo.setArtifactOf(new DoapProject[0]);
        fileInfo.setComment("");
        fileInfo.setConcludedLicense((AnyLicenseInfo)new SpdxNoAssertionLicense());
        fileInfo.setContributors(fileContributorList.toArray(new String[fileContributorList.size()]));
        fileInfo.setCopyright(copyright);
        fileInfo.setDeclaredLicense(declaredLicense);
        fileInfo.setLicenseComment("");
        fileInfo.setNotice(notice);
        SpdxPackage retval = new SpdxPackage(packageName, (AnyLicenseInfo)new SpdxNoAssertionLicense(), new AnyLicenseInfo[]{new SpdxNoAssertionLicense()}, copyright, declaredLicense, downloadLocation, new SpdxFile[0], new SpdxPackageVerificationCode("cf23df2207d99a74fbe169e3eba035e633b65d94", new String[0]));
        if (model.getVersion() != null) {
            retval.setVersionInfo(model.getVersion());
        }
        if (model.getDescription() != null) {
            retval.setDescription(model.getDescription());
            retval.setSummary(model.getDescription());
        }
        if (model.getOrganization() != null) {
            retval.setOriginator("Organization:" + model.getOrganization().getName());
        }
        if (model.getUrl() != null) {
            retval.setHomepage(model.getUrl());
        }
        return retval;
    }

    private AnyLicenseInfo mavenLicensesToSpdxLicense(List<License> mavenLicenses) throws LicenseMapperException {
        try {
            return this.licenseManager.mavenLicenseListToSpdxLicense(mavenLicenses);
        }
        catch (LicenseManagerException ex) {
            return MavenToSpdxLicenseMapper.getInstance(this.log).mavenLicenseListToSpdxLicense(mavenLicenses);
        }
    }

    private FileSet[] getIncludedDirectoriesFromModel(Model model) {
        List resourceList;
        ArrayList<FileSet> result = new ArrayList<FileSet>();
        String sourcePath = model.getBuild().getSourceDirectory();
        if (sourcePath != null && !sourcePath.isEmpty()) {
            FileSet srcFileSet = new FileSet();
            File sourceDir = new File(sourcePath);
            srcFileSet.setDirectory(sourceDir.getAbsolutePath());
            srcFileSet.addInclude("**/*");
            result.add(srcFileSet);
        }
        if ((resourceList = model.getBuild().getResources()) != null) {
            for (Resource resource : resourceList) {
                FileSet resourceFileSet = new FileSet();
                File resourceDir = new File(resource.getDirectory());
                resourceFileSet.setDirectory(resourceDir.getAbsolutePath());
                resourceFileSet.setExcludes(resource.getExcludes());
                resourceFileSet.setIncludes(resource.getIncludes());
                result.add(resourceFileSet);
            }
        }
        return result.toArray(new FileSet[result.size()]);
    }

    private File artifactFileToSpdxFile(File file) {
        return this.getFileWithDifferentType(file, "spdx");
    }

    private File getFileWithDifferentType(File file, String type) {
        String filePath = file.getAbsolutePath();
        int indexOfDot = filePath.lastIndexOf(46);
        if (indexOfDot > 0) {
            filePath = filePath.substring(0, indexOfDot + 1);
        }
        filePath = filePath + type;
        File retval = new File(filePath);
        return retval;
    }

    private File artifactFileToPomFile(File file) {
        return this.getFileWithDifferentType(file, "pom");
    }

    public List<Relationship> getPackageRelationships() {
        return this.relationships;
    }

    public Collection<ExternalDocumentRef> getDocumentExternalReferences() {
        return this.externalDocuments.values();
    }
}

