/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.maven;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.shared.model.fileset.FileSet;
import org.apache.maven.shared.model.fileset.util.FileSetManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spdx.maven.SpdxCollectionException;
import org.spdx.maven.SpdxDefaultFileInformation;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.SpdxPackageVerificationCode;
import org.spdx.rdfparser.license.AnyLicenseInfo;
import org.spdx.rdfparser.model.DoapProject;
import org.spdx.rdfparser.model.Relationship;
import org.spdx.rdfparser.model.SpdxElement;
import org.spdx.rdfparser.model.SpdxFile;
import org.spdx.rdfparser.model.SpdxPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpdxFileCollector {
    static Logger logger = LoggerFactory.getLogger(SpdxFileCollector.class);
    static HashSet<String> SOURCE_EXTENSIONS = new HashSet();
    static HashSet<String> BINARY_EXTENSIONS = new HashSet();
    static HashSet<String> ARCHIVE_EXTENSIONS = new HashSet();
    static final String SPDX_FILE_TYPE_CONSTANTS_PROP_PATH = "resources/SpdxFileTypeConstants.prop";
    static final String SPDX_PROP_FILETYPE_SOURCE = "SpdxSourceExtensions";
    static final String SPDX_PROP_FILETYPE_BINARY = "SpdxBinaryExtensions";
    static final String SPDX_PROP_FILETYPE_ARCHIVE = "SpdxArchiveExtensions";
    static final String SHA1_ALGORITHM = "SHA-1";
    static final String PACKAGE_VERIFICATION_CHARSET = "UTF-8";
    private static MessageDigest digest;
    Set<AnyLicenseInfo> licensesFromFiles = new HashSet<AnyLicenseInfo>();
    Map<String, SpdxFile> spdxFiles = new HashMap<String, SpdxFile>();
    FileSetManager fileSetManager = new FileSetManager();
    private Log log;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadFileExtensionConstants() {
        InputStream is = null;
        Properties prop = new Properties();
        try {
            is = SpdxFileCollector.class.getClassLoader().getResourceAsStream(SPDX_FILE_TYPE_CONSTANTS_PROP_PATH);
            if (is == null) {
                logger.error("Unable to load properties file resources/SpdxFileTypeConstants.prop");
            }
            prop.load(is);
            String sourceExtensionStr = prop.getProperty(SPDX_PROP_FILETYPE_SOURCE);
            SpdxFileCollector.loadSetUpcase(SOURCE_EXTENSIONS, sourceExtensionStr);
            String binaryExtensionStr = prop.getProperty(SPDX_PROP_FILETYPE_BINARY);
            SpdxFileCollector.loadSetUpcase(BINARY_EXTENSIONS, binaryExtensionStr);
            String archiveExtensionStr = prop.getProperty(SPDX_PROP_FILETYPE_ARCHIVE);
            SpdxFileCollector.loadSetUpcase(ARCHIVE_EXTENSIONS, archiveExtensionStr);
        }
        catch (IOException e) {
            logger.warn("WARNING: Error reading SpdxFileTypeConstants properties file.  All file types will be mapped to Other.");
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Throwable e) {
                logger.warn("WARNING: Error closing SpdxFileTypeConstants properties file");
            }
        }
    }

    private static void loadSetUpcase(Set<String> set, String str) {
        String[] values = str.split(",");
        for (int i = 0; i < values.length; ++i) {
            set.add(values[i].toUpperCase().trim());
        }
    }

    public void collectFiles(FileSet[] fileSets, String baseDir, SpdxDefaultFileInformation defaultFileInformation, Map<String, SpdxDefaultFileInformation> pathSpecificInformation, SpdxPackage projectPackage, Relationship.RelationshipType relationshipType) throws SpdxCollectionException {
        for (int i = 0; i < fileSets.length; ++i) {
            String[] includedFiles = this.fileSetManager.getIncludedFiles(fileSets[i]);
            for (int j = 0; j < includedFiles.length; ++j) {
                String filePath = fileSets[i].getDirectory() + File.separator + includedFiles[j];
                SpdxDefaultFileInformation fileInfo = this.findDefaultFileInformation(filePath, pathSpecificInformation);
                if (fileInfo == null) {
                    fileInfo = defaultFileInformation;
                }
                File file = new File(filePath);
                String outputFileName = fileSets[i].getOutputDirectory() != null ? fileSets[i].getOutputDirectory() + File.separator + includedFiles[j] : file.getAbsolutePath().substring(baseDir.length() + 1);
                this.collectFile(file, outputFileName, fileInfo, relationshipType, projectPackage);
            }
        }
    }

    private SpdxDefaultFileInformation findDefaultFileInformation(String filePath, Map<String, SpdxDefaultFileInformation> pathSpecificInformation) {
        SpdxDefaultFileInformation retval = pathSpecificInformation.get(filePath);
        if (retval != null) {
            this.debug("Found file path for path specific information.  File comment: " + retval.getComment());
            return retval;
        }
        String parentPath = filePath;
        int parentPathIndex = 0;
        do {
            if ((parentPathIndex = parentPath.lastIndexOf(File.separator)) <= 0) continue;
            parentPath = parentPath.substring(0, parentPathIndex);
            retval = pathSpecificInformation.get(parentPath);
        } while (retval == null && parentPathIndex > 0);
        if (retval != null) {
            this.debug("Found file path for path specific information.  File comment: " + retval.getComment());
        }
        return retval;
    }

    private void debug(String msg) {
        if (this.getLog() != null) {
            this.getLog().debug((CharSequence)msg);
        } else {
            logger.debug(msg);
        }
    }

    private void collectFile(File file, String outputFileName, SpdxDefaultFileInformation fileInfo, Relationship.RelationshipType relationshipType, SpdxPackage projectPackage) throws SpdxCollectionException {
        if (this.spdxFiles.containsKey(file.getPath())) {
            return;
        }
        SpdxFile spdxFile = this.convertToSpdxFile(file, outputFileName, fileInfo);
        Relationship relationship = new Relationship((SpdxElement)projectPackage, relationshipType, "");
        try {
            spdxFile.addRelationship(relationship);
        }
        catch (InvalidSPDXAnalysisException e) {
            this.log.error((CharSequence)("Spdx exception creating file relationship: " + e.getMessage()), (Throwable)e);
            throw new SpdxCollectionException("Error creating SPDX file relationship: " + e.getMessage());
        }
        this.spdxFiles.put(file.getPath(), spdxFile);
        AnyLicenseInfo[] licenseInfoFromFiles = spdxFile.getLicenseInfoFromFiles();
        for (int j = 0; j < licenseInfoFromFiles.length; ++j) {
            this.licensesFromFiles.add(licenseInfoFromFiles[j]);
        }
    }

    private SpdxFile convertToSpdxFile(File file, String outputFileName, SpdxDefaultFileInformation defaultFileInformation) throws SpdxCollectionException {
        String relativePath = this.convertFilePathToSpdxFileName(outputFileName);
        SpdxFile.FileType[] fileTypes = new SpdxFile.FileType[]{SpdxFileCollector.extensionToFileType(this.getExtension(file))};
        String sha1 = SpdxFileCollector.generateSha1(file);
        AnyLicenseInfo license = defaultFileInformation.getDeclaredLicense();
        String copyright = defaultFileInformation.getCopyright();
        String notice = defaultFileInformation.getNotice();
        String comment = defaultFileInformation.getComment();
        String[] contributors = defaultFileInformation.getContributors();
        DoapProject[] artifactOf = defaultFileInformation.getArtifactOf();
        AnyLicenseInfo concludedLicense = defaultFileInformation.getConcludedLicense();
        String licenseComment = defaultFileInformation.getLicenseComment();
        SpdxFile retval = null;
        try {
            retval = new SpdxFile(relativePath, fileTypes, sha1, concludedLicense, new AnyLicenseInfo[]{license}, licenseComment, copyright, artifactOf, comment);
            retval.setFileContributors(contributors);
            retval.setNoticeText(notice);
        }
        catch (InvalidSPDXAnalysisException e) {
            this.log.error((CharSequence)("Spdx exception creating file: " + e.getMessage()), (Throwable)e);
            throw new SpdxCollectionException("Error creating SPDX file: " + e.getMessage());
        }
        return retval;
    }

    public String convertFilePathToSpdxFileName(String filePath) {
        String result = filePath.replace('\\', '/');
        if (!result.startsWith("./")) {
            result = "./" + result;
        }
        return result;
    }

    public String getExtension(File file) {
        String fileName = file.getName();
        int lastDot = fileName.lastIndexOf(46);
        if (lastDot < 1) {
            return "";
        }
        return fileName.substring(lastDot + 1);
    }

    private static SpdxFile.FileType extensionToFileType(String fileExtension) {
        if (fileExtension == null) {
            return SpdxFile.FileType.fileType_other;
        }
        String upperExtension = fileExtension.toUpperCase();
        if (SOURCE_EXTENSIONS.contains(upperExtension)) {
            return SpdxFile.FileType.fileType_source;
        }
        if (BINARY_EXTENSIONS.contains(upperExtension)) {
            return SpdxFile.FileType.fileType_binary;
        }
        if (ARCHIVE_EXTENSIONS.contains(upperExtension)) {
            return SpdxFile.FileType.fileType_archive;
        }
        return SpdxFile.FileType.fileType_other;
    }

    public SpdxFile[] getFiles() {
        return this.spdxFiles.values().toArray(new SpdxFile[this.spdxFiles.size()]);
    }

    public AnyLicenseInfo[] getLicenseInfoFromFiles() {
        return this.licensesFromFiles.toArray(new AnyLicenseInfo[this.licensesFromFiles.size()]);
    }

    public SpdxPackageVerificationCode getVerificationCode(String spdxFilePath) throws NoSuchAlgorithmException {
        ArrayList<String> excludedFileNamesFromVerificationCode = new ArrayList<String>();
        if (spdxFilePath != null && this.spdxFiles.containsKey(spdxFilePath)) {
            excludedFileNamesFromVerificationCode.add(this.spdxFiles.get(spdxFilePath).getName());
        }
        SpdxPackageVerificationCode verificationCode = this.calculatePackageVerificationCode(this.spdxFiles.values(), excludedFileNamesFromVerificationCode);
        return verificationCode;
    }

    private SpdxPackageVerificationCode calculatePackageVerificationCode(Collection<SpdxFile> spdxFiles, ArrayList<String> excludedFileNamesFromVerificationCode) throws NoSuchAlgorithmException {
        ArrayList<String> fileChecksums = new ArrayList<String>();
        for (SpdxFile file : spdxFiles) {
            if (!this.includeInVerificationCode(file.getName(), excludedFileNamesFromVerificationCode)) continue;
            fileChecksums.add(file.getSha1());
        }
        Collections.sort(fileChecksums);
        MessageDigest verificationCodeDigest = MessageDigest.getInstance(SHA1_ALGORITHM);
        for (int i = 0; i < fileChecksums.size(); ++i) {
            byte[] hashInput = ((String)fileChecksums.get(i)).getBytes(Charset.forName(PACKAGE_VERIFICATION_CHARSET));
            verificationCodeDigest.update(hashInput);
        }
        String value = SpdxFileCollector.convertChecksumToString(verificationCodeDigest.digest());
        return new SpdxPackageVerificationCode(value, excludedFileNamesFromVerificationCode.toArray(new String[excludedFileNamesFromVerificationCode.size()]));
    }

    private boolean includeInVerificationCode(String name, ArrayList<String> excludedFileNamesFromVerificationCode) {
        for (int i = 0; i < excludedFileNamesFromVerificationCode.size(); ++i) {
            if (!excludedFileNamesFromVerificationCode.get(i).equals(name)) continue;
            return false;
        }
        return true;
    }

    public static String convertChecksumToString(byte[] digestBytes) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < digestBytes.length; ++i) {
            String hex = Integer.toHexString(0xFF & digestBytes[i]);
            if (hex.length() < 2) {
                sb.append('0');
            }
            sb.append(hex);
        }
        return sb.toString();
    }

    public static String generateSha1(File file) throws SpdxCollectionException {
        FileInputStream in;
        if (digest == null) {
            try {
                digest = MessageDigest.getInstance(SHA1_ALGORITHM);
            }
            catch (NoSuchAlgorithmException e) {
                throw new SpdxCollectionException("Unable to create the message digest for generating the File SHA1");
            }
        }
        digest.reset();
        try {
            in = new FileInputStream(file);
        }
        catch (IOException e1) {
            throw new SpdxCollectionException("IO getting file content while calculating the SHA1");
        }
        try {
            byte[] buffer = new byte[2048];
            int numBytes = ((InputStream)in).read(buffer);
            while (numBytes >= 0) {
                digest.update(buffer, 0, numBytes);
                numBytes = ((InputStream)in).read(buffer);
            }
            String string = SpdxFileCollector.convertChecksumToString(digest.digest());
            return string;
        }
        catch (IOException e) {
            throw new SpdxCollectionException("IO error reading file input stream while calculating the SHA1");
        }
        finally {
            try {
                if (in != null) {
                    ((InputStream)in).close();
                }
            }
            catch (IOException e) {
                throw new SpdxCollectionException("IO error closing file input stream while calculating the SHA1");
            }
        }
    }

    public void setLog(Log log) {
        this.log = log;
    }

    private Log getLog() {
        return this.log;
    }

    static {
        SpdxFileCollector.loadFileExtensionConstants();
        try {
            digest = MessageDigest.getInstance(SHA1_ALGORITHM);
        }
        catch (NoSuchAlgorithmException e) {
            logger.error("No such algorithm error initializing the SPDX file collector - SHA1", (Throwable)e);
            digest = null;
        }
    }
}

