/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.maven;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.model.License;
import org.apache.maven.plugin.logging.Log;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.spdx.maven.LicenseManager;
import org.spdx.maven.LicenseMapperException;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.license.AnyLicenseInfo;
import org.spdx.rdfparser.license.ConjunctiveLicenseSet;
import org.spdx.rdfparser.license.LicenseInfoFactory;
import org.spdx.rdfparser.license.SpdxListedLicense;
import org.spdx.rdfparser.license.SpdxNoAssertionLicense;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenToSpdxLicenseMapper {
    private static final String SPDX_LICENSE_URL_PREFIX = "http://spdx.org/licenses/";
    private static final String LISTED_LICENSE_JSON_URL = "http://spdx.org/licenses/licenses.json";
    private static final String LISTED_LICENSE_JSON_PATH = "resources/licenses.json";
    static MavenToSpdxLicenseMapper instance;
    private Map<String, String> urlStringToSpdxLicenseId;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MavenToSpdxLicenseMapper(Log log) throws LicenseMapperException {
        InputStream is;
        block10: {
            is = null;
            try {
                URL uRL = new URL(LISTED_LICENSE_JSON_URL);
            }
            catch (MalformedURLException e) {
                if (log == null) break block10;
                log.warn((CharSequence)"Invalid JSON URL for SPDX listed licenses.  Using cached version");
            }
        }
        if (is == null) {
            is = LicenseManager.class.getClassLoader().getResourceAsStream(LISTED_LICENSE_JSON_PATH);
        }
        InputStreamReader reader = new InputStreamReader(is);
        try {
            this.initializeUrlMap(reader, log);
        }
        finally {
            block12: {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    if (log == null) break block12;
                    log.warn((CharSequence)("IO error closing listed license reader: " + e.getMessage()));
                }
            }
        }
    }

    public static MavenToSpdxLicenseMapper getInstance(Log log) throws LicenseMapperException {
        if (instance == null) {
            instance = new MavenToSpdxLicenseMapper(log);
        }
        return instance;
    }

    public String urlToSpdxId(String url) {
        return this.urlStringToSpdxLicenseId.get(url);
    }

    private void initializeUrlMap(Reader jsonReader, Log log) throws LicenseMapperException {
        JSONParser parser = new JSONParser();
        Object parsedObject = null;
        try {
            parsedObject = parser.parse(jsonReader);
        }
        catch (IOException e1) {
            if (log != null) {
                log.error((CharSequence)("I/O error parsing listed licenses JSON file: " + e1.getMessage()));
            }
            throw new LicenseMapperException("I/O Error parsing listed licenses");
        }
        catch (ParseException e1) {
            if (log != null) {
                log.error((CharSequence)("JSON parsing error parsing listed licenses JSON file: " + e1.getMessage()));
            }
            throw new LicenseMapperException("JSON parsing error parsing listed licenses");
        }
        JSONObject listedLicenseSource = (JSONObject)parsedObject;
        JSONArray listedLicenses = (JSONArray)listedLicenseSource.get((Object)"licenses");
        this.urlStringToSpdxLicenseId = new HashMap<String, String>();
        ArrayList<String> urlsWithMultipleIds = new ArrayList<String>();
        for (int i = 0; i < listedLicenses.size(); ++i) {
            JSONObject listedLicense = (JSONObject)listedLicenses.get(i);
            String licenseId = (String)listedLicense.get((Object)"licenseId");
            this.urlStringToSpdxLicenseId.put(SPDX_LICENSE_URL_PREFIX + licenseId, licenseId);
            JSONArray urls = (JSONArray)listedLicense.get((Object)"seeAlso");
            if (urls == null) continue;
            for (int j = 0; j < urls.size(); ++j) {
                String url = (String)urls.get(j);
                if (this.urlStringToSpdxLicenseId.containsKey(url)) {
                    urlsWithMultipleIds.add(url);
                    continue;
                }
                this.urlStringToSpdxLicenseId.put(url, licenseId);
            }
        }
        for (String redundantUrl : urlsWithMultipleIds) {
            this.urlStringToSpdxLicenseId.remove(redundantUrl);
        }
        this.addManualMappings();
    }

    private void addManualMappings() {
        this.urlStringToSpdxLicenseId.put("http://www.apache.org/licenses/LICENSE-2.0.txt", "Apache-2.0");
        this.urlStringToSpdxLicenseId.put("http://www.opensource.org/licenses/cpl1.0.txt", "CPL-1.0");
        this.urlStringToSpdxLicenseId.put("http://www.opensource.org/licenses/mit-license.php", "MIT");
        this.urlStringToSpdxLicenseId.put("http://www.mozilla.org/MPL/MPL-1.0.txt", "MPL-1.0");
    }

    public AnyLicenseInfo mavenLicenseListToSpdxLicense(List<License> licenseList) {
        if (licenseList == null) {
            return new SpdxNoAssertionLicense();
        }
        ArrayList<SpdxListedLicense> spdxLicenses = new ArrayList<SpdxListedLicense>();
        for (License license : licenseList) {
            SpdxListedLicense listedLicense = this.mavenLicenseToSpdxListedLicense(license);
            if (listedLicense == null) continue;
            spdxLicenses.add(listedLicense);
        }
        if (spdxLicenses.size() < 1) {
            return new SpdxNoAssertionLicense();
        }
        if (spdxLicenses.size() == 1) {
            return (AnyLicenseInfo)spdxLicenses.get(0);
        }
        AnyLicenseInfo[] licensesInSet = spdxLicenses.toArray(new AnyLicenseInfo[spdxLicenses.size()]);
        ConjunctiveLicenseSet conjunctiveLicense = new ConjunctiveLicenseSet(licensesInSet);
        return conjunctiveLicense;
    }

    private SpdxListedLicense mavenLicenseToSpdxListedLicense(License license) {
        if (license == null) {
            return null;
        }
        if (license.getUrl() == null || license.getUrl().isEmpty()) {
            return null;
        }
        String spdxId = this.urlStringToSpdxLicenseId.get(license.getUrl());
        if (spdxId == null) {
            return null;
        }
        try {
            return LicenseInfoFactory.getListedLicenseById((String)spdxId);
        }
        catch (InvalidSPDXAnalysisException e) {
            return null;
        }
    }

    public Map<String, String> getMap() {
        return this.urlStringToSpdxLicenseId;
    }
}

