/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.maven;

import java.util.List;
import org.apache.maven.plugins.annotations.Parameter;
import org.spdx.maven.SnippetInfo;
import org.spdx.maven.SpdxDefaultFileInformation;
import org.spdx.rdfparser.SpdxDocumentContainer;
import org.spdx.rdfparser.license.AnyLicenseInfo;
import org.spdx.rdfparser.license.LicenseInfoFactory;
import org.spdx.spdxspreadsheet.InvalidLicenseStringException;

public class PathSpecificSpdxInfo {
    @Parameter(required=true)
    String directoryOrFile;
    @Parameter
    private String fileComment;
    @Parameter
    private String[] fileContributors;
    @Parameter
    private String fileCopyright;
    @Parameter
    private String fileLicenseComment;
    @Parameter
    private String fileNotice;
    @Parameter
    private String fileConcludedLicense;
    @Parameter
    private String licenseInformationInFile;
    @Parameter(required=false)
    private List<SnippetInfo> snippets;

    public SpdxDefaultFileInformation getDefaultFileInformation(SpdxDefaultFileInformation defaults, SpdxDocumentContainer container) throws InvalidLicenseStringException {
        SpdxDefaultFileInformation retval = new SpdxDefaultFileInformation();
        if (this.fileComment != null) {
            retval.setComment(this.fileComment);
        } else {
            retval.setComment(defaults.getComment());
        }
        if (this.fileConcludedLicense != null) {
            AnyLicenseInfo concludedLicense = null;
            concludedLicense = LicenseInfoFactory.parseSPDXLicenseString((String)this.fileConcludedLicense.trim(), (SpdxDocumentContainer)container);
            retval.setConcludedLicense(concludedLicense);
        } else {
            retval.setConcludedLicense(defaults.getConcludedLicense());
        }
        if (this.fileContributors != null) {
            retval.setContributors(this.fileContributors);
        } else {
            retval.setContributors(defaults.getContributors());
        }
        if (this.fileCopyright != null) {
            retval.setCopyright(this.fileCopyright);
        } else {
            retval.setCopyright(defaults.getCopyright());
        }
        if (this.fileLicenseComment != null) {
            retval.setLicenseComment(this.fileLicenseComment);
        } else {
            retval.setLicenseComment(defaults.getLicenseComment());
        }
        if (this.fileNotice != null) {
            retval.setNotice(this.fileNotice);
        } else {
            retval.setNotice(defaults.getNotice());
        }
        if (this.licenseInformationInFile != null) {
            AnyLicenseInfo declaredLicense = null;
            declaredLicense = LicenseInfoFactory.parseSPDXLicenseString((String)this.licenseInformationInFile.trim(), (SpdxDocumentContainer)container);
            retval.setDeclaredLicense(declaredLicense);
        } else {
            retval.setDeclaredLicense(defaults.getDeclaredLicense());
        }
        if (this.snippets != null) {
            retval.setSnippets(this.snippets);
        }
        return retval;
    }

    public String getPath() {
        return this.directoryOrFile;
    }
}

