/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.maven;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Parameter;
import org.spdx.maven.SpdxBuilderException;
import org.spdx.rdfparser.SpdxDocumentContainer;
import org.spdx.rdfparser.license.AnyLicenseInfo;
import org.spdx.rdfparser.license.LicenseInfoFactory;
import org.spdx.rdfparser.model.SpdxElement;
import org.spdx.rdfparser.model.pointer.ByteOffsetPointer;
import org.spdx.rdfparser.model.pointer.LineCharPointer;
import org.spdx.rdfparser.model.pointer.SinglePointer;
import org.spdx.rdfparser.model.pointer.StartEndPointer;
import org.spdx.spdxspreadsheet.InvalidLicenseStringException;

public class SnippetInfo {
    private static final Pattern NUMBER_RANGE_PATTERN = Pattern.compile("(\\d+):(\\d+)");
    @Parameter(required=false)
    private String name;
    @Parameter(required=false)
    private String comment;
    @Parameter(defaultValue="NOASSERTION")
    private String concludedLicense;
    @Parameter(required=false)
    private String lineRange;
    @Parameter(required=true)
    private String byteRange;
    @Parameter(required=false)
    private String licenseComment;
    @Parameter(defaultValue="NOASSERTION")
    private String copyrightText;
    @Parameter(defaultValue="NOASSERTION")
    private String licenseInfoInSnippet;

    public void logInfo(Log log) {
        log.debug((CharSequence)"Snippet information follows:");
        if (this.name != null) {
            log.debug((CharSequence)("Name: " + this.name));
        }
        log.debug((CharSequence)("Byte range: " + this.byteRange));
        if (this.comment != null) {
            log.debug((CharSequence)("Comment: " + this.comment));
        }
        log.debug((CharSequence)("Concluded license: " + this.concludedLicense));
        if (this.copyrightText != null) {
            log.debug((CharSequence)("Copyright: " + this.copyrightText));
        }
        if (this.licenseComment != null) {
            log.debug((CharSequence)("License comment: " + this.licenseComment));
        }
        log.debug((CharSequence)("License info in Snippet: " + this.licenseInfoInSnippet));
        if (this.lineRange != null) {
            log.debug((CharSequence)("Line range: " + this.lineRange));
        }
    }

    public String getName() {
        return this.name;
    }

    public String getComment() {
        return this.comment;
    }

    public AnyLicenseInfo getLicenseConcluded(SpdxDocumentContainer container) throws InvalidLicenseStringException {
        return LicenseInfoFactory.parseSPDXLicenseString((String)this.concludedLicense, (SpdxDocumentContainer)container);
    }

    public AnyLicenseInfo[] getLicenseInfoInSnippet(SpdxDocumentContainer container) throws InvalidLicenseStringException {
        return new AnyLicenseInfo[]{LicenseInfoFactory.parseSPDXLicenseString((String)this.licenseInfoInSnippet, (SpdxDocumentContainer)container)};
    }

    public String getCopyrightText() {
        return this.copyrightText;
    }

    public String getLicensComment() {
        return this.licenseComment;
    }

    public StartEndPointer getByteRange(SpdxElement fileReference) throws SpdxBuilderException {
        Matcher matcher = NUMBER_RANGE_PATTERN.matcher(this.byteRange.trim());
        if (!matcher.find()) {
            throw new SpdxBuilderException("Invalid snippet byte range: " + this.byteRange);
        }
        ByteOffsetPointer start = null;
        try {
            start = new ByteOffsetPointer(fileReference, Integer.parseInt(matcher.group(1)));
        }
        catch (Exception ex) {
            throw new SpdxBuilderException("Non integer start to snippet byte offset: " + this.byteRange);
        }
        ByteOffsetPointer end = null;
        try {
            end = new ByteOffsetPointer(fileReference, Integer.parseInt(matcher.group(2)));
        }
        catch (Exception ex) {
            throw new SpdxBuilderException("Non integer end to snippet byte offset: " + this.byteRange);
        }
        return new StartEndPointer((SinglePointer)start, (SinglePointer)end);
    }

    public StartEndPointer getLineRange(SpdxElement fileReference) throws SpdxBuilderException {
        Matcher matcher = NUMBER_RANGE_PATTERN.matcher(this.lineRange);
        if (!matcher.find()) {
            throw new SpdxBuilderException("Invalid snippet line range: " + this.lineRange);
        }
        LineCharPointer start = null;
        try {
            start = new LineCharPointer(fileReference, Integer.parseInt(matcher.group(1)));
        }
        catch (Exception ex) {
            throw new SpdxBuilderException("Non integer start to snippet line offset: " + this.lineRange);
        }
        LineCharPointer end = null;
        try {
            end = new LineCharPointer(fileReference, Integer.parseInt(matcher.group(2)));
        }
        catch (Exception ex) {
            throw new SpdxBuilderException("Non integer end to snippet line offset: " + this.lineRange);
        }
        return new StartEndPointer((SinglePointer)start, (SinglePointer)end);
    }

    public String getConcludedLicense() {
        return this.concludedLicense;
    }

    public void setConcludedLicense(String concludedLicense) {
        this.concludedLicense = concludedLicense;
    }

    public String getLicenseComment() {
        return this.licenseComment;
    }

    public void setLicenseComment(String licenseComment) {
        this.licenseComment = licenseComment;
    }

    public String getLicenseInfoInSnippet() {
        return this.licenseInfoInSnippet;
    }

    public void setLicenseInfoInSnippet(String licenseInfoInSnippet) {
        this.licenseInfoInSnippet = licenseInfoInSnippet;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setLineRange(String lineRange) {
        this.lineRange = lineRange;
    }

    public void setByteRange(String byteRange) {
        this.byteRange = byteRange;
    }

    public void setCopyrightText(String copyrightText) {
        this.copyrightText = copyrightText;
    }
}

