/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.maven;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.security.NoSuchAlgorithmException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.shared.model.fileset.FileSet;
import org.spdx.maven.Annotation;
import org.spdx.maven.ExternalReference;
import org.spdx.maven.LicenseManager;
import org.spdx.maven.LicenseManagerException;
import org.spdx.maven.LicenseMapperException;
import org.spdx.maven.NonStandardLicense;
import org.spdx.maven.SpdxBuilderException;
import org.spdx.maven.SpdxCollectionException;
import org.spdx.maven.SpdxDefaultFileInformation;
import org.spdx.maven.SpdxDependencyInformation;
import org.spdx.maven.SpdxFileCollector;
import org.spdx.maven.SpdxProjectInformation;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.SPDXCreatorInformation;
import org.spdx.rdfparser.SpdxDocumentContainer;
import org.spdx.rdfparser.SpdxPackageVerificationCode;
import org.spdx.rdfparser.SpdxVerificationHelper;
import org.spdx.rdfparser.license.AnyLicenseInfo;
import org.spdx.rdfparser.license.LicenseInfoFactory;
import org.spdx.rdfparser.license.SpdxListedLicense;
import org.spdx.rdfparser.model.Checksum;
import org.spdx.rdfparser.model.ExternalDocumentRef;
import org.spdx.rdfparser.model.ExternalRef;
import org.spdx.rdfparser.model.Relationship;
import org.spdx.rdfparser.model.SpdxDocument;
import org.spdx.rdfparser.model.SpdxElement;
import org.spdx.rdfparser.model.SpdxFile;
import org.spdx.rdfparser.model.SpdxPackage;
import org.spdx.rdfparser.model.SpdxSnippet;
import org.spdx.spdxspreadsheet.InvalidLicenseStringException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpdxDocumentBuilder {
    private static final String UNSPECIFIED = "UNSPECIFIED";
    public static final String NULL_SHA1 = "cf23df2207d99a74fbe169e3eba035e633b65d94";
    DateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private Log log;
    private SpdxDocument spdxDoc;
    private SpdxPackage projectPackage;
    private SpdxDocumentContainer container;
    private LicenseManager licenseManager;
    private File spdxFile;

    public SpdxDocumentBuilder(Log log, File spdxFile, URL spdxDocumentNamespace, boolean useStdLicenseSourceUrls) throws SpdxBuilderException, LicenseMapperException {
        this.log = log;
        this.spdxFile = spdxFile;
        if (spdxDocumentNamespace == null) {
            this.getLog().error((CharSequence)"spdxDocumentNamespace must be specified as a configuration parameter");
            throw new SpdxBuilderException("Missing spdxDocumentNamespace");
        }
        if (!spdxFile.exists()) {
            File parentDir = spdxFile.getParentFile();
            if (parentDir != null && !parentDir.exists() && !parentDir.mkdirs()) {
                this.getLog().error((CharSequence)("Unable to create directory containing the SPDX file: " + parentDir.getPath()));
                throw new SpdxBuilderException("Unable to create directories for SPDX file");
            }
            try {
                if (!spdxFile.createNewFile()) {
                    this.getLog().error((CharSequence)("Unable to create the SPDX file: " + spdxFile.getPath()));
                    throw new SpdxBuilderException("Unable to create the SPDX file");
                }
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)("IO error creating the SPDX file " + spdxFile.getPath() + ":" + e.getMessage()), (Throwable)e);
                throw new SpdxBuilderException("IO error creating the SPDX file");
            }
        }
        if (!spdxFile.canWrite()) {
            this.getLog().error((CharSequence)("Can not write to SPDX file " + spdxFile.getPath()));
            throw new SpdxBuilderException("Unable to write to SPDX file - check permissions: " + spdxFile.getPath());
        }
        try {
            this.container = new SpdxDocumentContainer(spdxDocumentNamespace.toString());
            this.spdxDoc = this.container.getSpdxDocument();
        }
        catch (InvalidSPDXAnalysisException e) {
            this.getLog().error((CharSequence)"Error creating SPDX document", (Throwable)e);
            throw new SpdxBuilderException("Error creating SPDX document: " + e.getMessage());
        }
        this.licenseManager = new LicenseManager(this.spdxDoc, this.getLog(), useStdLicenseSourceUrls);
    }

    public void addNonStandardLicenses(NonStandardLicense[] nonStandardLicenses) throws SpdxBuilderException {
        if (nonStandardLicenses != null) {
            for (int i = 0; i < nonStandardLicenses.length; ++i) {
                try {
                    this.licenseManager.addExtractedLicense(nonStandardLicenses[i]);
                    continue;
                }
                catch (LicenseManagerException e) {
                    this.getLog().error((CharSequence)("Error adding license " + e.getMessage()), (Throwable)e);
                    throw new SpdxBuilderException("Error adding non standard license: " + e.getMessage(), e);
                }
            }
        }
    }

    public Log getLog() {
        return this.log;
    }

    public void setLog(Log log) {
        this.log = log;
    }

    public SpdxDocument getSpdxDoc() {
        return this.spdxDoc;
    }

    public void buildDocumentFromFiles(FileSet[] includedSourceDirectories, FileSet[] includedTestDirectories, FileSet[] includedResourceDirectories, String baseDir, SpdxProjectInformation projectInformation, SpdxDefaultFileInformation defaultFileInformation, Map<String, SpdxDefaultFileInformation> pathSpecificInformation, SpdxDependencyInformation dependencyInformation) throws SpdxBuilderException {
        FileOutputStream spdxOut = null;
        try {
            this.log.debug((CharSequence)"Starting buid document from files");
            spdxOut = new FileOutputStream(this.spdxFile);
            this.fillSpdxDocumentInformation(projectInformation);
            this.collectSpdxFileInformation(includedSourceDirectories, includedTestDirectories, includedResourceDirectories, baseDir, defaultFileInformation, this.spdxFile.getPath().replace("\\", "/"), pathSpecificInformation);
            this.addDependencyInformation(dependencyInformation);
            this.container.getModel().write((OutputStream)spdxOut);
            this.log.debug((CharSequence)"Completed build document from files");
        }
        catch (FileNotFoundException e) {
            this.getLog().error((CharSequence)"Error saving SPDX data to file", (Throwable)e);
            throw new SpdxBuilderException("Error saving SPDX data to file: " + e.getMessage());
        }
        catch (InvalidSPDXAnalysisException e) {
            this.getLog().error((CharSequence)"Error collecting SPDX file data", (Throwable)e);
            throw new SpdxBuilderException("Error collecting SPDX file data: " + e.getMessage());
        }
        finally {
            if (spdxOut != null) {
                try {
                    spdxOut.close();
                }
                catch (IOException e) {
                    this.getLog().warn((CharSequence)"Error closing SPDX output file", (Throwable)e);
                }
            }
        }
    }

    private void addDependencyInformation(SpdxDependencyInformation dependencyInformation) throws SpdxBuilderException {
        Collection<ExternalDocumentRef> externalDocRefs;
        List<Relationship> packageRelationships = dependencyInformation.getPackageRelationships();
        if (packageRelationships != null) {
            for (Relationship relationship : packageRelationships) {
                try {
                    this.projectPackage.addRelationship(relationship);
                }
                catch (InvalidSPDXAnalysisException e) {
                    this.log.error((CharSequence)("Unable to set package dependencies: " + e.getMessage()));
                    throw new SpdxBuilderException("Unable to set package dependencies", e);
                }
            }
        }
        if ((externalDocRefs = dependencyInformation.getDocumentExternalReferences()) != null && !externalDocRefs.isEmpty()) {
            try {
                this.spdxDoc.setExternalDocumentRefs(externalDocRefs.toArray(new ExternalDocumentRef[externalDocRefs.size()]));
            }
            catch (InvalidSPDXAnalysisException e) {
                this.log.error((CharSequence)("Unable to set external document references: " + e.getMessage()));
                throw new SpdxBuilderException("Unable to set external document references", e);
            }
        }
    }

    private void fillSpdxDocumentInformation(SpdxProjectInformation projectInformation) throws SpdxBuilderException {
        try {
            if (projectInformation.getDocumentComment() != null && !projectInformation.getDocumentComment().isEmpty()) {
                this.spdxDoc.setComment(projectInformation.getDocumentComment());
            }
            this.fillCreatorInfo(projectInformation);
            SpdxListedLicense dataLicense = (SpdxListedLicense)LicenseInfoFactory.parseSPDXLicenseString((String)"CC0-1.0");
            this.spdxDoc.setDataLicense((AnyLicenseInfo)dataLicense);
            if (projectInformation.getDocumentAnnotations() != null && projectInformation.getDocumentAnnotations().length > 0) {
                this.spdxDoc.setAnnotations(this.toSpdxAnnotations(projectInformation.getDocumentAnnotations()));
            }
            this.spdxDoc.setName(projectInformation.getName());
            this.projectPackage = this.createSpdxPackage(projectInformation);
            Relationship documentContainsRelationship = new Relationship((SpdxElement)this.projectPackage, Relationship.RelationshipType.DESCRIBES, "");
            this.spdxDoc.getDocumentContainer().addElement((SpdxElement)this.projectPackage);
            this.spdxDoc.addRelationship(documentContainsRelationship);
        }
        catch (InvalidSPDXAnalysisException e) {
            this.getLog().error((CharSequence)"SPDX error filling SPDX information", (Throwable)e);
            throw new SpdxBuilderException("Error adding package information to SPDX document: " + e.getMessage(), e);
        }
        catch (InvalidLicenseStringException e) {
            this.getLog().error((CharSequence)"SPDX error creating license", (Throwable)e);
            throw new SpdxBuilderException("Error adding package information to SPDX document: " + e.getMessage(), e);
        }
    }

    private org.spdx.rdfparser.model.Annotation[] toSpdxAnnotations(Annotation[] annotations) {
        org.spdx.rdfparser.model.Annotation[] retval = new org.spdx.rdfparser.model.Annotation[annotations.length];
        for (int i = 0; i < annotations.length; ++i) {
            retval[i] = annotations[i].toSpdxAnnotation();
        }
        return retval;
    }

    private SpdxPackage createSpdxPackage(SpdxProjectInformation projectInformation) throws SpdxBuilderException {
        List<ExternalReference> externalRefs;
        String downloadUrl;
        String copyrightText = projectInformation.getCopyrightText();
        if (copyrightText == null) {
            copyrightText = UNSPECIFIED;
        }
        if ((downloadUrl = projectInformation.getDownloadUrl()) == null) {
            downloadUrl = UNSPECIFIED;
        }
        SpdxPackageVerificationCode nullPackageVerificationCode = new SpdxPackageVerificationCode(NULL_SHA1, new String[0]);
        SpdxPackage pkg = new SpdxPackage(projectInformation.getName(), projectInformation.getConcludedLicense(), new AnyLicenseInfo[0], copyrightText, projectInformation.getDeclaredLicense(), downloadUrl, new SpdxFile[0], nullPackageVerificationCode);
        if (projectInformation.getPackageAnnotations() != null && projectInformation.getPackageAnnotations().length > 0) {
            try {
                pkg.setAnnotations(this.toSpdxAnnotations(projectInformation.getPackageAnnotations()));
            }
            catch (InvalidSPDXAnalysisException e) {
                this.getLog().error((CharSequence)"Invalid package annotation", (Throwable)e);
                throw new SpdxBuilderException("Error adding package annotations to SPDX document: " + e.getMessage(), e);
            }
        }
        if (projectInformation.getDescription() != null) {
            pkg.setDescription(projectInformation.getDescription());
        }
        if (projectInformation.getDownloadUrl() != null) {
            pkg.setDownloadLocation(projectInformation.getDownloadUrl());
        }
        if (projectInformation.getPackageArchiveFileName() != null) {
            pkg.setPackageFileName(projectInformation.getPackageArchiveFileName());
        }
        if (projectInformation.getHomePage() != null) {
            pkg.setHomepage(projectInformation.getHomePage());
        }
        if (projectInformation.getSourceInfo() != null) {
            pkg.setSourceInfo(projectInformation.getSourceInfo());
        }
        if (projectInformation.getLicenseComment() != null) {
            pkg.setLicenseComments(projectInformation.getLicenseComment());
        }
        if (projectInformation.getOriginator() != null) {
            pkg.setOriginator(projectInformation.getOriginator());
        }
        if (projectInformation.getSha1() != null) {
            Checksum checksum = new Checksum(Checksum.ChecksumAlgorithm.checksumAlgorithm_sha1, projectInformation.getSha1());
            try {
                pkg.setChecksums(new Checksum[]{checksum});
            }
            catch (InvalidSPDXAnalysisException e) {
                this.getLog().error((CharSequence)"Invalid checksum value for package", (Throwable)e);
                throw new SpdxBuilderException("Error adding package information to SPDX document - Invalid checksum provided: " + e.getMessage(), e);
            }
        }
        if (projectInformation.getShortDescription() != null) {
            pkg.setSummary(projectInformation.getShortDescription());
        }
        if (projectInformation.getSupplier() != null) {
            pkg.setSupplier(projectInformation.getSupplier());
        }
        if (projectInformation.getVersionInfo() != null) {
            pkg.setVersionInfo(projectInformation.getVersionInfo());
        }
        if ((externalRefs = projectInformation.getExternalRefs()) != null && externalRefs.size() > 0) {
            ExternalRef[] externalRefAr = new ExternalRef[externalRefs.size()];
            for (int i = 0; i < externalRefAr.length; ++i) {
                try {
                    externalRefAr[i] = externalRefs.get(i).getExternalRef();
                    continue;
                }
                catch (MojoExecutionException e) {
                    this.getLog().error((CharSequence)"Invalid external refs", (Throwable)e);
                    throw new SpdxBuilderException("Error adding package information to SPDX document - Invalid external refs provided: " + e.getMessage(), e);
                }
            }
            try {
                pkg.setExternalRefs(externalRefAr);
            }
            catch (InvalidSPDXAnalysisException e) {
                this.getLog().error((CharSequence)"Invalid external refs", (Throwable)e);
                throw new SpdxBuilderException("Error adding package information to SPDX document - Invalid external refs provided: " + e.getMessage(), e);
            }
        }
        return pkg;
    }

    private void fillCreatorInfo(SpdxProjectInformation projectInformation) throws InvalidSPDXAnalysisException {
        ArrayList<String> creators = new ArrayList<String>();
        String[] parameterCreators = projectInformation.getCreators();
        for (int i = 0; i < parameterCreators.length; ++i) {
            String verify = SpdxVerificationHelper.verifyCreator((String)parameterCreators[i]);
            if (verify == null) {
                creators.add(parameterCreators[i]);
                continue;
            }
            this.getLog().warn((CharSequence)("Invalid creator string ( " + verify + " ), " + parameterCreators[i] + " will be skipped."));
        }
        SPDXCreatorInformation spdxCreator = new SPDXCreatorInformation(creators.toArray(new String[creators.size()]), this.format.format(new Date()), projectInformation.getCreatorComment(), "3.1");
        this.spdxDoc.setCreationInfo(spdxCreator);
    }

    private void collectSpdxFileInformation(FileSet[] includedSourceDirectories, FileSet[] includedTestDirectories, FileSet[] includedResourceDirectories, String baseDir, SpdxDefaultFileInformation defaultFileInformation, String spdxFileName, Map<String, SpdxDefaultFileInformation> pathSpecificInformation) throws InvalidSPDXAnalysisException, SpdxBuilderException {
        SpdxFileCollector fileCollector = new SpdxFileCollector(this.getLog());
        fileCollector.setLog(this.getLog());
        try {
            fileCollector.collectFiles(includedSourceDirectories, baseDir, defaultFileInformation, pathSpecificInformation, this.projectPackage, Relationship.RelationshipType.GENERATES, this.container);
            fileCollector.collectFiles(includedTestDirectories, baseDir, defaultFileInformation, pathSpecificInformation, this.projectPackage, Relationship.RelationshipType.TEST_CASE_OF, this.container);
            fileCollector.collectFiles(includedResourceDirectories, baseDir, defaultFileInformation, pathSpecificInformation, this.projectPackage, Relationship.RelationshipType.CONTAINED_BY, this.container);
        }
        catch (SpdxCollectionException e) {
            this.getLog().error((CharSequence)"SPDX error collecting file information", (Throwable)e);
            throw new SpdxBuilderException("Error collecting SPDX file information: " + e.getMessage());
        }
        this.projectPackage.setFiles(fileCollector.getFiles());
        List<SpdxSnippet> snippets = fileCollector.getSnippets();
        if (snippets != null) {
            for (SpdxSnippet snippet : snippets) {
                this.spdxDoc.getDocumentContainer().addElement((SpdxElement)snippet);
            }
        }
        this.projectPackage.setLicenseInfosFromFiles(fileCollector.getLicenseInfoFromFiles());
        try {
            this.projectPackage.setPackageVerificationCode(fileCollector.getVerificationCode(spdxFileName));
        }
        catch (NoSuchAlgorithmException e) {
            this.getLog().error((CharSequence)"Error calculating verification code", (Throwable)e);
            throw new SpdxBuilderException("Unable to calculate verification code");
        }
        catch (InvalidSPDXAnalysisException e) {
            this.getLog().error((CharSequence)"SPDX Error updating verification code", (Throwable)e);
            throw new SpdxBuilderException("Unable to update verification code");
        }
    }

    public LicenseManager getLicenseManager() {
        return this.licenseManager;
    }
}

