/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.maven;

import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.model.ExternalRef;
import org.spdx.rdfparser.referencetype.ListedReferenceTypes;
import org.spdx.rdfparser.referencetype.ReferenceType;

public class ExternalReference {
    @Parameter(required=true)
    private String category;
    @Parameter(required=true)
    private String type;
    @Parameter(required=true)
    private String locator;
    @Parameter(required=false)
    private String comment;

    public ExternalRef getExternalRef() throws MojoExecutionException {
        ExternalRef.ReferenceCategory cat = ExternalRef.ReferenceCategory.fromTag((String)this.category);
        if (cat == null) {
            throw new MojoExecutionException("External reference category " + this.category + " is not recognized as a valid, standard category.");
        }
        ReferenceType refType = null;
        try {
            refType = ListedReferenceTypes.getListedReferenceTypes().getListedReferenceTypeByName(this.type);
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new MojoExecutionException("Error getting listed reference type for " + this.type, (Exception)((Object)e));
        }
        if (refType == null) {
            throw new MojoExecutionException("Listed reference type not found for " + this.type);
        }
        return new ExternalRef(cat, refType, this.locator, this.comment);
    }
}

