/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.maven;

import edu.emory.mathcs.backport.java.util.Arrays;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.shared.model.fileset.FileSet;
import org.spdx.maven.Annotation;
import org.spdx.maven.ExternalReference;
import org.spdx.maven.LicenseManager;
import org.spdx.maven.LicenseManagerException;
import org.spdx.maven.LicenseMapperException;
import org.spdx.maven.NonStandardLicense;
import org.spdx.maven.PathSpecificSpdxInfo;
import org.spdx.maven.SpdxBuilderException;
import org.spdx.maven.SpdxCollectionException;
import org.spdx.maven.SpdxDefaultFileInformation;
import org.spdx.maven.SpdxDependencyInformation;
import org.spdx.maven.SpdxDocumentBuilder;
import org.spdx.maven.SpdxFileCollector;
import org.spdx.maven.SpdxProjectInformation;
import org.spdx.rdfparser.SpdxDocumentContainer;
import org.spdx.rdfparser.license.AnyLicenseInfo;
import org.spdx.rdfparser.license.LicenseInfoFactory;
import org.spdx.rdfparser.license.SpdxNoAssertionLicense;
import org.spdx.spdxspreadsheet.InvalidLicenseStringException;

@Mojo(name="createSPDX", defaultPhase=LifecyclePhase.VERIFY)
@Execute(goal="createSPDX", phase=LifecyclePhase.VERIFY)
public class CreateSpdxMojo
extends AbstractMojo {
    static final String INCLUDE_ALL = "**/*";
    private static final String CREATOR_TOOL_MAVEN_PLUGIN = "Tool: spdx-maven-plugin";
    private static final String SPDX_ARTIFACT_TYPE = "spdx.rdf.xml";
    @Parameter(defaultValue="${project}")
    MavenProject mavenProject;
    @Component
    private MavenProjectHelper projectHelper;
    private Set<Artifact> dependencies;
    @Parameter(defaultValue="${project.reporting.outputDirectory}/${project.name}-${project.version}.spdx.rdf.xml", property="spdxFileName", required=true)
    private File spdxFile;
    @Parameter(defaultValue="http://spdx.org/spdxpackages/${project.name}-${project.version}", property="spdxDocumentNamespace", required=true)
    private String spdxDocumentNamespace;
    @Parameter(defaultValue="${project.basedir}", property="componentName")
    private String componentName;
    @Parameter
    private NonStandardLicense[] nonStandardLicenses;
    @Parameter(defaultValue="true")
    private boolean matchLicensesOnCrossReferenceUrls;
    @Parameter
    private String documentComment;
    @Parameter
    private Annotation[] documentAnnotations;
    @Parameter
    private Annotation[] packageAnnotations;
    @Parameter
    private String defaultFileComment;
    @Parameter
    private String[] defaultFileContributors;
    @Parameter(defaultValue="NOASSERTION")
    private String defaultFileCopyright;
    @Parameter
    private String defaultFileLicenseComment;
    @Parameter
    private String defaultFileNotice;
    @Parameter(defaultValue="NOASSERTION")
    private String defaultFileConcludedLicense;
    @Parameter(defaultValue="NOASSERTION")
    private String defaultLicenseInformationInFile;
    @Parameter
    private String licenseDeclared;
    @Parameter
    private String licenseConcluded;
    @Parameter
    private String creatorComment;
    @Parameter
    private String[] creators;
    @Parameter
    private String licenseComments;
    @Parameter
    private String originator;
    @Parameter
    private String sourceInfo;
    @Parameter(defaultValue="NOASSERTION")
    private String copyrightText;
    @Parameter(required=false)
    private List<PathSpecificSpdxInfo> pathsWithSpecificSpdxInfo;
    @Parameter(required=false)
    private List<ExternalReference> externalReferences;

    public void execute() throws MojoExecutionException {
        SpdxDocumentBuilder builder;
        this.dependencies = this.mavenProject.getDependencyArtifacts();
        if (this.getLog() == null) {
            throw new MojoExecutionException("Null log for Mojo");
        }
        if (this.spdxFile == null) {
            throw new MojoExecutionException("No SPDX file referenced.  Specify a configuration paramaeter spdxFile to resolve.");
        }
        File outputDir = this.spdxFile.getParentFile();
        if (outputDir == null) {
            throw new MojoExecutionException("Invalid path for SPDX output file.  Specify a configuration parameter spdxFile with a valid directory path to resolve.");
        }
        if (!outputDir.exists()) {
            outputDir.mkdirs();
        }
        this.getLog().info((CharSequence)("Creating SPDX File " + this.spdxFile.getPath()));
        try {
            URL namespaceUrl = new URL(this.spdxDocumentNamespace);
            URI uri = new URI(namespaceUrl.getProtocol(), namespaceUrl.getUserInfo(), namespaceUrl.getHost(), namespaceUrl.getPort(), namespaceUrl.getPath(), namespaceUrl.getQuery(), namespaceUrl.getRef());
            namespaceUrl = uri.toURL();
            builder = new SpdxDocumentBuilder(this.getLog(), this.spdxFile, namespaceUrl, this.matchLicensesOnCrossReferenceUrls);
        }
        catch (SpdxBuilderException e) {
            this.getLog().error((CharSequence)("Error creating SPDX Document Builder: " + e.getMessage()), (Throwable)e);
            throw new MojoExecutionException("Error creating SPDX Document Builder: " + e.getMessage(), (Exception)e);
        }
        catch (LicenseMapperException e) {
            this.getLog().error((CharSequence)("License mapping error creating SPDX Document Builder: " + e.getMessage()), (Throwable)e);
            throw new MojoExecutionException("License mapping error creating SPDX Document Builder: " + e.getMessage(), (Exception)e);
        }
        catch (MalformedURLException e) {
            this.getLog().error((CharSequence)("Invalid SPDX document namespace - not a valid URL: " + this.spdxDocumentNamespace), (Throwable)e);
            throw new MojoExecutionException("Invalid SPDX document namespace - not a valid URL: " + this.spdxDocumentNamespace, (Exception)e);
        }
        catch (URISyntaxException e) {
            this.getLog().error((CharSequence)("Invalid SPDX document namespace - not a valid URL: " + this.spdxDocumentNamespace), (Throwable)e);
            throw new MojoExecutionException("Invalid SPDX document namespace - not a valid URL: " + this.spdxDocumentNamespace, (Exception)e);
        }
        if (this.nonStandardLicenses != null) {
            try {
                builder.addNonStandardLicenses(this.nonStandardLicenses);
            }
            catch (SpdxBuilderException e) {
                this.getLog().error((CharSequence)("Error adding non standard licenses: " + e.getMessage()), (Throwable)e);
                throw new MojoExecutionException("Error adding non standard licenses: " + e.getMessage(), (Exception)e);
            }
        }
        SpdxDocumentContainer container = builder.getSpdxDoc().getDocumentContainer();
        FileSet[] includedSourceDirectories = this.getSourceDirectories();
        FileSet[] includedResourceDirectories = this.getResourceDirectories();
        FileSet[] includedTestDirectories = this.getTestDirectories();
        SpdxProjectInformation projectInformation = this.getSpdxProjectInfoFromParameters(builder.getLicenseManager(), container);
        SpdxDefaultFileInformation defaultFileInformation = this.getDefaultFileInfoFromParameters(container);
        HashMap<String, SpdxDefaultFileInformation> pathSpecificInformation = this.getPathSpecificInfoFromParameters(defaultFileInformation, container);
        SpdxDependencyInformation dependencyInformation = null;
        try {
            dependencyInformation = this.getSpdxDependencyInformation(this.dependencies, builder.getLicenseManager());
        }
        catch (LicenseMapperException e1) {
            this.getLog().error((CharSequence)("Error mapping licenses for dependencies: " + e1.getMessage()), (Throwable)e1);
            throw new MojoExecutionException("Error mapping licenses for dependencies: " + e1.getMessage(), (Exception)e1);
        }
        this.logIncludedDirectories(includedSourceDirectories);
        this.logIncludedDirectories(includedTestDirectories);
        this.logIncludedDirectories(includedResourceDirectories);
        this.logNonStandardLicenses(this.nonStandardLicenses);
        projectInformation.logInfo(this.getLog());
        defaultFileInformation.logInfo(this.getLog());
        this.logFileSpecificInfo(pathSpecificInformation);
        this.logDependencies(this.dependencies);
        try {
            builder.buildDocumentFromFiles(includedSourceDirectories, includedTestDirectories, includedResourceDirectories, this.mavenProject.getBasedir().getAbsolutePath(), projectInformation, defaultFileInformation, pathSpecificInformation, dependencyInformation);
        }
        catch (SpdxBuilderException e) {
            this.getLog().error((CharSequence)("Error building SPDX document from project files: " + e.getMessage()), (Throwable)e);
            throw new MojoExecutionException("Error building SPDX document from project files: " + e.getMessage(), (Exception)e);
        }
        this.getLog().debug((CharSequence)("Project Helper: " + this.projectHelper));
        if (this.projectHelper != null) {
            this.projectHelper.attachArtifact(this.mavenProject, SPDX_ARTIFACT_TYPE, this.spdxFile);
        } else {
            this.getLog().warn((CharSequence)"Unable to attach SPDX artifact file - no ProjectHelper exists");
        }
        List spdxErrors = builder.getSpdxDoc().verify();
        if (spdxErrors != null && spdxErrors.size() > 0) {
            StringBuilder sb = new StringBuilder("The following errors were found in the SPDX file:\n ");
            sb.append((String)spdxErrors.get(0));
            for (int i = 0; i < spdxErrors.size(); ++i) {
                sb.append("\n ");
                sb.append((String)spdxErrors.get(i));
            }
            this.getLog().warn((CharSequence)sb.toString());
        }
    }

    private SpdxDependencyInformation getSpdxDependencyInformation(Set<Artifact> dependencies, LicenseManager licenseManager) throws LicenseMapperException {
        SpdxDependencyInformation retval = new SpdxDependencyInformation(this.getLog(), licenseManager);
        if (dependencies != null) {
            for (Artifact dependency : dependencies) {
                retval.addMavenDependency(dependency);
            }
        }
        return retval;
    }

    private void logDependencies(Set<Artifact> dependencies) {
        this.getLog().debug((CharSequence)"Dependencies:");
        if (dependencies == null) {
            this.getLog().debug((CharSequence)"\tNull dependencies");
            return;
        }
        if (dependencies.isEmpty()) {
            this.getLog().debug((CharSequence)"\tZero dependencies");
            return;
        }
        for (Artifact dependency : dependencies) {
            String filePath = dependency.getFile() != null ? dependency.getFile().getAbsolutePath() : "[NONE]";
            String scope = dependency.getScope() != null ? dependency.getScope() : "[NONE]";
            this.getLog().debug((CharSequence)("ArtifactId: " + dependency.getArtifactId() + ", file path: " + filePath + ", Scope: " + scope));
        }
    }

    private void logFileSpecificInfo(HashMap<String, SpdxDefaultFileInformation> fileSpecificInformation) {
        for (Map.Entry<String, SpdxDefaultFileInformation> entry : fileSpecificInformation.entrySet()) {
            this.getLog().debug((CharSequence)("File Specific Information for " + entry.getKey()));
            entry.getValue().logInfo(this.getLog());
        }
    }

    private HashMap<String, SpdxDefaultFileInformation> getPathSpecificInfoFromParameters(SpdxDefaultFileInformation projectDefault, SpdxDocumentContainer container) throws MojoExecutionException {
        HashMap<String, SpdxDefaultFileInformation> retval = new HashMap<String, SpdxDefaultFileInformation>();
        if (this.pathsWithSpecificSpdxInfo != null) {
            for (PathSpecificSpdxInfo spdxInfo : this.pathsWithSpecificSpdxInfo) {
                SpdxDefaultFileInformation value = null;
                try {
                    value = spdxInfo.getDefaultFileInformation(projectDefault, container);
                }
                catch (InvalidLicenseStringException e) {
                    this.getLog().error((CharSequence)("Invalid license string used in the path specific SPDX information for file " + spdxInfo.getPath()), (Throwable)e);
                    throw new MojoExecutionException("Invalid license string used in the path specific SPDX information for file " + spdxInfo.getPath(), (Exception)((Object)e));
                }
                if (retval.containsKey(spdxInfo.getPath())) {
                    this.getLog().warn((CharSequence)("Multiple file path specific SPDX data for " + spdxInfo.getPath()));
                }
                retval.put(spdxInfo.getPath(), value);
            }
        }
        return retval;
    }

    private void logNonStandardLicenses(NonStandardLicense[] nonStandardLicenses) {
        if (nonStandardLicenses == null) {
            return;
        }
        for (int i = 0; i < nonStandardLicenses.length; ++i) {
            this.getLog().debug((CharSequence)("Non standard license ID: " + nonStandardLicenses[i].getLicenseId()));
            this.getLog().debug((CharSequence)("Non standard license Text: " + nonStandardLicenses[i].getExtractedText()));
            this.getLog().debug((CharSequence)("Non standard license Comment: " + nonStandardLicenses[i].getComment()));
            this.getLog().debug((CharSequence)("Non standard license Name: " + nonStandardLicenses[i].getName()));
            String[] crossReferences = nonStandardLicenses[i].getCrossReference();
            if (crossReferences == null) continue;
            for (int j = 0; j < crossReferences.length; ++j) {
                this.getLog().debug((CharSequence)("Non standard license cross reference: " + crossReferences[j]));
            }
        }
    }

    private void logIncludedDirectories(FileSet[] includedDirectories) {
        if (includedDirectories == null) {
            return;
        }
        this.getLog().debug((CharSequence)("Logging " + String.valueOf(includedDirectories.length) + " filesets."));
        for (int i = 0; i < includedDirectories.length; ++i) {
            List excludes;
            StringBuilder sb = new StringBuilder("Included Directory: " + includedDirectories[i].getDirectory());
            List includes = includedDirectories[i].getIncludes();
            if (includes != null && includes.size() > 0) {
                sb.append("; Included=");
                sb.append((String)includes.get(0));
                for (int j = 1; j < includes.size(); ++j) {
                    sb.append(",");
                    sb.append((String)includes.get(j));
                }
            }
            if ((excludes = includedDirectories[i].getExcludes()) != null && excludes.size() > 0) {
                sb.append("; Excluded=");
                sb.append((String)excludes.get(0));
                for (int j = 1; j < excludes.size(); ++j) {
                    sb.append(",");
                    sb.append((String)excludes.get(j));
                }
            }
            this.getLog().debug((CharSequence)sb.toString());
        }
    }

    private SpdxDefaultFileInformation getDefaultFileInfoFromParameters(SpdxDocumentContainer container) throws MojoExecutionException {
        SpdxDefaultFileInformation retval = new SpdxDefaultFileInformation();
        retval.setComment(this.defaultFileComment);
        AnyLicenseInfo concludedLicense = null;
        try {
            concludedLicense = LicenseInfoFactory.parseSPDXLicenseString((String)this.defaultFileConcludedLicense.trim(), (SpdxDocumentContainer)container);
        }
        catch (InvalidLicenseStringException e) {
            this.getLog().error((CharSequence)("Invalid default file concluded license: " + e.getMessage()));
            throw new MojoExecutionException("Invalid default file concluded license: " + e.getMessage());
        }
        retval.setConcludedLicense(concludedLicense);
        retval.setContributors(this.defaultFileContributors);
        retval.setCopyright(this.defaultFileCopyright);
        AnyLicenseInfo declaredLicense = null;
        try {
            declaredLicense = LicenseInfoFactory.parseSPDXLicenseString((String)this.defaultLicenseInformationInFile.trim(), (SpdxDocumentContainer)container);
        }
        catch (InvalidLicenseStringException e) {
            this.getLog().error((CharSequence)("Invalid default file declared license: " + e.getMessage()));
            throw new MojoExecutionException("Invalid default file declared license: " + e.getMessage());
        }
        retval.setDeclaredLicense(declaredLicense);
        retval.setLicenseComment(this.defaultFileLicenseComment);
        retval.setNotice(this.defaultFileNotice);
        return retval;
    }

    private SpdxProjectInformation getSpdxProjectInfoFromParameters(LicenseManager licenseManager, SpdxDocumentContainer container) throws MojoExecutionException {
        String supplier;
        SpdxProjectInformation retval = new SpdxProjectInformation();
        if (this.documentComment != null) {
            retval.setDocumentComment(this.documentComment);
        }
        AnyLicenseInfo declaredLicense = null;
        if (this.licenseDeclared == null) {
            List mavenLicenses = this.mavenProject.getLicenses();
            try {
                declaredLicense = licenseManager.mavenLicenseListToSpdxLicense(mavenLicenses);
            }
            catch (LicenseManagerException e) {
                this.getLog().warn((CharSequence)"Unable to map maven licenses to a declared license.  Using NOASSERTION");
                declaredLicense = new SpdxNoAssertionLicense();
            }
        } else {
            try {
                declaredLicense = LicenseInfoFactory.parseSPDXLicenseString((String)this.licenseDeclared.trim(), (SpdxDocumentContainer)container);
            }
            catch (InvalidLicenseStringException e) {
                this.getLog().error((CharSequence)("Invalid declared license: " + e.getMessage()));
                throw new MojoExecutionException("Invalid declared license: " + e.getMessage());
            }
        }
        AnyLicenseInfo concludedLicense = null;
        if (this.licenseConcluded == null) {
            concludedLicense = declaredLicense;
        } else {
            try {
                concludedLicense = LicenseInfoFactory.parseSPDXLicenseString((String)this.licenseConcluded.trim(), (SpdxDocumentContainer)container);
            }
            catch (InvalidLicenseStringException e) {
                this.getLog().error((CharSequence)("Invalid concluded license: " + e.getMessage()));
                throw new MojoExecutionException("Invalid concluded license: " + e.getMessage());
            }
        }
        retval.setConcludedLicense(concludedLicense);
        retval.setCreatorComment(this.creatorComment);
        if (this.creators == null) {
            this.creators = new String[0];
        }
        String[] allCreators = (String[])Arrays.copyOf((Object[])this.creators, (int)(this.creators.length + 1));
        allCreators[allCreators.length - 1] = CREATOR_TOOL_MAVEN_PLUGIN;
        retval.setCreators(allCreators);
        retval.setCopyrightText(this.copyrightText);
        retval.setDeclaredLicense(declaredLicense);
        String projectName = this.mavenProject.getName();
        if (projectName == null || projectName.isEmpty()) {
            projectName = this.getDefaultProjectName();
        }
        retval.setName(projectName);
        retval.setDescription(this.mavenProject.getDescription());
        String downloadUrl = "NOASSERTION";
        DistributionManagement distributionManager = this.mavenProject.getDistributionManagement();
        if (distributionManager != null && distributionManager.getDownloadUrl() != null && !distributionManager.getDownloadUrl().isEmpty()) {
            downloadUrl = distributionManager.getDownloadUrl();
        }
        retval.setDownloadUrl(downloadUrl);
        retval.setHomePage(this.mavenProject.getUrl());
        retval.setLicenseComment(this.licenseComments);
        if (this.originator == null && this.mavenProject.getOrganization() != null && this.mavenProject.getOrganization().getName() != null && !this.mavenProject.getOrganization().getName().isEmpty()) {
            this.originator = "Organization:" + this.mavenProject.getOrganization().getName();
        }
        retval.setOriginator(this.originator);
        String packageFileName = null;
        File packageFile = null;
        Artifact mainArtifact = this.mavenProject.getArtifact();
        if (mainArtifact != null && mainArtifact.getFile() != null) {
            packageFileName = mainArtifact.getArtifactId() + "." + mainArtifact.getType();
            packageFile = mainArtifact.getFile();
        } else {
            packageFileName = "NOASSERTION";
        }
        retval.setPackageArchiveFileName(packageFileName);
        String sha1 = null;
        if (packageFile != null && packageFile.exists()) {
            try {
                sha1 = SpdxFileCollector.generateSha1(packageFile);
            }
            catch (SpdxCollectionException e) {
                this.getLog().warn((CharSequence)("Unable to collect sha1 value for " + packageFile.getName() + ":" + e.getMessage()));
            }
        }
        retval.setSha1(sha1);
        retval.setShortDescription(this.mavenProject.getDescription());
        if (this.mavenProject.getOrganization() != null && (supplier = this.mavenProject.getOrganization().getName()) != null && !supplier.isEmpty()) {
            supplier = "Organization: " + supplier;
            retval.setSupplier(supplier);
        }
        retval.setSourceInfo(this.sourceInfo);
        retval.setVersionInfo(this.mavenProject.getVersion());
        retval.setDocumentAnnotations(this.documentAnnotations);
        retval.setPackageAnnotations(this.packageAnnotations);
        retval.setExternalRefs(this.externalReferences);
        return retval;
    }

    private String getDefaultProjectName() {
        return this.mavenProject.getArtifactId();
    }

    private FileSet[] getSourceDirectories() {
        ArrayList<FileSet> result = new ArrayList<FileSet>();
        List sourceRoots = this.mavenProject.getCompileSourceRoots();
        if (sourceRoots != null) {
            Iterator sourceRootIter = sourceRoots.iterator();
            while (sourceRootIter.hasNext()) {
                FileSet srcFileSet = new FileSet();
                File sourceDir = new File((String)sourceRootIter.next());
                srcFileSet.setDirectory(sourceDir.getAbsolutePath());
                srcFileSet.addInclude(INCLUDE_ALL);
                result.add(srcFileSet);
                this.getLog().debug((CharSequence)("Adding sourceRoot directory " + srcFileSet.getDirectory()));
            }
        }
        return result.toArray(new FileSet[result.size()]);
    }

    private FileSet[] getResourceDirectories() {
        List resourceList;
        ArrayList<FileSet> result = new ArrayList<FileSet>();
        List sourceRoots = this.mavenProject.getCompileSourceRoots();
        if (sourceRoots != null) {
            Iterator sourceRootIter = sourceRoots.iterator();
            while (sourceRootIter.hasNext()) {
                FileSet srcFileSet = new FileSet();
                File sourceDir = new File((String)sourceRootIter.next());
                srcFileSet.setDirectory(sourceDir.getAbsolutePath());
                srcFileSet.addInclude(INCLUDE_ALL);
                result.add(srcFileSet);
                this.getLog().debug((CharSequence)("Adding sourceRoot directory " + srcFileSet.getDirectory()));
            }
        }
        if ((resourceList = this.mavenProject.getResources()) != null) {
            for (Resource resource : resourceList) {
                FileSet resourceFileSet = new FileSet();
                File resourceDir = new File(resource.getDirectory());
                resourceFileSet.setDirectory(resourceDir.getAbsolutePath());
                resourceFileSet.setExcludes(resource.getExcludes());
                resourceFileSet.setIncludes(resource.getIncludes());
                result.add(resourceFileSet);
                this.getLog().debug((CharSequence)("Adding resource directory " + resource.getDirectory()));
            }
        }
        this.getLog().debug((CharSequence)("Number of filesets: " + String.valueOf(result.size())));
        return result.toArray(new FileSet[result.size()]);
    }

    private FileSet[] getTestDirectories() {
        ArrayList<FileSet> result = new ArrayList<FileSet>();
        List sourceRoots = this.mavenProject.getTestCompileSourceRoots();
        if (sourceRoots != null) {
            Iterator sourceRootIter = sourceRoots.iterator();
            while (sourceRootIter.hasNext()) {
                FileSet srcFileSet = new FileSet();
                File sourceDir = new File((String)sourceRootIter.next());
                srcFileSet.setDirectory(sourceDir.getAbsolutePath());
                srcFileSet.addInclude(INCLUDE_ALL);
                result.add(srcFileSet);
                this.getLog().debug((CharSequence)("Adding TestSourceRoot directory " + srcFileSet.getDirectory()));
            }
        }
        return result.toArray(new FileSet[result.size()]);
    }
}

