/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.maven;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.model.License;
import org.apache.maven.plugin.logging.Log;
import org.spdx.maven.LicenseManagerException;
import org.spdx.maven.LicenseMapperException;
import org.spdx.maven.MavenToSpdxLicenseMapper;
import org.spdx.maven.NonStandardLicense;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.license.AnyLicenseInfo;
import org.spdx.rdfparser.license.ConjunctiveLicenseSet;
import org.spdx.rdfparser.license.ExtractedLicenseInfo;
import org.spdx.rdfparser.license.LicenseInfoFactory;
import org.spdx.rdfparser.license.SpdxListedLicense;
import org.spdx.rdfparser.license.SpdxNoAssertionLicense;
import org.spdx.rdfparser.model.SpdxDocument;
import org.spdx.spdxspreadsheet.InvalidLicenseStringException;

public class LicenseManager {
    SpdxDocument spdxDoc = null;
    Map<String, String> urlStringToSpdxLicenseId = new HashMap<String, String>();
    Map<String, ExtractedLicenseInfo> extractedLicenses = new HashMap<String, ExtractedLicenseInfo>();
    Log log;

    public LicenseManager(SpdxDocument spdxDoc, Log log, boolean useStdLicenseSourceUrls) throws LicenseMapperException {
        this.spdxDoc = spdxDoc;
        this.log = log;
        this.initializeUrlMap();
    }

    private void initializeUrlMap() throws LicenseMapperException {
        this.urlStringToSpdxLicenseId.putAll(MavenToSpdxLicenseMapper.getInstance(this.log).getMap());
    }

    protected Log getLog() {
        return this.log;
    }

    public void addExtractedLicense(NonStandardLicense license) throws LicenseManagerException {
        ExtractedLicenseInfo spdxLicense = new ExtractedLicenseInfo(license.getLicenseId(), license.getExtractedText(), license.getName(), license.getCrossReference(), license.getComment());
        try {
            this.spdxDoc.addExtractedLicenseInfos(spdxLicense);
        }
        catch (InvalidSPDXAnalysisException e) {
            String licenseId = license.getLicenseId();
            if (licenseId == null) {
                licenseId = "[NullLicenseId]";
            }
            throw new LicenseManagerException("Unable to add non listed license " + licenseId + ": " + e.getMessage(), e);
        }
        String[] urls = license.getCrossReference();
        if (urls != null) {
            for (int i = 0; i < urls.length; ++i) {
                if (this.urlStringToSpdxLicenseId.containsKey(urls[i])) {
                    String oldLicenseId = this.urlStringToSpdxLicenseId.get(urls[i]);
                    this.getLog().warn((CharSequence)("Duplicate URL for SPDX extracted license.  Replacing " + oldLicenseId + " with " + license.getLicenseId() + " for " + urls[i]));
                }
                if (this.getLog() != null) {
                    this.getLog().debug((CharSequence)("Adding URL mapping for non-standard license " + spdxLicense.getLicenseId()));
                }
                this.urlStringToSpdxLicenseId.put(urls[i], spdxLicense.getLicenseId());
            }
        }
        this.extractedLicenses.put(spdxLicense.getLicenseId(), spdxLicense);
    }

    public AnyLicenseInfo mavenLicenseListToSpdxLicense(List<License> licenseList) throws LicenseManagerException {
        if (licenseList == null) {
            return new SpdxNoAssertionLicense();
        }
        ArrayList<AnyLicenseInfo> spdxLicenses = new ArrayList<AnyLicenseInfo>();
        for (License license : licenseList) {
            spdxLicenses.add(this.mavenLicenseToSpdxLicense(license));
        }
        if (spdxLicenses.size() < 1) {
            return new SpdxNoAssertionLicense();
        }
        if (spdxLicenses.size() == 1) {
            return (AnyLicenseInfo)spdxLicenses.get(0);
        }
        AnyLicenseInfo[] licensesInSet = spdxLicenses.toArray(new AnyLicenseInfo[spdxLicenses.size()]);
        ConjunctiveLicenseSet conjunctiveLicense = new ConjunctiveLicenseSet(licensesInSet);
        return conjunctiveLicense;
    }

    public AnyLicenseInfo mavenLicenseToSpdxLicense(License mavenLicense) throws LicenseManagerException {
        if (mavenLicense.getUrl() == null) {
            throw new LicenseManagerException("Can not map maven license " + mavenLicense.getName() + "  No URL exists to provide a mapping");
        }
        String licenseId = this.urlStringToSpdxLicenseId.get(mavenLicense.getUrl());
        if (licenseId == null) {
            throw new LicenseManagerException("Can not map maven license " + mavenLicense.getName() + "  No listed or extracted license matches the URL " + mavenLicense.getUrl());
        }
        AnyLicenseInfo retval = (AnyLicenseInfo)this.extractedLicenses.get(licenseId);
        if (retval == null) {
            try {
                retval = LicenseInfoFactory.parseSPDXLicenseString((String)licenseId);
            }
            catch (InvalidLicenseStringException e) {
                throw new LicenseManagerException("Can not map maven license " + mavenLicense.getName() + "  Invalid listed or extracted license id matching the URL " + mavenLicense.getUrl());
            }
        }
        return retval;
    }

    public License spdxLicenseToMavenLicense(AnyLicenseInfo spdxLicense) throws LicenseManagerException {
        if (spdxLicense instanceof ExtractedLicenseInfo) {
            return this.spdxNonStdLicenseToMavenLicense((ExtractedLicenseInfo)spdxLicense);
        }
        if (spdxLicense instanceof SpdxListedLicense) {
            return this.spdxStdLicenseToMavenLicense((SpdxListedLicense)spdxLicense);
        }
        throw new LicenseManagerException("Can not create a Maven license from this SPDX license type.  Must be an ExtractedLicenseInfo or an SpdxListedLicense ");
    }

    private License spdxStdLicenseToMavenLicense(SpdxListedLicense spdxLicense) {
        License retval = new License();
        if (spdxLicense.getName() != null && !spdxLicense.getName().isEmpty()) {
            retval.setName(spdxLicense.getName());
        } else {
            retval.setName(spdxLicense.getLicenseId());
        }
        if (spdxLicense.getComment() != null && !spdxLicense.getComment().isEmpty()) {
            retval.setComments(spdxLicense.getComment());
        }
        if (spdxLicense.getSeeAlso() != null && spdxLicense.getSeeAlso().length > 0) {
            retval.setUrl(spdxLicense.getSeeAlso()[0]);
            if (spdxLicense.getSeeAlso().length > 1 && this.getLog() != null) {
                this.getLog().warn((CharSequence)("SPDX license " + spdxLicense.getLicenseId() + " contains multiple URLs.  Only the first URL will be preserved in the Maven license created."));
            }
        }
        return retval;
    }

    private License spdxNonStdLicenseToMavenLicense(ExtractedLicenseInfo spdxLicense) {
        License retval = new License();
        if (spdxLicense.getName() != null && !spdxLicense.getName().isEmpty()) {
            retval.setName(spdxLicense.getName());
        } else {
            retval.setName(spdxLicense.getLicenseId());
        }
        if (spdxLicense.getComment() != null && !spdxLicense.getComment().isEmpty()) {
            retval.setComments(spdxLicense.getComment());
        }
        if (spdxLicense.getSeeAlso() != null && spdxLicense.getSeeAlso().length > 0) {
            retval.setUrl(spdxLicense.getSeeAlso()[0]);
            if (spdxLicense.getSeeAlso().length > 1) {
                this.getLog().warn((CharSequence)("SPDX license " + spdxLicense.getLicenseId() + " contains multiple URLs.  Only the first URL will be preserved in the Maven license created."));
            }
        }
        return retval;
    }
}

