/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.maven;

import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.spdx.library.InvalidSPDXAnalysisException;
import org.spdx.library.model.ExternalRef;
import org.spdx.library.model.ReferenceType;
import org.spdx.library.model.SpdxDocument;
import org.spdx.library.model.enumerations.ReferenceCategory;
import org.spdx.library.referencetype.ListedReferenceTypes;

public class ExternalReference {
    @Parameter(required=true)
    private String category;
    @Parameter(required=true)
    private String type;
    @Parameter(required=true)
    private String locator;
    @Parameter(required=false)
    private String comment;

    public ExternalRef getExternalRef(SpdxDocument spdxDoc) throws MojoExecutionException {
        ReferenceCategory cat = null;
        try {
            cat = ReferenceCategory.valueOf((String)this.category.replaceAll("-", "_"));
        }
        catch (Exception ex) {
            throw new MojoExecutionException("External reference category " + this.category + " is not recognized as a valid, standard category.");
        }
        ReferenceType refType = null;
        try {
            refType = ListedReferenceTypes.getListedReferenceTypes().getListedReferenceTypeByName(this.type);
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new MojoExecutionException("Error getting listed reference type for " + this.type, (Exception)((Object)e));
        }
        if (refType == null) {
            throw new MojoExecutionException("Listed reference type not found for " + this.type);
        }
        try {
            return spdxDoc.createExternalRef(cat, refType, this.locator, this.comment);
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new MojoExecutionException("Error createing External Reference: " + e.getMessage());
        }
    }
}

