/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.maven;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.shared.model.fileset.FileSet;
import org.apache.maven.shared.model.fileset.util.FileSetManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spdx.library.InvalidSPDXAnalysisException;
import org.spdx.library.model.Checksum;
import org.spdx.library.model.Relationship;
import org.spdx.library.model.SpdxDocument;
import org.spdx.library.model.SpdxElement;
import org.spdx.library.model.SpdxFile;
import org.spdx.library.model.SpdxPackage;
import org.spdx.library.model.SpdxPackageVerificationCode;
import org.spdx.library.model.SpdxSnippet;
import org.spdx.library.model.enumerations.ChecksumAlgorithm;
import org.spdx.library.model.enumerations.FileType;
import org.spdx.library.model.enumerations.RelationshipType;
import org.spdx.library.model.license.AnyLicenseInfo;
import org.spdx.library.model.license.InvalidLicenseStringException;
import org.spdx.maven.SnippetInfo;
import org.spdx.maven.SpdxBuilderException;
import org.spdx.maven.SpdxCollectionException;
import org.spdx.maven.SpdxDefaultFileInformation;
import org.spdx.maven.SpdxSourceFileParser;
import org.spdx.maven.SpdxSourceParserException;
import org.spdx.storage.IModelStore;

public class SpdxFileCollector {
    static Logger logger = LoggerFactory.getLogger(SpdxFileCollector.class);
    static final String SPDX_FILE_TYPE_CONSTANTS_PROP_PATH = "resources/SpdxFileTypeConstants.prop";
    static final Map<String, FileType> EXT_TO_FILE_TYPE = new HashMap<String, FileType>();
    static final Map<ChecksumAlgorithm, String> checksumAlgorithms;
    Set<AnyLicenseInfo> licensesFromFiles = new HashSet<AnyLicenseInfo>();
    Map<String, SpdxFile> spdxFiles = new HashMap<String, SpdxFile>();
    List<SpdxSnippet> spdxSnippets = new ArrayList<SpdxSnippet>();
    FileSetManager fileSetManager = new FileSetManager();
    private Log log;

    public SpdxFileCollector(Log log) {
        this.log = log;
    }

    private static void loadFileExtensionConstants() {
        Properties prop = new Properties();
        try (InputStream is = SpdxFileCollector.class.getClassLoader().getResourceAsStream(SPDX_FILE_TYPE_CONSTANTS_PROP_PATH);){
            if (is == null) {
                logger.error("Unable to load properties file resources/SpdxFileTypeConstants.prop");
            }
            prop.load(is);
            for (Map.Entry<Object, Object> entry : prop.entrySet()) {
                String[] extensions;
                String fileTypeStr = (String)entry.getKey();
                FileType fileType = FileType.valueOf((String)fileTypeStr);
                for (String extension : extensions = ((String)entry.getValue()).split(",")) {
                    try {
                        String trimmedExtension = extension.toUpperCase().trim();
                        if (EXT_TO_FILE_TYPE.containsKey(trimmedExtension)) {
                            logger.warn("Dulicate file extension: " + trimmedExtension);
                        }
                        EXT_TO_FILE_TYPE.put(trimmedExtension, fileType);
                    }
                    catch (Exception ex) {
                        logger.error("Error adding file extensions to filetype map", (Throwable)ex);
                    }
                }
            }
        }
        catch (IOException e) {
            logger.warn("WARNING: Error reading SpdxFileTypeConstants properties file.  All file types will be mapped to Other.");
        }
    }

    public void collectFiles(FileSet[] fileSets, String baseDir, SpdxDefaultFileInformation defaultFileInformation, Map<String, SpdxDefaultFileInformation> pathSpecificInformation, SpdxPackage projectPackage, RelationshipType relationshipType, SpdxDocument spdxDoc, Set<ChecksumAlgorithm> algorithms) throws SpdxCollectionException {
        for (FileSet fileSet : fileSets) {
            String[] includedFiles;
            for (String includedFile : includedFiles = this.fileSetManager.getIncludedFiles(fileSet)) {
                String filePath = fileSet.getDirectory() + File.separator + includedFile;
                File file = new File(filePath);
                String relativeFilePath = file.getAbsolutePath().substring(baseDir.length() + 1).replace('\\', '/');
                SpdxDefaultFileInformation fileInfo = this.findDefaultFileInformation(relativeFilePath, pathSpecificInformation);
                if (fileInfo == null) {
                    fileInfo = defaultFileInformation;
                }
                String outputFileName = fileSet.getOutputDirectory() != null ? fileSet.getOutputDirectory() + File.separator + includedFile : file.getAbsolutePath().substring(baseDir.length() + 1);
                this.collectFile(file, outputFileName, fileInfo, relationshipType, projectPackage, spdxDoc, algorithms);
            }
        }
    }

    private SpdxDefaultFileInformation findDefaultFileInformation(String filePath, Map<String, SpdxDefaultFileInformation> pathSpecificInformation) {
        SpdxDefaultFileInformation retval;
        if (this.log != null) {
            this.log.debug((CharSequence)("Checking for file path " + filePath));
        }
        if ((retval = pathSpecificInformation.get(filePath)) != null) {
            if (this.log != null) {
                this.log.debug((CharSequence)"Found filepath");
            }
            return retval;
        }
        String parentPath = filePath;
        int parentPathIndex = 0;
        do {
            if ((parentPathIndex = parentPath.lastIndexOf("/")) <= 0) continue;
            parentPath = parentPath.substring(0, parentPathIndex);
            retval = pathSpecificInformation.get(parentPath);
        } while (retval == null && parentPathIndex > 0);
        if (retval != null) {
            this.debug("Found directory containing file path for path specific information.  File path: " + parentPath);
        }
        return retval;
    }

    private void debug(String msg) {
        if (this.getLog() != null) {
            this.getLog().debug((CharSequence)msg);
        } else {
            logger.debug(msg);
        }
    }

    private void collectFile(File file, String outputFileName, SpdxDefaultFileInformation fileInfo, RelationshipType relationshipType, SpdxPackage projectPackage, SpdxDocument spdxDoc, Set<ChecksumAlgorithm> algorithms) throws SpdxCollectionException {
        if (this.spdxFiles.containsKey(file.getPath())) {
            return;
        }
        SpdxFile spdxFile = this.convertToSpdxFile(file, outputFileName, fileInfo, algorithms, spdxDoc);
        try {
            Relationship relationship = spdxDoc.createRelationship((SpdxElement)projectPackage, relationshipType, "");
            spdxFile.addRelationship(relationship);
        }
        catch (InvalidSPDXAnalysisException e) {
            if (this.log != null) {
                this.log.error((CharSequence)("Spdx exception creating file relationship: " + e.getMessage()), (Throwable)e);
            }
            throw new SpdxCollectionException("Error creating SPDX file relationship: " + e.getMessage());
        }
        if (fileInfo.getSnippets() != null) {
            for (SnippetInfo snippet : fileInfo.getSnippets()) {
                SpdxSnippet spdxSnippet;
                try {
                    spdxSnippet = this.convertToSpdxSnippet(snippet, spdxFile, spdxDoc);
                }
                catch (InvalidLicenseStringException e) {
                    logger.error("Invalid license string creating snippet", (Throwable)e);
                    throw new SpdxCollectionException("Error processing SPDX snippet information.  Invalid license string specified in snippet.", e);
                }
                catch (SpdxBuilderException e) {
                    logger.error("Error creating SPDX snippet", (Throwable)e);
                    throw new SpdxCollectionException("Error creating SPDX snippet information.", e);
                }
                catch (InvalidSPDXAnalysisException e) {
                    logger.error("SPDX Analysis error creating snippet", (Throwable)e);
                    throw new SpdxCollectionException("Error processing SPDX snippet information.", e);
                }
                this.spdxSnippets.add(spdxSnippet);
            }
        }
        this.spdxFiles.put(file.getPath(), spdxFile);
        try {
            Collection licenseInfoFromFiles = spdxFile.getLicenseInfoFromFiles();
            this.licensesFromFiles.addAll(licenseInfoFromFiles);
        }
        catch (InvalidSPDXAnalysisException e) {
            logger.error("Error getting license information from files", (Throwable)e);
            throw new SpdxCollectionException("Error getting license information from files.", e);
        }
    }

    private SpdxSnippet convertToSpdxSnippet(SnippetInfo snippet, SpdxFile spdxFile, SpdxDocument spdxDoc) throws SpdxBuilderException, InvalidSPDXAnalysisException {
        return spdxDoc.createSpdxSnippet(spdxDoc.getModelStore().getNextId(IModelStore.IdType.SpdxId, spdxDoc.getDocumentUri()), snippet.getName(), snippet.getLicenseConcluded(spdxDoc), snippet.getLicenseInfoInSnippet(spdxDoc), snippet.getCopyrightText(), spdxFile, snippet.getByteRangeStart(), snippet.getByteRangeEnd()).setComment(snippet.getComment()).setLicenseComments(snippet.getLicensComment()).setLineRange(snippet.getLineRangeStart(), snippet.getLineRangeEnd()).build();
    }

    private SpdxFile convertToSpdxFile(File file, String outputFileName, SpdxDefaultFileInformation defaultFileInformation, Set<ChecksumAlgorithm> algorithms, SpdxDocument spdxDoc) throws SpdxCollectionException {
        Set<Checksum> checksums;
        String relativePath = this.convertFilePathToSpdxFileName(outputFileName);
        ArrayList<FileType> fileTypes = new ArrayList<FileType>();
        fileTypes.add(SpdxFileCollector.extensionToFileType(this.getExtension(file)));
        try {
            checksums = SpdxFileCollector.generateChecksum(file, algorithms, spdxDoc);
        }
        catch (InvalidSPDXAnalysisException | SpdxCollectionException e1) {
            if (this.log != null) {
                this.log.error((CharSequence)("Error generating checksums for file " + file.getName()));
            }
            throw new SpdxCollectionException("Unable to generate checksum for file " + file.getName());
        }
        AnyLicenseInfo concludedLicense = null;
        AnyLicenseInfo license = null;
        String licenseComment = defaultFileInformation.getLicenseComment();
        if (this.isSourceFile(fileTypes) && file.length() < 300000L) {
            List<AnyLicenseInfo> fileSpdxLicenses;
            block21: {
                fileSpdxLicenses = null;
                try {
                    fileSpdxLicenses = SpdxSourceFileParser.parseFileForSpdxLicenses(file);
                }
                catch (SpdxSourceParserException ex) {
                    if (this.log == null) break block21;
                    this.log.error((CharSequence)"Error parsing for SPDX license ID's", (Throwable)ex);
                }
            }
            if (fileSpdxLicenses != null && fileSpdxLicenses.size() > 0) {
                if (fileSpdxLicenses.size() == 1) {
                    license = fileSpdxLicenses.get(0);
                } else {
                    try {
                        license = spdxDoc.createConjunctiveLicenseSet(fileSpdxLicenses);
                    }
                    catch (InvalidSPDXAnalysisException e) {
                        if (this.log != null) {
                            this.log.error((CharSequence)("Spdx exception creating conjunctive license set: " + e.getMessage()), (Throwable)e);
                        }
                        throw new SpdxCollectionException("Error creating SPDX file - unable to create a license set", e);
                    }
                }
                if (licenseComment == null) {
                    licenseComment = "";
                } else if (licenseComment.length() > 0) {
                    licenseComment = licenseComment.concat(";  ");
                }
                licenseComment = licenseComment.concat("This file contains SPDX-License-Identifiers for ");
                licenseComment = licenseComment.concat(license.toString());
            }
        }
        if (license == null) {
            license = defaultFileInformation.getDeclaredLicense();
            concludedLicense = defaultFileInformation.getConcludedLicense();
        } else {
            concludedLicense = license;
        }
        String copyright = defaultFileInformation.getCopyright();
        String notice = defaultFileInformation.getNotice();
        String comment = defaultFileInformation.getComment();
        String[] defaultContributors = defaultFileInformation.getContributors();
        List<String> contributors = defaultContributors != null ? Arrays.asList(defaultFileInformation.getContributors()) : new ArrayList<String>();
        SpdxFile retval = null;
        try {
            ArrayList<AnyLicenseInfo> seenLicenses = new ArrayList<AnyLicenseInfo>();
            seenLicenses.add(license);
            Checksum sha1 = null;
            for (Checksum checksum : checksums) {
                if (!ChecksumAlgorithm.SHA1.equals((Object)checksum.getAlgorithm())) continue;
                sha1 = checksum;
                break;
            }
            retval = spdxDoc.createSpdxFile(spdxDoc.getModelStore().getNextId(IModelStore.IdType.SpdxId, spdxDoc.getDocumentUri()), relativePath, concludedLicense, seenLicenses, copyright, sha1).setComment(comment).setLicenseComments(licenseComment).setFileTypes(fileTypes).setFileContributors(contributors).build();
            retval.setNoticeText(notice);
        }
        catch (InvalidSPDXAnalysisException e) {
            if (this.log != null) {
                this.log.error((CharSequence)("Spdx exception creating file: " + e.getMessage()), (Throwable)e);
            }
            throw new SpdxCollectionException("Error creating SPDX file: " + e.getMessage());
        }
        return retval;
    }

    protected boolean isSourceFile(Collection<FileType> fileTypes) {
        for (FileType ft : fileTypes) {
            if (ft != FileType.SOURCE) continue;
            return true;
        }
        return false;
    }

    public String convertFilePathToSpdxFileName(String filePath) {
        String result = filePath.replace('\\', '/');
        if (!result.startsWith("./")) {
            result = "./" + result;
        }
        return result;
    }

    public String getExtension(File file) {
        String fileName = file.getName();
        int lastDot = fileName.lastIndexOf(46);
        if (lastDot < 1) {
            return "";
        }
        return fileName.substring(lastDot + 1);
    }

    protected static FileType extensionToFileType(String fileExtension) {
        FileType retval = EXT_TO_FILE_TYPE.get(fileExtension.trim().toUpperCase());
        if (retval == null) {
            retval = FileType.OTHER;
        }
        return retval;
    }

    public Collection<SpdxFile> getFiles() {
        return this.spdxFiles.values();
    }

    public List<SpdxSnippet> getSnippets() {
        return this.spdxSnippets;
    }

    public Collection<AnyLicenseInfo> getLicenseInfoFromFiles() {
        return this.licensesFromFiles;
    }

    public SpdxPackageVerificationCode getVerificationCode(String spdxFilePath, SpdxDocument spdxDoc) throws NoSuchAlgorithmException, InvalidSPDXAnalysisException {
        Optional excludedFileName;
        ArrayList<String> excludedFileNamesFromVerificationCode = new ArrayList<String>();
        if (spdxFilePath != null && this.spdxFiles.containsKey(spdxFilePath) && (excludedFileName = this.spdxFiles.get(spdxFilePath).getName()).isPresent()) {
            excludedFileNamesFromVerificationCode.add((String)excludedFileName.get());
        }
        SpdxPackageVerificationCode verificationCode = this.calculatePackageVerificationCode(this.spdxFiles.values(), excludedFileNamesFromVerificationCode, spdxDoc);
        return verificationCode;
    }

    private SpdxPackageVerificationCode calculatePackageVerificationCode(Collection<SpdxFile> spdxFiles, List<String> excludedFileNamesFromVerificationCode, SpdxDocument spdxDoc) throws NoSuchAlgorithmException, InvalidSPDXAnalysisException {
        ArrayList<String> fileChecksums = new ArrayList<String>();
        for (SpdxFile spdxFile : spdxFiles) {
            Optional filename = spdxFile.getName();
            if (!filename.isPresent() || !this.includeInVerificationCode((String)spdxFile.getName().get(), excludedFileNamesFromVerificationCode)) continue;
            fileChecksums.add(spdxFile.getSha1());
        }
        Collections.sort(fileChecksums);
        MessageDigest verificationCodeDigest = MessageDigest.getInstance("SHA-1");
        for (String fileChecksum : fileChecksums) {
            byte[] hashInput = fileChecksum.getBytes(StandardCharsets.UTF_8);
            verificationCodeDigest.update(hashInput);
        }
        String string = SpdxFileCollector.convertChecksumToString(verificationCodeDigest.digest());
        return spdxDoc.createPackageVerificationCode(string, excludedFileNamesFromVerificationCode);
    }

    private boolean includeInVerificationCode(String name, List<String> excludedFileNamesFromVerificationCode) {
        for (String s : excludedFileNamesFromVerificationCode) {
            if (!s.equals(name)) continue;
            return false;
        }
        return true;
    }

    public static String convertChecksumToString(byte[] digestBytes) {
        StringBuilder sb = new StringBuilder();
        for (byte digestByte : digestBytes) {
            String hex = Integer.toHexString(0xFF & digestByte);
            if (hex.length() < 2) {
                sb.append('0');
            }
            sb.append(hex);
        }
        return sb.toString();
    }

    public static String generateSha1(File file, SpdxDocument spdxDoc) throws SpdxCollectionException, InvalidSPDXAnalysisException {
        HashSet<ChecksumAlgorithm> sha1 = new HashSet<ChecksumAlgorithm>();
        sha1.add(ChecksumAlgorithm.SHA1);
        Checksum sha1Checksum = SpdxFileCollector.generateChecksum(file, sha1, spdxDoc).iterator().next();
        return sha1Checksum.getValue();
    }

    public static Set<Checksum> generateChecksum(File file, Set<ChecksumAlgorithm> algorithms, SpdxDocument spdxDoc) throws SpdxCollectionException, InvalidSPDXAnalysisException {
        byte[] buffer;
        HashSet<Checksum> checksums = new HashSet<Checksum>();
        try {
            buffer = Files.readAllBytes(file.toPath());
        }
        catch (IOException e) {
            throw new SpdxCollectionException("IO error while calculating checksums.", e);
        }
        for (ChecksumAlgorithm algorithm : algorithms) {
            MessageDigest digest;
            String checksumAlgorithm = checksumAlgorithms.get(algorithm);
            try {
                digest = MessageDigest.getInstance(checksumAlgorithm);
            }
            catch (NoSuchAlgorithmException e) {
                throw new SpdxCollectionException(e);
            }
            digest.update(buffer);
            String checksum = SpdxFileCollector.convertChecksumToString(digest.digest());
            checksums.add(spdxDoc.createChecksum(algorithm, checksum));
        }
        return checksums;
    }

    public void setLog(Log log) {
        this.log = log;
    }

    private Log getLog() {
        return this.log;
    }

    static {
        SpdxFileCollector.loadFileExtensionConstants();
        checksumAlgorithms = new HashMap<ChecksumAlgorithm, String>();
        checksumAlgorithms.put(ChecksumAlgorithm.SHA1, "SHA-1");
        checksumAlgorithms.put(ChecksumAlgorithm.SHA224, "SHA-224");
        checksumAlgorithms.put(ChecksumAlgorithm.SHA256, "SHA-256");
        checksumAlgorithms.put(ChecksumAlgorithm.SHA384, "SHA-384");
        checksumAlgorithms.put(ChecksumAlgorithm.SHA3_384, "SHA-512");
        checksumAlgorithms.put(ChecksumAlgorithm.MD2, "MD2");
        checksumAlgorithms.put(ChecksumAlgorithm.MD4, "MD4");
        checksumAlgorithms.put(ChecksumAlgorithm.MD5, "MD5");
        checksumAlgorithms.put(ChecksumAlgorithm.MD6, "MD6");
    }
}

