/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.maven;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Contributor;
import org.apache.maven.model.License;
import org.apache.maven.model.Model;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingResult;
import org.apache.maven.shared.model.fileset.FileSet;
import org.spdx.jacksonstore.MultiFormatStore;
import org.spdx.library.InvalidSPDXAnalysisException;
import org.spdx.library.SpdxConstants;
import org.spdx.library.SpdxInvalidIdException;
import org.spdx.library.model.Annotation;
import org.spdx.library.model.Checksum;
import org.spdx.library.model.ExternalDocumentRef;
import org.spdx.library.model.ExternalSpdxElement;
import org.spdx.library.model.Relationship;
import org.spdx.library.model.SpdxDocument;
import org.spdx.library.model.SpdxElement;
import org.spdx.library.model.SpdxPackage;
import org.spdx.library.model.enumerations.AnnotationType;
import org.spdx.library.model.enumerations.ChecksumAlgorithm;
import org.spdx.library.model.enumerations.Purpose;
import org.spdx.library.model.enumerations.RelationshipType;
import org.spdx.library.model.license.AnyLicenseInfo;
import org.spdx.library.model.license.SpdxNoAssertionLicense;
import org.spdx.maven.LicenseManager;
import org.spdx.maven.LicenseManagerException;
import org.spdx.maven.LicenseMapperException;
import org.spdx.maven.MavenToSpdxLicenseMapper;
import org.spdx.maven.SpdxCollectionException;
import org.spdx.maven.SpdxDefaultFileInformation;
import org.spdx.maven.SpdxFileCollector;
import org.spdx.spdxRdfStore.RdfStore;
import org.spdx.storage.IModelStore;
import org.spdx.storage.simple.InMemSpdxStore;

public class SpdxDependencyInformation {
    private Log log;
    private List<Relationship> toRelationships = new ArrayList<Relationship>();
    private List<FromRelationship> fromRelationships = new ArrayList<FromRelationship>();
    private Map<String, ExternalDocumentRef> externalDocuments = new HashMap<String, ExternalDocumentRef>();
    private List<Annotation> documentAnnotations = new ArrayList<Annotation>();
    private LicenseManager licenseManager;
    private SpdxDocument spdxDoc;
    private boolean createExternalRefs = false;
    DateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");

    public SpdxDependencyInformation(Log log, LicenseManager licenseManager, SpdxDocument spdxDoc, boolean createExternalRefs) {
        this.log = log;
        this.licenseManager = licenseManager;
        this.spdxDoc = spdxDoc;
        this.createExternalRefs = createExternalRefs;
    }

    public void addMavenDependency(Artifact dependency, ProjectBuilder mavenProjectBuilder, MavenSession session, MavenProject mavenProject) throws LicenseMapperException, InvalidSPDXAnalysisException {
        String scope = dependency.getScope();
        RelationshipType relType = this.scopeToRelationshipType(scope, dependency.isOptional());
        if (relType == RelationshipType.OTHER) {
            this.log.warn((CharSequence)("Could not determine the SPDX relationship type for dependency artifact ID " + dependency.getArtifactId() + " scope " + scope));
        }
        SpdxElement dependencyPackage = this.createSpdxPackage(dependency, mavenProjectBuilder, session, mavenProject);
        if (relType.toString().endsWith("_OF")) {
            if (dependencyPackage instanceof SpdxPackage) {
                this.fromRelationships.add(new FromRelationship((SpdxPackage)dependencyPackage, relType));
                this.log.debug((CharSequence)("Added relationship of type " + relType.toString() + " for " + dependencyPackage.getName()));
            } else {
                this.toRelationships.add(this.spdxDoc.createRelationship(dependencyPackage, RelationshipType.OTHER, "This relationship is the inverse of " + relType.toString() + " to an external document reference."));
                this.log.debug((CharSequence)("Could not create proper to relationships for external element " + dependencyPackage.getId()));
            }
        } else {
            this.toRelationships.add(this.spdxDoc.createRelationship(dependencyPackage, relType, "Relationship based on Maven POM file dependency information"));
        }
    }

    private RelationshipType scopeToRelationshipType(String scope, boolean optional) {
        if (scope == null) {
            return RelationshipType.OTHER;
        }
        if (optional) {
            return RelationshipType.OPTIONAL_COMPONENT_OF;
        }
        if (scope.equals("compile") || scope.equals("runtime")) {
            return RelationshipType.DYNAMIC_LINK;
        }
        if (scope.equals("test")) {
            return RelationshipType.TEST_DEPENDENCY_OF;
        }
        return RelationshipType.OTHER;
    }

    private SpdxElement createSpdxPackage(Artifact artifact, ProjectBuilder mavenProjectBuilder, MavenSession session, MavenProject mavenProject) throws LicenseMapperException, InvalidSPDXAnalysisException {
        this.log.debug((CharSequence)("Creating SPDX package for artifact " + artifact.getArtifactId()));
        if (artifact.getFile() == null) {
            this.log.debug((CharSequence)"Artifact file is null");
        } else {
            this.log.debug((CharSequence)("Artifact file name = " + artifact.getFile().getName()));
        }
        File spdxFile = null;
        if (artifact.getFile() != null) {
            spdxFile = this.artifactFileToSpdxFile(artifact.getFile());
        }
        if (spdxFile != null && spdxFile.exists()) {
            this.log.debug((CharSequence)("Dependency " + artifact.getArtifactId() + "Looking for SPDX file " + spdxFile.getAbsolutePath()));
            try {
                this.log.debug((CharSequence)("Dependency " + artifact.getArtifactId() + "Dependency information collected from SPDX file " + spdxFile.getAbsolutePath()));
                SpdxDocument externalSpdxDoc = this.spdxDocumentFromFile(spdxFile.getPath());
                if (this.createExternalRefs) {
                    return this.createExternalSpdxPackageReference(externalSpdxDoc, spdxFile, artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion());
                }
                return this.copyPackageInfoFromExternalDoc(externalSpdxDoc, artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion());
            }
            catch (IOException e) {
                this.log.warn((CharSequence)("IO error reading SPDX document for dependency artifact ID " + artifact.getArtifactId() + ":" + e.getMessage() + ".  Using POM file information for creating SPDX package data."));
            }
            catch (SpdxInvalidIdException e) {
                this.log.warn((CharSequence)("Invalid SPDX ID exception reading SPDX document for dependency artifact ID " + artifact.getArtifactId() + ":" + e.getMessage() + ".  Using POM file information for creating SPDX package data."));
            }
            catch (InvalidSPDXAnalysisException e) {
                this.log.warn((CharSequence)("Invalid SPDX analysis exception reading SPDX document for dependency artifact ID " + artifact.getArtifactId() + ":" + e.getMessage() + ".  Using POM file information for creating SPDX package data."));
            }
            catch (SpdxCollectionException e) {
                this.log.warn((CharSequence)("Unable to create file checksum for external SPDX document for dependency artifact ID " + artifact.getArtifactId() + ":" + e.getMessage() + ".  Using POM file information for creating SPDX package data."));
            }
            catch (Exception e) {
                this.log.warn((CharSequence)("Unknown error processing SPDX document for dependency artifact ID " + artifact.getArtifactId() + ":" + e.getMessage() + ".  Using POM file information for creating SPDX package data."));
            }
        }
        try {
            DefaultProjectBuildingRequest request = new DefaultProjectBuildingRequest(session.getProjectBuildingRequest());
            request.setRemoteRepositories(mavenProject.getRemoteArtifactRepositories());
            for (ArtifactRepository ar : request.getRemoteRepositories()) {
                this.log.debug((CharSequence)("request Remote repository ID: " + ar.getId()));
            }
            for (ArtifactRepository ar : mavenProject.getRemoteArtifactRepositories()) {
                this.log.debug((CharSequence)("Project Remote repository ID: " + ar.getId()));
            }
            ProjectBuildingResult build = mavenProjectBuilder.build(artifact, (ProjectBuildingRequest)request);
            MavenProject depProject = build.getProject();
            this.log.debug((CharSequence)("Dependency " + artifact.getArtifactId() + "Collecting information from project metadata for " + depProject.getArtifactId()));
            return this.createSpdxPackage(depProject);
        }
        catch (SpdxCollectionException e) {
            this.log.error((CharSequence)("SPDX File Collection Error creating SPDX package for dependency artifact ID " + artifact.getArtifactId() + ":" + e.getMessage()));
        }
        catch (NoSuchAlgorithmException e) {
            this.log.error((CharSequence)("Verification Code Error creating SPDX package for dependency artifact ID " + artifact.getArtifactId() + ":" + e.getMessage()));
        }
        catch (ProjectBuildingException e) {
            this.log.error((CharSequence)("Maven Project Build Error creating SPDX package for dependency artifact ID " + artifact.getArtifactId() + ":" + e.getMessage()));
        }
        this.log.warn((CharSequence)("Error creating SPDX package for dependency artifact ID " + artifact.getArtifactId() + ".  A minimal SPDX package will be created."));
        this.log.debug((CharSequence)("Dependency " + artifact.getArtifactId() + "Using only artifact information to create dependent package"));
        SpdxPackage pkg = this.spdxDoc.createPackage(this.spdxDoc.getModelStore().getNextId(IModelStore.IdType.SpdxId, this.spdxDoc.getDocumentUri()), artifact.getArtifactId(), (AnyLicenseInfo)new SpdxNoAssertionLicense(), "NOASSERTION", (AnyLicenseInfo)new SpdxNoAssertionLicense()).setComment("This package was created for a Maven dependency.  No SPDX or license information could be found in the Maven POM file.").setVersionInfo(artifact.getBaseVersion()).setFilesAnalyzed(false).build();
        return pkg;
    }

    private SpdxPackage copyPackageInfoFromExternalDoc(SpdxDocument externalSpdxDoc, String groupId, String artifactId, String version) throws InvalidSPDXAnalysisException {
        Optional versionInfo;
        Optional validUntil;
        Optional supplier;
        Optional summary;
        Optional sourceInfo;
        Optional releaseDate;
        Optional primaryPurpose;
        Optional pkgFileName;
        Optional originator;
        Optional licenseComments;
        Optional homePage;
        Optional desc;
        Optional comment;
        SpdxPackage source = this.findMatchingDescribedPackage(externalSpdxDoc, artifactId);
        Optional downloadLocation = source.getDownloadLocation();
        Optional name = source.getName();
        SpdxPackage dest = this.spdxDoc.createPackage(this.spdxDoc.getModelStore().getNextId(IModelStore.IdType.SpdxId, this.spdxDoc.getDocumentUri()), name.isPresent() ? (String)name.get() : "NONE", source.getLicenseConcluded(), source.getCopyrightText(), source.getLicenseDeclared()).setFilesAnalyzed(false).setAnnotations(source.getAnnotations()).setChecksums(source.getChecksums()).setDownloadLocation(downloadLocation.isPresent() ? (String)downloadLocation.get() : "NOASSERTION").setExternalRefs(source.getExternalRefs()).build();
        Optional builtDate = source.getBuiltDate();
        if (builtDate.isPresent()) {
            dest.setBuiltDate((String)builtDate.get());
        }
        if ((comment = source.getComment()).isPresent()) {
            dest.setComment((String)comment.get());
        }
        if ((desc = source.getDescription()).isPresent()) {
            dest.setDescription((String)desc.get());
        }
        if ((homePage = source.getHomepage()).isPresent()) {
            dest.setHomepage((String)homePage.get());
        }
        if ((licenseComments = source.getLicenseComments()).isPresent()) {
            dest.setLicenseComments((String)licenseComments.get());
        }
        if ((originator = source.getOriginator()).isPresent()) {
            dest.setOriginator((String)originator.get());
        }
        if ((pkgFileName = source.getPackageFileName()).isPresent()) {
            dest.setPackageFileName((String)pkgFileName.get());
        }
        if ((primaryPurpose = source.getPrimaryPurpose()).isPresent()) {
            dest.setPrimaryPurpose((Purpose)primaryPurpose.get());
        }
        if ((releaseDate = source.getReleaseDate()).isPresent()) {
            dest.setReleaseDate((String)releaseDate.get());
        }
        if ((sourceInfo = source.getSourceInfo()).isPresent()) {
            dest.setSourceInfo((String)sourceInfo.get());
        }
        if ((summary = source.getSummary()).isPresent()) {
            dest.setSummary((String)summary.get());
        }
        if ((supplier = source.getSupplier()).isPresent()) {
            dest.setSupplier((String)supplier.get());
        }
        if ((validUntil = source.getValidUntilDate()).isPresent()) {
            dest.setValidUntilDate((String)validUntil.get());
        }
        if ((versionInfo = source.getVersionInfo()).isPresent()) {
            dest.setVersionInfo((String)versionInfo.get());
        }
        return dest;
    }

    private SpdxPackage findMatchingDescribedPackage(SpdxDocument externalSpdxDoc, String artifactId) throws InvalidSPDXAnalysisException {
        SpdxElement itemDescribed = null;
        for (SpdxElement item : externalSpdxDoc.getDocumentDescribes()) {
            Optional name = item.getName();
            if (!(item instanceof SpdxPackage) || !name.isPresent() || !((String)item.getName().get()).equals(artifactId)) continue;
            itemDescribed = item;
            break;
        }
        if (itemDescribed == null) {
            this.log.warn((CharSequence)("Could not find matching artifact ID in SPDX file for " + artifactId + ".  Using the first package found in SPDX file."));
            for (SpdxElement item : externalSpdxDoc.getDocumentDescribes()) {
                if (!(item instanceof SpdxPackage)) continue;
                itemDescribed = item;
                break;
            }
        }
        if (itemDescribed == null) {
            throw new InvalidSPDXAnalysisException("SPDX document does not contain any described items.");
        }
        return (SpdxPackage)itemDescribed;
    }

    private SpdxDocument spdxDocumentFromFile(String path) throws FileNotFoundException, IOException, InvalidSPDXAnalysisException {
        Object modelStore = path.toLowerCase().endsWith("json") ? new MultiFormatStore((IModelStore)new InMemSpdxStore(), MultiFormatStore.Format.JSON_PRETTY, MultiFormatStore.Verbose.COMPACT) : new RdfStore();
        try {
            SpdxDocument spdxDocument;
            try (FileInputStream inputStream = new FileInputStream(path);){
                String documentUri = modelStore.deSerialize((InputStream)inputStream, false);
                spdxDocument = new SpdxDocument((IModelStore)modelStore, documentUri, this.spdxDoc.getCopyManager(), false);
            }
            return spdxDocument;
        }
        finally {
            if (modelStore != null) {
                try {
                    modelStore.close();
                }
                catch (Exception e) {
                    this.log.error((CharSequence)"Error closing SPDX model store", (Throwable)e);
                }
            }
        }
    }

    private SpdxElement createExternalSpdxPackageReference(SpdxDocument externalSpdxDoc, File spdxFile, String groupId, String artifactId, @Nullable String version) throws SpdxCollectionException, InvalidSPDXAnalysisException {
        String externalDocNamespace = externalSpdxDoc.getDocumentUri();
        ExternalDocumentRef externalRef = this.externalDocuments.get(externalDocNamespace);
        StringBuilder sb = new StringBuilder(groupId).append(artifactId);
        if (Objects.nonNull(version)) {
            sb.append(version);
        }
        String fullArtifactId = sb.toString();
        if (externalRef == null) {
            String externalRefDocId = SpdxConstants.EXTERNAL_DOC_REF_PRENUM + this.fixExternalRefId(fullArtifactId);
            this.log.debug((CharSequence)("Creating external document ref " + externalDocNamespace));
            String sha1 = SpdxFileCollector.generateSha1(spdxFile, this.spdxDoc);
            Checksum cksum = externalSpdxDoc.createChecksum(ChecksumAlgorithm.SHA1, sha1);
            externalRef = this.spdxDoc.createExternalDocumentRef(externalRefDocId, externalSpdxDoc.getDocumentUri(), cksum);
            this.spdxDoc.getExternalDocumentRefs().add(externalRef);
            Annotation docRefAddedAnnotation = this.spdxDoc.createAnnotation("Tool: spdx-maven-plugin", AnnotationType.OTHER, this.format.format(new Date()), "External document ref '" + externalRefDocId + "' created for artifact " + fullArtifactId);
            this.spdxDoc.getAnnotations().add(docRefAddedAnnotation);
            this.documentAnnotations.add(docRefAddedAnnotation);
            this.externalDocuments.put(externalDocNamespace, externalRef);
            this.log.debug((CharSequence)("Created external document ref " + externalRefDocId));
        }
        SpdxPackage pkg = this.findMatchingDescribedPackage(externalSpdxDoc, artifactId);
        return new ExternalSpdxElement(this.spdxDoc.getModelStore(), this.spdxDoc.getDocumentUri(), externalRef.getId() + ":" + pkg.getId(), this.spdxDoc.getCopyManager(), true);
    }

    private String fixExternalRefId(String externalRefId) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < externalRefId.length(); ++i) {
            if (this.validExternalRefIdChar(externalRefId.charAt(i))) {
                sb.append(externalRefId.charAt(i));
                continue;
            }
            sb.append("-");
        }
        return sb.toString();
    }

    private boolean validExternalRefIdChar(char ch) {
        return ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '9' || ch == '.' || ch == '-';
    }

    private SpdxPackage createSpdxPackage(MavenProject project) throws SpdxCollectionException, NoSuchAlgorithmException, LicenseMapperException, InvalidSPDXAnalysisException {
        SpdxDefaultFileInformation fileInfo = new SpdxDefaultFileInformation();
        String packageName = project.getName();
        if (packageName == null || packageName.isEmpty()) {
            packageName = project.getArtifactId();
        }
        List contributors = project.getContributors();
        ArrayList<String> fileContributorList = new ArrayList<String>();
        if (contributors != null) {
            for (Contributor contributor : contributors) {
                fileContributorList.add(contributor.getName());
            }
        }
        String copyright = "UNSPECIFIED";
        String notice = "UNSPECIFIED";
        String downloadLocation = "NOASSERTION";
        AnyLicenseInfo declaredLicense = this.mavenLicensesToSpdxLicense(project.getLicenses());
        fileInfo.setComment("");
        fileInfo.setConcludedLicense((AnyLicenseInfo)new SpdxNoAssertionLicense());
        fileInfo.setContributors(fileContributorList.toArray(new String[0]));
        fileInfo.setCopyright(copyright);
        fileInfo.setDeclaredLicense(declaredLicense);
        fileInfo.setLicenseComment("");
        fileInfo.setNotice(notice);
        SpdxPackage retval = this.spdxDoc.createPackage(this.spdxDoc.getModelStore().getNextId(IModelStore.IdType.SpdxId, this.spdxDoc.getDocumentUri()), packageName, (AnyLicenseInfo)new SpdxNoAssertionLicense(), copyright, declaredLicense).setDownloadLocation(downloadLocation).setFilesAnalyzed(false).build();
        if (project.getVersion() != null) {
            retval.setVersionInfo(project.getVersion());
        }
        if (project.getDescription() != null) {
            retval.setDescription(project.getDescription());
            retval.setSummary(project.getDescription());
        }
        if (project.getOrganization() != null) {
            retval.setOriginator("Organization:" + project.getOrganization().getName());
        }
        if (project.getUrl() != null) {
            try {
                retval.setHomepage(project.getUrl());
            }
            catch (InvalidSPDXAnalysisException e) {
                this.log.warn((CharSequence)("Invalid homepage for dependency " + project.getArtifactId() + ": " + project.getUrl()));
            }
        }
        return retval;
    }

    private AnyLicenseInfo mavenLicensesToSpdxLicense(List<License> mavenLicenses) throws LicenseMapperException, InvalidSPDXAnalysisException {
        try {
            return this.licenseManager.mavenLicenseListToSpdxLicense(mavenLicenses);
        }
        catch (LicenseManagerException ex) {
            return MavenToSpdxLicenseMapper.getInstance(this.log).mavenLicenseListToSpdxLicense(mavenLicenses, this.spdxDoc);
        }
    }

    private FileSet[] getIncludedDirectoriesFromModel(Model model) {
        List resourceList;
        ArrayList<FileSet> result = new ArrayList<FileSet>();
        String sourcePath = model.getBuild().getSourceDirectory();
        if (sourcePath != null && !sourcePath.isEmpty()) {
            FileSet srcFileSet = new FileSet();
            File sourceDir = new File(sourcePath);
            srcFileSet.setDirectory(sourceDir.getAbsolutePath());
            srcFileSet.addInclude("**/*");
            result.add(srcFileSet);
        }
        if ((resourceList = model.getBuild().getResources()) != null) {
            for (Resource resource : resourceList) {
                FileSet resourceFileSet = new FileSet();
                File resourceDir = new File(resource.getDirectory());
                resourceFileSet.setDirectory(resourceDir.getAbsolutePath());
                resourceFileSet.setExcludes(resource.getExcludes());
                resourceFileSet.setIncludes(resource.getIncludes());
                result.add(resourceFileSet);
            }
        }
        return result.toArray(new FileSet[0]);
    }

    private File artifactFileToSpdxFile(File file) {
        File retval = this.getFileWithDifferentType(file, "spdx.rdf.xml");
        if (retval == null || !retval.exists()) {
            retval = this.getFileWithDifferentType(file, "spdx.json");
        }
        if (retval == null || !retval.exists()) {
            retval = this.getFileWithDifferentType(file, "spdx");
        }
        return retval;
    }

    private File getFileWithDifferentType(File file, String type) {
        Object filePath = file.getAbsolutePath();
        int indexOfDot = ((String)filePath).lastIndexOf(46);
        if (indexOfDot > 0) {
            filePath = ((String)filePath).substring(0, indexOfDot + 1);
        }
        filePath = (String)filePath + type;
        File retval = new File((String)filePath);
        return retval;
    }

    public Collection<ExternalDocumentRef> getDocumentExternalReferences() {
        return this.externalDocuments.values();
    }

    public List<Relationship> getToRelationships() {
        return this.toRelationships;
    }

    public List<FromRelationship> getFromRelationships() {
        return this.fromRelationships;
    }

    public Map<String, ExternalDocumentRef> getExternalDocuments() {
        return this.externalDocuments;
    }

    public List<Annotation> getDocumentAnnotations() {
        return this.documentAnnotations;
    }

    public SpdxDocument getSpdxDoc() {
        return this.spdxDoc;
    }

    public boolean isCreateExternalRefs() {
        return this.createExternalRefs;
    }

    static class FromRelationship {
        private SpdxPackage fromPackage;
        private RelationshipType relationshipType;

        FromRelationship(SpdxPackage fromPackage, RelationshipType relationshipType) {
            this.fromPackage = fromPackage;
            this.relationshipType = relationshipType;
        }

        Relationship createAndAddRelationship(SpdxPackage toPackage) throws InvalidSPDXAnalysisException {
            Relationship retval = this.fromPackage.createRelationship((SpdxElement)toPackage, this.relationshipType, "Relationship created based on Maven POM information");
            this.fromPackage.addRelationship(retval);
            return retval;
        }

        public SpdxPackage getFromPackage() {
            return this.fromPackage;
        }

        public RelationshipType getRelationshipType() {
            return this.relationshipType;
        }
    }
}

