/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.maven;

import java.io.File;
import org.spdx.core.SpdxCoreConstants;

public enum OutputFormat {
    RDF_XML("RDF/XML", "spdx.rdf.xml", ".rdf.xml", SpdxCoreConstants.SpdxMajorVersion.VERSION_2),
    JSON("JSON", "spdx.json", ".json", SpdxCoreConstants.SpdxMajorVersion.VERSION_2),
    JSON_LD("JSON-LD", "spdx.json-ld.json", ".json-ld.json", SpdxCoreConstants.SpdxMajorVersion.VERSION_3);

    private final String value;
    private final String artifactType;
    private final String fileType;
    private final SpdxCoreConstants.SpdxMajorVersion specVersion;

    private OutputFormat(String value, String artifactType, String fileType, SpdxCoreConstants.SpdxMajorVersion specVersion) {
        this.value = value;
        this.artifactType = artifactType;
        this.fileType = fileType;
        this.specVersion = specVersion;
    }

    public static OutputFormat getOutputFormat(String format, File file) throws IllegalArgumentException {
        if (format == null) {
            if (file != null) {
                String fileName = file.getName().toLowerCase();
                if (fileName.endsWith(".rdf.xml")) {
                    return RDF_XML;
                }
                return file.getName().toLowerCase().endsWith(".json-ld.json") ? JSON_LD : JSON;
            }
            throw new IllegalArgumentException("Could not determine output file");
        }
        String upperCaseFormat = format.toUpperCase();
        if (OutputFormat.RDF_XML.value.equals(upperCaseFormat)) {
            return RDF_XML;
        }
        if (OutputFormat.JSON.value.equals(upperCaseFormat)) {
            return JSON;
        }
        if (OutputFormat.JSON_LD.value.equals(upperCaseFormat)) {
            return JSON_LD;
        }
        throw new IllegalArgumentException("Invalid SPDX output format: " + format);
    }

    public String getArtifactType() {
        return this.artifactType;
    }

    public String getFileType() {
        return this.fileType;
    }

    public SpdxCoreConstants.SpdxMajorVersion getSpecVersion() {
        return this.specVersion;
    }
}

