/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.maven.utils;

import java.io.File;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.maven.shared.model.fileset.FileSet;
import org.apache.maven.shared.model.fileset.util.FileSetManager;
import org.spdx.core.IModelCopyManager;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.library.LicenseInfoFactory;
import org.spdx.library.model.v2.Relationship;
import org.spdx.library.model.v2.SpdxDocument;
import org.spdx.library.model.v2.SpdxElement;
import org.spdx.library.model.v2.SpdxFile;
import org.spdx.library.model.v2.SpdxPackage;
import org.spdx.library.model.v2.SpdxPackageVerificationCode;
import org.spdx.library.model.v2.SpdxSnippet;
import org.spdx.library.model.v2.enumerations.ChecksumAlgorithm;
import org.spdx.library.model.v2.enumerations.FileType;
import org.spdx.library.model.v2.enumerations.RelationshipType;
import org.spdx.library.model.v2.license.AnyLicenseInfo;
import org.spdx.library.model.v2.license.InvalidLicenseStringException;
import org.spdx.maven.Checksum;
import org.spdx.maven.SnippetInfo;
import org.spdx.maven.utils.AbstractFileCollector;
import org.spdx.maven.utils.SpdxBuilderException;
import org.spdx.maven.utils.SpdxCollectionException;
import org.spdx.maven.utils.SpdxDefaultFileInformation;
import org.spdx.maven.utils.SpdxSourceFileParser;
import org.spdx.maven.utils.SpdxSourceParserException;
import org.spdx.storage.IModelStore;

public class SpdxV2FileCollector
extends AbstractFileCollector {
    private static final String DEFAULT_SHA1_VALUE = "0000000000000000000000000000000000000000";
    Set<AnyLicenseInfo> licensesFromFiles = new HashSet<AnyLicenseInfo>();
    Map<String, SpdxFile> spdxFiles = new HashMap<String, SpdxFile>();
    List<SpdxSnippet> spdxSnippets = new ArrayList<SpdxSnippet>();
    FileSetManager fileSetManager = new FileSetManager();

    public void collectFiles(List<FileSet> fileSets, String baseDir, SpdxDefaultFileInformation defaultFileInformation, Map<String, SpdxDefaultFileInformation> pathSpecificInformation, SpdxPackage projectPackage, RelationshipType relationshipType, SpdxDocument spdxDoc, Set<String> algorithms) throws SpdxCollectionException {
        for (FileSet fileSet : fileSets) {
            String[] includedFiles;
            for (String includedFile : includedFiles = this.fileSetManager.getIncludedFiles(fileSet)) {
                String filePath = fileSet.getDirectory() + File.separator + includedFile;
                File file = new File(filePath);
                String relativeFilePath = file.getAbsolutePath().substring(baseDir.length() + 1).replace('\\', '/');
                SpdxDefaultFileInformation fileInfo = this.findDefaultFileInformation(relativeFilePath, pathSpecificInformation);
                if (fileInfo == null) {
                    fileInfo = defaultFileInformation;
                }
                Object outputFileName = fileSet.getOutputDirectory() != null ? fileSet.getOutputDirectory() + File.separator + includedFile : file.getAbsolutePath().substring(baseDir.length() + 1);
                this.collectFile(file, (String)outputFileName, fileInfo, relationshipType, projectPackage, spdxDoc, algorithms);
            }
        }
    }

    @Nullable
    private SpdxDefaultFileInformation findDefaultFileInformation(String filePath, Map<String, SpdxDefaultFileInformation> pathSpecificInformation) {
        int parentPathIndex;
        LOG.debug("Checking for file path {}", (Object)filePath);
        SpdxDefaultFileInformation retval = pathSpecificInformation.get(filePath);
        if (retval != null) {
            LOG.debug("Found filepath");
            return retval;
        }
        String parentPath = filePath;
        do {
            if ((parentPathIndex = parentPath.lastIndexOf("/")) <= 0) continue;
            parentPath = parentPath.substring(0, parentPathIndex);
            retval = pathSpecificInformation.get(parentPath);
        } while (retval == null && parentPathIndex > 0);
        if (retval != null) {
            LOG.debug("Found directory containing file path for path specific information.  File path: {}", (Object)parentPath);
        }
        return retval;
    }

    private void collectFile(File file, String outputFileName, SpdxDefaultFileInformation fileInfo, RelationshipType relationshipType, SpdxPackage projectPackage, SpdxDocument spdxDoc, Set<String> algorithms) throws SpdxCollectionException {
        if (this.spdxFiles.containsKey(file.getPath())) {
            return;
        }
        SpdxFile spdxFile = this.convertToSpdxFile(file, outputFileName, fileInfo, algorithms, spdxDoc);
        try {
            Relationship relationship = spdxDoc.createRelationship((SpdxElement)projectPackage, relationshipType, "");
            spdxFile.addRelationship(relationship);
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new SpdxCollectionException("Error creating SPDX file relationship", e);
        }
        if (fileInfo.getSnippets() != null) {
            for (SnippetInfo snippet : fileInfo.getSnippets()) {
                SpdxSnippet spdxSnippet;
                try {
                    spdxSnippet = this.convertToSpdxSnippet(snippet, spdxFile, spdxDoc);
                }
                catch (InvalidLicenseStringException e) {
                    throw new SpdxCollectionException("Error processing SPDX snippet information.  Invalid license string specified in snippet.", e);
                }
                catch (SpdxBuilderException e) {
                    throw new SpdxCollectionException("Error creating SPDX snippet information.", (Throwable)((Object)e));
                }
                catch (InvalidSPDXAnalysisException e) {
                    throw new SpdxCollectionException("Error processing SPDX snippet information.", e);
                }
                this.spdxSnippets.add(spdxSnippet);
            }
        }
        this.spdxFiles.put(file.getPath(), spdxFile);
        try {
            Collection licenseInfoFromFiles = spdxFile.getLicenseInfoFromFiles();
            this.licensesFromFiles.addAll(licenseInfoFromFiles);
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new SpdxCollectionException("Error getting license information from files.", e);
        }
    }

    private SpdxSnippet convertToSpdxSnippet(SnippetInfo snippet, SpdxFile spdxFile, SpdxDocument spdxDoc) throws SpdxBuilderException, InvalidSPDXAnalysisException {
        AnyLicenseInfo concludedLicense = LicenseInfoFactory.parseSPDXLicenseStringCompatV2((String)snippet.getLicenseConcluded(), (IModelStore)spdxDoc.getModelStore(), (String)spdxDoc.getDocumentUri(), (IModelCopyManager)spdxDoc.getCopyManager());
        ArrayList<AnyLicenseInfo> licenseInfoInSnippet = new ArrayList<AnyLicenseInfo>();
        licenseInfoInSnippet.add(LicenseInfoFactory.parseSPDXLicenseStringCompatV2((String)snippet.getLicenseInfoInSnippet(), (IModelStore)spdxDoc.getModelStore(), (String)spdxDoc.getDocumentUri(), (IModelCopyManager)spdxDoc.getCopyManager()));
        return spdxDoc.createSpdxSnippet(spdxDoc.getModelStore().getNextId(IModelStore.IdType.SpdxId), snippet.getName(), concludedLicense, licenseInfoInSnippet, snippet.getCopyrightText(), spdxFile, snippet.getByteRangeStart(), snippet.getByteRangeEnd()).setComment(snippet.getComment()).setLicenseComments(snippet.getLicensComment()).setLineRange(snippet.getLineRangeStart(), snippet.getLineRangeEnd()).build();
    }

    private SpdxFile convertToSpdxFile(File file, String outputFileName, SpdxDefaultFileInformation defaultFileInformation, Set<String> algorithms, SpdxDocument spdxDoc) throws SpdxCollectionException {
        SpdxFile retval;
        AnyLicenseInfo concludedLicense;
        Set<Checksum> checksums;
        String relativePath = this.convertFilePathToSpdxFileName(outputFileName);
        ArrayList<FileType> fileTypes = new ArrayList<FileType>();
        fileTypes.add(SpdxV2FileCollector.extensionToFileType(this.getExtension(file)));
        try {
            checksums = SpdxV2FileCollector.generateChecksum(file, algorithms);
        }
        catch (InvalidSPDXAnalysisException | SpdxCollectionException e1) {
            throw new SpdxCollectionException("Unable to generate checksum for file " + file.getName());
        }
        AnyLicenseInfo license = null;
        String licenseComment = defaultFileInformation.getLicenseComment();
        if (this.isSourceFile(fileTypes) && file.length() < 300000L) {
            List<String> fileSpdxLicenses = null;
            try {
                fileSpdxLicenses = SpdxSourceFileParser.parseFileForSpdxLicenses(file);
            }
            catch (SpdxSourceParserException ex) {
                LOG.error("Error parsing for SPDX license ID's", (Throwable)ex);
            }
            if (fileSpdxLicenses != null && !fileSpdxLicenses.isEmpty()) {
                try {
                    if (fileSpdxLicenses.size() == 1) {
                        license = LicenseInfoFactory.parseSPDXLicenseStringCompatV2((String)fileSpdxLicenses.get(0), (IModelStore)spdxDoc.getModelStore(), (String)spdxDoc.getDocumentUri(), (IModelCopyManager)spdxDoc.getCopyManager());
                    } else {
                        HashSet<AnyLicenseInfo> licenseSet = new HashSet<AnyLicenseInfo>();
                        for (String licenseExpression : fileSpdxLicenses) {
                            licenseSet.add(LicenseInfoFactory.parseSPDXLicenseStringCompatV2((String)licenseExpression, (IModelStore)spdxDoc.getModelStore(), (String)spdxDoc.getDocumentUri(), (IModelCopyManager)spdxDoc.getCopyManager()));
                        }
                        license = spdxDoc.createConjunctiveLicenseSet(licenseSet);
                    }
                }
                catch (InvalidSPDXAnalysisException e) {
                    LOG.error("Invalid license expressions found in source file {}", (Object)file.getName(), (Object)e);
                }
                if (licenseComment == null) {
                    licenseComment = "";
                } else if (!licenseComment.isEmpty()) {
                    licenseComment = licenseComment.concat(";  ");
                }
                licenseComment = licenseComment.concat("This file contains SPDX-License-Identifiers for ");
                if (license != null) {
                    licenseComment = licenseComment.concat(license.toString());
                }
            }
        }
        if (license == null) {
            try {
                license = LicenseInfoFactory.parseSPDXLicenseStringCompatV2((String)defaultFileInformation.getDeclaredLicense(), (IModelStore)spdxDoc.getModelStore(), (String)spdxDoc.getDocumentUri(), (IModelCopyManager)spdxDoc.getCopyManager());
                concludedLicense = LicenseInfoFactory.parseSPDXLicenseStringCompatV2((String)defaultFileInformation.getConcludedLicense(), (IModelStore)spdxDoc.getModelStore(), (String)spdxDoc.getDocumentUri(), (IModelCopyManager)spdxDoc.getCopyManager());
            }
            catch (InvalidSPDXAnalysisException e) {
                throw new SpdxCollectionException("Error creating SPDX file - unable create default file license", e);
            }
        } else {
            concludedLicense = license;
        }
        String copyright = defaultFileInformation.getCopyright();
        String notice = defaultFileInformation.getNotice();
        String comment = defaultFileInformation.getComment();
        String[] defaultContributors = defaultFileInformation.getContributors();
        List<String> contributors = defaultContributors != null ? Arrays.asList(defaultFileInformation.getContributors()) : new ArrayList<String>();
        try {
            ArrayList<AnyLicenseInfo> seenLicenses = new ArrayList<AnyLicenseInfo>();
            seenLicenses.add(license);
            String sha1Value = null;
            for (Checksum checksum : checksums) {
                if (!ChecksumAlgorithm.SHA1.toString().equals(checksum.getAlgorithm())) continue;
                sha1Value = checksum.getValue();
                break;
            }
            if (sha1Value == null) {
                LOG.error("No SHA1 checksum was found for file {}", (Object)file.getName());
                sha1Value = DEFAULT_SHA1_VALUE;
            }
            retval = spdxDoc.createSpdxFile(spdxDoc.getModelStore().getNextId(IModelStore.IdType.SpdxId), relativePath, concludedLicense, seenLicenses, copyright, spdxDoc.createChecksum(ChecksumAlgorithm.SHA1, sha1Value)).setComment(comment).setLicenseComments(licenseComment).setFileTypes(fileTypes).setFileContributors(contributors).build();
            retval.setNoticeText(notice);
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new SpdxCollectionException("Error creating SPDX file", e);
        }
        return retval;
    }

    public Collection<SpdxFile> getFiles() {
        return this.spdxFiles.values();
    }

    public List<SpdxSnippet> getSnippets() {
        return this.spdxSnippets;
    }

    public Collection<AnyLicenseInfo> getLicenseInfoFromFiles() {
        return this.licensesFromFiles;
    }

    public SpdxPackageVerificationCode getVerificationCode(String spdxFilePath, SpdxDocument spdxDoc) throws NoSuchAlgorithmException, InvalidSPDXAnalysisException {
        ArrayList<String> excludedFileNamesFromVerificationCode = new ArrayList<String>();
        if (spdxFilePath != null && this.spdxFiles.containsKey(spdxFilePath)) {
            Optional excludedFileName = this.spdxFiles.get(spdxFilePath).getName();
            excludedFileName.ifPresent(excludedFileNamesFromVerificationCode::add);
        }
        SpdxPackageVerificationCode verificationCode = this.calculatePackageVerificationCode(this.spdxFiles.values(), excludedFileNamesFromVerificationCode, spdxDoc);
        return verificationCode;
    }

    private SpdxPackageVerificationCode calculatePackageVerificationCode(Collection<SpdxFile> spdxFiles, List<String> excludedFileNamesFromVerificationCode, SpdxDocument spdxDoc) throws NoSuchAlgorithmException, InvalidSPDXAnalysisException {
        ArrayList<String> fileChecksums = new ArrayList<String>();
        for (SpdxFile spdxFile : spdxFiles) {
            Optional filename = spdxFile.getName();
            if (!filename.isPresent() || !this.includeInVerificationCode((String)filename.get(), excludedFileNamesFromVerificationCode)) continue;
            fileChecksums.add(spdxFile.getSha1());
        }
        Collections.sort(fileChecksums);
        MessageDigest verificationCodeDigest = MessageDigest.getInstance("SHA-1");
        for (String fileChecksum : fileChecksums) {
            byte[] hashInput = fileChecksum.getBytes(StandardCharsets.UTF_8);
            verificationCodeDigest.update(hashInput);
        }
        String string = SpdxV2FileCollector.convertChecksumToString(verificationCodeDigest.digest());
        return spdxDoc.createPackageVerificationCode(string, excludedFileNamesFromVerificationCode);
    }

    private boolean includeInVerificationCode(String name, List<String> excludedFileNamesFromVerificationCode) {
        for (String s : excludedFileNamesFromVerificationCode) {
            if (!s.equals(name)) continue;
            return false;
        }
        return true;
    }
}

