/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.maven.utils;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.maven.model.License;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.model.fileset.FileSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spdx.core.CoreModelObject;
import org.spdx.core.IModelCopyManager;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.library.LicenseInfoFactory;
import org.spdx.library.conversion.Spdx2to3Converter;
import org.spdx.library.model.v2.ReferenceType;
import org.spdx.library.model.v2.enumerations.AnnotationType;
import org.spdx.library.model.v2.enumerations.ChecksumAlgorithm;
import org.spdx.library.model.v2.enumerations.ReferenceCategory;
import org.spdx.library.model.v3_0_1.core.CreationInfo;
import org.spdx.library.model.v3_0_1.core.DictionaryEntry;
import org.spdx.library.model.v3_0_1.core.Element;
import org.spdx.library.model.v3_0_1.core.HashAlgorithm;
import org.spdx.library.model.v3_0_1.core.Relationship;
import org.spdx.library.model.v3_0_1.core.RelationshipCompleteness;
import org.spdx.library.model.v3_0_1.core.RelationshipType;
import org.spdx.library.model.v3_0_1.core.SpdxDocument;
import org.spdx.library.model.v3_0_1.core.Tool;
import org.spdx.library.model.v3_0_1.simplelicensing.AnyLicenseInfo;
import org.spdx.library.model.v3_0_1.software.Sbom;
import org.spdx.library.model.v3_0_1.software.SoftwareArtifact;
import org.spdx.library.model.v3_0_1.software.SoftwarePurpose;
import org.spdx.library.model.v3_0_1.software.SpdxFile;
import org.spdx.library.model.v3_0_1.software.SpdxPackage;
import org.spdx.library.referencetype.ListedReferenceTypes;
import org.spdx.maven.Annotation;
import org.spdx.maven.Checksum;
import org.spdx.maven.ExternalReference;
import org.spdx.maven.NonStandardLicense;
import org.spdx.maven.OutputFormat;
import org.spdx.maven.Packaging;
import org.spdx.maven.utils.AbstractDocumentBuilder;
import org.spdx.maven.utils.LicenseManagerException;
import org.spdx.maven.utils.LicenseMapperException;
import org.spdx.maven.utils.SpdxBuilderException;
import org.spdx.maven.utils.SpdxCollectionException;
import org.spdx.maven.utils.SpdxDefaultFileInformation;
import org.spdx.maven.utils.SpdxExternalIdBuilder;
import org.spdx.maven.utils.SpdxProjectInformation;
import org.spdx.maven.utils.SpdxV3FileCollector;
import org.spdx.maven.utils.SpdxV3LicenseManager;
import org.spdx.storage.IModelStore;
import org.spdx.storage.simple.InMemSpdxStore;
import org.spdx.v3jsonldstore.JsonLDStore;

public class SpdxV3DocumentBuilder
extends AbstractDocumentBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(SpdxV3DocumentBuilder.class);
    protected CreationInfo creationInfo;
    protected Sbom sbom;
    protected SpdxDocument spdxDoc;
    protected SpdxPackage projectPackage;
    protected SpdxV3LicenseManager licenseManager;
    protected List<DictionaryEntry> customIdToUri = new ArrayList<DictionaryEntry>();

    public SpdxV3DocumentBuilder(MavenProject mavenProject, boolean generatePurls, File spdxFile, URI namespaceUri, OutputFormat outputFormatEnum) throws SpdxBuilderException, LicenseMapperException {
        super(mavenProject, generatePurls, spdxFile, outputFormatEnum);
        if (namespaceUri == null) {
            throw new SpdxBuilderException("Missing namespaceUri");
        }
        if (!OutputFormat.JSON_LD.equals((Object)outputFormatEnum)) {
            throw new SpdxBuilderException(String.format("Unsupported output format for SPDX spec version 3: %s", outputFormatEnum.toString()));
        }
        try {
            this.modelStore = new JsonLDStore((IModelStore)new InMemSpdxStore());
            this.creationInfo = new CreationInfo((IModelStore)this.modelStore, this.modelStore.getNextId(IModelStore.IdType.Anonymous), (IModelCopyManager)this.copyManager, true, namespaceUri.toString());
            this.sbom = this.creationInfo.createSbom(namespaceUri + "sbom").build();
            this.spdxDoc = this.sbom.createSpdxDocument(namespaceUri + "/Document").addRootElement((Element)this.sbom).build();
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new SpdxBuilderException("Error creating SPDX SBOM", e);
        }
        this.licenseManager = new SpdxV3LicenseManager(this.spdxDoc);
    }

    public SpdxDocument getSpdxDoc() {
        return this.spdxDoc;
    }

    @Override
    public void fillSpdxDocumentInformation(SpdxProjectInformation projectInformation) throws SpdxBuilderException {
        try {
            if (projectInformation.getDocumentComment() != null && !projectInformation.getDocumentComment().isEmpty()) {
                this.spdxDoc.setComment(projectInformation.getDocumentComment());
            }
            this.fillCreatorInfo(projectInformation);
            if (projectInformation.getDocumentAnnotations() != null && projectInformation.getDocumentAnnotations().length > 0) {
                this.addSpdxAnnotations(projectInformation.getDocumentAnnotations(), (Element)this.spdxDoc);
            }
            this.spdxDoc.setName(projectInformation.getName());
            this.projectPackage = this.createSpdxPackage(projectInformation);
            this.sbom.getRootElements().add(this.projectPackage);
        }
        catch (MojoExecutionException | InvalidSPDXAnalysisException e) {
            throw new SpdxBuilderException("Error adding package information to SPDX document", e);
        }
    }

    private void addSpdxAnnotations(Annotation[] annotations, Element element) throws MojoExecutionException {
        for (Annotation annotation : annotations) {
            org.spdx.library.model.v3_0_1.core.AnnotationType annotationType;
            try {
                annotationType = (org.spdx.library.model.v3_0_1.core.AnnotationType)Spdx2to3Converter.ANNOTATION_TYPE_MAP.get(AnnotationType.valueOf((String)annotation.getAnnotationType()));
            }
            catch (Exception ex) {
                throw new MojoExecutionException("Invalid annotation type " + annotation.getAnnotationType());
            }
            try {
                CreationInfo creationInfo = new CreationInfo.CreationInfoBuilder(this.spdxDoc.getModelStore(), this.spdxDoc.getModelStore().getNextId(IModelStore.IdType.Anonymous), this.spdxDoc.getCopyManager()).setCreated(annotation.getAnnotationDate()).setSpecVersion("3.0.1").build();
                creationInfo.setIdPrefix(element.getIdPrefix());
                creationInfo.getCreatedBys().add(Spdx2to3Converter.stringToAgent((String)annotation.getAnnotator(), (CreationInfo)creationInfo));
                element.createAnnotation(element.getIdPrefix() + element.getModelStore().getNextId(IModelStore.IdType.SpdxId)).setAnnotationType(annotationType).setStatement(annotation.getAnnotationComment()).setSubject(element).setCreationInfo(creationInfo).build();
            }
            catch (InvalidSPDXAnalysisException e) {
                throw new MojoExecutionException("Error creating annotation.", (Exception)((Object)e));
            }
        }
    }

    private void fillCreatorInfo(SpdxProjectInformation projectInformation) throws InvalidSPDXAnalysisException {
        String[] parameterCreators;
        CreationInfo creationInfo = this.spdxDoc.getCreationInfo();
        Objects.requireNonNull(creationInfo, "CreationInfo for the SPDX document must not be null");
        creationInfo.setCreated(projectInformation.getCreated());
        for (String parameterCreator : parameterCreators = projectInformation.getCreators()) {
            try {
                if (parameterCreator.startsWith("Tool:")) {
                    Tool tool = this.spdxDoc.createTool(this.spdxDoc.getIdPrefix() + this.spdxDoc.getModelStore().getNextId(IModelStore.IdType.SpdxId)).setName(parameterCreator.substring("Tool:".length()).trim()).build();
                    creationInfo.getCreatedUsings().add(tool);
                    continue;
                }
                creationInfo.getCreatedBys().add(Spdx2to3Converter.stringToAgent((String)parameterCreator, (CreationInfo)creationInfo));
            }
            catch (InvalidSPDXAnalysisException e) {
                LOG.warn("Invalid creator string, {} will be skipped.", (Object)parameterCreator);
            }
        }
        String comment = projectInformation.getCreatorComment();
        if (Objects.nonNull(comment) && !comment.isBlank()) {
            creationInfo.setComment(comment);
        }
    }

    private SpdxPackage createSpdxPackage(SpdxProjectInformation projectInformation) throws SpdxBuilderException {
        SpdxPackage pkg;
        String downloadUrl;
        String copyrightText = projectInformation.getCopyrightText();
        if (copyrightText == null) {
            copyrightText = "UNSPECIFIED";
        }
        if ((downloadUrl = projectInformation.getDownloadUrl()) == null || downloadUrl.isBlank()) {
            downloadUrl = "UNSPECIFIED";
        }
        try {
            AnyLicenseInfo concludedLicense = LicenseInfoFactory.parseSPDXLicenseString((String)projectInformation.getConcludedLicense(), (IModelStore)this.spdxDoc.getModelStore(), (String)this.spdxDoc.getIdPrefix(), (IModelCopyManager)this.spdxDoc.getCopyManager(), this.customIdToUri);
            AnyLicenseInfo declaredLicense = LicenseInfoFactory.parseSPDXLicenseString((String)projectInformation.getDeclaredLicense(), (IModelStore)this.spdxDoc.getModelStore(), (String)this.spdxDoc.getIdPrefix(), (IModelCopyManager)this.spdxDoc.getCopyManager(), this.customIdToUri);
            Packaging packaging = Packaging.valueOfPackaging(this.project.getPackaging());
            SoftwarePurpose primaryPurpose = packaging != null ? packaging.getSoftwarePurpose() : SoftwarePurpose.LIBRARY;
            pkg = this.spdxDoc.createSpdxPackage(this.spdxDoc.getIdPrefix() + this.spdxDoc.getModelStore().getNextId(IModelStore.IdType.SpdxId)).setName(projectInformation.getName()).setDownloadLocation(downloadUrl).setPrimaryPurpose(primaryPurpose).setCopyrightText(copyrightText).addAllExternalIdentifier(SpdxExternalIdBuilder.getDefaultExternalIdentifiers(this.spdxDoc, this.generatePurls, this.project)).build();
            pkg.createRelationship(pkg.getIdPrefix() + pkg.getModelStore().getNextId(IModelStore.IdType.SpdxId)).setRelationshipType(RelationshipType.HAS_DECLARED_LICENSE).setCompleteness(RelationshipCompleteness.COMPLETE).setFrom((Element)pkg).addTo((Element)declaredLicense).build();
            pkg.createRelationship(pkg.getIdPrefix() + pkg.getModelStore().getNextId(IModelStore.IdType.SpdxId)).setRelationshipType(RelationshipType.HAS_CONCLUDED_LICENSE).setCompleteness(RelationshipCompleteness.COMPLETE).setFrom((Element)pkg).addTo((Element)concludedLicense).build();
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new SpdxBuilderException("Error creating initial package", e);
        }
        if (projectInformation.getPackageAnnotations() != null && projectInformation.getPackageAnnotations().length > 0) {
            try {
                this.addSpdxAnnotations(projectInformation.getPackageAnnotations(), (Element)pkg);
            }
            catch (MojoExecutionException e) {
                throw new SpdxBuilderException("Error adding package annotations to SPDX document", e);
            }
        }
        try {
            if (projectInformation.getDescription() != null) {
                pkg.setDescription(projectInformation.getDescription());
            }
            if (projectInformation.getDownloadUrl() != null) {
                pkg.setDownloadLocation(projectInformation.getDownloadUrl());
            }
            if (projectInformation.getPackageArchiveFileName() != null) {
                SpdxFile packageFile = pkg.createSpdxFile(pkg.getIdPrefix() + pkg.getModelStore().getNextId(IModelStore.IdType.SpdxId)).setName(projectInformation.getPackageArchiveFileName()).build();
                if (projectInformation.getChecksums() != null) {
                    try {
                        for (Checksum checksum : projectInformation.getChecksums()) {
                            HashAlgorithm algorithm = (HashAlgorithm)Spdx2to3Converter.HASH_ALGORITH_MAP.get(ChecksumAlgorithm.valueOf((String)checksum.getAlgorithm()));
                            if (Objects.isNull(algorithm)) {
                                LOG.error("Invalid checksum algorithm {}", (Object)checksum.getAlgorithm());
                                continue;
                            }
                            packageFile.getVerifiedUsings().add(packageFile.createHash(packageFile.getModelStore().getNextId(IModelStore.IdType.Anonymous)).setAlgorithm(algorithm).setHashValue(checksum.getValue()).build());
                        }
                    }
                    catch (InvalidSPDXAnalysisException e) {
                        throw new SpdxBuilderException("Error adding package information to SPDX document - Invalid checksum provided", e);
                    }
                }
                pkg.createRelationship(pkg.getIdPrefix() + pkg.getModelStore().getNextId(IModelStore.IdType.SpdxId)).setFrom((Element)pkg).addTo((Element)packageFile).setCompleteness(RelationshipCompleteness.COMPLETE).setRelationshipType(RelationshipType.HAS_DISTRIBUTION_ARTIFACT).build();
            }
            if (projectInformation.getHomePage() != null) {
                try {
                    pkg.setHomePage(projectInformation.getHomePage());
                }
                catch (InvalidSPDXAnalysisException ex) {
                    LOG.warn("Invalid URL in project POM file: {}", (Object)projectInformation.getHomePage());
                }
            }
            if (projectInformation.getSourceInfo() != null) {
                pkg.setSourceInfo(projectInformation.getSourceInfo());
            }
            if (projectInformation.getLicenseComment() != null) {
                pkg.setComment("License: " + projectInformation.getLicenseComment());
            }
            if (projectInformation.getOriginator() != null) {
                pkg.getOriginatedBys().add(Spdx2to3Converter.stringToAgent((String)projectInformation.getOriginator(), (CreationInfo)pkg.getCreationInfo()));
            }
            if (projectInformation.getShortDescription() != null) {
                pkg.setSummary(projectInformation.getShortDescription());
            }
            if (projectInformation.getSupplier() != null) {
                pkg.setSuppliedBy(Spdx2to3Converter.stringToAgent((String)projectInformation.getSupplier(), (CreationInfo)pkg.getCreationInfo()));
            }
            if (projectInformation.getVersionInfo() != null) {
                pkg.setPackageVersion(projectInformation.getVersionInfo());
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new SpdxBuilderException("Error adding package properties", e);
        }
        ExternalReference[] externalRefs = projectInformation.getExternalRefs();
        try {
            this.addExternalRefs(externalRefs, (SoftwareArtifact)pkg);
        }
        catch (MojoExecutionException e) {
            throw new SpdxBuilderException("Error adding external references to package", e);
        }
        return pkg;
    }

    private void addExternalRefs(ExternalReference[] externalRefs, SoftwareArtifact artifact) throws MojoExecutionException {
        if (Objects.isNull(externalRefs)) {
            return;
        }
        for (ExternalReference externalRef : externalRefs) {
            ReferenceType refType;
            ReferenceCategory cat;
            try {
                cat = ReferenceCategory.valueOf((String)externalRef.getCategory().replaceAll("-", "_"));
            }
            catch (Exception ex) {
                throw new MojoExecutionException("External reference category " + externalRef.getCategory() + " is not recognized as a valid, standard category.");
            }
            try {
                refType = ListedReferenceTypes.getListedReferenceTypes().getListedReferenceTypeByName(externalRef.getType());
            }
            catch (InvalidSPDXAnalysisException e) {
                throw new MojoExecutionException("Error getting listed reference type for " + externalRef.getType(), (Exception)((Object)e));
            }
            if (refType == null) {
                throw new MojoExecutionException("Listed reference type not found for " + externalRef.getType());
            }
            try {
                Spdx2to3Converter.addExternalRefToArtifact((ReferenceCategory)cat, (ReferenceType)refType, (String)externalRef.getLocator(), (String)externalRef.getComment(), (SoftwareArtifact)artifact, (IModelStore)artifact.getModelStore());
            }
            catch (InvalidSPDXAnalysisException e) {
                throw new MojoExecutionException("Error adding external ref to artifact", (Exception)((Object)e));
            }
        }
    }

    @Override
    public void collectSpdxFileInformation(List<FileSet> sources, String baseDir, SpdxDefaultFileInformation defaultFileInformation, HashMap<String, SpdxDefaultFileInformation> pathSpecificInformation, Set<String> checksumAlgorithms) throws SpdxBuilderException {
        SpdxV3FileCollector fileCollector = new SpdxV3FileCollector(this.customIdToUri);
        try {
            fileCollector.collectFiles(sources, baseDir, defaultFileInformation, pathSpecificInformation, this.projectPackage, RelationshipType.GENERATES, this.spdxDoc, checksumAlgorithms);
            Relationship pkgRelationship = this.projectPackage.createRelationship(this.projectPackage.getIdPrefix() + this.projectPackage.getModelStore().getNextId(IModelStore.IdType.SpdxId)).setFrom((Element)this.projectPackage).setRelationshipType(RelationshipType.CONTAINS).build();
            for (SpdxFile file : fileCollector.getFiles()) {
                pkgRelationship.getTos().add(file);
            }
        }
        catch (InvalidSPDXAnalysisException | SpdxCollectionException e) {
            throw new SpdxBuilderException("Error collecting SPDX file information", e);
        }
    }

    @Override
    public void saveSpdxDocumentToFile() throws SpdxBuilderException {
        try (FileOutputStream spdxOut = new FileOutputStream(this.spdxFile);){
            this.modelStore.serialize((OutputStream)spdxOut);
        }
        catch (FileNotFoundException e) {
            throw new SpdxBuilderException("Error saving SPDX data to file", e);
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new SpdxBuilderException("Error collecting SPDX file data", e);
        }
        catch (IOException e) {
            throw new SpdxBuilderException("I/O Error saving SPDX data to file", e);
        }
    }

    @Override
    public void addNonStandardLicenses(NonStandardLicense[] nonStandardLicenses) throws SpdxBuilderException {
        if (nonStandardLicenses != null) {
            for (NonStandardLicense nonStandardLicense : nonStandardLicenses) {
                try {
                    this.licenseManager.addExtractedLicense(nonStandardLicense);
                }
                catch (LicenseManagerException e) {
                    throw new SpdxBuilderException("Error adding non standard license", e);
                }
            }
        }
    }

    @Override
    public CoreModelObject getProjectPackage() {
        return this.projectPackage;
    }

    @Override
    public String mavenLicenseListToSpdxLicenseExpression(List<License> mavenLicenses) throws LicenseManagerException {
        return this.licenseManager.mavenLicenseListToSpdxLicense(mavenLicenses).toString();
    }

    public SpdxV3LicenseManager getLicenseManager() {
        return this.licenseManager;
    }

    @Override
    public List<String> verify() {
        return this.spdxDoc.verify();
    }
}

