/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.maven.utils;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.maven.shared.model.fileset.FileSet;
import org.apache.maven.shared.model.fileset.util.FileSetManager;
import org.spdx.core.IModelCopyManager;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.library.LicenseInfoFactory;
import org.spdx.library.conversion.Spdx2to3Converter;
import org.spdx.library.model.v2.enumerations.ChecksumAlgorithm;
import org.spdx.library.model.v2.enumerations.FileType;
import org.spdx.library.model.v3_0_1.core.DictionaryEntry;
import org.spdx.library.model.v3_0_1.core.Element;
import org.spdx.library.model.v3_0_1.core.Hash;
import org.spdx.library.model.v3_0_1.core.HashAlgorithm;
import org.spdx.library.model.v3_0_1.core.Person;
import org.spdx.library.model.v3_0_1.core.PositiveIntegerRange;
import org.spdx.library.model.v3_0_1.core.RelationshipCompleteness;
import org.spdx.library.model.v3_0_1.core.RelationshipType;
import org.spdx.library.model.v3_0_1.core.SpdxDocument;
import org.spdx.library.model.v3_0_1.simplelicensing.AnyLicenseInfo;
import org.spdx.library.model.v3_0_1.software.Snippet;
import org.spdx.library.model.v3_0_1.software.SoftwarePurpose;
import org.spdx.library.model.v3_0_1.software.SpdxFile;
import org.spdx.library.model.v3_0_1.software.SpdxPackage;
import org.spdx.maven.Checksum;
import org.spdx.maven.SnippetInfo;
import org.spdx.maven.utils.AbstractFileCollector;
import org.spdx.maven.utils.SpdxBuilderException;
import org.spdx.maven.utils.SpdxCollectionException;
import org.spdx.maven.utils.SpdxDefaultFileInformation;
import org.spdx.maven.utils.SpdxSourceFileParser;
import org.spdx.maven.utils.SpdxSourceParserException;
import org.spdx.maven.utils.SpdxV2FileCollector;
import org.spdx.storage.IModelStore;

public class SpdxV3FileCollector
extends AbstractFileCollector {
    static final Map<String, String> EXT_TO_MEDIA_TYPE = new HashMap<String, String>();
    static final Map<String, SoftwarePurpose> EXT_TO_PURPOSE = new HashMap<String, SoftwarePurpose>();
    Map<String, SpdxFile> spdxFiles = new HashMap<String, SpdxFile>();
    List<Snippet> spdxSnippets = new ArrayList<Snippet>();
    FileSetManager fileSetManager = new FileSetManager();
    private final List<DictionaryEntry> customIdToUri;

    public SpdxV3FileCollector(List<DictionaryEntry> customIdToUri) {
        this.customIdToUri = customIdToUri;
    }

    public void collectFiles(List<FileSet> fileSets, String baseDir, SpdxDefaultFileInformation defaultFileInformation, Map<String, SpdxDefaultFileInformation> pathSpecificInformation, SpdxPackage projectPackage, RelationshipType relationshipType, SpdxDocument spdxDoc, Set<String> algorithms) throws SpdxCollectionException {
        for (FileSet fileSet : fileSets) {
            String[] includedFiles;
            for (String includedFile : includedFiles = this.fileSetManager.getIncludedFiles(fileSet)) {
                String filePath = fileSet.getDirectory() + File.separator + includedFile;
                File file = new File(filePath);
                String relativeFilePath = file.getAbsolutePath().substring(baseDir.length() + 1).replace('\\', '/');
                SpdxDefaultFileInformation fileInfo = this.findDefaultFileInformation(relativeFilePath, pathSpecificInformation);
                if (fileInfo == null) {
                    fileInfo = defaultFileInformation;
                }
                Object outputFileName = fileSet.getOutputDirectory() != null ? fileSet.getOutputDirectory() + File.separator + includedFile : file.getAbsolutePath().substring(baseDir.length() + 1);
                this.collectFile(file, (String)outputFileName, fileInfo, relationshipType, projectPackage, spdxDoc, algorithms);
            }
        }
    }

    private SpdxDefaultFileInformation findDefaultFileInformation(String filePath, Map<String, SpdxDefaultFileInformation> pathSpecificInformation) {
        int parentPathIndex;
        LOG.debug("Checking for file path {}", (Object)filePath);
        SpdxDefaultFileInformation retval = pathSpecificInformation.get(filePath);
        if (retval != null) {
            LOG.debug("Found filepath");
            return retval;
        }
        String parentPath = filePath;
        do {
            if ((parentPathIndex = parentPath.lastIndexOf("/")) <= 0) continue;
            parentPath = parentPath.substring(0, parentPathIndex);
            retval = pathSpecificInformation.get(parentPath);
        } while (retval == null && parentPathIndex > 0);
        if (retval != null) {
            LOG.debug("Found directory containing file path for path specific information.  File path: {}", (Object)parentPath);
        }
        return retval;
    }

    private void collectFile(File file, String outputFileName, SpdxDefaultFileInformation fileInfo, RelationshipType relationshipType, SpdxPackage projectPackage, SpdxDocument spdxDoc, Set<String> algorithms) throws SpdxCollectionException {
        if (this.spdxFiles.containsKey(file.getPath())) {
            return;
        }
        SpdxFile spdxFile = this.convertToSpdxFile(file, outputFileName, fileInfo, algorithms, spdxDoc);
        try {
            spdxDoc.createRelationship(spdxDoc.getIdPrefix() + spdxDoc.getModelStore().getNextId(IModelStore.IdType.SpdxId)).setFrom((Element)spdxFile).addTo((Element)projectPackage).setRelationshipType(relationshipType).build();
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new SpdxCollectionException("Error creating SPDX file relationship", e);
        }
        if (fileInfo.getSnippets() != null) {
            for (SnippetInfo snippet : fileInfo.getSnippets()) {
                Snippet spdxSnippet;
                try {
                    spdxSnippet = this.convertToSpdxSnippet(snippet, spdxFile);
                }
                catch (SpdxBuilderException e) {
                    throw new SpdxCollectionException("Error creating SPDX snippet information.", (Throwable)((Object)e));
                }
                catch (InvalidSPDXAnalysisException e) {
                    throw new SpdxCollectionException("Error processing SPDX snippet information.", e);
                }
                this.spdxSnippets.add(spdxSnippet);
            }
        }
        this.spdxFiles.put(file.getPath(), spdxFile);
    }

    private Snippet convertToSpdxSnippet(SnippetInfo snippet, SpdxFile spdxFile) throws SpdxBuilderException, InvalidSPDXAnalysisException {
        String licenseComment;
        PositiveIntegerRange byteRange = spdxFile.createPositiveIntegerRange(spdxFile.getModelStore().getNextId(IModelStore.IdType.Anonymous)).setBeginIntegerRange(Integer.valueOf(snippet.getByteRangeStart())).setEndIntegerRange(Integer.valueOf(snippet.getByteRangeEnd())).build();
        PositiveIntegerRange lineRange = spdxFile.createPositiveIntegerRange(spdxFile.getModelStore().getNextId(IModelStore.IdType.Anonymous)).setBeginIntegerRange(Integer.valueOf(snippet.getLineRangeStart())).setEndIntegerRange(Integer.valueOf(snippet.getLineRangeEnd())).build();
        Snippet retval = spdxFile.createSnippet(spdxFile.getIdPrefix() + spdxFile.getModelStore().getNextId(IModelStore.IdType.SpdxId)).setName(snippet.getName()).setCopyrightText(snippet.getCopyrightText()).setSnippetFromFile(spdxFile).setByteRange(byteRange).setLineRange(lineRange).build();
        Object comment = snippet.getComment();
        if (Objects.isNull(comment)) {
            comment = "";
        }
        if (Objects.nonNull(licenseComment = snippet.getLicensComment()) && !licenseComment.isBlank()) {
            comment = (String)comment + "; License: " + licenseComment;
        }
        retval.setComment((String)comment);
        AnyLicenseInfo concludedLicense = LicenseInfoFactory.parseSPDXLicenseString((String)snippet.getConcludedLicense(), (IModelStore)spdxFile.getModelStore(), (String)spdxFile.getIdPrefix(), (IModelCopyManager)spdxFile.getCopyManager(), this.customIdToUri);
        retval.createRelationship(retval.getIdPrefix() + retval.getModelStore().getNextId(IModelStore.IdType.SpdxId)).setCompleteness(RelationshipCompleteness.COMPLETE).setFrom((Element)retval).addTo((Element)concludedLicense).setRelationshipType(RelationshipType.HAS_CONCLUDED_LICENSE).build();
        AnyLicenseInfo declaredLicense = LicenseInfoFactory.parseSPDXLicenseString((String)snippet.getLicenseInfoInSnippet(), (IModelStore)spdxFile.getModelStore(), (String)spdxFile.getIdPrefix(), (IModelCopyManager)spdxFile.getCopyManager(), this.customIdToUri);
        retval.createRelationship(retval.getIdPrefix() + retval.getModelStore().getNextId(IModelStore.IdType.SpdxId)).setCompleteness(RelationshipCompleteness.COMPLETE).setFrom((Element)retval).addTo((Element)declaredLicense).setRelationshipType(RelationshipType.HAS_DECLARED_LICENSE).build();
        return retval;
    }

    private SpdxFile convertToSpdxFile(File file, String outputFileName, SpdxDefaultFileInformation defaultFileInformation, Set<String> algorithms, SpdxDocument spdxDoc) throws SpdxCollectionException {
        SpdxFile retval;
        AnyLicenseInfo concludedLicense;
        String relativePath = this.convertFilePathToSpdxFileName(outputFileName);
        String extension = this.getExtension(file).trim().toUpperCase();
        SoftwarePurpose purpose = EXT_TO_PURPOSE.getOrDefault(extension, SoftwarePurpose.OTHER);
        ArrayList<Hash> hashes = new ArrayList<Hash>();
        try {
            Set<Checksum> checksums = SpdxV3FileCollector.generateChecksum(file, algorithms);
            for (Checksum checksum : checksums) {
                HashAlgorithm algorithm = (HashAlgorithm)Spdx2to3Converter.HASH_ALGORITH_MAP.get(ChecksumAlgorithm.valueOf((String)checksum.getAlgorithm()));
                if (Objects.isNull(algorithm)) {
                    throw new SpdxCollectionException("Invalid checksum algorithm for file " + file.getName());
                }
                hashes.add(spdxDoc.createHash(spdxDoc.getModelStore().getNextId(IModelStore.IdType.Anonymous)).setAlgorithm(algorithm).setHashValue(checksum.getValue()).build());
            }
        }
        catch (InvalidSPDXAnalysisException | SpdxCollectionException e1) {
            throw new SpdxCollectionException("Unable to generate checksum for file " + file.getName());
        }
        AnyLicenseInfo license = null;
        String licenseComment = defaultFileInformation.getLicenseComment();
        if (SoftwarePurpose.SOURCE.equals((Object)purpose) && file.length() < 300000L) {
            List<String> fileSpdxLicenses = null;
            try {
                fileSpdxLicenses = SpdxSourceFileParser.parseFileForSpdxLicenses(file);
            }
            catch (SpdxSourceParserException ex) {
                LOG.error("Error parsing for SPDX license ID's", (Throwable)ex);
            }
            if (fileSpdxLicenses != null && !fileSpdxLicenses.isEmpty()) {
                try {
                    if (fileSpdxLicenses.size() == 1) {
                        license = LicenseInfoFactory.parseSPDXLicenseString((String)fileSpdxLicenses.get(0), (IModelStore)spdxDoc.getModelStore(), (String)spdxDoc.getIdPrefix(), (IModelCopyManager)spdxDoc.getCopyManager(), this.customIdToUri);
                    } else {
                        HashSet<AnyLicenseInfo> licenseSet = new HashSet<AnyLicenseInfo>();
                        for (String licenseExpression : fileSpdxLicenses) {
                            licenseSet.add(LicenseInfoFactory.parseSPDXLicenseString((String)licenseExpression, (IModelStore)spdxDoc.getModelStore(), (String)spdxDoc.getIdPrefix(), (IModelCopyManager)spdxDoc.getCopyManager(), this.customIdToUri));
                        }
                        license = spdxDoc.createConjunctiveLicenseSet(spdxDoc.getIdPrefix() + spdxDoc.getModelStore().getNextId(IModelStore.IdType.SpdxId)).addAllMember(licenseSet).build();
                    }
                }
                catch (InvalidSPDXAnalysisException e) {
                    LOG.error("Invalid license expressions found in source file {}", (Object)file.getName(), (Object)e);
                }
                if (licenseComment == null) {
                    licenseComment = "";
                } else if (!licenseComment.isEmpty()) {
                    licenseComment = licenseComment.concat(";  ");
                }
                licenseComment = licenseComment.concat("This file contains SPDX-License-Identifiers for ");
                if (license != null) {
                    licenseComment = licenseComment.concat(license.toString());
                }
            }
        }
        if (license == null) {
            try {
                license = LicenseInfoFactory.parseSPDXLicenseString((String)defaultFileInformation.getDeclaredLicense(), (IModelStore)spdxDoc.getModelStore(), (String)spdxDoc.getIdPrefix(), (IModelCopyManager)spdxDoc.getCopyManager(), this.customIdToUri);
                concludedLicense = LicenseInfoFactory.parseSPDXLicenseString((String)defaultFileInformation.getConcludedLicense(), (IModelStore)spdxDoc.getModelStore(), (String)spdxDoc.getIdPrefix(), (IModelCopyManager)spdxDoc.getCopyManager(), this.customIdToUri);
            }
            catch (InvalidSPDXAnalysisException e) {
                throw new SpdxCollectionException("Error creating SPDX file - unable create default file license", e);
            }
        } else {
            concludedLicense = license;
        }
        String copyright = defaultFileInformation.getCopyright();
        String notice = defaultFileInformation.getNotice();
        Object comment = defaultFileInformation.getComment();
        if (Objects.isNull(comment)) {
            comment = "";
        }
        if (Objects.nonNull(licenseComment) && !licenseComment.isBlank()) {
            comment = (String)comment + " ;License: " + licenseComment;
        }
        String[] defaultContributors = defaultFileInformation.getContributors();
        ArrayList<Person> contributors = new ArrayList<Person>();
        if (defaultContributors != null) {
            for (String contributor : defaultFileInformation.getContributors()) {
                if (!Objects.nonNull(contributor) || contributor.isBlank()) continue;
                try {
                    contributors.add(spdxDoc.createPerson(spdxDoc.getModelStore().getNextId(IModelStore.IdType.Anonymous)).setName(contributor).setDescription("Contributor").build());
                }
                catch (InvalidSPDXAnalysisException e) {
                    LOG.warn("Error creating contributor {} for file {}.  Skipping.", (Object)contributor, (Object)file);
                }
            }
        } else {
            contributors = new ArrayList();
        }
        try {
            retval = spdxDoc.createSpdxFile(spdxDoc.getIdPrefix() + spdxDoc.getModelStore().getNextId(IModelStore.IdType.SpdxId)).setName(relativePath).setCopyrightText(copyright).setComment((String)comment).setPrimaryPurpose(purpose).addAllVerifiedUsing(hashes).addAttributionText(notice).addAllOriginatedBy(contributors).build();
            String mediaType = EXT_TO_MEDIA_TYPE.get(extension);
            if (Objects.nonNull(mediaType)) {
                retval.setContentType(mediaType);
            }
            retval.createRelationship(retval.getIdPrefix() + retval.getModelStore().getNextId(IModelStore.IdType.SpdxId)).setCompleteness(RelationshipCompleteness.COMPLETE).setFrom((Element)retval).addTo((Element)concludedLicense).setRelationshipType(RelationshipType.HAS_CONCLUDED_LICENSE).build();
            retval.createRelationship(retval.getIdPrefix() + retval.getModelStore().getNextId(IModelStore.IdType.SpdxId)).setCompleteness(RelationshipCompleteness.COMPLETE).setFrom((Element)retval).addTo((Element)license).setRelationshipType(RelationshipType.HAS_DECLARED_LICENSE).build();
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new SpdxCollectionException("Error creating SPDX file", e);
        }
        return retval;
    }

    public Collection<SpdxFile> getFiles() {
        return this.spdxFiles.values();
    }

    public List<Snippet> getSnippets() {
        return this.spdxSnippets;
    }

    static {
        for (Map.Entry entry : SpdxV2FileCollector.EXT_TO_FILE_TYPE.entrySet()) {
            switch ((FileType)entry.getValue()) {
                case SOURCE: {
                    EXT_TO_MEDIA_TYPE.put((String)entry.getKey(), "text/plain");
                    EXT_TO_PURPOSE.put((String)entry.getKey(), SoftwarePurpose.SOURCE);
                    break;
                }
                case BINARY: {
                    EXT_TO_MEDIA_TYPE.put((String)entry.getKey(), "application/octet-stream");
                    EXT_TO_PURPOSE.put((String)entry.getKey(), SoftwarePurpose.LIBRARY);
                    break;
                }
                case ARCHIVE: {
                    EXT_TO_PURPOSE.put((String)entry.getKey(), SoftwarePurpose.ARCHIVE);
                    break;
                }
                case APPLICATION: {
                    EXT_TO_PURPOSE.put((String)entry.getKey(), SoftwarePurpose.APPLICATION);
                    break;
                }
                case AUDIO: {
                    EXT_TO_MEDIA_TYPE.put((String)entry.getKey(), "audio/*");
                    break;
                }
                case IMAGE: {
                    EXT_TO_MEDIA_TYPE.put((String)entry.getKey(), "image/*");
                    break;
                }
                case TEXT: {
                    EXT_TO_MEDIA_TYPE.put((String)entry.getKey(), "text/plain");
                    break;
                }
                case VIDEO: {
                    EXT_TO_MEDIA_TYPE.put((String)entry.getKey(), "video/*");
                    break;
                }
                case DOCUMENTATION: {
                    EXT_TO_PURPOSE.put((String)entry.getKey(), SoftwarePurpose.DOCUMENTATION);
                    break;
                }
                case SPDX: {
                    EXT_TO_MEDIA_TYPE.put((String)entry.getKey(), "application/spdx");
                    EXT_TO_PURPOSE.put((String)entry.getKey(), SoftwarePurpose.BOM);
                    break;
                }
                case OTHER: {
                    EXT_TO_PURPOSE.put((String)entry.getKey(), SoftwarePurpose.OTHER);
                }
            }
        }
    }
}

