/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.spdxRdfStore;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.NodeIterator;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.ResIterator;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spdx.library.InvalidSPDXAnalysisException;
import org.spdx.library.SpdxVerificationHelper;
import org.spdx.library.model.enumerations.AnnotationType;
import org.spdx.library.model.enumerations.RelationshipType;

public class CompatibilityUpgrader {
    static final Map<String, Map<String, String>> TYPE_PROPERTY_MAP;
    static final Logger logger;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void upgrade(Model model, String documentNamespace) throws InvalidSPDXAnalysisException {
        model.enterCriticalSection(false);
        try {
            for (Map.Entry<String, Map<String, String>> entry : TYPE_PROPERTY_MAP.entrySet()) {
                String query = "SELECT ?s  WHERE { ?s  <http://www.w3.org/1999/02/22-rdf-syntax-ns#type> <http://spdx.org/rdf/terms#" + entry.getKey() + "> }";
                QueryExecution qe = QueryExecutionFactory.create((String)query, (Model)model);
                try {
                    ResultSet result = qe.execSelect();
                    while (result.hasNext()) {
                        Resource subject = result.next().get("s").asResource();
                        for (Map.Entry<String, String> propEntry : entry.getValue().entrySet()) {
                            Property incompatibleProperty = model.createProperty(propEntry.getKey());
                            if (!subject.hasProperty(incompatibleProperty)) continue;
                            Property compatibleProperty = model.createProperty(propEntry.getValue());
                            NodeIterator iter = model.listObjectsOfProperty(subject, incompatibleProperty);
                            while (iter.hasNext()) {
                                RDFNode object = iter.next();
                                subject.addProperty(compatibleProperty, object);
                            }
                            subject.removeAll(incompatibleProperty);
                        }
                    }
                }
                finally {
                    if (qe == null) continue;
                    qe.close();
                }
            }
            CompatibilityUpgrader.upgradeArtifactOf(model, documentNamespace);
            CompatibilityUpgrader.upgradeReviewers(model, documentNamespace);
            CompatibilityUpgrader.upgradeExternalDocumentRefs(model, documentNamespace);
        }
        finally {
            model.leaveCriticalSection();
        }
    }

    private static void upgradeExternalDocumentRefs(Model model, String documentNamespace) throws InvalidSPDXAnalysisException {
        String query = "SELECT ?s ?o  WHERE { ?s  <http://spdx.org/rdf/terms#externalDocumentId> ?o }";
        try (QueryExecution qe = QueryExecutionFactory.create((String)query, (Model)model);){
            ResultSet result = qe.execSelect();
            ArrayList<Statement> statementsToRemove = new ArrayList<Statement>();
            ArrayList<Statement> statementsToAdd = new ArrayList<Statement>();
            while (result.hasNext()) {
                QuerySolution qs = result.next();
                try {
                    Resource currentExternalRef = qs.get("s").asResource();
                    String id = qs.get("o").asLiteral().getString();
                    if (!SpdxVerificationHelper.isValidExternalDocRef((String)id)) {
                        throw new InvalidSPDXAnalysisException("Invalid external document ref " + id);
                    }
                    String uri = documentNamespace + "#" + id;
                    if (currentExternalRef.isURIResource() && !uri.equals(currentExternalRef.getURI())) continue;
                    Resource newExternalRef = model.createResource(uri);
                    StmtIterator currentPropIter = currentExternalRef.listProperties();
                    while (currentPropIter.hasNext()) {
                        Statement stmt = (Statement)currentPropIter.next();
                        statementsToAdd.add(model.createStatement(newExternalRef, stmt.getPredicate(), stmt.getObject()));
                        statementsToRemove.add(stmt);
                    }
                    StmtIterator currentExternalRefRefs = model.listStatements(null, null, (RDFNode)currentExternalRef);
                    while (currentExternalRefRefs.hasNext()) {
                        Statement stmt = (Statement)currentExternalRefRefs.next();
                        statementsToAdd.add(model.createStatement(stmt.getSubject(), stmt.getPredicate(), (RDFNode)newExternalRef));
                        statementsToRemove.add(stmt);
                    }
                }
                catch (Exception ex) {
                    throw new InvalidSPDXAnalysisException("Error upgrading external document refs", (Throwable)ex);
                }
            }
            model.remove(statementsToRemove);
            model.add(statementsToAdd);
        }
    }

    private static void upgradeReviewers(Model model, String documentNamespace) throws InvalidSPDXAnalysisException {
        Resource document = model.createResource(documentNamespace + "#" + "SPDXRef-DOCUMENT");
        Property annotationProperty = model.createProperty("http://spdx.org/rdf/terms#annotation");
        Resource reviewerType = model.createResource(AnnotationType.REVIEW.getIndividualURI());
        Property typeProperty = model.createProperty("http://www.w3.org/1999/02/22-rdf-syntax-ns#type");
        Resource annotationClass = model.createResource("http://spdx.org/rdf/terms#Annotation");
        Property commentProperty = model.createProperty("http://www.w3.org/2000/01/rdf-schema#comment");
        Property annotatorProperty = model.createProperty("http://spdx.org/rdf/terms#annotator");
        Property annotationDateProperty = model.createProperty("http://spdx.org/rdf/terms#annotationDate");
        Property annotationTypeProperty = model.createProperty("http://spdx.org/rdf/terms#annotationType");
        ArrayList<Statement> statementsToRemove = new ArrayList<Statement>();
        HashSet<Integer> addedAnnotations = new HashSet<Integer>();
        String query = "SELECT ?s ?o  WHERE { ?s  <http://spdx.org/rdf/terms#reviewer> ?o }";
        try (QueryExecution qe = QueryExecutionFactory.create((String)query, (Model)model);){
            ResultSet result = qe.execSelect();
            while (result.hasNext()) {
                String comment;
                String reviewDate;
                QuerySolution qs = result.next();
                Resource review = qs.get("s").asResource();
                String reviewer = qs.get("o").asLiteral().toString();
                Resource annotation = model.createResource();
                annotation.addProperty(typeProperty, (RDFNode)annotationClass);
                try {
                    reviewDate = review.getRequiredProperty(model.createProperty("http://spdx.org/rdf/terms#reviewDate")).getString();
                    if (Objects.isNull(reviewDate)) {
                        throw new InvalidSPDXAnalysisException("Missing or invalid review date for review");
                    }
                }
                catch (Exception ex) {
                    throw new InvalidSPDXAnalysisException("Missing or invalid review date for review");
                }
                try {
                    comment = review.getRequiredProperty(commentProperty).getString();
                    if (Objects.isNull(comment)) {
                        throw new InvalidSPDXAnalysisException("Missing or invalid review comment for review");
                    }
                }
                catch (Exception ex) {
                    throw new InvalidSPDXAnalysisException("Missing or invalid review comment for review");
                }
                StmtIterator iter = review.listProperties();
                while (iter.hasNext()) {
                    statementsToRemove.add((Statement)iter.next());
                }
                int hashOfAnnotation = reviewer.hashCode() ^ reviewDate.hashCode() ^ comment.hashCode();
                if (addedAnnotations.contains(hashOfAnnotation)) continue;
                addedAnnotations.add(hashOfAnnotation);
                annotation.addProperty(annotatorProperty, reviewer);
                annotation.addProperty(annotationDateProperty, reviewDate);
                annotation.addProperty(commentProperty, comment);
                annotation.addProperty(annotationTypeProperty, (RDFNode)reviewerType);
                document.addProperty(annotationProperty, (RDFNode)annotation);
            }
            StmtIterator iter = document.listProperties(model.createProperty("http://spdx.org/rdf/terms#reviewed"));
            while (iter.hasNext()) {
                statementsToRemove.add((Statement)iter.next());
            }
            model.remove(statementsToRemove);
        }
    }

    private static void upgradeArtifactOf(Model model, String documentNamespace) throws InvalidSPDXAnalysisException {
        String docNamespace = documentNamespace + "#";
        HashSet<String> addedDoapProjects = new HashSet<String>();
        ArrayList<Statement> statementsToRemove = new ArrayList<Statement>();
        Property artifactOfProperty = model.createProperty("http://spdx.org/rdf/terms#artifactOf");
        Property relationshipProperty = model.createProperty("http://spdx.org/rdf/terms#relationship");
        String query = "SELECT ?s ?o  WHERE { ?s  <http://spdx.org/rdf/terms#artifactOf> ?o }";
        try (QueryExecution qe = QueryExecutionFactory.create((String)query, (Model)model);){
            ResultSet result = qe.execSelect();
            String idPrefix = "SPDXRef-fromDoap-";
            int nextSpdxIdNum = CompatibilityUpgrader.getNexId(model, docNamespace, idPrefix, 0);
            while (result.hasNext()) {
                QuerySolution qs = result.next();
                Resource subject = qs.get("s").asResource();
                Resource doapProject = qs.get("o").asResource();
                statementsToRemove.add(model.createStatement(subject, artifactOfProperty, (RDFNode)doapProject));
                StmtIterator iter = doapProject.listProperties();
                while (iter.hasNext()) {
                    statementsToRemove.add((Statement)iter.next());
                }
                Resource pkg = CompatibilityUpgrader.convertDoapProjectToSpdxPackage(model, doapProject, docNamespace + idPrefix + Integer.toString(nextSpdxIdNum));
                if (addedDoapProjects.contains(pkg.getURI())) continue;
                addedDoapProjects.add(pkg.getURI());
                nextSpdxIdNum = CompatibilityUpgrader.getNexId(model, docNamespace, idPrefix, nextSpdxIdNum);
                Resource relationship = CompatibilityUpgrader.createRelationship(model, pkg, RelationshipType.GENERATED_FROM);
                subject.addProperty(relationshipProperty, (RDFNode)relationship);
            }
            model.remove(statementsToRemove);
        }
    }

    private static Resource createRelationship(Model model, Resource relatedElement, RelationshipType relationshipType) {
        Resource retval = model.createResource();
        retval.addProperty(model.createProperty("http://www.w3.org/1999/02/22-rdf-syntax-ns#type"), (RDFNode)model.createResource("http://spdx.org/rdf/terms#Relationship"));
        retval.addProperty(model.createProperty("http://spdx.org/rdf/terms#relatedSpdxElement"), (RDFNode)relatedElement);
        retval.addProperty(model.createProperty("http://spdx.org/rdf/terms#relationshipType"), (RDFNode)model.createResource(relationshipType.getIndividualURI()));
        return retval;
    }

    private static int getNexId(Model model, String docNamespace, String idPrefix, int startingNum) {
        int retval = startingNum;
        Resource idResource = model.getResource(docNamespace + idPrefix + Integer.toString(retval));
        while (model.containsResource((RDFNode)idResource)) {
            idResource = model.getResource(docNamespace + idPrefix + Integer.toString(++retval));
        }
        return retval;
    }

    private static Resource convertDoapProjectToSpdxPackage(Model model, Resource doapProject, String packageUri) throws InvalidSPDXAnalysisException {
        String packageName;
        try {
            packageName = doapProject.getProperty(model.createProperty("http://usefulinc.com/ns/doap#name")).getString();
        }
        catch (Exception ex) {
            throw new InvalidSPDXAnalysisException("DOAP project name is not a valid string");
        }
        if (Objects.isNull(packageName)) {
            throw new InvalidSPDXAnalysisException("Missing required DOAP project name");
        }
        String homePage = null;
        Property homePageProperty = model.createProperty("http://usefulinc.com/ns/doap#homepage");
        try {
            homePage = doapProject.getProperty(homePageProperty).getString();
        }
        catch (Exception ex) {
            homePage = null;
        }
        String addedPackageComment = "This package was converted from a DOAP Project by the same name";
        Property commentProperty = model.createProperty("http://www.w3.org/2000/01/rdf-schema#comment");
        Property nameProperty = model.createProperty("http://spdx.org/rdf/terms#name");
        ResIterator iter = model.listResourcesWithProperty(nameProperty, (Object)packageName);
        while (iter.hasNext()) {
            Statement commentStatment;
            Statement homePageStatement;
            Resource pkg = (Resource)iter.next();
            if (!(Objects.nonNull(homePage) ? Objects.nonNull(homePageStatement = pkg.getProperty(homePageProperty)) && homePage.equals(homePageStatement.getObject().asLiteral().getString()) : Objects.nonNull(commentStatment = pkg.getProperty(commentProperty)) && addedPackageComment.equals(commentStatment.getObject().asLiteral().getString()))) continue;
            return pkg;
        }
        Resource retval = model.createResource(packageUri);
        retval.addProperty(model.createProperty("http://www.w3.org/1999/02/22-rdf-syntax-ns#type"), (RDFNode)model.createResource("http://spdx.org/rdf/terms#Package"));
        Resource noAssertion = model.createResource("http://spdx.org/rdf/terms#noassertion");
        retval.addProperty(model.createProperty("http://spdx.org/rdf/terms#downloadLocation"), (RDFNode)noAssertion);
        retval.addProperty(model.createProperty("http://spdx.org/rdf/terms#licenseConcluded"), (RDFNode)noAssertion);
        retval.addProperty(model.createProperty("http://spdx.org/rdf/terms#licenseDeclared"), (RDFNode)noAssertion);
        retval.addProperty(model.createProperty("http://spdx.org/rdf/terms#copyrightText"), (RDFNode)noAssertion);
        retval.addProperty(commentProperty, addedPackageComment);
        retval.addLiteral(model.createProperty("http://spdx.org/rdf/terms#filesAnalyzed"), false);
        retval.addLiteral(nameProperty, (Object)packageName);
        if (Objects.nonNull(homePage)) {
            retval.addLiteral(homePageProperty, (Object)homePage);
        }
        return retval;
    }

    static {
        logger = LoggerFactory.getLogger(CompatibilityUpgrader.class);
        HashMap mutableTypePropertyMap = new HashMap();
        HashMap documentMap = new HashMap();
        mutableTypePropertyMap.put("SpdxDocument", Collections.unmodifiableMap(documentMap));
        TYPE_PROPERTY_MAP = Collections.unmodifiableMap(mutableTypePropertyMap);
    }
}

