/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.spdxRdfStore;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.jena.atlas.web.TypedInputStream;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.ARQ;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spdx.library.InvalidSPDXAnalysisException;
import org.spdx.library.SpdxConstants;
import org.spdx.library.model.DuplicateSpdxIdException;
import org.spdx.library.model.SpdxIdNotFoundException;
import org.spdx.library.model.TypedValue;
import org.spdx.library.model.license.LicenseInfoFactory;
import org.spdx.spdxRdfStore.CompatibilityUpgrader;
import org.spdx.spdxRdfStore.OutputFormat;
import org.spdx.spdxRdfStore.RdfSpdxDocumentModelManager;
import org.spdx.spdxRdfStore.SpdxRdfException;
import org.spdx.storage.IModelStore;
import org.spdx.storage.ISerializableModelStore;

public class RdfStore
implements IModelStore,
ISerializableModelStore {
    static final Logger logger = LoggerFactory.getLogger((String)RdfStore.class.getName());
    static final String GENERATED = "gnrtd";
    static Pattern DOCUMENT_ID_PATTERN_GENERATED = Pattern.compile(String.valueOf(SpdxConstants.EXTERNAL_DOC_REF_PRENUM) + "gnrtd" + "(\\d+)$");
    static Pattern SPDX_ID_PATTERN_GENERATED = Pattern.compile(String.valueOf(SpdxConstants.SPDX_ELEMENT_REF_PRENUM) + "gnrtd" + "(\\d+)$");
    static Pattern LICENSE_ID_PATTERN_GENERATED = Pattern.compile(String.valueOf(SpdxConstants.NON_STD_LICENSE_ID_PRENUM) + "gnrtd" + "(\\d+)$");
    static final String ANON_PREFIX = "__anon__";
    static Pattern ANON_ID_PATTERN = Pattern.compile("__anon__(.+)$");
    private static final Set<String> LITERAL_VALUE_SET = new HashSet<String>(Arrays.asList(SpdxConstants.LITERAL_VALUES));
    Map<String, RdfSpdxDocumentModelManager> documentUriModelMap = new ConcurrentHashMap<String, RdfSpdxDocumentModelManager>();
    private OutputFormat outputFormat = OutputFormat.XML_ABBREV;

    static {
        ARQ.init();
    }

    public OutputFormat getOutputFormat() {
        return this.outputFormat;
    }

    public void setOutputFormat(OutputFormat outputFormat) {
        this.outputFormat = outputFormat;
    }

    public boolean exists(String documentUri, String id) {
        Objects.requireNonNull(documentUri, "Missing required document URI");
        Objects.requireNonNull(id, "Missing required ID");
        RdfSpdxDocumentModelManager documentModel = this.documentUriModelMap.get(documentUri);
        if (Objects.isNull(documentModel)) {
            return false;
        }
        return documentModel.exists(id);
    }

    public IModelStore.IdType getIdType(String id) {
        Objects.requireNonNull(id, "Missing required ID");
        if (ANON_ID_PATTERN.matcher(id).matches()) {
            return IModelStore.IdType.Anonymous;
        }
        if (SpdxConstants.LICENSE_ID_PATTERN.matcher(id).matches()) {
            return IModelStore.IdType.LicenseRef;
        }
        if (SpdxConstants.EXTERNAL_DOC_REF_PATTERN.matcher(id).matches()) {
            return IModelStore.IdType.DocumentRef;
        }
        if (SpdxConstants.SPDX_ELEMENT_REF_PATTERN.matcher(id).matches()) {
            return IModelStore.IdType.SpdxId;
        }
        if (LITERAL_VALUE_SET.contains(id)) {
            return IModelStore.IdType.Literal;
        }
        if (LicenseInfoFactory.isSpdxListedLicenseId((String)id) || LicenseInfoFactory.isSpdxListedExceptionId((String)id)) {
            return IModelStore.IdType.ListedLicense;
        }
        return IModelStore.IdType.Unkown;
    }

    public void create(String documentUri, String id, String type) throws InvalidSPDXAnalysisException {
        Objects.requireNonNull(documentUri, "Missing required document URI");
        Objects.requireNonNull(id, "Missing required ID");
        Objects.requireNonNull(type, "Missing required type");
        RdfSpdxDocumentModelManager modelManager = this.documentUriModelMap.get(documentUri);
        if (Objects.isNull(modelManager)) {
            Model model = ModelFactory.createDefaultModel();
            model.getGraph().getPrefixMapping().setNsPrefix("spdx", "http://spdx.org/rdf/terms#");
            model.getGraph().getPrefixMapping().setNsPrefix("doap", "http://usefulinc.com/ns/doap#");
            model.getGraph().getPrefixMapping().setNsPrefix("ptr", "http://www.w3.org/2009/pointers#");
            model.getGraph().getPrefixMapping().setNsPrefix("rdfs", "http://www.w3.org/2000/01/rdf-schema#");
            modelManager = new RdfSpdxDocumentModelManager(documentUri, model);
            RdfSpdxDocumentModelManager previousModel = this.documentUriModelMap.putIfAbsent(documentUri, modelManager);
            if (!Objects.isNull(previousModel)) {
                modelManager = previousModel;
            }
        }
        if (modelManager.getCasesensitiveId(id).isPresent()) {
            throw new DuplicateSpdxIdException("Id " + id + " already exists.");
        }
        modelManager.getOrCreate(id, type);
    }

    public List<String> getPropertyValueNames(String documentUri, String id) throws InvalidSPDXAnalysisException {
        Objects.requireNonNull(documentUri, "Missing required document URI");
        Objects.requireNonNull(id, "Missing required ID");
        RdfSpdxDocumentModelManager modelManager = this.documentUriModelMap.get(documentUri);
        if (Objects.isNull(modelManager)) {
            return new ArrayList<String>();
        }
        return modelManager.getPropertyValueNames(id);
    }

    public void setValue(String documentUri, String id, String propertyName, Object value) throws InvalidSPDXAnalysisException {
        Objects.requireNonNull(id);
        Objects.requireNonNull(documentUri);
        Objects.requireNonNull(propertyName);
        Objects.requireNonNull(value);
        RdfSpdxDocumentModelManager modelManager = this.documentUriModelMap.get(documentUri);
        if (modelManager == null) {
            logger.error("Attempting to set a value for a non-existent document URI " + documentUri + " ID: " + id);
            throw new SpdxIdNotFoundException("Document URI " + documentUri + " was not found in the RDF store.  The ID must first be created before getting or setting property values.");
        }
        modelManager.setValue(id, propertyName, value);
    }

    public Optional<Object> getValue(String documentUri, String id, String propertyName) throws InvalidSPDXAnalysisException {
        Objects.requireNonNull(documentUri, "Missing required document URI");
        Objects.requireNonNull(id, "Missing required ID");
        Objects.requireNonNull(propertyName, "Missing required property name");
        RdfSpdxDocumentModelManager modelManager = this.documentUriModelMap.get(documentUri);
        if (Objects.isNull(modelManager)) {
            return Optional.empty();
        }
        return modelManager.getPropertyValue(id, propertyName);
    }

    public String getNextId(IModelStore.IdType idType, String documentUri) throws InvalidSPDXAnalysisException {
        Objects.requireNonNull(documentUri, "Missing required document URI");
        Objects.requireNonNull(idType, "Missing required ID type");
        RdfSpdxDocumentModelManager modelManager = this.documentUriModelMap.get(documentUri);
        if (Objects.isNull(modelManager)) {
            Model model = ModelFactory.createDefaultModel();
            model.getGraph().getPrefixMapping().setNsPrefix("spdx", "http://spdx.org/rdf/terms#");
            model.getGraph().getPrefixMapping().setNsPrefix("doap", "http://usefulinc.com/ns/doap#");
            modelManager = new RdfSpdxDocumentModelManager(documentUri, model);
            RdfSpdxDocumentModelManager previousModel = this.documentUriModelMap.putIfAbsent(documentUri, modelManager);
            if (!Objects.isNull(previousModel)) {
                modelManager = previousModel;
            }
        }
        return modelManager.getNextId(idType);
    }

    public void removeProperty(String documentUri, String id, String propertyName) throws InvalidSPDXAnalysisException {
        Objects.requireNonNull(documentUri, "Missing required document URI");
        Objects.requireNonNull(id, "Missing required ID");
        Objects.requireNonNull(propertyName, "Missing required property name");
        RdfSpdxDocumentModelManager modelManager = this.documentUriModelMap.get(documentUri);
        if (Objects.isNull(modelManager)) {
            logger.error("The document " + documentUri + " has not been created.  Can not remove a property.");
            throw new SpdxRdfException("The document has not been created.  Can not remove property");
        }
        modelManager.removeProperty(id, propertyName);
    }

    public List<String> getDocumentUris() {
        return Collections.unmodifiableList(new ArrayList<String>(this.documentUriModelMap.keySet()));
    }

    public Stream<TypedValue> getAllItems(String documentUri, String typeFilter) throws InvalidSPDXAnalysisException {
        Objects.requireNonNull(documentUri, "Missing required document URI");
        RdfSpdxDocumentModelManager modelManager = this.documentUriModelMap.get(documentUri);
        if (Objects.isNull(modelManager)) {
            return new ArrayList().stream();
        }
        return modelManager.getAllItems(typeFilter);
    }

    public boolean removeValueFromCollection(String documentUri, String id, String propertyName, Object value) throws InvalidSPDXAnalysisException {
        Objects.requireNonNull(documentUri, "Missing required document URI");
        Objects.requireNonNull(id, "Missing required ID");
        Objects.requireNonNull(propertyName, "Missing required property name");
        Objects.requireNonNull(value, "Mising required value");
        RdfSpdxDocumentModelManager modelManager = this.documentUriModelMap.get(documentUri);
        if (Objects.isNull(modelManager)) {
            logger.error("The document " + documentUri + " has not been created.  Can not remove a value from a collection.");
            throw new SpdxRdfException("The document has not been created.  Can not remove value from a collection");
        }
        return modelManager.removeValueFromCollection(id, propertyName, value);
    }

    public int collectionSize(String documentUri, String id, String propertyName) throws InvalidSPDXAnalysisException {
        Objects.requireNonNull(documentUri, "Missing required document URI");
        Objects.requireNonNull(id, "Missing required ID");
        Objects.requireNonNull(propertyName, "Missing required property name");
        RdfSpdxDocumentModelManager modelManager = this.documentUriModelMap.get(documentUri);
        if (Objects.isNull(modelManager)) {
            logger.error("The document " + documentUri + " has not been created.  Can not retrieve a collection.");
            throw new SpdxRdfException("The document has not been created.  Can not retrieve a collection.");
        }
        return modelManager.collectionSize(id, propertyName);
    }

    public boolean collectionContains(String documentUri, String id, String propertyName, Object value) throws InvalidSPDXAnalysisException {
        Objects.requireNonNull(documentUri, "Missing required document URI");
        Objects.requireNonNull(id, "Missing required ID");
        Objects.requireNonNull(propertyName, "Missing required property name");
        Objects.requireNonNull(value, "Missing required value");
        RdfSpdxDocumentModelManager modelManager = this.documentUriModelMap.get(documentUri);
        if (Objects.isNull(modelManager)) {
            logger.error("The document " + documentUri + " has not been created.  Can not retrieve a collection.");
            throw new SpdxRdfException("The document has not been created.  Can not retrieve a collection.");
        }
        return modelManager.collectionContains(id, propertyName, value);
    }

    public void clearValueCollection(String documentUri, String id, String propertyName) throws InvalidSPDXAnalysisException {
        Objects.requireNonNull(documentUri, "Missing required document URI");
        Objects.requireNonNull(id, "Missing required ID");
        Objects.requireNonNull(propertyName, "Missing required property name");
        RdfSpdxDocumentModelManager modelManager = this.documentUriModelMap.get(documentUri);
        if (Objects.isNull(modelManager)) {
            logger.error("The document " + documentUri + " has not been created.  Can not retrieve a collection.");
            throw new SpdxRdfException("The document has not been created.  Can not retrieve a collection.");
        }
        modelManager.clearValueCollection(id, propertyName);
    }

    public boolean addValueToCollection(String documentUri, String id, String propertyName, Object value) throws InvalidSPDXAnalysisException {
        Objects.requireNonNull(documentUri, "Missing required document URI");
        Objects.requireNonNull(id, "Missing required ID");
        Objects.requireNonNull(propertyName, "Missing required property name");
        RdfSpdxDocumentModelManager modelManager = this.documentUriModelMap.get(documentUri);
        if (Objects.isNull(modelManager)) {
            logger.error("The document " + documentUri + " has not been created.  Can not add a collection.");
            throw new SpdxRdfException("The document has not been created.  Can not add a collection.");
        }
        return modelManager.addValueToCollection(id, propertyName, value);
    }

    public Iterator<Object> listValues(String documentUri, String id, String propertyName) throws InvalidSPDXAnalysisException {
        Objects.requireNonNull(documentUri, "Missing required document URI");
        Objects.requireNonNull(id, "Missing required ID");
        Objects.requireNonNull(propertyName, "Missing required property name");
        RdfSpdxDocumentModelManager modelManager = this.documentUriModelMap.get(documentUri);
        if (Objects.isNull(modelManager)) {
            logger.error("The document " + documentUri + " has not been created.  Can not get a collection.");
            throw new SpdxRdfException("The document has not been created.  Can not get a collection.");
        }
        return modelManager.getValueList(id, propertyName);
    }

    public boolean isCollectionMembersAssignableTo(String documentUri, String id, String propertyName, Class<?> clazz) throws InvalidSPDXAnalysisException {
        Objects.requireNonNull(documentUri, "Missing required document URI");
        Objects.requireNonNull(id, "Missing required ID");
        Objects.requireNonNull(propertyName, "Missing required property name");
        Objects.requireNonNull(clazz, "Missing required class");
        RdfSpdxDocumentModelManager modelManager = this.documentUriModelMap.get(documentUri);
        if (Objects.isNull(modelManager)) {
            logger.error("The document " + documentUri + " has not been created.  Can not get a collection.");
            throw new SpdxRdfException("The document has not been created.  Can not get a collection.");
        }
        return modelManager.isCollectionMembersAssignableTo(id, propertyName, clazz);
    }

    public boolean isPropertyValueAssignableTo(String documentUri, String id, String propertyName, Class<?> clazz) throws InvalidSPDXAnalysisException {
        Objects.requireNonNull(documentUri, "Missing required document URI");
        Objects.requireNonNull(id, "Missing required ID");
        Objects.requireNonNull(propertyName, "Missing required property name");
        Objects.requireNonNull(clazz, "Missing required class");
        RdfSpdxDocumentModelManager modelManager = this.documentUriModelMap.get(documentUri);
        if (Objects.isNull(modelManager)) {
            logger.error("The document " + documentUri + " has not been created.  Can not check property for assignability.");
            throw new SpdxRdfException("The document has not been created.  Can not check property for assignability.");
        }
        return modelManager.isPropertyValueAssignableTo(id, propertyName, clazz);
    }

    public boolean isCollectionProperty(String documentUri, String id, String propertyName) throws InvalidSPDXAnalysisException {
        Objects.requireNonNull(documentUri, "Missing required document URI");
        Objects.requireNonNull(id, "Missing required ID");
        Objects.requireNonNull(propertyName, "Missing required property name");
        RdfSpdxDocumentModelManager modelManager = this.documentUriModelMap.get(documentUri);
        if (Objects.isNull(modelManager)) {
            logger.error("The document " + documentUri + " has not been created.  Can not check property for collection.");
            throw new SpdxRdfException("The document has not been created.  Can not check property for collection.");
        }
        return modelManager.isCollectionProperty(id, propertyName);
    }

    public void leaveCriticalSection(IModelStore.IModelStoreLock lock) {
        lock.unlock();
    }

    public IModelStore.IModelStoreLock enterCriticalSection(String documentUri, boolean readLockRequested) throws InvalidSPDXAnalysisException {
        Objects.requireNonNull(documentUri, "Missing required document URI");
        RdfSpdxDocumentModelManager modelManager = this.documentUriModelMap.get(documentUri);
        if (Objects.isNull(modelManager)) {
            logger.error("The document " + documentUri + " has not been created.  Can not enter critical section for a document that has not been created.");
            throw new InvalidSPDXAnalysisException("Can not enter a critical section for a document which has not been created in the RDF store.");
        }
        return modelManager.enterCriticalSection(readLockRequested);
    }

    public String loadModelFromFile(String fileNameOrUrl, boolean overwrite) throws InvalidSPDXAnalysisException, IOException {
        TypedInputStream spdxRdfInput = RDFDataMgr.open((String)fileNameOrUrl);
        if (Objects.isNull(spdxRdfInput)) {
            throw new FileNotFoundException(String.valueOf(fileNameOrUrl) + " not found.");
        }
        try {
            String string = this.deSerialize((InputStream)spdxRdfInput, overwrite);
            return string;
        }
        finally {
            try {
                spdxRdfInput.close();
            }
            catch (IOException e) {
                logger.warn("Error closing SPDX RDF file " + fileNameOrUrl, (Throwable)e);
            }
        }
    }

    private static String formDocNamespace(String docUriString) {
        int fragmentIndex = docUriString.indexOf(35);
        if (fragmentIndex <= 0) {
            return docUriString;
        }
        return docUriString.substring(0, fragmentIndex);
    }

    public static Node getSpdxDocNode(Model model) {
        Node spdxDocNode = null;
        Node rdfTypePredicate = model.getProperty("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "type").asNode();
        Node spdxDocObject = model.getProperty("http://spdx.org/rdf/terms#", "SpdxDocument").asNode();
        Triple m = Triple.createMatch(null, (Node)rdfTypePredicate, (Node)spdxDocObject);
        ExtendedIterator tripleIter = model.getGraph().find(m);
        while (tripleIter.hasNext()) {
            Triple docTriple = (Triple)tripleIter.next();
            spdxDocNode = docTriple.getSubject();
        }
        return spdxDocNode;
    }

    public static String getDocumentNamespace(Model model) throws InvalidSPDXAnalysisException {
        Node documentNode = RdfStore.getSpdxDocNode(model);
        if (documentNode == null) {
            throw new InvalidSPDXAnalysisException("Invalid model - must contain an SPDX Document");
        }
        if (!documentNode.isURI()) {
            throw new InvalidSPDXAnalysisException("SPDX Documents must have a unique URI");
        }
        String docUri = documentNode.getURI();
        return RdfStore.formDocNamespace(docUri);
    }

    public void serialize(String documentUri, OutputStream stream) throws InvalidSPDXAnalysisException, IOException {
        RdfSpdxDocumentModelManager modelManager = this.documentUriModelMap.get(documentUri);
        if (Objects.isNull(modelManager)) {
            logger.error("The document " + documentUri + " does not exist.");
            throw new InvalidSPDXAnalysisException("The document " + documentUri + " does not exist.");
        }
        modelManager.serialize(stream, this.outputFormat);
    }

    public String deSerialize(InputStream stream, boolean overwrite) throws InvalidSPDXAnalysisException, IOException {
        Model model = ModelFactory.createDefaultModel();
        model.read(stream, null, this.outputFormat.getType());
        String documentNamespace = RdfStore.getDocumentNamespace(model);
        RdfSpdxDocumentModelManager modelManager = new RdfSpdxDocumentModelManager(documentNamespace, model);
        CompatibilityUpgrader.upgrade(model, documentNamespace);
        RdfSpdxDocumentModelManager previousModel = this.documentUriModelMap.putIfAbsent(documentNamespace, modelManager);
        if (!Objects.isNull(previousModel)) {
            if (overwrite) {
                logger.warn("Overwriting previous model from file for document URI " + documentNamespace);
                this.documentUriModelMap.put(documentNamespace, modelManager);
            } else {
                throw new SpdxRdfException("Document " + documentNamespace + " is already open in the RDF Store");
            }
        }
        return documentNamespace;
    }

    public String deSerialize(InputStream stream, boolean overwrite, String documentNamespace) throws InvalidSPDXAnalysisException, IOException {
        Model model = ModelFactory.createDefaultModel();
        model.read(stream, null, this.outputFormat.getType());
        RdfSpdxDocumentModelManager modelManager = new RdfSpdxDocumentModelManager(documentNamespace, model);
        CompatibilityUpgrader.upgrade(model, documentNamespace);
        RdfSpdxDocumentModelManager previousModel = this.documentUriModelMap.putIfAbsent(documentNamespace, modelManager);
        if (!Objects.isNull(previousModel)) {
            if (overwrite) {
                logger.warn("Overwriting previous model from file for document URI " + documentNamespace);
                this.documentUriModelMap.put(documentNamespace, modelManager);
            } else {
                throw new SpdxRdfException("Document " + documentNamespace + " is already open in the RDF Store");
            }
        }
        return documentNamespace;
    }

    public Optional<String> getCaseSensisitiveId(String documentUri, String caseInsensisitiveId) {
        RdfSpdxDocumentModelManager modelManager = this.documentUriModelMap.get(documentUri);
        if (Objects.isNull(modelManager)) {
            return Optional.empty();
        }
        return modelManager.getCasesensitiveId(caseInsensisitiveId);
    }

    public Optional<TypedValue> getTypedValue(String documentUri, String id) throws InvalidSPDXAnalysisException {
        RdfSpdxDocumentModelManager modelManager = this.documentUriModelMap.get(documentUri);
        if (Objects.isNull(modelManager)) {
            return Optional.empty();
        }
        return modelManager.getTypedValue(id);
    }

    public void delete(String documentUri, String id) throws InvalidSPDXAnalysisException {
        Objects.requireNonNull(documentUri, "Missing required document URI");
        Objects.requireNonNull(id, "Missing required ID");
        RdfSpdxDocumentModelManager modelManager = this.documentUriModelMap.get(documentUri);
        if (Objects.isNull(modelManager)) {
            throw new SpdxIdNotFoundException("Can not delete - document URI " + documentUri + " does not exist");
        }
        if (!modelManager.getCasesensitiveId(id).isPresent()) {
            throw new SpdxIdNotFoundException("Can not delete - element ID " + id + " does not exist");
        }
        modelManager.delete(id);
    }

    public void close() throws Exception {
        Iterator<RdfSpdxDocumentModelManager> modelManagerIter = this.documentUriModelMap.values().iterator();
        ArrayList<RdfSpdxDocumentModelManager> modelManagersToClose = new ArrayList<RdfSpdxDocumentModelManager>();
        while (modelManagerIter.hasNext()) {
            modelManagersToClose.add(modelManagerIter.next());
        }
        this.documentUriModelMap.clear();
        for (RdfSpdxDocumentModelManager modelManager : modelManagersToClose) {
            modelManager.close();
        }
    }
}

