/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.spdxRdfStore;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import org.apache.jena.atlas.web.TypedInputStream;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.ARQ;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spdx.core.CoreModelObject;
import org.spdx.core.DuplicateSpdxIdException;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.core.TypedValue;
import org.spdx.library.SpdxModelFactory;
import org.spdx.library.model.v2.SpdxConstantsCompatV2;
import org.spdx.library.model.v2.SpdxDocument;
import org.spdx.spdxRdfStore.CompatibilityUpgrader;
import org.spdx.spdxRdfStore.OutputFormat;
import org.spdx.spdxRdfStore.RdfSpdxModelManager;
import org.spdx.spdxRdfStore.SpdxRdfException;
import org.spdx.storage.IModelStore;
import org.spdx.storage.ISerializableModelStore;
import org.spdx.storage.PropertyDescriptor;
import org.spdx.storage.compatv2.CompatibleModelStoreWrapper;

public class RdfStore
implements IModelStore,
ISerializableModelStore {
    static final Logger logger = LoggerFactory.getLogger((String)RdfStore.class.getName());
    static final String GENERATED = "gnrtd";
    static Pattern DOCUMENT_ID_PATTERN_GENERATED = Pattern.compile(SpdxConstantsCompatV2.EXTERNAL_DOC_REF_PRENUM + "gnrtd(\\d+)$");
    static Pattern SPDX_ID_PATTERN_GENERATED = Pattern.compile(SpdxConstantsCompatV2.SPDX_ELEMENT_REF_PRENUM + "gnrtd(\\d+)$");
    static Pattern LICENSE_ID_PATTERN_GENERATED = Pattern.compile(SpdxConstantsCompatV2.NON_STD_LICENSE_ID_PRENUM + "gnrtd(\\d+)$");
    static final String ANON_PREFIX = "__anon__";
    static Pattern ANON_ID_PATTERN = Pattern.compile("__anon__(.+)$");
    RdfSpdxModelManager modelManager;
    String documentUri;
    boolean dontStoreLicenseDetails = false;
    private OutputFormat outputFormat = OutputFormat.XML_ABBREV;

    public RdfStore(InputStream stream) throws InvalidSPDXAnalysisException, IOException {
        this.deSerialize(stream, false);
    }

    public RdfStore() {
        this.modelManager = null;
        this.documentUri = null;
    }

    public RdfStore(InputStream stream, String documentUri) throws InvalidSPDXAnalysisException, IOException {
        this.documentUri = documentUri;
        this.deSerialize(stream, false, documentUri);
    }

    public RdfStore(String documentUri) {
        this.documentUri = documentUri;
        this.modelManager = this.createModelManager(documentUri);
    }

    public OutputFormat getOutputFormat() {
        return this.outputFormat;
    }

    @Nullable
    public String getDocumentUri() {
        return this.documentUri;
    }

    public void setDocumentUri(@Nullable String documentUri, boolean overwrite) throws InvalidSPDXAnalysisException {
        if (Objects.nonNull(this.documentUri) && !overwrite && !Objects.equals(this.documentUri, documentUri)) {
            throw new InvalidSPDXAnalysisException("Document URI " + this.documentUri + " already exists");
        }
        if (!Objects.equals(this.documentUri, documentUri)) {
            this.documentUri = documentUri;
            this.modelManager = Objects.nonNull(documentUri) ? this.createModelManager(documentUri) : null;
        }
    }

    public void setOutputFormat(OutputFormat outputFormat) {
        this.outputFormat = outputFormat;
    }

    public boolean isDontStoreLicenseDetails() {
        return this.dontStoreLicenseDetails;
    }

    public void setDontStoreLicenseDetails(boolean dontStoreLicenseDetails) {
        this.dontStoreLicenseDetails = dontStoreLicenseDetails;
    }

    public boolean exists(String objectUri) {
        String id;
        if (Objects.isNull(this.modelManager)) {
            return false;
        }
        Objects.requireNonNull(objectUri, "Missing required objectUri");
        if (!(this.isAnon(objectUri) || objectUri.startsWith(this.documentUri + "#") || objectUri.startsWith("http://spdx.org/licenses/") || objectUri.startsWith("https://spdx.org/licenses/"))) {
            return false;
        }
        try {
            id = CompatibleModelStoreWrapper.objectUriToId((IModelStore)this, (String)objectUri, (String)this.documentUri);
        }
        catch (InvalidSPDXAnalysisException e) {
            logger.warn("Unable to convert Object URI into a document URI + ID: " + objectUri);
            return false;
        }
        return this.modelManager.exists(id);
    }

    public boolean isAnon(String objectUri) {
        Objects.requireNonNull(objectUri, "Missing required objectUri");
        return ANON_ID_PATTERN.matcher(objectUri).matches();
    }

    public IModelStore.IdType getIdType(String objectUri) {
        String id;
        Objects.requireNonNull(objectUri, "Missing required objectUri");
        if (this.isAnon(objectUri)) {
            return IModelStore.IdType.Anonymous;
        }
        if (objectUri.startsWith("http://spdx.org/licenses/") || objectUri.startsWith("https://spdx.org/licenses/")) {
            return IModelStore.IdType.ListedLicense;
        }
        try {
            id = CompatibleModelStoreWrapper.objectUriToId((boolean)false, (String)objectUri, (String)this.documentUri);
        }
        catch (InvalidSPDXAnalysisException e) {
            logger.warn("Error converting object URI to ID for URI: " + objectUri, (Throwable)e);
            return IModelStore.IdType.Unkown;
        }
        if (SpdxConstantsCompatV2.LICENSE_ID_PATTERN.matcher(id).matches()) {
            return IModelStore.IdType.LicenseRef;
        }
        if (SpdxConstantsCompatV2.EXTERNAL_DOC_REF_PATTERN.matcher(id).matches()) {
            return IModelStore.IdType.DocumentRef;
        }
        if (SpdxConstantsCompatV2.SPDX_ELEMENT_REF_PATTERN.matcher(id).matches()) {
            return IModelStore.IdType.SpdxId;
        }
        return IModelStore.IdType.Unkown;
    }

    public void create(TypedValue typedValue) throws InvalidSPDXAnalysisException {
        this.checkClosed();
        Objects.requireNonNull(typedValue, "Missing required typed value");
        if ("ExternalSpdxElement".equals(typedValue.getType()) || "ExternalExtractedLicenseInfo".equals(typedValue.getType())) {
            return;
        }
        String id = CompatibleModelStoreWrapper.objectUriToId((IModelStore)this, (String)typedValue.getObjectUri(), (String)this.documentUri);
        if (this.modelManager.getCasesensitiveId(id).isPresent()) {
            throw new DuplicateSpdxIdException("Id " + id + " already exists.");
        }
        this.modelManager.getOrCreate(typedValue.getObjectUri(), typedValue.getType());
    }

    private RdfSpdxModelManager createModelManager(String documentUri) {
        Model model = ModelFactory.createDefaultModel();
        model.getGraph().getPrefixMapping().setNsPrefix("spdx", "http://spdx.org/rdf/terms#");
        model.getGraph().getPrefixMapping().setNsPrefix("doap", "http://usefulinc.com/ns/doap#");
        model.getGraph().getPrefixMapping().setNsPrefix("ptr", "http://www.w3.org/2009/pointers#");
        model.getGraph().getPrefixMapping().setNsPrefix("rdfs", "http://www.w3.org/2000/01/rdf-schema#");
        RdfSpdxModelManager modelManager = new RdfSpdxModelManager(documentUri, model);
        return modelManager;
    }

    public List<PropertyDescriptor> getPropertyValueDescriptors(String objectUri) throws InvalidSPDXAnalysisException {
        this.checkClosed();
        Objects.requireNonNull(objectUri, "Missing required object URI");
        String id = CompatibleModelStoreWrapper.objectUriToId((IModelStore)this, (String)objectUri, (String)this.documentUri);
        return StreamSupport.stream(this.modelManager.getPropertyValueNames(id).spliterator(), false).map(propName -> CompatibleModelStoreWrapper.propNameToPropDescriptor((String)propName)).collect(Collectors.toList());
    }

    public void setValue(String objectUri, PropertyDescriptor prop, Object value) throws InvalidSPDXAnalysisException {
        this.checkClosed();
        Objects.requireNonNull(objectUri);
        Objects.requireNonNull(prop);
        if (this.isListedLicenseOrException(objectUri) && this.dontStoreLicenseDetails) {
            return;
        }
        String id = CompatibleModelStoreWrapper.objectUriToId((IModelStore)this, (String)objectUri, (String)this.documentUri);
        this.modelManager.setValue(id, prop.getName(), value);
    }

    private boolean isListedLicenseOrException(String objectUri) {
        return Objects.isNull(objectUri) || objectUri.startsWith("http://spdx.org/licenses/") || objectUri.startsWith("https://spdx.org/licenses/");
    }

    public Optional<Object> getValue(String objectUri, PropertyDescriptor prop) throws InvalidSPDXAnalysisException {
        this.checkClosed();
        Objects.requireNonNull(objectUri, "Missing required object URI");
        Objects.requireNonNull(prop, "Missing required property descriptor");
        String id = CompatibleModelStoreWrapper.objectUriToId((IModelStore)this, (String)objectUri, (String)this.documentUri);
        return this.modelManager.getPropertyValue(id, prop.getName());
    }

    public String getNextId(IModelStore.IdType idType) throws InvalidSPDXAnalysisException {
        this.checkClosed();
        Objects.requireNonNull(idType, "Missing required ID type");
        return this.modelManager.getNextId(idType);
    }

    public void removeProperty(String objectUri, PropertyDescriptor prop) throws InvalidSPDXAnalysisException {
        this.checkClosed();
        Objects.requireNonNull(objectUri, "Missing required Object URI");
        Objects.requireNonNull(prop, "Missing required property descriptor");
        String id = CompatibleModelStoreWrapper.objectUriToId((IModelStore)this, (String)objectUri, (String)this.documentUri);
        this.modelManager.removeProperty(id, prop.getName());
    }

    public Stream<TypedValue> getAllItems(@Nullable String prefix, String typeFilter) throws InvalidSPDXAnalysisException {
        this.checkClosed();
        return this.modelManager.getAllItems(typeFilter);
    }

    public boolean removeValueFromCollection(String objectUri, PropertyDescriptor propertyDescriptor, Object value) throws InvalidSPDXAnalysisException {
        this.checkClosed();
        Objects.requireNonNull(objectUri, "Missing required object URI");
        Objects.requireNonNull(propertyDescriptor, "Missing required property descriptor");
        Objects.requireNonNull(value, "Mising required value");
        if (this.isListedLicenseOrException(objectUri) && this.dontStoreLicenseDetails) {
            return false;
        }
        String id = CompatibleModelStoreWrapper.objectUriToId((IModelStore)this, (String)objectUri, (String)this.documentUri);
        return this.modelManager.removeValueFromCollection(id, propertyDescriptor.getName(), value);
    }

    public int collectionSize(String objectUri, PropertyDescriptor propertyDescriptor) throws InvalidSPDXAnalysisException {
        this.checkClosed();
        Objects.requireNonNull(objectUri, "Missing required Object URI");
        Objects.requireNonNull(propertyDescriptor, "Missing required property descriptor");
        String id = CompatibleModelStoreWrapper.objectUriToId((IModelStore)this, (String)objectUri, (String)this.documentUri);
        return this.modelManager.collectionSize(id, propertyDescriptor.getName());
    }

    public boolean collectionContains(String objectUri, PropertyDescriptor propertyDescriptor, Object value) throws InvalidSPDXAnalysisException {
        this.checkClosed();
        Objects.requireNonNull(objectUri, "Missing required Object URI");
        Objects.requireNonNull(propertyDescriptor, "Missing required property descriptor");
        Objects.requireNonNull(value, "Missing required value");
        String id = CompatibleModelStoreWrapper.objectUriToId((IModelStore)this, (String)objectUri, (String)this.documentUri);
        return this.modelManager.collectionContains(id, propertyDescriptor.getName(), value);
    }

    public void clearValueCollection(String objectUri, PropertyDescriptor propertyDescriptor) throws InvalidSPDXAnalysisException {
        this.checkClosed();
        Objects.requireNonNull(objectUri, "Missing required Object URI");
        Objects.requireNonNull(propertyDescriptor, "Missing required property descriptor");
        String id = CompatibleModelStoreWrapper.objectUriToId((IModelStore)this, (String)objectUri, (String)this.documentUri);
        this.modelManager.clearValueCollection(id, propertyDescriptor.getName());
    }

    public boolean addValueToCollection(String objectUri, PropertyDescriptor propertyDescriptor, Object value) throws InvalidSPDXAnalysisException {
        Objects.requireNonNull(objectUri, "Missing required Object URI");
        Objects.requireNonNull(propertyDescriptor, "Missing required property descriptor");
        this.checkClosed();
        if (this.isListedLicenseOrException(objectUri) && this.dontStoreLicenseDetails) {
            return false;
        }
        String id = CompatibleModelStoreWrapper.objectUriToId((IModelStore)this, (String)objectUri, (String)this.documentUri);
        return this.modelManager.addValueToCollection(id, propertyDescriptor.getName(), value);
    }

    private void checkClosed() throws InvalidSPDXAnalysisException {
        if (Objects.isNull(this.modelManager)) {
            throw new InvalidSPDXAnalysisException("RDF Store has been closed or not properly initialized");
        }
    }

    public Iterator<Object> listValues(String objectUri, PropertyDescriptor propertyDescriptor) throws InvalidSPDXAnalysisException {
        this.checkClosed();
        Objects.requireNonNull(objectUri, "Missing required Object URI");
        Objects.requireNonNull(propertyDescriptor, "Missing required property descriptor");
        String id = CompatibleModelStoreWrapper.objectUriToId((IModelStore)this, (String)objectUri, (String)this.documentUri);
        return this.modelManager.getValueList(id, propertyDescriptor.getName());
    }

    public boolean isCollectionMembersAssignableTo(String objectUri, PropertyDescriptor propertyDescriptor, Class<?> clazz) throws InvalidSPDXAnalysisException {
        this.checkClosed();
        Objects.requireNonNull(objectUri, "Missing required Object URI");
        Objects.requireNonNull(propertyDescriptor, "Missing required property descriptor");
        Objects.requireNonNull(clazz, "Missing required class");
        String id = CompatibleModelStoreWrapper.objectUriToId((IModelStore)this, (String)objectUri, (String)this.documentUri);
        return this.modelManager.isCollectionMembersAssignableTo(id, propertyDescriptor.getName(), clazz);
    }

    public boolean isPropertyValueAssignableTo(String objectUri, PropertyDescriptor propertyDescriptor, Class<?> clazz, String specVersion) throws InvalidSPDXAnalysisException {
        this.checkClosed();
        Objects.requireNonNull(objectUri, "Missing required Object URI");
        Objects.requireNonNull(propertyDescriptor, "Missing required property descriptor");
        Objects.requireNonNull(clazz, "Missing required class");
        String id = CompatibleModelStoreWrapper.objectUriToId((IModelStore)this, (String)objectUri, (String)this.documentUri);
        return this.modelManager.isPropertyValueAssignableTo(id, propertyDescriptor.getName(), clazz);
    }

    public boolean isCollectionProperty(String objectUri, PropertyDescriptor propertyDescriptor) throws InvalidSPDXAnalysisException {
        this.checkClosed();
        Objects.requireNonNull(objectUri, "Missing required Object URI");
        Objects.requireNonNull(propertyDescriptor, "Missing required property descriptor");
        String id = CompatibleModelStoreWrapper.objectUriToId((IModelStore)this, (String)objectUri, (String)this.documentUri);
        return this.modelManager.isCollectionProperty(id, propertyDescriptor.getName());
    }

    public void leaveCriticalSection(IModelStore.IModelStoreLock lock) {
        lock.unlock();
    }

    public IModelStore.IModelStoreLock enterCriticalSection(boolean readLockRequested) throws InvalidSPDXAnalysisException {
        this.checkClosed();
        return this.modelManager.enterCriticalSection(readLockRequested);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String loadModelFromFile(String fileNameOrUrl, boolean overwrite) throws InvalidSPDXAnalysisException, IOException {
        TypedInputStream spdxRdfInput = RDFDataMgr.open((String)fileNameOrUrl);
        if (Objects.isNull(spdxRdfInput)) {
            throw new FileNotFoundException(fileNameOrUrl + " not found.");
        }
        try {
            SpdxDocument doc = this.deSerialize((InputStream)spdxRdfInput, overwrite);
            String string = doc.getDocumentUri();
            return string;
        }
        finally {
            try {
                spdxRdfInput.close();
            }
            catch (IOException e) {
                logger.warn("Error closing SPDX RDF file " + fileNameOrUrl, (Throwable)e);
            }
        }
    }

    private static String formDocNamespace(String docUriString) {
        int fragmentIndex = docUriString.indexOf(35);
        if (fragmentIndex <= 0) {
            return docUriString;
        }
        return docUriString.substring(0, fragmentIndex);
    }

    public static List<Node> getSpdxDocNodes(Model model) {
        Node rdfTypePredicate = model.getProperty("http://www.w3.org/1999/02/22-rdf-syntax-ns#", SpdxConstantsCompatV2.RDF_PROP_TYPE.getName()).asNode();
        Node spdxDocObject = model.getProperty("http://spdx.org/rdf/terms#", "SpdxDocument").asNode();
        Triple m = Triple.createMatch(null, (Node)rdfTypePredicate, (Node)spdxDocObject);
        ExtendedIterator tripleIter = model.getGraph().find(m);
        ArrayList<Node> retval = new ArrayList<Node>();
        while (tripleIter.hasNext()) {
            Triple docTriple = (Triple)tripleIter.next();
            retval.add(docTriple.getSubject());
        }
        return retval;
    }

    public static List<String> getDocumentNamespaces(Model model) throws InvalidSPDXAnalysisException {
        ArrayList<String> retval = new ArrayList<String>();
        for (Node documentNode : RdfStore.getSpdxDocNodes(model)) {
            if (documentNode == null) {
                throw new InvalidSPDXAnalysisException("Invalid model - must contain an SPDX Document");
            }
            if (!documentNode.isURI()) {
                throw new InvalidSPDXAnalysisException("SPDX Documents must have a unique URI");
            }
            String docUri = documentNode.getURI();
            retval.add(RdfStore.formDocNamespace(docUri));
        }
        return retval;
    }

    public void serialize(OutputStream stream) throws InvalidSPDXAnalysisException, IOException {
        this.checkClosed();
        this.modelManager.serialize(stream, this.outputFormat);
    }

    public void serialize(OutputStream stream, @Nullable CoreModelObject spdxDocument) throws InvalidSPDXAnalysisException, IOException {
        this.checkClosed();
        if (Objects.nonNull(spdxDocument)) {
            if (!(spdxDocument instanceof SpdxDocument)) {
                logger.error("Attempting to serialize " + spdxDocument.getClass().getName() + " which is not an SpdxDocument");
                throw new InvalidSPDXAnalysisException("Attempting to serialize " + spdxDocument.getClass().getName() + " which is not an SpdxDocument");
            }
            if (!this.documentUri.equals(((SpdxDocument)spdxDocument).getDocumentUri())) {
                logger.error(((SpdxDocument)spdxDocument).getDocumentUri() + " not found in model store");
                throw new InvalidSPDXAnalysisException(((SpdxDocument)spdxDocument).getDocumentUri() + " not found in model store");
            }
        }
        this.modelManager.serialize(stream, this.outputFormat);
    }

    public SpdxDocument deSerialize(InputStream stream, boolean overwrite) throws InvalidSPDXAnalysisException, IOException {
        Model model = ModelFactory.createDefaultModel();
        model.read(stream, null, this.outputFormat.getType());
        List<String> documentNamespaces = RdfStore.getDocumentNamespaces(model);
        if (documentNamespaces.size() > 1) {
            throw new InvalidSPDXAnalysisException("Can only deserialize SPDX version 2 RDF documents with a single SPDX document");
        }
        if (documentNamespaces.isEmpty()) {
            throw new InvalidSPDXAnalysisException("Missing SPDX document");
        }
        String documentNamespace = documentNamespaces.get(0);
        CompatibilityUpgrader.upgrade(model, documentNamespace);
        if (Objects.nonNull(this.modelManager) && !RdfStore.getDocumentNamespaces(this.modelManager.getModel()).isEmpty()) {
            if (overwrite) {
                logger.warn("Overwriting previous model from file for document URI " + documentNamespace);
            } else {
                throw new SpdxRdfException("RDF Store contains data and overwrite is set to false");
            }
        }
        this.modelManager = new RdfSpdxModelManager(documentNamespace, model);
        this.documentUri = documentNamespace;
        Stream documentStream = SpdxModelFactory.getSpdxObjects((IModelStore)this, null, (String)"SpdxDocument", (String)(documentNamespace + "#SPDXRef-DOCUMENT"), (String)documentNamespace);
        List documents = documentStream.collect(Collectors.toList());
        if (documents.isEmpty()) {
            logger.error("No SPDX document found in file");
            throw new InvalidSPDXAnalysisException("No SPDX document was found in file");
        }
        return (SpdxDocument)documents.get(0);
    }

    public void deSerialize(InputStream stream, boolean overwrite, String documentNamespace) throws InvalidSPDXAnalysisException, IOException {
        Model model = ModelFactory.createDefaultModel();
        model.read(stream, null, this.outputFormat.getType());
        CompatibilityUpgrader.upgrade(model, documentNamespace);
        if (!RdfStore.getDocumentNamespaces(this.modelManager.getModel()).isEmpty()) {
            if (overwrite) {
                logger.warn("Overwriting previous model from file for document URI " + documentNamespace);
            } else {
                throw new SpdxRdfException("Document " + documentNamespace + " is already open in the RDF Store");
            }
        }
        this.modelManager = new RdfSpdxModelManager(documentNamespace, model);
        this.documentUri = documentNamespace;
    }

    public Optional<String> getCaseSensisitiveId(String documentUri, String caseInsensisitiveId) {
        if (Objects.isNull(this.modelManager)) {
            return Optional.empty();
        }
        return this.modelManager.getCasesensitiveId(caseInsensisitiveId);
    }

    public Optional<TypedValue> getTypedValue(String objectUri) throws InvalidSPDXAnalysisException {
        this.checkClosed();
        Objects.requireNonNull(objectUri, "Missing required Object URI");
        if (!(this.isAnon(objectUri) || objectUri.startsWith(this.documentUri + "#") || objectUri.startsWith("http://spdx.org/licenses/") || objectUri.startsWith("https://spdx.org/licenses/"))) {
            return Optional.empty();
        }
        String id = CompatibleModelStoreWrapper.objectUriToId((IModelStore)this, (String)objectUri, (String)this.documentUri);
        return this.modelManager.getTypedValue(id);
    }

    public void delete(String objectUri) throws InvalidSPDXAnalysisException {
        this.checkClosed();
        Objects.requireNonNull(objectUri, "Missing required Object URI");
        String id = CompatibleModelStoreWrapper.objectUriToId((IModelStore)this, (String)objectUri, (String)this.documentUri);
        this.modelManager.delete(id);
    }

    public void close() throws Exception {
        if (Objects.nonNull(this.modelManager)) {
            this.modelManager.close();
            this.modelManager = null;
        }
    }

    static {
        ARQ.init();
    }
}

