/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.spdx_to_osv;

import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.spdx.spdx_to_osv.osvmodel.OsvPackage;
import org.spdx.spdx_to_osv.osvmodel.OsvVulnerabilityRequest;

public class DownloadLocationParser {
    static final String MAVEN_PREFIX = "https://search.maven.org/remotecontent";
    static final Pattern MAVEN_PATTERN = Pattern.compile("https://search.maven.org/remotecontent.*?filepath=([^?]+)(\\?.+$|$)");
    static final String NPM_PREFIX = "https://www.npmjs.com/package/";
    static final Pattern NPM_PATTERN_W_VERSION = Pattern.compile("https://www.npmjs.com/package/([@A-Za-z0-9_.-/]+)/v/([A-Za-z0-9_.-]+)$");
    static final Pattern NPM_PATTERN_NO_VERSION = Pattern.compile("https://www.npmjs.com/package/([@A-Za-z0-9_.-/]+)$");
    static final String NUGET_PREFIX = "https://www.nuget.org/api/";
    static final Pattern NUGET_PATTERN = Pattern.compile("https://www.nuget.org/api/v[0-9]+/package/([A-Za-z0-9_.-]+)/([A-Za-z0-9_.-]+)$");
    static final String GITHUB_PREFIX = "https://github.com/";
    static final String GITHUB_SSH_PREFIX = "git@github.com:";
    static final String GITHUB_GIT_PREFIX = "git+";
    static final String GITHUB_VALID_PART = "[A-Za-z0-9_.\\-]";
    static final String GITHUB_ORG_PROJECT = "([A-Za-z0-9_.\\-]+)/([A-Za-z0-9_.\\-]+)";
    static final Pattern GITHUB_GIT_DOWNLOAD_PATTERN = Pattern.compile("git\\+(https://github\\.com/|git@github\\.com:)([A-Za-z0-9_.\\-]+)/([A-Za-z0-9_.\\-]+)(@[A-Za-z0-9_.\\-]+)?(#[A-Za-z0-9_.\\-]+)?");
    static final Pattern GITHUB_PAGE_PATTERN = Pattern.compile("https://github.com/([A-Za-z0-9_.\\-]+)/([A-Za-z0-9_.\\-]+)$");
    static final Pattern GITHUB_RELEASE_PATTERN = Pattern.compile("https://github.com/([A-Za-z0-9_.\\-]+)/([A-Za-z0-9_.\\-]+)/releases/tag/([A-Za-z0-9_.-]+)$");
    static final Pattern GITHUB_HTTPS_PATTERN = Pattern.compile("https://github.com/([A-Za-z0-9_.\\-]+)/([A-Za-z0-9_.\\-]+)\\.git$");
    static final Pattern GITHUB_SSH_PATTERN = Pattern.compile("git@github.com:([A-Za-z0-9_.\\-]+)/([A-Za-z0-9_.\\-]+)\\.git$");
    static final Pattern GITHUB_COMMIT_PATTERN = Pattern.compile("https://github.com/([A-Za-z0-9_.\\-]+)/([A-Za-z0-9_.\\-]+)/tree/([a-f0-9]{40})$");
    static final Pattern GITHUB_TAG_PATTERN = Pattern.compile("https://github.com/([A-Za-z0-9_.\\-]+)/([A-Za-z0-9_.\\-]+)/tree/([A-Za-z0-9_.-]+)$");
    static final Pattern COMMIT_PART_PATTERN = Pattern.compile("[a-f0-9]{40}");
    private String downloadLocation;
    Optional<OsvVulnerabilityRequest> osvVulnerabilityRequest;

    public DownloadLocationParser(String downloadLocation) {
        this.downloadLocation = downloadLocation;
        this.osvVulnerabilityRequest = Optional.empty();
        if (Objects.isNull(downloadLocation) || downloadLocation.isEmpty()) {
            return;
        }
        if (downloadLocation.startsWith(MAVEN_PREFIX)) {
            this.parseMaven();
        } else if (downloadLocation.startsWith(NPM_PREFIX)) {
            this.parseNpm();
        } else if (downloadLocation.startsWith(NUGET_PREFIX)) {
            this.parseNuget();
        } else if (downloadLocation.startsWith(GITHUB_PREFIX) || downloadLocation.startsWith(GITHUB_SSH_PREFIX) || downloadLocation.startsWith(GITHUB_GIT_PREFIX)) {
            this.parseGithub();
        }
    }

    private void parseGithub() {
        String githubNamePrefix = "github.com/";
        Matcher matcher = GITHUB_GIT_DOWNLOAD_PATTERN.matcher(this.downloadLocation);
        if (matcher.matches()) {
            String versionOrCommit;
            String org = matcher.group(2);
            String pkg = matcher.group(3);
            this.osvVulnerabilityRequest = matcher.group(4) != null && matcher.group(4).startsWith("@") ? (COMMIT_PART_PATTERN.matcher(versionOrCommit = matcher.group(4).substring(1)).matches() ? Optional.of(new OsvVulnerabilityRequest(versionOrCommit)) : Optional.of(new OsvVulnerabilityRequest(new OsvPackage(githubNamePrefix + org + "/" + pkg, null, null), versionOrCommit))) : Optional.of(new OsvVulnerabilityRequest(new OsvPackage(githubNamePrefix + org + "/" + pkg, null, null), null));
            return;
        }
        matcher = GITHUB_HTTPS_PATTERN.matcher(this.downloadLocation);
        if (matcher.matches()) {
            String org = matcher.group(1);
            String pkg = matcher.group(2);
            this.osvVulnerabilityRequest = Optional.of(new OsvVulnerabilityRequest(new OsvPackage(githubNamePrefix + org + "/" + pkg, null, null), null));
            return;
        }
        matcher = GITHUB_PAGE_PATTERN.matcher(this.downloadLocation);
        if (matcher.matches()) {
            String org = matcher.group(1);
            String pkg = matcher.group(2);
            this.osvVulnerabilityRequest = Optional.of(new OsvVulnerabilityRequest(new OsvPackage(githubNamePrefix + org + "/" + pkg, null, null), null));
            return;
        }
        matcher = GITHUB_SSH_PATTERN.matcher(this.downloadLocation);
        if (matcher.matches()) {
            String org = matcher.group(1);
            String pkg = matcher.group(2);
            this.osvVulnerabilityRequest = Optional.of(new OsvVulnerabilityRequest(new OsvPackage(githubNamePrefix + org + "/" + pkg, null, null), null));
            return;
        }
        matcher = GITHUB_COMMIT_PATTERN.matcher(this.downloadLocation);
        if (matcher.matches()) {
            String commit = matcher.group(3);
            this.osvVulnerabilityRequest = Optional.of(new OsvVulnerabilityRequest(commit));
            return;
        }
        matcher = GITHUB_RELEASE_PATTERN.matcher(this.downloadLocation);
        if (matcher.matches()) {
            String org = matcher.group(1);
            String pkg = matcher.group(2);
            String version = matcher.group(3);
            this.osvVulnerabilityRequest = Optional.of(new OsvVulnerabilityRequest(new OsvPackage(githubNamePrefix + org + "/" + pkg, null, null), version));
            return;
        }
        matcher = GITHUB_TAG_PATTERN.matcher(this.downloadLocation);
        if (matcher.matches()) {
            String org = matcher.group(1);
            String pkg = matcher.group(2);
            String version = matcher.group(3);
            this.osvVulnerabilityRequest = Optional.of(new OsvVulnerabilityRequest(new OsvPackage(githubNamePrefix + org + "/" + pkg, null, null), version));
            return;
        }
    }

    private void parseNuget() {
        Matcher matcher = NUGET_PATTERN.matcher(this.downloadLocation);
        if (matcher.matches()) {
            String pkg = matcher.group(1);
            String version = matcher.group(2);
            this.osvVulnerabilityRequest = Optional.of(new OsvVulnerabilityRequest(new OsvPackage(pkg, "NuGet", "pkg:nuget/" + pkg + "@" + version), version));
        }
    }

    private void parseNpm() {
        Matcher matcher = NPM_PATTERN_W_VERSION.matcher(this.downloadLocation);
        if (matcher.matches()) {
            String pkg = matcher.group(1);
            String version = matcher.group(2);
            this.osvVulnerabilityRequest = Optional.of(new OsvVulnerabilityRequest(new OsvPackage(pkg, "npm", "pkg:npm/" + pkg.replaceAll("@", "%40") + "@" + version), version));
        } else {
            matcher = NPM_PATTERN_NO_VERSION.matcher(this.downloadLocation);
            if (matcher.matches()) {
                String pkg = matcher.group(1);
                this.osvVulnerabilityRequest = Optional.of(new OsvVulnerabilityRequest(new OsvPackage(pkg, "npm", "pkg:npm/" + pkg.replaceAll("@", "%40")), null));
            }
        }
    }

    private void parseMaven() {
        Matcher matcher = MAVEN_PATTERN.matcher(this.downloadLocation);
        if (matcher.matches()) {
            String filepath = matcher.group(1);
            String[] parts = filepath.split("/");
            if (parts.length < 3) {
                return;
            }
            String version = parts[parts.length - 2];
            StringBuilder pkgName = new StringBuilder(parts[0]);
            for (int i = 1; i < parts.length - 2; ++i) {
                pkgName.append(".");
                pkgName.append(parts[i]);
            }
            this.osvVulnerabilityRequest = Optional.of(new OsvVulnerabilityRequest(new OsvPackage(pkgName.toString(), "Maven", "pkg:maven/" + pkgName.toString() + "@" + version), version));
        }
    }

    public String getDownloadLocation() {
        return this.downloadLocation;
    }

    public Optional<OsvVulnerabilityRequest> getOsvVulnerabilityRequest() {
        return this.osvVulnerabilityRequest;
    }
}

