/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.spdx_to_osv;

import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.spdx.library.InvalidSPDXAnalysisException;
import org.spdx.library.model.ExternalRef;
import org.spdx.spdx_to_osv.InvalidExternalRefPattern;
import org.spdx.spdx_to_osv.SwhException;
import org.spdx.spdx_to_osv.osvmodel.OsvPackage;
import org.spdx.spdx_to_osv.osvmodel.OsvVulnerabilityRequest;
import us.springett.parsers.cpe.Cpe;
import us.springett.parsers.cpe.CpeParser;
import us.springett.parsers.cpe.exceptions.CpeParsingException;
import us.springett.parsers.cpe.values.Part;

public class ExternalRefParser {
    static final Pattern SWH_PATTERN = Pattern.compile("swh:1:(cnt|dir|rev|rel|snp):([0123456789abcdef]{40})$");
    static final Pattern PURL_PATTERN = Pattern.compile("pkg:((?<type>[^?/#@]+)/)((?<namespace>[^?#@]+)/)?(?<name>[^?#@]+)(@(?<version>[^?#]+))?(\\?[^#]+)*(#.+)*$");
    private boolean useMavenGroupInPkgName = true;
    private ExternalRef externalRef;
    Optional<OsvVulnerabilityRequest> osvVulnerabilityRequest = Optional.empty();
    Optional<Part> cpePart = Optional.empty();
    Optional<String> vendor = Optional.empty();
    Optional<String> update = Optional.empty();
    Optional<String> edition = Optional.empty();
    Optional<String> language = Optional.empty();
    private Optional<String> swEdition = Optional.empty();
    private Optional<String> targetSw = Optional.empty();
    private Optional<String> targetHw = Optional.empty();
    private Optional<String> cpeOther = Optional.empty();

    public ExternalRefParser(ExternalRef externalRef) throws InvalidSPDXAnalysisException, InvalidExternalRefPattern, IOException, SwhException {
        this(externalRef, true);
    }

    public ExternalRefParser(ExternalRef externalRef, boolean useMavenGroupInPkgName) throws InvalidSPDXAnalysisException, InvalidExternalRefPattern, IOException, SwhException {
        this.useMavenGroupInPkgName = useMavenGroupInPkgName;
        this.externalRef = externalRef;
        if (externalRef.getReferenceType().getIndividualURI().endsWith("/cpe22Type")) {
            this.parseCpe(externalRef.getReferenceLocator());
        } else if (externalRef.getReferenceType().getIndividualURI().endsWith("/cpe23Type")) {
            this.parseCpe(externalRef.getReferenceLocator());
        } else if (externalRef.getReferenceType().getIndividualURI().endsWith("/maven-central")) {
            this.parseMavenCentral(externalRef.getReferenceLocator());
        } else if (externalRef.getReferenceType().getIndividualURI().endsWith("/npm")) {
            this.parseNpm(externalRef.getReferenceLocator());
        } else if (externalRef.getReferenceType().getIndividualURI().endsWith("/nuget")) {
            this.parseNuget(externalRef.getReferenceLocator());
        } else if (externalRef.getReferenceType().getIndividualURI().endsWith("/bower")) {
            this.parseBower(externalRef.getReferenceLocator());
        } else if (externalRef.getReferenceType().getIndividualURI().endsWith("/purl")) {
            this.paserPurl(externalRef.getReferenceLocator());
        } else if (externalRef.getReferenceType().getIndividualURI().endsWith("/swh")) {
            this.parseSwh(externalRef.getReferenceLocator());
        } else {
            this.osvVulnerabilityRequest = Optional.empty();
        }
    }

    private void parseSwh(String referenceLocator) throws InvalidExternalRefPattern, IOException, SwhException {
        Matcher matcher = SWH_PATTERN.matcher(referenceLocator);
        if (!matcher.matches()) {
            throw new InvalidExternalRefPattern("Software Heritage reference locator '" + referenceLocator + "' does not match the pattern '" + SWH_PATTERN.toString());
        }
        this.osvVulnerabilityRequest = Optional.of(new OsvVulnerabilityRequest(matcher.group(2)));
    }

    private void paserPurl(String referenceLocator) throws InvalidExternalRefPattern {
        Matcher match = PURL_PATTERN.matcher(referenceLocator);
        if (!match.matches()) {
            throw new InvalidExternalRefPattern("Purl reference locator '" + referenceLocator + "' does not match the pattern '" + PURL_PATTERN.toString());
        }
        String type = match.group("type");
        String packageName = match.group("name");
        String version = match.group("version");
        if ("github".equals(type) || "bitbucket".equals(type)) {
            this.osvVulnerabilityRequest = Optional.of(new OsvVulnerabilityRequest(version));
        } else if ("docker".equals(type) && Objects.nonNull(version) && version.startsWith("sha256:")) {
            this.osvVulnerabilityRequest = Optional.of(new OsvVulnerabilityRequest(version.substring("sha256:".length())));
        } else if ("maven".equals(type) && this.useMavenGroupInPkgName) {
            packageName = match.group("namespace").replaceAll("/", ".") + ":" + packageName;
            this.osvVulnerabilityRequest = Optional.of(new OsvVulnerabilityRequest(new OsvPackage(packageName, this.purlTypeToOsvEcosystem(type), referenceLocator), version));
        } else {
            this.osvVulnerabilityRequest = Optional.of(new OsvVulnerabilityRequest(new OsvPackage(packageName, this.purlTypeToOsvEcosystem(type), referenceLocator), version));
        }
    }

    private String purlTypeToOsvEcosystem(String purlType) {
        if (Objects.isNull(purlType) || purlType.isEmpty()) {
            return "OSS-Fuzz";
        }
        if (purlType.equals("pypi")) {
            return "PyPI";
        }
        if (purlType.equals("golang")) {
            return "Go";
        }
        if (purlType.equals("maven")) {
            return "Maven";
        }
        if (purlType.equals("npm")) {
            return "npm";
        }
        if (purlType.equals("nuget")) {
            return "NuGet";
        }
        return "OSS-Fuzz";
    }

    private void parseBower(String referenceLocator) {
        String[] parts = referenceLocator.split("#");
        this.cpePart = Optional.of(Part.APPLICATION);
        String pkg = parts[0];
        String version = null;
        if (parts.length > 1) {
            version = parts[1];
        }
        this.osvVulnerabilityRequest = Optional.of(new OsvVulnerabilityRequest(new OsvPackage(pkg), version));
    }

    private void parseNuget(String referenceLocator) {
        String[] parts = referenceLocator.split("/");
        this.cpePart = Optional.of(Part.APPLICATION);
        String pkg = parts[0];
        String purl = "pkg:nuget/" + pkg;
        String version = null;
        if (parts.length > 1) {
            version = parts[1];
            purl = purl + "@" + version;
        }
        this.osvVulnerabilityRequest = Optional.of(new OsvVulnerabilityRequest(new OsvPackage(pkg, "NuGet", purl), version));
    }

    private void parseNpm(String referenceLocator) {
        String[] parts = referenceLocator.split("@");
        this.cpePart = Optional.of(Part.APPLICATION);
        String pkg = parts[0];
        String purl = "pkg:npm/" + pkg.replaceAll("@", "%40");
        String version = null;
        if (parts.length > 1) {
            version = parts[1];
            purl = purl + "@" + version;
        }
        this.osvVulnerabilityRequest = Optional.of(new OsvVulnerabilityRequest(new OsvPackage(pkg, "npm", purl), version));
    }

    private void parseMavenCentral(String referenceLocator) throws InvalidExternalRefPattern {
        String[] parts = referenceLocator.split(":");
        if (parts.length < 2) {
            throw new InvalidExternalRefPattern("Maven central string must have at least the group and artifact");
        }
        this.cpePart = Optional.of(Part.APPLICATION);
        String pkg = this.useMavenGroupInPkgName ? parts[0] + ":" + parts[1] : parts[1];
        String purl = "pkg:maven/" + parts[0] + "/" + parts[1];
        String version = null;
        if (parts.length > 2) {
            version = parts[2];
            purl = purl + "@" + version;
        }
        this.osvVulnerabilityRequest = Optional.of(new OsvVulnerabilityRequest(new OsvPackage(pkg, "Maven", purl), version));
    }

    private void parseCpe(String referenceLocator) throws InvalidExternalRefPattern, InvalidSPDXAnalysisException {
        try {
            Cpe parsedCpe = CpeParser.parse((String)referenceLocator);
            this.cpeOther = Optional.ofNullable(parsedCpe.getOther());
            this.cpePart = Optional.ofNullable(parsedCpe.getPart());
            this.edition = Optional.ofNullable(parsedCpe.getEdition());
            this.language = Optional.ofNullable(parsedCpe.getLanguage());
            String product = parsedCpe.getProduct();
            String version = parsedCpe.getVersion();
            this.osvVulnerabilityRequest = Objects.nonNull(product) && !product.isEmpty() ? (Objects.nonNull(version) && !version.isEmpty() ? Optional.of(new OsvVulnerabilityRequest(new OsvPackage(product), version)) : Optional.of(new OsvVulnerabilityRequest(new OsvPackage(product), null))) : Optional.empty();
            this.swEdition = Optional.ofNullable(parsedCpe.getEdition());
            this.targetHw = Optional.ofNullable(parsedCpe.getTargetHw());
            this.update = Optional.ofNullable(parsedCpe.getUpdate());
            this.vendor = Optional.ofNullable(parsedCpe.getVendor());
        }
        catch (CpeParsingException e) {
            throw new InvalidExternalRefPattern("Invalid CPE 2.2 reference", e);
        }
    }

    public ExternalRef getExternalRef() {
        return this.externalRef;
    }

    public Optional<OsvVulnerabilityRequest> osvVulnerabilityRequest() {
        return this.osvVulnerabilityRequest;
    }

    public Optional<Part> getCpePart() {
        return this.cpePart;
    }

    public Optional<String> getVendor() {
        return this.vendor;
    }

    public Optional<String> getUpdate() {
        return this.update;
    }

    public Optional<String> getEdition() {
        return this.edition;
    }

    public Optional<String> getLanguage() {
        return this.language;
    }

    public Optional<String> getSwEdition() {
        return this.swEdition;
    }

    public Optional<String> getTargetSw() {
        return this.targetSw;
    }

    public Optional<String> getTargetHw() {
        return this.targetHw;
    }

    public Optional<String> getCpeOther() {
        return this.cpeOther;
    }

    public boolean isUseMavenGroupInPkgName() {
        return this.useMavenGroupInPkgName;
    }
}

