/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.spdx_to_osv;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.spdx.library.InvalidSPDXAnalysisException;
import org.spdx.library.model.ExternalRef;
import org.spdx.library.model.Relationship;
import org.spdx.library.model.SpdxDocument;
import org.spdx.library.model.SpdxElement;
import org.spdx.library.model.SpdxFile;
import org.spdx.library.model.SpdxModelFactory;
import org.spdx.library.model.SpdxPackage;
import org.spdx.library.model.enumerations.RelationshipType;
import org.spdx.spdx_to_osv.DownloadLocationParser;
import org.spdx.spdx_to_osv.ExternalRefParser;
import org.spdx.spdx_to_osv.InvalidExternalRefPattern;
import org.spdx.spdx_to_osv.OsvApi;
import org.spdx.spdx_to_osv.SpdxToOsvException;
import org.spdx.spdx_to_osv.SwhException;
import org.spdx.spdx_to_osv.osvmodel.OsvPackage;
import org.spdx.spdx_to_osv.osvmodel.OsvVulnerability;
import org.spdx.spdx_to_osv.osvmodel.OsvVulnerabilityRequest;
import org.spdx.storage.IModelStore;
import org.spdx.storage.ISerializableModelStore;
import org.spdx.tools.SpdxToolsHelper;

public class Main {
    static final int ERROR_STATUS = 1;
    static final int SUCCESS_STATUS = 0;
    static final Set<RelationshipType> RELEVANT_RELATIONSHIPS = new HashSet<RelationshipType>();
    static final Set<RelationshipType> RELEVANT_REVERSE_RELATIONSHIPS = new HashSet<RelationshipType>();
    static final Set<RelationshipType> NON_RELEVANT_RELATIONSHIPS = new HashSet<RelationshipType>();

    public static void main(String[] args) {
        Options options = Main.createOptions();
        if (args.length == 1 && "-h".equals(args[0])) {
            Main.usage(options);
            System.exit(0);
        }
        DefaultParser parser = new DefaultParser();
        CommandLine cmdLine = null;
        try {
            cmdLine = parser.parse(options, args);
        }
        catch (ParseException e1) {
            System.out.println(e1.getMessage());
            Main.usage(options);
            System.exit(1);
        }
        File fromFile = new File(cmdLine.getOptionValue("I").trim());
        File toFile = new File(cmdLine.getOptionValue("O").trim());
        SpdxToolsHelper.SerFileType inputFileType = null;
        if (cmdLine.hasOption("f")) {
            try {
                inputFileType = SpdxToolsHelper.strToFileType((String)cmdLine.getOptionValue("f").trim());
            }
            catch (Exception e) {
                System.out.println("Invalid file type " + cmdLine.getOptionValue("f").trim() + ".  Expecting RDFXML, JSON, XLS, XLSX, YAML, or TAG");
                System.exit(1);
            }
        }
        try {
            inputFileType = SpdxToolsHelper.fileToFileType((File)fromFile);
        }
        catch (Exception e) {
            System.out.println("Invalid file extension for input file " + fromFile.getName());
            System.exit(1);
        }
        boolean allPackages = cmdLine.hasOption("a");
        try {
            Main.spdxToOsv(fromFile, toFile, inputFileType, allPackages);
            System.exit(0);
        }
        catch (Exception ex) {
            System.err.println("Error converting SPDX file to OSV.");
            if (Objects.nonNull(ex.getMessage())) {
                System.err.println(ex.getMessage());
            }
            if (Objects.nonNull(ex.getCause())) {
                System.err.println(ex.getCause());
            }
            Main.usage(options);
            System.exit(1);
        }
    }

    private static Options createOptions() {
        Options retval = new Options();
        retval.addOption(Option.builder((String)"I").longOpt("input").desc("Input SPDX file in one of the supported formats (json, yaml, tag/value, xls, xlsx, rdf/xml)").hasArg(true).required(true).build());
        retval.addOption(Option.builder((String)"O").longOpt("output").desc("output file name.  File will be in the OSV JSON format").hasArg(true).required(true).build());
        retval.addOption(Option.builder((String)"f").longOpt("inputFormat").desc("Input file format - RDFXML, JSON, XLS, XLSX, YAML, or TAG").hasArg(true).required(false).build());
        retval.addOption(Option.builder((String)"a").longOpt("all").desc("Include vulnerabilities for all packages in the SPDX file. Default is to only include vulnerabilities related to the element described by the document.").hasArg(false).required(false).build());
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void spdxToOsv(File fromFile, File toFile, SpdxToolsHelper.SerFileType inputFileType, boolean allPackages) throws SpdxToOsvException, IOException {
        if (!fromFile.exists()) {
            throw new SpdxToOsvException("Input file " + fromFile.getName() + " does not exist");
        }
        if (toFile.exists()) {
            throw new SpdxToOsvException("Output file " + toFile.getName() + " already exists.");
        }
        InputStream inStream = null;
        OutputStreamWriter writer = null;
        try {
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(toFile), StandardCharsets.UTF_8);
            inStream = new FileInputStream(fromFile);
            Main.spdxToOsv(inStream, inputFileType, (Writer)writer, allPackages);
        }
        finally {
            if (Objects.nonNull(inStream)) {
                inStream.close();
            }
            if (Objects.nonNull(writer)) {
                ((Writer)writer).close();
            }
        }
    }

    public static void spdxToOsv(IModelStore fromStore, String documentUri, Writer writer, boolean allPackages) throws SpdxToOsvException, IOException, InvalidSPDXAnalysisException {
        OsvApi osvApi = OsvApi.getInstance();
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        HashSet<OsvVulnerabilityRequest> pvSet = new HashSet<OsvVulnerabilityRequest>();
        List<SpdxPackage> pkgs = Main.getPackageFromDocument(fromStore, documentUri, allPackages);
        for (SpdxPackage pkg : pkgs) {
            try {
                Optional<OsvVulnerabilityRequest> pnv;
                Optional packageName = pkg.getName();
                Optional version = pkg.getVersionInfo();
                if (packageName.isPresent() && version.isPresent()) {
                    Object pName = (String)packageName.get();
                    pName = ((String)pName).split("@")[0];
                    pvSet.add(new OsvVulnerabilityRequest(new OsvPackage((String)pName, null, null), (String)version.get()));
                }
                for (ExternalRef externalRef : pkg.getExternalRefs()) {
                    try {
                        Optional<OsvVulnerabilityRequest> pnv2 = new ExternalRefParser(externalRef).osvVulnerabilityRequest();
                        if (!pnv2.isPresent()) continue;
                        pvSet.add(pnv2.get());
                    }
                    catch (InvalidExternalRefPattern e) {
                        System.err.println("Warning: Error parsing external ref: " + e.getMessage());
                    }
                    catch (IOException e) {
                        System.err.println("Warning: I/O Error parsing external ref: " + e.getMessage());
                    }
                    catch (SwhException e) {
                        System.err.println("Warning: Software Heritage API error while processing external ref: " + e.getMessage());
                    }
                }
                Optional downloadLocation = pkg.getDownloadLocation();
                if (!downloadLocation.isPresent() || !(pnv = new DownloadLocationParser((String)downloadLocation.get()).getOsvVulnerabilityRequest()).isPresent()) continue;
                OsvVulnerabilityRequest req = pnv.get();
                if (req.getVersion() == null && req.getCommit() == null) {
                    if (version.isPresent()) {
                        req.setVersion((String)version.get());
                    } else {
                        System.err.printf("Warning: Unable to query package %s due to missing version/commit info", req.getPackage().getName());
                        continue;
                    }
                }
                pvSet.add(req);
            }
            catch (InvalidSPDXAnalysisException ex) {
                throw new RuntimeException(ex);
            }
        }
        writer.append('[');
        int numVulns = 0;
        for (OsvVulnerabilityRequest pnv : pvSet) {
            for (OsvVulnerability vulnerability : osvApi.queryVulnerabilities(pnv)) {
                if (numVulns > 0) {
                    writer.append(',');
                    writer.append('\n');
                }
                gson.toJson((Object)vulnerability, (Appendable)writer);
                ++numVulns;
            }
        }
        writer.append(']');
    }

    private static List<SpdxPackage> getPackageFromDocument(IModelStore fromStore, String documentUri, boolean allPackages) throws InvalidSPDXAnalysisException {
        if (allPackages) {
            ArrayList<SpdxPackage> retval = new ArrayList<SpdxPackage>();
            SpdxModelFactory.getElements((IModelStore)fromStore, (String)documentUri, null, SpdxPackage.class).forEach(oPackage -> retval.add((SpdxPackage)oPackage));
            return retval;
        }
        SpdxDocument doc = (SpdxDocument)SpdxModelFactory.getModelObject((IModelStore)fromStore, (String)documentUri, (String)"SPDXRef-DOCUMENT", (String)"SpdxDocument", null, (boolean)false);
        if (Objects.isNull(doc)) {
            throw new InvalidSPDXAnalysisException("Missing document ID");
        }
        HashMap<String, List<Relationship>> fromElementIdRelationshipMap = new HashMap<String, List<Relationship>>();
        HashMap<String, List<SpdxElement>> toElementIdToRelationship = new HashMap<String, List<SpdxElement>>();
        SpdxModelFactory.getElements((IModelStore)fromStore, (String)documentUri, null, SpdxPackage.class).forEach(oPackage -> {
            try {
                Main.addRelevantRelationships((SpdxElement)oPackage, fromElementIdRelationshipMap, toElementIdToRelationship);
            }
            catch (InvalidSPDXAnalysisException e) {
                throw new RuntimeException("Error parsing relationship graph", e);
            }
        });
        SpdxModelFactory.getElements((IModelStore)fromStore, (String)documentUri, null, SpdxFile.class).forEach(oFile -> {
            try {
                Main.addRelevantRelationships((SpdxElement)oFile, fromElementIdRelationshipMap, toElementIdToRelationship);
            }
            catch (InvalidSPDXAnalysisException e) {
                throw new RuntimeException("Error parsing relationship graph", e);
            }
        });
        ArrayList<SpdxPackage> retval = new ArrayList<SpdxPackage>();
        HashSet<String> visitedElementIds = new HashSet<String>();
        for (SpdxElement described : doc.getDocumentDescribes()) {
            if (visitedElementIds.contains(described.getId())) continue;
            Main.collectRelevantPackages(described, retval, fromElementIdRelationshipMap, toElementIdToRelationship, visitedElementIds);
        }
        return retval;
    }

    private static void collectRelevantPackages(SpdxElement element, List<SpdxPackage> relevantPackages, Map<String, List<Relationship>> fromElementIdRelationshipMap, Map<String, List<SpdxElement>> toElementIdToRelationship, Set<String> visitedElementIds) throws InvalidSPDXAnalysisException {
        String id = element.getId();
        if (visitedElementIds.contains(id)) {
            return;
        }
        visitedElementIds.add(id);
        if (element instanceof SpdxPackage) {
            relevantPackages.add((SpdxPackage)element);
        }
        if (fromElementIdRelationshipMap.containsKey(id)) {
            for (Relationship relationship : fromElementIdRelationshipMap.get(id)) {
                if (!relationship.getRelatedSpdxElement().isPresent()) continue;
                Main.collectRelevantPackages((SpdxElement)relationship.getRelatedSpdxElement().get(), relevantPackages, fromElementIdRelationshipMap, toElementIdToRelationship, visitedElementIds);
            }
        }
        if (toElementIdToRelationship.containsKey(id)) {
            for (SpdxElement relatedElement : toElementIdToRelationship.get(id)) {
                Main.collectRelevantPackages(relatedElement, relevantPackages, fromElementIdRelationshipMap, toElementIdToRelationship, visitedElementIds);
            }
        }
    }

    private static void addRelevantRelationships(SpdxElement element, Map<String, List<Relationship>> fromElementIdRelationshipMap, Map<String, List<SpdxElement>> toElementIdRelationshipMap) throws InvalidSPDXAnalysisException {
        ArrayList<Relationship> elementRelationships = new ArrayList<Relationship>();
        fromElementIdRelationshipMap.put(element.getId(), elementRelationships);
        for (Relationship relationship : element.getRelationships()) {
            if (RELEVANT_RELATIONSHIPS.contains(relationship.getRelationshipType())) {
                elementRelationships.add(relationship);
            }
            if (!RELEVANT_REVERSE_RELATIONSHIPS.contains(relationship.getRelationshipType()) || !relationship.getRelatedSpdxElement().isPresent()) continue;
            List<SpdxElement> reverseRelationships = toElementIdRelationshipMap.get(((SpdxElement)relationship.getRelatedSpdxElement().get()).getId());
            if (Objects.isNull(reverseRelationships)) {
                reverseRelationships = new ArrayList<SpdxElement>();
                toElementIdRelationshipMap.put(((SpdxElement)relationship.getRelatedSpdxElement().get()).getId(), reverseRelationships);
            }
            reverseRelationships.add(element);
        }
    }

    public static void spdxToOsv(InputStream inStream, SpdxToolsHelper.SerFileType inputFileType, Writer writer, boolean allPackages) throws SpdxToOsvException {
        try {
            ISerializableModelStore fromStore = SpdxToolsHelper.fileTypeToStore((SpdxToolsHelper.SerFileType)inputFileType);
            String documentUri = fromStore.deSerialize(inStream, false);
            Main.spdxToOsv((IModelStore)fromStore, documentUri, writer, allPackages);
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new SpdxToOsvException("Error reading the SPDX input file", e);
        }
        catch (IOException e) {
            throw new SpdxToOsvException("I/O error converting SPDX to OSV", e);
        }
    }

    private static void usage(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("spdx-to-osv", options);
    }

    static {
        RELEVANT_RELATIONSHIPS.add(RelationshipType.CONTAINS);
        RELEVANT_RELATIONSHIPS.add(RelationshipType.COPY_OF);
        RELEVANT_RELATIONSHIPS.add(RelationshipType.DYNAMIC_LINK);
        RELEVANT_RELATIONSHIPS.add(RelationshipType.EXPANDED_FROM_ARCHIVE);
        RELEVANT_RELATIONSHIPS.add(RelationshipType.FILE_ADDED);
        RELEVANT_RELATIONSHIPS.add(RelationshipType.GENERATED_FROM);
        RELEVANT_RELATIONSHIPS.add(RelationshipType.GENERATED_FROM);
        RELEVANT_RELATIONSHIPS.add(RelationshipType.PACKAGE_OF);
        RELEVANT_RELATIONSHIPS.add(RelationshipType.PATCH_FOR);
        RELEVANT_RELATIONSHIPS.add(RelationshipType.STATIC_LINK);
        RELEVANT_RELATIONSHIPS.add(RelationshipType.HAS_PREREQUISITE);
        RELEVANT_RELATIONSHIPS.add(RelationshipType.VARIANT_OF);
        RELEVANT_RELATIONSHIPS.add(RelationshipType.DEPENDS_ON);
        RELEVANT_REVERSE_RELATIONSHIPS.add(RelationshipType.CONTAINED_BY);
        RELEVANT_REVERSE_RELATIONSHIPS.add(RelationshipType.COPY_OF);
        RELEVANT_REVERSE_RELATIONSHIPS.add(RelationshipType.DISTRIBUTION_ARTIFACT);
        RELEVANT_REVERSE_RELATIONSHIPS.add(RelationshipType.GENERATES);
        RELEVANT_REVERSE_RELATIONSHIPS.add(RelationshipType.OPTIONAL_COMPONENT_OF);
        RELEVANT_REVERSE_RELATIONSHIPS.add(RelationshipType.PACKAGE_OF);
        RELEVANT_REVERSE_RELATIONSHIPS.add(RelationshipType.PATCH_APPLIED);
        RELEVANT_REVERSE_RELATIONSHIPS.add(RelationshipType.PREREQUISITE_FOR);
        RELEVANT_REVERSE_RELATIONSHIPS.add(RelationshipType.VARIANT_OF);
        RELEVANT_REVERSE_RELATIONSHIPS.add(RelationshipType.DEPENDENCY_OF);
        RELEVANT_REVERSE_RELATIONSHIPS.add(RelationshipType.OPTIONAL_DEPENDENCY_OF);
        RELEVANT_REVERSE_RELATIONSHIPS.add(RelationshipType.RUNTIME_DEPENDENCY_OF);
        NON_RELEVANT_RELATIONSHIPS.add(RelationshipType.DESCRIBES);
        NON_RELEVANT_RELATIONSHIPS.add(RelationshipType.DESCRIBED_BY);
        NON_RELEVANT_RELATIONSHIPS.add(RelationshipType.ANCESTOR_OF);
        NON_RELEVANT_RELATIONSHIPS.add(RelationshipType.BUILD_TOOL_OF);
        NON_RELEVANT_RELATIONSHIPS.add(RelationshipType.DATA_FILE_OF);
        NON_RELEVANT_RELATIONSHIPS.add(RelationshipType.DESCENDANT_OF);
        NON_RELEVANT_RELATIONSHIPS.add(RelationshipType.DOCUMENTATION_OF);
        NON_RELEVANT_RELATIONSHIPS.add(RelationshipType.FILE_DELETED);
        NON_RELEVANT_RELATIONSHIPS.add(RelationshipType.FILE_MODIFIED);
        NON_RELEVANT_RELATIONSHIPS.add(RelationshipType.METAFILE_OF);
        NON_RELEVANT_RELATIONSHIPS.add(RelationshipType.OTHER);
        NON_RELEVANT_RELATIONSHIPS.add(RelationshipType.AMENDS);
        NON_RELEVANT_RELATIONSHIPS.add(RelationshipType.TEST_CASE_OF);
        NON_RELEVANT_RELATIONSHIPS.add(RelationshipType.MISSING);
        NON_RELEVANT_RELATIONSHIPS.add(RelationshipType.BUILD_DEPENDENCY_OF);
        NON_RELEVANT_RELATIONSHIPS.add(RelationshipType.DEPENDENCY_MANIFEST_OF);
        NON_RELEVANT_RELATIONSHIPS.add(RelationshipType.DEV_DEPENDENCY_OF);
        NON_RELEVANT_RELATIONSHIPS.add(RelationshipType.DEV_TOOL_OF);
        NON_RELEVANT_RELATIONSHIPS.add(RelationshipType.EXAMPLE_OF);
        NON_RELEVANT_RELATIONSHIPS.add(RelationshipType.PROVIDED_DEPENDENCY_OF);
        NON_RELEVANT_RELATIONSHIPS.add(RelationshipType.TEST_DEPENDENCY_OF);
        NON_RELEVANT_RELATIONSHIPS.add(RelationshipType.TEST_OF);
        NON_RELEVANT_RELATIONSHIPS.add(RelationshipType.TEST_TOOL_OF);
    }
}

