/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.spdx_to_osv;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.spdx.spdx_to_osv.SpdxToOsvException;
import org.spdx.spdx_to_osv.osvmodel.OsvErrorResponse;
import org.spdx.spdx_to_osv.osvmodel.OsvVulnerability;
import org.spdx.spdx_to_osv.osvmodel.OsvVulnerabilityRequest;
import org.spdx.spdx_to_osv.osvmodel.OsvVulnerabilityResponse;

public class OsvApi {
    private static OsvApi _instance;
    protected static String API_URL_STRING;
    protected URL apiUrl;
    static final Gson GSON;

    private OsvApi() {
        try {
            this.apiUrl = new URL(API_URL_STRING);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public static synchronized OsvApi getInstance() {
        if (Objects.isNull(_instance)) {
            _instance = new OsvApi();
        }
        return _instance;
    }

    public List<OsvVulnerability> queryVulnerabilities(OsvVulnerabilityRequest packageNameVersion) throws IOException, SpdxToOsvException {
        HttpURLConnection con = (HttpURLConnection)this.apiUrl.openConnection();
        String pkgNameVersionJson = GSON.toJson((Object)packageNameVersion);
        byte[] json = pkgNameVersionJson.getBytes(StandardCharsets.UTF_8);
        int len = json.length;
        con.setRequestMethod("POST");
        con.setFixedLengthStreamingMode(len);
        con.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
        con.setRequestProperty("Accept", "application/json");
        con.setDoOutput(true);
        con.connect();
        try {
            Object responseJson;
            String response;
            ArrayList<OsvVulnerability> sb;
            try (OutputStream out = con.getOutputStream();){
                if (Objects.nonNull(out)) {
                    out.write(json);
                }
            }
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(con.getInputStream(), StandardCharsets.UTF_8));){
                sb = new StringBuilder();
                String line = null;
                while ((line = reader.readLine()) != null) {
                    ((StringBuilder)((Object)sb)).append(line);
                }
                response = ((StringBuilder)((Object)sb)).toString();
            }
            if (con.getResponseCode() == 200) {
                responseJson = (OsvVulnerabilityResponse)GSON.fromJson(response, OsvVulnerabilityResponse.class);
                if (Objects.nonNull(((OsvVulnerabilityResponse)responseJson).getVulns())) {
                    sb = ((OsvVulnerabilityResponse)responseJson).getVulns();
                    return sb;
                }
                sb = new ArrayList<OsvVulnerability>();
                return sb;
            }
            responseJson = (OsvErrorResponse)GSON.fromJson(response, OsvErrorResponse.class);
            String msg = "Error getting vulnerability data";
            if (Objects.nonNull(responseJson) && Objects.nonNull(((OsvErrorResponse)responseJson).getMessage()) && !((OsvErrorResponse)responseJson).getMessage().isEmpty()) {
                msg = msg + ((OsvErrorResponse)responseJson).getMessage();
            }
            throw new SpdxToOsvException(msg);
        }
        finally {
            con.disconnect();
        }
    }

    static {
        API_URL_STRING = "https://api.osv.dev/v1/query";
        GSON = new GsonBuilder().setPrettyPrinting().create();
    }
}

