/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.spdx_to_osv;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.spdx.spdx_to_osv.SwhApiException;
import org.spdx.spdx_to_osv.SwhException;
import org.spdx.spdx_to_osv.SwhRelease;
import org.spdx.spdx_to_osv.SwhResourceNotFoundException;

public class SwhApi {
    private static SwhApi _instance;
    static final Gson GSON;
    public static final String ENDPOINT = "https://archive.softwareheritage.org/api/1/";
    public static final String RELEASE_ENDPOINT = "https://archive.softwareheritage.org/api/1/release/";

    private SwhApi() {
    }

    public static synchronized SwhApi getInstance() {
        if (Objects.isNull(_instance)) {
            _instance = new SwhApi();
        }
        return _instance;
    }

    public SwhRelease getSwhRelease(String releaseSha1) throws IOException, SwhException {
        try {
            URL url = new URL(RELEASE_ENDPOINT + releaseSha1 + "/");
            return (SwhRelease)GSON.fromJson(this.getResponseString(url), SwhRelease.class);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Malformed URL when getting Software Heritage Release", e);
        }
    }

    private String getResponseString(URL url) throws IOException, SwhException {
        HttpURLConnection con = (HttpURLConnection)url.openConnection();
        con.setRequestMethod("GET");
        con.setRequestProperty("Accept", "application/json");
        con.connect();
        try {
            String response;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(con.getInputStream(), StandardCharsets.UTF_8));){
                StringBuilder sb = new StringBuilder();
                String line = null;
                while ((line = reader.readLine()) != null) {
                    sb.append(line);
                }
                response = sb.toString();
            }
            if (con.getResponseCode() == 200) {
                String string = response;
                return string;
            }
            if (con.getResponseCode() == 404) {
                throw new SwhResourceNotFoundException("Resource not found for URL " + url);
            }
            throw new SwhApiException("Unexpected response code from SwhApi: " + con.getResponseCode());
        }
        finally {
            con.disconnect();
        }
    }

    static {
        GSON = new GsonBuilder().setPrettyPrinting().create();
    }
}

