/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.spdx_to_osv.osvmodel;

import java.util.Objects;
import javax.annotation.Nullable;

public class OsvPackage {
    private String name;
    private String ecosystem;
    private String purl;

    public OsvPackage() {
    }

    public OsvPackage(String name, String ecosystem, @Nullable String purl) {
        Objects.requireNonNull(name, "Package name can not be null");
        this.name = name;
        this.ecosystem = ecosystem;
        this.purl = purl;
    }

    public OsvPackage(String name) {
        this(name, "OSS-Fuzz", null);
    }

    public int hashCode() {
        if (Objects.nonNull(this.purl)) {
            return this.purl.hashCode();
        }
        return this.name.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof OsvPackage)) {
            return false;
        }
        OsvPackage compare = (OsvPackage)o;
        return Objects.equals(this.name, compare.getName()) && Objects.equals(this.purl, compare.getPurl());
    }

    public String getName() {
        return this.name;
    }

    public String getEcosystem() {
        return this.ecosystem;
    }

    @Nullable
    public String getPurl() {
        return this.purl;
    }
}

