/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.spdx_to_osv.osvmodel;

import com.google.gson.annotations.SerializedName;
import java.util.Objects;
import org.spdx.spdx_to_osv.osvmodel.OsvPackage;

public class OsvVulnerabilityRequest {
    @SerializedName(value="package")
    private OsvPackage osvPackage;
    private String version;
    private String commit;

    public OsvVulnerabilityRequest(OsvPackage osvPackage, String version) {
        Objects.requireNonNull(osvPackage, "Package can not be null");
        this.osvPackage = osvPackage;
        this.version = version;
        this.commit = null;
    }

    public OsvVulnerabilityRequest(String commit) {
        Objects.requireNonNull(commit, "Commit can not be null");
        this.commit = commit;
        this.osvPackage = null;
        this.version = null;
    }

    public OsvPackage getPackage() {
        return this.osvPackage;
    }

    public void setPackage(OsvPackage osvPackage) {
        this.osvPackage = osvPackage;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getCommit() {
        return this.commit;
    }

    public void setCommit(String commit) {
        this.commit = commit;
    }

    public int hashCode() {
        int retval = 101;
        if (Objects.nonNull(this.osvPackage)) {
            retval ^= this.osvPackage.hashCode();
        }
        if (Objects.nonNull(this.version)) {
            retval ^= this.version.hashCode();
        }
        if (Objects.nonNull(this.commit)) {
            retval ^= this.commit.hashCode();
        }
        return retval;
    }

    public boolean equals(Object o) {
        if (!(o instanceof OsvVulnerabilityRequest)) {
            return false;
        }
        OsvVulnerabilityRequest compare = (OsvVulnerabilityRequest)o;
        return Objects.equals(this.osvPackage, compare.getPackage()) && Objects.equals(this.version, compare.getVersion()) && Objects.equals(this.commit, compare.getCommit());
    }
}

