/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.compare;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.spdx.compare.LicenseCompareHelper;
import org.spdx.licenseTemplate.ILicenseTemplateOutputHandler;
import org.spdx.licenseTemplate.LicenseTemplateRule;

public class CompareTemplateOutputHandler
implements ILicenseTemplateOutputHandler {
    String compareText = "";
    boolean differenceFound = false;
    String[] compareTokens = new String[0];
    int compareTokenCounter = 0;
    String nextCompareToken = null;
    String differenceExplanation = "No difference found";
    StringBuilder optionalText = new StringBuilder();

    public CompareTemplateOutputHandler(String compareText) {
        this.compareText = compareText;
        this.compareTokens = this.compareText.split("\\s");
        this.compareTokenCounter = 0;
        this.nextCompareToken = LicenseCompareHelper.getTokenAt(this.compareTokens, this.compareTokenCounter++);
    }

    @Override
    public void optionalText(String text) {
        this.optionalText.append(' ');
        this.optionalText.append(text);
    }

    protected boolean textEquivalent(String text) {
        String[] textTokens = text.split("\\s");
        int textTokenCounter = 0;
        String nextTextToken = LicenseCompareHelper.getTokenAt(textTokens, textTokenCounter++);
        while (nextTextToken != null) {
            if (this.nextCompareToken == null) {
                while (nextTextToken != null && LicenseCompareHelper.canSkip(nextTextToken)) {
                    nextTextToken = LicenseCompareHelper.getTokenAt(textTokens, textTokenCounter++);
                }
                if (nextTextToken == null) continue;
                return false;
            }
            if (LicenseCompareHelper.tokensEquivalent(nextTextToken, this.nextCompareToken)) {
                nextTextToken = LicenseCompareHelper.getTokenAt(textTokens, textTokenCounter++);
                this.nextCompareToken = LicenseCompareHelper.getTokenAt(this.compareTokens, this.compareTokenCounter++);
                continue;
            }
            while (this.nextCompareToken != null && LicenseCompareHelper.canSkip(this.nextCompareToken)) {
                this.nextCompareToken = LicenseCompareHelper.getTokenAt(this.compareTokens, this.compareTokenCounter++);
            }
            while (nextTextToken != null && LicenseCompareHelper.canSkip(nextTextToken)) {
                nextTextToken = LicenseCompareHelper.getTokenAt(textTokens, textTokenCounter++);
            }
            if (!LicenseCompareHelper.tokensEquivalent(this.nextCompareToken, nextTextToken)) {
                return false;
            }
            nextTextToken = LicenseCompareHelper.getTokenAt(textTokens, textTokenCounter++);
            this.nextCompareToken = LicenseCompareHelper.getTokenAt(this.compareTokens, this.compareTokenCounter++);
        }
        return true;
    }

    @Override
    public void normalText(String text) {
        if (this.differenceFound) {
            return;
        }
        if (!this.textEquivalent(text)) {
            this.differenceFound = true;
            this.differenceExplanation = this.nextCompareToken == null ? "End of compare text encountered before the end of the license template" : "Difference found starting at token #" + String.valueOf(this.compareTokenCounter) + "\"" + this.nextCompareToken + "\".";
        }
    }

    @Override
    public void variableRule(LicenseTemplateRule rule) {
        if (this.differenceFound) {
            return;
        }
        String remainingText = this.buildRemainingCompareText();
        Pattern matchPattern = Pattern.compile(rule.getMatch());
        Matcher matcher = matchPattern.matcher(remainingText);
        if (!matcher.find()) {
            this.differenceFound = true;
            this.differenceExplanation = "Variable text rule " + rule.getName() + " did not match the compare text starting at token #" + String.valueOf(this.compareTokenCounter) + "\"" + this.nextCompareToken + "\".";
        } else if (matcher.start() > 0) {
            this.differenceFound = true;
            this.differenceExplanation = "Extra text \"" + remainingText.substring(0, matcher.start()) + "\" found before the variable text rule " + rule.getName() + " starting at token #" + String.valueOf(this.compareTokenCounter) + "\"" + this.nextCompareToken + "\".";
        } else {
            String textAfterMatch = remainingText.substring(matcher.end()).trim();
            if (textAfterMatch.trim().isEmpty()) {
                this.nextCompareToken = null;
                this.compareTokenCounter = this.compareTokens.length;
            } else {
                String[] tokensAfterMatch = textAfterMatch.split("\\s");
                this.compareTokenCounter = this.compareTokens.length - tokensAfterMatch.length;
                this.nextCompareToken = this.compareTokens[this.compareTokenCounter++];
                if (!this.nextCompareToken.equals(tokensAfterMatch[0]) && tokensAfterMatch.length > 1 && !this.nextCompareToken.equals(tokensAfterMatch[1])) {
                    this.nextCompareToken = this.compareTokens[this.compareTokenCounter++];
                    if (!this.nextCompareToken.equals(tokensAfterMatch[0]) && tokensAfterMatch.length > 1 && !this.nextCompareToken.equals(tokensAfterMatch[1])) {
                        this.differenceFound = true;
                        this.differenceExplanation = "Missmatched text found after end of variable rule" + rule.getName();
                    }
                }
            }
        }
    }

    private String buildRemainingCompareText() {
        StringBuilder sb = new StringBuilder();
        if (this.nextCompareToken != null) {
            sb.append(this.nextCompareToken);
            for (int i = this.compareTokenCounter; i < this.compareTokens.length; ++i) {
                sb.append(' ');
                sb.append(this.compareTokens[i]);
            }
        }
        return sb.toString();
    }

    @Override
    public void beginOptional(LicenseTemplateRule rule) {
        if (this.differenceFound) {
            return;
        }
        this.optionalText.setLength(0);
    }

    @Override
    public void endOptional(LicenseTemplateRule rule) {
        if (this.differenceFound) {
            return;
        }
        String saveNextComparisonToken = this.nextCompareToken;
        int saveCompareTokenCounter = this.compareTokenCounter;
        String saveDifferenceExplanation = this.differenceExplanation;
        if (!this.textEquivalent(this.optionalText.toString())) {
            this.nextCompareToken = saveNextComparisonToken;
            this.compareTokenCounter = saveCompareTokenCounter;
            this.differenceExplanation = saveDifferenceExplanation;
        }
    }

    public boolean matches() {
        return !this.differenceFound;
    }
}

