/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.compare;

import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.spdx.compare.SpdxCompareException;
import org.spdx.compare.SpdxComparer;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.spdxspreadsheet.AbstractSheet;

public class DocumentSheet
extends AbstractSheet {
    int NUM_COLS = 7;
    int DOCUMENT_NAME_COL = 0;
    int SPDX_VERSION_COL = this.DOCUMENT_NAME_COL + 1;
    int DATA_LICENSE_COL = this.SPDX_VERSION_COL + 1;
    int DOCUMENT_COMMENT_COL = this.DATA_LICENSE_COL + 1;
    int CREATION_DATE_COL = this.DOCUMENT_COMMENT_COL + 1;
    int CREATOR_COMMENT_COL = this.CREATION_DATE_COL + 1;
    int LICENSE_LIST_VERSION_COL = this.CREATOR_COMMENT_COL + 1;
    static final boolean[] REQUIRED = new boolean[]{true, true, true, false, true, false, false};
    static final String[] HEADER_TITLES = new String[]{"Document Name", "SPDX Version", "Data License", "Document Comment", "Creation Date", "Creator Comment", "Lic. List. Ver."};
    static final int[] COLUMN_WIDTHS = new int[]{35, 15, 15, 60, 22, 60, 22};
    private static final String DIFFERENT_STRING = "Diff";
    private static final String EQUAL_STRING = "Equals";

    public DocumentSheet(Workbook workbook, String sheetName) {
        super(workbook, sheetName);
    }

    @Override
    public String verify() {
        try {
            if (this.sheet == null) {
                return "Worksheet for SPDX Package Info does not exist";
            }
            Row firstRow = this.sheet.getRow(this.firstRowNum);
            for (int i = 0; i < this.NUM_COLS; ++i) {
                Cell cell = firstRow.getCell(i + this.firstCellNum);
                if (cell != null && cell.getStringCellValue() != null && cell.getStringCellValue().equals(HEADER_TITLES[i])) continue;
                return "Column " + HEADER_TITLES[i] + " missing for SPDX Package Info worksheet";
            }
            return null;
        }
        catch (Exception ex) {
            return "Error in verifying SPDX Package Info work sheet: " + ex.getMessage();
        }
    }

    public static void create(Workbook wb, String sheetName) {
        int sheetNum = wb.getSheetIndex(sheetName);
        if (sheetNum >= 0) {
            wb.removeSheetAt(sheetNum);
        }
        Sheet sheet = wb.createSheet(sheetName);
        CellStyle headerStyle = AbstractSheet.createHeaderStyle(wb);
        CellStyle defaultStyle = AbstractSheet.createLeftWrapStyle(wb);
        Row row = sheet.createRow(0);
        for (int i = 0; i < HEADER_TITLES.length; ++i) {
            sheet.setColumnWidth(i, COLUMN_WIDTHS[i] * 256);
            sheet.setDefaultColumnStyle(i, defaultStyle);
            Cell cell = row.createCell(i);
            cell.setCellStyle(headerStyle);
            cell.setCellValue(HEADER_TITLES[i]);
        }
    }

    public void importCompareResults(SpdxComparer comparer, String[] docNames) throws SpdxCompareException, InvalidSPDXAnalysisException {
        if (comparer.getNumSpdxDocs() != docNames.length) {
            throw new SpdxCompareException("Number of document names does not match the number of SPDX documents");
        }
        this.clear();
        for (int i = 0; i < docNames.length + 1; ++i) {
            this.addRow();
        }
        this.importDocumentNames(docNames);
        this.importSpdxVersion(comparer);
        this.importDataLicense(comparer);
        this.importDocumentComments(comparer);
        this.importCreationDate(comparer);
        this.importCreatorComment(comparer);
        this.importLicenseListVersions(comparer);
    }

    private void importLicenseListVersions(SpdxComparer comparer) throws SpdxCompareException, InvalidSPDXAnalysisException {
        Cell cell = this.sheet.getRow(this.getFirstDataRow()).createCell(this.LICENSE_LIST_VERSION_COL);
        if (comparer.isLicenseListVersionEqual()) {
            this.setCellEqualValue(cell);
        } else {
            this.setCellDifferentValue(cell);
        }
        for (int i = 0; i < comparer.getNumSpdxDocs(); ++i) {
            cell = this.sheet.getRow(this.getFirstDataRow() + i + 1).createCell(this.LICENSE_LIST_VERSION_COL);
            if (comparer.getSpdxDoc(i).getCreatorInfo().getLicenseListVersion() == null) continue;
            cell.setCellValue(comparer.getSpdxDoc(i).getCreatorInfo().getLicenseListVersion());
        }
    }

    private void importSpdxVersion(SpdxComparer comparer) throws SpdxCompareException, InvalidSPDXAnalysisException {
        Cell cell = this.sheet.getRow(this.getFirstDataRow()).createCell(this.SPDX_VERSION_COL);
        if (comparer.isSpdxVersionEqual()) {
            this.setCellEqualValue(cell);
        } else {
            this.setCellDifferentValue(cell);
        }
        for (int i = 0; i < comparer.getNumSpdxDocs(); ++i) {
            cell = this.sheet.getRow(this.getFirstDataRow() + i + 1).createCell(this.SPDX_VERSION_COL);
            if (comparer.getSpdxDoc(i).getSpdxVersion() == null) continue;
            cell.setCellValue(comparer.getSpdxDoc(i).getSpdxVersion());
        }
    }

    private void importDataLicense(SpdxComparer comparer) throws SpdxCompareException, InvalidSPDXAnalysisException {
        Cell cell = this.sheet.getRow(this.getFirstDataRow()).createCell(this.DATA_LICENSE_COL);
        if (comparer.isDataLicenseEqual()) {
            this.setCellEqualValue(cell);
        } else {
            this.setCellDifferentValue(cell);
        }
        for (int i = 0; i < comparer.getNumSpdxDocs(); ++i) {
            cell = this.sheet.getRow(this.getFirstDataRow() + i + 1).createCell(this.DATA_LICENSE_COL);
            if (comparer.getSpdxDoc(i).getDataLicense() == null) continue;
            cell.setCellValue(comparer.getSpdxDoc(i).getDataLicense().toString());
        }
    }

    private void importDocumentComments(SpdxComparer comparer) throws SpdxCompareException, InvalidSPDXAnalysisException {
        Cell cell = this.sheet.getRow(this.getFirstDataRow()).createCell(this.DOCUMENT_COMMENT_COL);
        if (comparer.isDocumentCommentsEqual()) {
            this.setCellEqualValue(cell);
        } else {
            this.setCellDifferentValue(cell);
        }
        for (int i = 0; i < comparer.getNumSpdxDocs(); ++i) {
            cell = this.sheet.getRow(this.getFirstDataRow() + i + 1).createCell(this.DOCUMENT_COMMENT_COL);
            if (comparer.getSpdxDoc(i).getDocumentComment() == null) continue;
            cell.setCellValue(comparer.getSpdxDoc(i).getDocumentComment());
        }
    }

    private void importCreatorComment(SpdxComparer comparer) throws InvalidSPDXAnalysisException, SpdxCompareException {
        Cell cell = this.sheet.getRow(this.getFirstDataRow()).createCell(this.CREATOR_COMMENT_COL);
        if (comparer.isCreatorInformationEqual()) {
            this.setCellEqualValue(cell);
        } else {
            this.setCellDifferentValue(cell);
        }
        for (int i = 0; i < comparer.getNumSpdxDocs(); ++i) {
            cell = this.sheet.getRow(this.getFirstDataRow() + i + 1).createCell(this.CREATOR_COMMENT_COL);
            cell.setCellValue(comparer.getSpdxDoc(i).getCreatorInfo().getComment());
        }
    }

    private void importCreationDate(SpdxComparer comparer) throws InvalidSPDXAnalysisException, SpdxCompareException {
        Cell cell = this.sheet.getRow(this.getFirstDataRow()).createCell(this.CREATION_DATE_COL);
        if (comparer.isCreatorInformationEqual()) {
            this.setCellEqualValue(cell);
        } else {
            this.setCellDifferentValue(cell);
        }
        for (int i = 0; i < comparer.getNumSpdxDocs(); ++i) {
            cell = this.sheet.getRow(this.getFirstDataRow() + i + 1).createCell(this.CREATION_DATE_COL);
            cell.setCellValue(comparer.getSpdxDoc(i).getCreatorInfo().getCreated());
        }
    }

    private void setCellDifferentValue(Cell cell) {
        cell.setCellValue(DIFFERENT_STRING);
        cell.setCellStyle(this.yellowWrapped);
    }

    private void setCellEqualValue(Cell cell) {
        cell.setCellValue(EQUAL_STRING);
        cell.setCellStyle(this.greenWrapped);
    }

    private void importDocumentNames(String[] docNames) {
        Cell cell = this.sheet.getRow(this.getFirstDataRow()).createCell(this.DOCUMENT_NAME_COL);
        cell.setCellValue("Compare Results");
        for (int i = 0; i < docNames.length; ++i) {
            cell = this.sheet.getRow(this.getFirstDataRow() + i + 1).createCell(this.DOCUMENT_NAME_COL);
            cell.setCellValue(docNames[i]);
        }
    }
}

