/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.compare;

import java.util.Arrays;
import java.util.Comparator;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.spdx.compare.LicenseCompareHelper;
import org.spdx.compare.SpdxCompareException;
import org.spdx.compare.SpdxComparer;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.SPDXLicenseInfo;
import org.spdx.rdfparser.SPDXNonStandardLicense;
import org.spdx.spdxspreadsheet.AbstractSheet;

public class ExtractedLicenseSheet
extends AbstractSheet {
    ExtractedLicenseComparator extractedLicenseComparator = new ExtractedLicenseComparator();
    private static final int EXTRACTED_TEXT_COL = 0;
    private static final int EXTRACTED_TEXT_WIDTH = 100;
    private static final String EXTRACTED_TEXT_TITLE = "Extracted License Text";
    private static final int LIC_ID_COL_WIDTH = 20;
    private static final int FIRST_LIC_ID_COL = 1;

    public ExtractedLicenseSheet(Workbook workbook, String sheetName) {
        super(workbook, sheetName);
    }

    @Override
    public String verify() {
        return null;
    }

    public static void create(Workbook wb, String sheetName) {
        int sheetNum = wb.getSheetIndex(sheetName);
        if (sheetNum >= 0) {
            wb.removeSheetAt(sheetNum);
        }
        Sheet sheet = wb.createSheet(sheetName);
        CellStyle headerStyle = AbstractSheet.createHeaderStyle(wb);
        CellStyle defaultStyle = AbstractSheet.createLeftWrapStyle(wb);
        Row row = sheet.createRow(0);
        sheet.setColumnWidth(0, 25600);
        sheet.setDefaultColumnStyle(0, defaultStyle);
        Cell extractedHeaderCell = row.createCell(0);
        extractedHeaderCell.setCellStyle(headerStyle);
        extractedHeaderCell.setCellValue(EXTRACTED_TEXT_TITLE);
        for (int i = 1; i < 25; ++i) {
            sheet.setColumnWidth(i, 5120);
            sheet.setDefaultColumnStyle(i, defaultStyle);
            Cell cell = row.createCell(i);
            cell.setCellStyle(headerStyle);
        }
    }

    public void importCompareResults(SpdxComparer comparer, String[] docNames) throws SpdxCompareException, InvalidSPDXAnalysisException {
        if (comparer.getNumSpdxDocs() != docNames.length) {
            throw new SpdxCompareException("Number of document names does not match the number of SPDX documents");
        }
        this.clear();
        Row header = this.sheet.getRow(0);
        int[] licenseIndexes = new int[comparer.getNumSpdxDocs()];
        SPDXLicenseInfo[][] extractedLicenses = new SPDXLicenseInfo[comparer.getNumSpdxDocs()][];
        for (int i = 0; i < extractedLicenses.length; ++i) {
            Cell headerCell = header.getCell(1 + i);
            headerCell.setCellValue(docNames[i]);
            SPDXNonStandardLicense[] docExtractedLicenses = comparer.getSpdxDoc(i).getExtractedLicenseInfos();
            Arrays.sort(docExtractedLicenses, this.extractedLicenseComparator);
            extractedLicenses[i] = docExtractedLicenses;
            licenseIndexes[i] = 0;
        }
        while (!this.allLicensesExhausted(extractedLicenses, licenseIndexes)) {
            Row currentRow = this.addRow();
            String extractedLicenseText = this.getNextExtractedLicenseText(extractedLicenses, licenseIndexes);
            Cell licenseTextCell = currentRow.createCell(0);
            licenseTextCell.setCellValue(extractedLicenseText);
            for (int i = 0; i < extractedLicenses.length; ++i) {
                if (extractedLicenses[i].length <= licenseIndexes[i]) continue;
                if (extractedLicenses[i][licenseIndexes[i]] instanceof SPDXNonStandardLicense) {
                    String compareExtractedText = ((SPDXNonStandardLicense)extractedLicenses[i][licenseIndexes[i]]).getText();
                    if (!LicenseCompareHelper.isLicenseTextEquivalent(extractedLicenseText, compareExtractedText)) continue;
                    Cell licenseIdCell = currentRow.createCell(1 + i);
                    licenseIdCell.setCellValue(this.formatLicenseInfo((SPDXNonStandardLicense)extractedLicenses[i][licenseIndexes[i]]));
                    int n = i;
                    licenseIndexes[n] = licenseIndexes[n] + 1;
                    continue;
                }
                int n = i;
                licenseIndexes[n] = licenseIndexes[n] + 1;
            }
        }
    }

    private String formatLicenseInfo(SPDXNonStandardLicense license) {
        StringBuilder sb = new StringBuilder(license.getId());
        if (license.getLicenseName() != null && !license.getLicenseName().isEmpty()) {
            sb.append("[");
            sb.append(license.getLicenseName());
            sb.append("]");
        }
        if (license.getSourceUrls() != null && license.getSourceUrls().length > 0) {
            sb.append("{");
            sb.append(license.getSourceUrls()[0]);
            for (int i = 1; i < license.getSourceUrls().length; ++i) {
                sb.append(", ");
                sb.append(license.getSourceUrls()[i]);
            }
            sb.append("}");
        }
        if (license.getComment() != null && !license.getComment().isEmpty()) {
            sb.append("(");
            sb.append(license.getComment());
            sb.append(")");
        }
        return sb.toString();
    }

    private String getNextExtractedLicenseText(SPDXLicenseInfo[][] licenseInfos, int[] licenseIndexes) {
        String retval = null;
        for (int i = 0; i < licenseInfos.length; ++i) {
            if (licenseInfos[i].length <= licenseIndexes[i]) continue;
            SPDXLicenseInfo licenseInfo = licenseInfos[i][licenseIndexes[i]];
            String extractedText = "";
            if (licenseInfo instanceof SPDXNonStandardLicense) {
                extractedText = ((SPDXNonStandardLicense)licenseInfo).getText();
            }
            if (retval != null && retval.compareTo(extractedText) <= 0) continue;
            retval = extractedText;
        }
        return retval;
    }

    private boolean allLicensesExhausted(SPDXLicenseInfo[][] licenseInfos, int[] licenseIndexes) {
        for (int i = 0; i < licenseInfos.length; ++i) {
            if (licenseIndexes[i] >= licenseInfos[i].length) continue;
            return false;
        }
        return true;
    }

    class ExtractedLicenseComparator
    implements Comparator<SPDXLicenseInfo> {
        ExtractedLicenseComparator() {
        }

        @Override
        public int compare(SPDXLicenseInfo o1, SPDXLicenseInfo o2) {
            if (o1 instanceof SPDXNonStandardLicense) {
                if (o2 instanceof SPDXNonStandardLicense) {
                    SPDXNonStandardLicense l1 = (SPDXNonStandardLicense)o1;
                    SPDXNonStandardLicense l2 = (SPDXNonStandardLicense)o2;
                    return l1.getText().compareTo(l2.getText());
                }
                return 1;
            }
            return -1;
        }
    }
}

