/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.compare;

import org.apache.poi.ss.usermodel.Workbook;
import org.spdx.compare.AbstractFileCompareSheet;
import org.spdx.compare.SpdxCompareException;
import org.spdx.compare.SpdxComparer;
import org.spdx.rdfparser.DOAPProject;
import org.spdx.rdfparser.SPDXFile;

public class FileArtifactOfSheet
extends AbstractFileCompareSheet {
    private static final int FILE_ARTIFACTOF_COL_WIDTH = 60;

    public FileArtifactOfSheet(Workbook workbook, String sheetName) {
        super(workbook, sheetName);
    }

    static void create(Workbook wb, String sheetName) {
        AbstractFileCompareSheet.create(wb, sheetName, 60);
    }

    @Override
    String getFileValue(SPDXFile spdxFile) {
        DOAPProject[] projects = spdxFile.getArtifactOf();
        if (projects == null || projects.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < projects.length; ++i) {
            if (sb.length() > 0) {
                sb.append("; ");
            }
            sb.append(projects[i].getName());
            if (projects[i].getHomePage() == null || projects[i].getHomePage().isEmpty()) continue;
            sb.append("(");
            sb.append(projects[i].getHomePage());
            sb.append(")");
        }
        return sb.toString();
    }

    @Override
    boolean valuesMatch(SpdxComparer comparer, SPDXFile fileA, int docIndexA, SPDXFile fileB, int docIndexB) throws SpdxCompareException {
        DOAPProject[] projectsA = fileA.getArtifactOf();
        DOAPProject[] projectsB = fileB.getArtifactOf();
        if (projectsA == null) {
            return projectsB == null || projectsB.length == 0;
        }
        if (projectsB == null) {
            return projectsA.length == 0;
        }
        if (projectsA.length != projectsB.length) {
            return false;
        }
        for (int i = 0; i < projectsA.length; ++i) {
            boolean found = false;
            for (int j = 0; j < projectsB.length; ++j) {
                if (!SpdxComparer.stringsEqual(projectsA[i].getName(), projectsB[j].getName()) || !SpdxComparer.stringsEqual(projectsA[i].getHomePage(), projectsB[j].getHomePage()) || !SpdxComparer.stringsEqual(projectsA[i].getProjectUri(), projectsB[j].getProjectUri())) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }
}

