/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.compare;

import org.apache.poi.ss.usermodel.Workbook;
import org.spdx.compare.AbstractFileCompareSheet;
import org.spdx.compare.SpdxCompareException;
import org.spdx.compare.SpdxComparer;
import org.spdx.rdfparser.SPDXFile;

public class FileConcludedSheet
extends AbstractFileCompareSheet {
    private static final int LICENSE_COL_WIDTH = 60;

    public FileConcludedSheet(Workbook workbook, String sheetName) {
        super(workbook, sheetName);
    }

    static void create(Workbook wb, String sheetName) {
        AbstractFileCompareSheet.create(wb, sheetName, 60);
    }

    @Override
    String getFileValue(SPDXFile spdxFile) {
        return spdxFile.getConcludedLicenses().toString();
    }

    @Override
    boolean valuesMatch(SpdxComparer comparer, SPDXFile fileA, int docIndexA, SPDXFile fileB, int docIndexB) throws SpdxCompareException {
        return comparer.compareLicense(docIndexA, fileA.getConcludedLicenses(), docIndexB, fileB.getConcludedLicenses());
    }
}

