/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.compare;

import org.apache.poi.ss.usermodel.Workbook;
import org.spdx.compare.AbstractFileCompareSheet;
import org.spdx.compare.SpdxCompareException;
import org.spdx.compare.SpdxComparer;
import org.spdx.rdfparser.SPDXFile;

public class FileContributorsSheet
extends AbstractFileCompareSheet {
    private static final int FILE_CONTRIBUTOR_COL_WIDTH = 60;

    public FileContributorsSheet(Workbook workbook, String sheetName) {
        super(workbook, sheetName);
    }

    static void create(Workbook wb, String sheetName) {
        AbstractFileCompareSheet.create(wb, sheetName, 60);
    }

    @Override
    boolean valuesMatch(SpdxComparer comparer, SPDXFile fileA, int docIndexA, SPDXFile fileB, int docIndexB) throws SpdxCompareException {
        return SpdxComparer.stringArraysEqual(fileA.getContributors(), fileB.getContributors());
    }

    @Override
    String getFileValue(SPDXFile spdxFile) {
        StringBuilder sb = new StringBuilder();
        String[] contributors = spdxFile.getContributors();
        if (contributors != null && contributors.length > 0) {
            sb.append(contributors[0]);
            for (int i = 1; i < contributors.length; ++i) {
                sb.append(", ");
                sb.append(contributors[i]);
            }
        }
        return sb.toString();
    }
}

