/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.compare;

import org.apache.poi.ss.usermodel.Workbook;
import org.spdx.compare.AbstractFileCompareSheet;
import org.spdx.compare.SpdxCompareException;
import org.spdx.compare.SpdxComparer;
import org.spdx.rdfparser.SPDXFile;
import org.spdx.rdfparser.SPDXLicenseInfo;

public class FileLicenseInfoSheet
extends AbstractFileCompareSheet {
    private static final int LICENSE_COL_WIDTH = 60;

    public FileLicenseInfoSheet(Workbook workbook, String sheetName) {
        super(workbook, sheetName);
    }

    static void create(Workbook wb, String sheetName) {
        AbstractFileCompareSheet.create(wb, sheetName, 60);
    }

    @Override
    String getFileValue(SPDXFile spdxFile) {
        if (spdxFile.getSeenLicenses() == null || spdxFile.getSeenLicenses().length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(spdxFile.getSeenLicenses()[0].toString());
        for (int i = 1; i < spdxFile.getSeenLicenses().length; ++i) {
            sb.append(", ");
            sb.append(spdxFile.getSeenLicenses()[i].toString());
        }
        return sb.toString();
    }

    @Override
    boolean valuesMatch(SpdxComparer comparer, SPDXFile fileA, int docIndexA, SPDXFile fileB, int docIndexB) throws SpdxCompareException {
        SPDXLicenseInfo[] licenseInfosB;
        SPDXLicenseInfo[] licenseInfosA = fileA.getSeenLicenses();
        if (licenseInfosA.length != (licenseInfosB = fileB.getSeenLicenses()).length) {
            return false;
        }
        for (int i = 0; i < licenseInfosA.length; ++i) {
            boolean found = false;
            for (int j = 0; j < licenseInfosB.length; ++j) {
                if (!comparer.compareLicense(docIndexA, licenseInfosA[i], docIndexB, licenseInfosB[j])) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }
}

