/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.compare;

import org.apache.poi.ss.usermodel.Workbook;
import org.spdx.compare.AbstractFileCompareSheet;
import org.spdx.compare.SpdxCompareException;
import org.spdx.compare.SpdxComparer;
import org.spdx.rdfparser.SPDXFile;

public class FileTypeSheet
extends AbstractFileCompareSheet {
    private static final int FILE_TYPE_COL_WIDTH = 15;

    public FileTypeSheet(Workbook workbook, String sheetName) {
        super(workbook, sheetName);
    }

    static void create(Workbook wb, String sheetName) {
        AbstractFileCompareSheet.create(wb, sheetName, 15);
    }

    @Override
    String getFileValue(SPDXFile spdxFile) {
        if (spdxFile.getType() == null) {
            return "";
        }
        return spdxFile.getType();
    }

    @Override
    boolean valuesMatch(SpdxComparer comparer, SPDXFile fileA, int docIndexA, SPDXFile fileB, int docIndexB) throws SpdxCompareException {
        return SpdxComparer.stringsEqual(fileA.getType(), fileB.getType());
    }
}

