/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.compare;

import java.util.HashMap;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.spdx.compare.CompareTemplateOutputHandler;
import org.spdx.compare.SpdxCompareException;
import org.spdx.licenseTemplate.LicenseTemplateRuleException;
import org.spdx.licenseTemplate.SpdxLicenseTemplateHelper;
import org.spdx.rdfparser.SPDXConjunctiveLicenseSet;
import org.spdx.rdfparser.SPDXDisjunctiveLicenseSet;
import org.spdx.rdfparser.SPDXLicenseInfo;
import org.spdx.rdfparser.SPDXLicenseSet;
import org.spdx.rdfparser.SPDXNonStandardLicense;
import org.spdx.rdfparser.SPDXStandardLicense;

public class LicenseCompareHelper {
    protected static final String TOKEN_DELIM = "\\s";
    protected static final HashSet<String> SKIPPABLE_TOKENS = new HashSet();
    protected static final HashMap<String, String> EQUIV_TOKENS;
    static final String DASHES_REGEX = "[\\u2012\\u2013\\u2014\\u2015]";
    static final String PER_CENT_REGEX = "(?i)per\\scent";
    static final Pattern PER_CENT_PATTERN;
    static final String COPYRIGHT_HOLDER_REGEX = "(?i)copyright\\sholder";
    static final Pattern COPYRIGHT_HOLDER_PATTERN;
    static final String COPYRIGHT_OWNER_REGEX = "(?i)copyright\\sowner";
    static final Pattern COPYRIGHT_OWNER_PATTERN;

    public static boolean isLicenseTextEquivalent(String licenseTextA, String licenseTextB) {
        String[] licenseATokens = LicenseCompareHelper.replaceMultWord(licenseTextA).split(TOKEN_DELIM);
        String[] licenseBTokens = LicenseCompareHelper.replaceMultWord(licenseTextB).split(TOKEN_DELIM);
        int bTokenCounter = 0;
        int aTokenCounter = 0;
        String nextAToken = LicenseCompareHelper.getTokenAt(licenseATokens, aTokenCounter++);
        String nextBToken = LicenseCompareHelper.getTokenAt(licenseBTokens, bTokenCounter++);
        while (nextAToken != null) {
            if (nextBToken == null) {
                while (nextAToken != null && LicenseCompareHelper.canSkip(nextAToken)) {
                    nextAToken = LicenseCompareHelper.getTokenAt(licenseATokens, aTokenCounter++);
                }
                if (nextAToken == null) continue;
                return false;
            }
            if (LicenseCompareHelper.tokensEquivalent(nextAToken, nextBToken)) {
                nextAToken = LicenseCompareHelper.getTokenAt(licenseATokens, aTokenCounter++);
                nextBToken = LicenseCompareHelper.getTokenAt(licenseBTokens, bTokenCounter++);
                continue;
            }
            while (nextBToken != null && LicenseCompareHelper.canSkip(nextBToken)) {
                nextBToken = LicenseCompareHelper.getTokenAt(licenseBTokens, bTokenCounter++);
            }
            while (nextAToken != null && LicenseCompareHelper.canSkip(nextAToken)) {
                nextAToken = LicenseCompareHelper.getTokenAt(licenseATokens, aTokenCounter++);
            }
            if (!LicenseCompareHelper.tokensEquivalent(nextAToken, nextBToken)) {
                return false;
            }
            nextAToken = LicenseCompareHelper.getTokenAt(licenseATokens, aTokenCounter++);
            nextBToken = LicenseCompareHelper.getTokenAt(licenseBTokens, bTokenCounter++);
        }
        while (nextBToken != null && LicenseCompareHelper.canSkip(nextBToken)) {
            nextBToken = LicenseCompareHelper.getTokenAt(licenseBTokens, bTokenCounter++);
        }
        return nextBToken == null;
    }

    private static String replaceMultWord(String s) {
        Matcher m = COPYRIGHT_HOLDER_PATTERN.matcher(s);
        String retval = m.replaceAll("copyright-holder");
        m = COPYRIGHT_OWNER_PATTERN.matcher(retval);
        retval = m.replaceAll("copyright-owner");
        m = PER_CENT_PATTERN.matcher(retval);
        retval = m.replaceAll("percent");
        return retval;
    }

    static String getTokenAt(String[] tokens, int tokenIndex) {
        if (tokenIndex >= tokens.length) {
            return null;
        }
        return tokens[tokenIndex];
    }

    static boolean tokensEquivalent(String tokenA, String tokenB) {
        String s2;
        if (tokenA == null) {
            return tokenB == null;
        }
        if (tokenB == null) {
            return false;
        }
        String s1 = tokenA.trim().toLowerCase().replaceAll(DASHES_REGEX, "-");
        if (s1.equals(s2 = tokenB.trim().toLowerCase().replaceAll(DASHES_REGEX, "-"))) {
            return true;
        }
        if (EQUIV_TOKENS.get(s1) != null) {
            return s2.equals(EQUIV_TOKENS.get(s1));
        }
        return false;
    }

    static boolean canSkip(String token) {
        if (token == null) {
            return false;
        }
        if (token.trim().isEmpty()) {
            return true;
        }
        return SKIPPABLE_TOKENS.contains(token.trim().toLowerCase());
    }

    public static boolean isLicenseEqual(SPDXLicenseInfo license1, SPDXLicenseInfo license2, HashMap<String, String> xlationMap) throws SpdxCompareException {
        if (license1 instanceof SPDXConjunctiveLicenseSet) {
            if (!(license2 instanceof SPDXConjunctiveLicenseSet)) {
                return false;
            }
            return LicenseCompareHelper.isLicenseSetsEqual((SPDXConjunctiveLicenseSet)license1, (SPDXConjunctiveLicenseSet)license2, xlationMap);
        }
        if (license1 instanceof SPDXDisjunctiveLicenseSet) {
            if (!(license2 instanceof SPDXDisjunctiveLicenseSet)) {
                return false;
            }
            return LicenseCompareHelper.isLicenseSetsEqual((SPDXDisjunctiveLicenseSet)license1, (SPDXDisjunctiveLicenseSet)license2, xlationMap);
        }
        if (license1 instanceof SPDXNonStandardLicense) {
            if (!(license2 instanceof SPDXNonStandardLicense)) {
                return false;
            }
            String licenseid1 = ((SPDXNonStandardLicense)license1).getId();
            String licenseid2 = ((SPDXNonStandardLicense)license2).getId();
            String xlatedLicenseId = xlationMap.get(licenseid1);
            if (xlatedLicenseId == null) {
                return false;
            }
            return xlatedLicenseId.equals(licenseid2);
        }
        return license1.equals(license2);
    }

    private static boolean isLicenseSetsEqual(SPDXLicenseSet license1, SPDXLicenseSet license2, HashMap<String, String> xlationMap) throws SpdxCompareException {
        SPDXLicenseInfo[] licenseInfos1 = license1.getSPDXLicenseInfos();
        SPDXLicenseInfo[] licenseInfos2 = license2.getSPDXLicenseInfos();
        if (licenseInfos1 == null) {
            return licenseInfos2 == null;
        }
        if (licenseInfos2 == null) {
            return false;
        }
        if (licenseInfos1.length != licenseInfos2.length) {
            return false;
        }
        for (int i = 0; i < licenseInfos1.length; ++i) {
            boolean found = false;
            for (int j = 0; j < licenseInfos2.length; ++j) {
                if (!LicenseCompareHelper.isLicenseEqual(licenseInfos1[i], licenseInfos2[j], xlationMap)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public static boolean isTextStandardLicense(SPDXStandardLicense license, String compareText) throws SpdxCompareException {
        String licenseTemplate = license.getTemplate();
        if (licenseTemplate == null || licenseTemplate.trim().isEmpty()) {
            return LicenseCompareHelper.isLicenseTextEquivalent(license.getText(), compareText);
        }
        CompareTemplateOutputHandler compareTemplateOutputHandler = new CompareTemplateOutputHandler(compareText);
        try {
            SpdxLicenseTemplateHelper.parseTemplate(licenseTemplate, compareTemplateOutputHandler);
        }
        catch (LicenseTemplateRuleException e) {
            throw new SpdxCompareException("Invalid template rule found during compare: " + e.getMessage(), e);
        }
        return compareTemplateOutputHandler.matches();
    }

    static {
        SKIPPABLE_TOKENS.add("//");
        SKIPPABLE_TOKENS.add("/*");
        SKIPPABLE_TOKENS.add("*/");
        SKIPPABLE_TOKENS.add("/**");
        SKIPPABLE_TOKENS.add("#");
        SKIPPABLE_TOKENS.add("##");
        SKIPPABLE_TOKENS.add("*");
        SKIPPABLE_TOKENS.add("\"\"\"");
        SKIPPABLE_TOKENS.add("=begin");
        SKIPPABLE_TOKENS.add("=end");
        EQUIV_TOKENS = new HashMap();
        EQUIV_TOKENS.put("acknowledgement", "acknowledgment");
        EQUIV_TOKENS.put("acknowledgment", "acknowledgement");
        EQUIV_TOKENS.put("analog", "analogue");
        EQUIV_TOKENS.put("analogue", "analog");
        EQUIV_TOKENS.put("analyze", "analyse");
        EQUIV_TOKENS.put("analyse", "analyze");
        EQUIV_TOKENS.put("artifact", "artefact");
        EQUIV_TOKENS.put("artefact", "artifact");
        EQUIV_TOKENS.put("authorization", "authorisation");
        EQUIV_TOKENS.put("authorisation", "authorization");
        EQUIV_TOKENS.put("authorized", "authorised");
        EQUIV_TOKENS.put("authorised", "authorized");
        EQUIV_TOKENS.put("caliber", "calibre");
        EQUIV_TOKENS.put("calibre", "caliber");
        EQUIV_TOKENS.put("canceled", "cancelled");
        EQUIV_TOKENS.put("cancelled", "canceled");
        EQUIV_TOKENS.put("apitalizations", "apitalisations");
        EQUIV_TOKENS.put("apitalisations", "apitalizations");
        EQUIV_TOKENS.put("catalog", "catalogue");
        EQUIV_TOKENS.put("catalogue", "catalog");
        EQUIV_TOKENS.put("categorize", "categorise");
        EQUIV_TOKENS.put("categorise", "categorize");
        EQUIV_TOKENS.put("center", "centre");
        EQUIV_TOKENS.put("centre", "center");
        EQUIV_TOKENS.put("emphasized", "emphasised");
        EQUIV_TOKENS.put("emphasised", "emphasized");
        EQUIV_TOKENS.put("favor", "favour");
        EQUIV_TOKENS.put("favour", "favor");
        EQUIV_TOKENS.put("favorite", "favourite");
        EQUIV_TOKENS.put("favourite", "favorite");
        EQUIV_TOKENS.put("fulfill", "fulfil");
        EQUIV_TOKENS.put("fulfil", "fulfill");
        EQUIV_TOKENS.put("fulfillment", "fulfilment");
        EQUIV_TOKENS.put("fulfilment", "fulfillment");
        EQUIV_TOKENS.put("initialize", "initialise");
        EQUIV_TOKENS.put("initialise", "initialize");
        EQUIV_TOKENS.put("judgement", "judgment");
        EQUIV_TOKENS.put("judgment", "judgement");
        EQUIV_TOKENS.put("labeling", "labelling");
        EQUIV_TOKENS.put("labelling", "labeling");
        EQUIV_TOKENS.put("labor", "labour");
        EQUIV_TOKENS.put("labour", "labor");
        EQUIV_TOKENS.put("license", "licence");
        EQUIV_TOKENS.put("licence", "license");
        EQUIV_TOKENS.put("maximize", "maximise");
        EQUIV_TOKENS.put("maximise", "maximize");
        EQUIV_TOKENS.put("modeled", "modelled");
        EQUIV_TOKENS.put("modelled", "modeled");
        EQUIV_TOKENS.put("modeling", "modelling");
        EQUIV_TOKENS.put("modelling", "modeling");
        EQUIV_TOKENS.put("offense", "offence");
        EQUIV_TOKENS.put("offence", "offense");
        EQUIV_TOKENS.put("optimize", "optimise");
        EQUIV_TOKENS.put("optimise", "optimize");
        EQUIV_TOKENS.put("organization", "organisation");
        EQUIV_TOKENS.put("organisation", "organization");
        EQUIV_TOKENS.put("organize", "organise");
        EQUIV_TOKENS.put("organise", "organize");
        EQUIV_TOKENS.put("practice", "practise");
        EQUIV_TOKENS.put("practise", "practice");
        EQUIV_TOKENS.put("program", "programme");
        EQUIV_TOKENS.put("programme", "program");
        EQUIV_TOKENS.put("realize", "realise");
        EQUIV_TOKENS.put("realise", "realize");
        EQUIV_TOKENS.put("recognize", "recognise");
        EQUIV_TOKENS.put("recognise", "recognize");
        EQUIV_TOKENS.put("signaling", "signalling");
        EQUIV_TOKENS.put("signalling", "signaling");
        EQUIV_TOKENS.put("utilization", "utilisation");
        EQUIV_TOKENS.put("utilisation", "utilization");
        EQUIV_TOKENS.put("while", "whilst");
        EQUIV_TOKENS.put("whilst", "while");
        EQUIV_TOKENS.put("wilfull", "wilful");
        EQUIV_TOKENS.put("wilful", "wilfull");
        EQUIV_TOKENS.put("noncommercial", "non-commercial");
        EQUIV_TOKENS.put("non-commercial", "noncommercial");
        EQUIV_TOKENS.put("copyright-holder", "copyright-owner");
        EQUIV_TOKENS.put("copyright-owner", "copyright-holder");
        EQUIV_TOKENS.put("sub-license", "sublicense");
        EQUIV_TOKENS.put("sublicense", "sub-license");
        PER_CENT_PATTERN = Pattern.compile(PER_CENT_REGEX, 2);
        COPYRIGHT_HOLDER_PATTERN = Pattern.compile(COPYRIGHT_HOLDER_REGEX, 2);
        COPYRIGHT_OWNER_PATTERN = Pattern.compile(COPYRIGHT_OWNER_REGEX, 2);
    }
}

