/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.compare;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Workbook;
import org.spdx.compare.CreatorSheet;
import org.spdx.compare.DocumentSheet;
import org.spdx.compare.ExtractedLicenseSheet;
import org.spdx.compare.FileArtifactOfSheet;
import org.spdx.compare.FileChecksumSheet;
import org.spdx.compare.FileCommentSheet;
import org.spdx.compare.FileConcludedSheet;
import org.spdx.compare.FileContributorsSheet;
import org.spdx.compare.FileDependenciesSheet;
import org.spdx.compare.FileLicenseCommentsSheet;
import org.spdx.compare.FileLicenseInfoSheet;
import org.spdx.compare.FileNoticeSheet;
import org.spdx.compare.FileTypeSheet;
import org.spdx.compare.NormalizedFileNameComparator;
import org.spdx.compare.PackageSheet;
import org.spdx.compare.ReviewerSheet;
import org.spdx.compare.SpdxCompareException;
import org.spdx.compare.SpdxComparer;
import org.spdx.compare.VerificationSheet;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.SPDXFile;
import org.spdx.spdxspreadsheet.AbstractSpreadsheet;
import org.spdx.spdxspreadsheet.SpreadsheetException;

public class MultiDocumentSpreadsheet
extends AbstractSpreadsheet {
    private SpdxFileComparator fileComparator = new SpdxFileComparator();
    static Logger logger = Logger.getLogger(MultiDocumentSpreadsheet.class);
    private static final String DOCUMENT_SHEET_NAME = "Document";
    private DocumentSheet documentSheet = new DocumentSheet(this.workbook, "Document");
    private static final String CREATOR_SHEET_NAME = "Creator";
    private CreatorSheet creatorSheet = new CreatorSheet(this.workbook, "Creator");
    private static final String PACKAGE_SHEET_NAME = "Package";
    private PackageSheet packageSheet = new PackageSheet(this.workbook, "Package");
    private static final String EXTRACTED_LICENSE_SHEET_NAME = "Extracted Licenses";
    private ExtractedLicenseSheet extractedLicenseSheet = new ExtractedLicenseSheet(this.workbook, "Extracted Licenses");
    private static final String FILE_CHECKSUM_SHEET_NAME = "File Checksum";
    private FileChecksumSheet fileChecksumSheet = new FileChecksumSheet(this.workbook, "File Checksum");
    private static final String FILE_CONCLUDED_SHEET_NAME = "File Concluded";
    private FileConcludedSheet fileConcludedSheet = new FileConcludedSheet(this.workbook, "File Concluded");
    private static final String FILE_FOUND_SHEET_NAME = "File Found Licenses";
    private FileLicenseInfoSheet fileLicenseInfoSheet = new FileLicenseInfoSheet(this.workbook, "File Found Licenses");
    private static final String FILE_LICENSE_COMMENT_SHEET_NAME = "File License Comment";
    private FileLicenseCommentsSheet fileLicenseCommentsSheet;
    private static final String FILE_COMMENT_SHEET_NAME = "File Comment";
    private FileCommentSheet fileCommentSheet = new FileCommentSheet(this.workbook, "File Comment");
    private static final String FILE_ARTIFACT_OF_SHEET_NAME = "File ArtifactOf";
    private FileArtifactOfSheet fileArtifactOfSheet;
    private static final String FILE_TYPE_SHEET_NAME = "File Type";
    private FileTypeSheet fileTypeSheet;
    private static final String REVIEWER_SHEET_NAME = "Reviewers";
    private ReviewerSheet reviewerSheet;
    private static final String FILE_CONTRIBUTOR_SHEET_NAME = "File Contributors";
    private FileContributorsSheet fileContributorsSheet;
    private static final String FILE_DEPENDENCIES_SHEET_NAME = "File Dependencies";
    private FileDependenciesSheet fileDependenciesSheet;
    private static final String FILE_NOTICE_SHEET_NAME = "File Notices";
    private FileNoticeSheet fileNoticeSheet;
    private static final String VERIFICATION_SHEET_NAME = "Verification Errors";
    public static final int MAX_DOCUMENTS = 25;
    private VerificationSheet verificationSheet;

    public MultiDocumentSpreadsheet(File spreadsheetFile, boolean create, boolean readonly) throws SpreadsheetException {
        super(spreadsheetFile, create, readonly);
        this.fileLicenseCommentsSheet = new FileLicenseCommentsSheet(this.workbook, FILE_LICENSE_COMMENT_SHEET_NAME);
        this.fileArtifactOfSheet = new FileArtifactOfSheet(this.workbook, FILE_ARTIFACT_OF_SHEET_NAME);
        this.fileTypeSheet = new FileTypeSheet(this.workbook, FILE_TYPE_SHEET_NAME);
        this.fileContributorsSheet = new FileContributorsSheet(this.workbook, FILE_CONTRIBUTOR_SHEET_NAME);
        this.fileDependenciesSheet = new FileDependenciesSheet(this.workbook, FILE_DEPENDENCIES_SHEET_NAME);
        this.fileNoticeSheet = new FileNoticeSheet(this.workbook, FILE_NOTICE_SHEET_NAME);
        this.reviewerSheet = new ReviewerSheet(this.workbook, REVIEWER_SHEET_NAME);
        this.verificationSheet = new VerificationSheet(this.workbook, VERIFICATION_SHEET_NAME);
        String verify = this.verifyWorkbook();
        if (verify != null && !verify.isEmpty()) {
            logger.error((Object)("Invalid workbook: " + verify));
            throw new SpreadsheetException("Invalid workbook: " + verify);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void create(File spreadsheetFile) throws IOException, SpreadsheetException {
        if (!spreadsheetFile.createNewFile()) {
            logger.error((Object)("Unable to create " + spreadsheetFile.getName()));
            throw new SpreadsheetException("Unable to create " + spreadsheetFile.getName());
        }
        FileOutputStream excelOut = null;
        try {
            excelOut = new FileOutputStream(spreadsheetFile);
            HSSFWorkbook wb = new HSSFWorkbook();
            DocumentSheet.create((Workbook)wb, DOCUMENT_SHEET_NAME);
            CreatorSheet.create((Workbook)wb, CREATOR_SHEET_NAME);
            PackageSheet.create((Workbook)wb, PACKAGE_SHEET_NAME);
            ExtractedLicenseSheet.create((Workbook)wb, EXTRACTED_LICENSE_SHEET_NAME);
            FileChecksumSheet.create((Workbook)wb, FILE_CHECKSUM_SHEET_NAME);
            FileConcludedSheet.create((Workbook)wb, FILE_CONCLUDED_SHEET_NAME);
            FileLicenseInfoSheet.create((Workbook)wb, FILE_FOUND_SHEET_NAME);
            FileCommentSheet.create((Workbook)wb, FILE_COMMENT_SHEET_NAME);
            FileLicenseCommentsSheet.create((Workbook)wb, FILE_LICENSE_COMMENT_SHEET_NAME);
            FileArtifactOfSheet.create((Workbook)wb, FILE_ARTIFACT_OF_SHEET_NAME);
            FileTypeSheet.create((Workbook)wb, FILE_TYPE_SHEET_NAME);
            FileContributorsSheet.create((Workbook)wb, FILE_CONTRIBUTOR_SHEET_NAME);
            FileDependenciesSheet.create((Workbook)wb, FILE_DEPENDENCIES_SHEET_NAME);
            FileNoticeSheet.create((Workbook)wb, FILE_NOTICE_SHEET_NAME);
            ReviewerSheet.create((Workbook)wb, REVIEWER_SHEET_NAME);
            VerificationSheet.create((Workbook)wb, VERIFICATION_SHEET_NAME);
            wb.write((OutputStream)excelOut);
        }
        finally {
            excelOut.close();
        }
    }

    public void importCompareResults(SpdxComparer comparer, String[] docNames) throws SpdxCompareException, InvalidSPDXAnalysisException {
        if (docNames == null) {
            throw new SpdxCompareException("Doc names can not be null");
        }
        if (comparer == null) {
            throw new SpdxCompareException("Comparer names can not be null");
        }
        if (docNames.length != comparer.getNumSpdxDocs()) {
            throw new SpdxCompareException("Number of document names does not match the number of documents compared");
        }
        SPDXFile[][] files = new SPDXFile[comparer.getNumSpdxDocs()][];
        for (int i = 0; i < files.length; ++i) {
            SPDXFile[] docFiles = comparer.getSpdxDoc(i).getSpdxPackage().getFiles();
            Arrays.sort(docFiles, this.fileComparator);
            files[i] = docFiles;
        }
        this.documentSheet.importCompareResults(comparer, docNames);
        this.documentSheet.resizeRows();
        this.creatorSheet.importCompareResults(comparer, docNames);
        this.creatorSheet.resizeRows();
        this.packageSheet.importCompareResults(comparer, docNames);
        this.packageSheet.resizeRows();
        this.extractedLicenseSheet.importCompareResults(comparer, docNames);
        this.extractedLicenseSheet.resizeRows();
        this.fileChecksumSheet.importCompareResults(comparer, files, docNames);
        this.fileChecksumSheet.resizeRows();
        this.fileConcludedSheet.importCompareResults(comparer, files, docNames);
        this.fileConcludedSheet.resizeRows();
        this.fileLicenseInfoSheet.importCompareResults(comparer, files, docNames);
        this.fileLicenseInfoSheet.resizeRows();
        this.fileCommentSheet.importCompareResults(comparer, files, docNames);
        this.fileCommentSheet.resizeRows();
        this.fileLicenseCommentsSheet.importCompareResults(comparer, files, docNames);
        this.fileLicenseCommentsSheet.resizeRows();
        this.fileArtifactOfSheet.importCompareResults(comparer, files, docNames);
        this.fileArtifactOfSheet.resizeRows();
        this.fileTypeSheet.importCompareResults(comparer, files, docNames);
        this.fileTypeSheet.resizeRows();
        this.fileContributorsSheet.importCompareResults(comparer, files, docNames);
        this.fileContributorsSheet.resizeRows();
        this.fileDependenciesSheet.importCompareResults(comparer, files, docNames);
        this.fileDependenciesSheet.resizeRows();
        this.fileNoticeSheet.importCompareResults(comparer, files, docNames);
        this.fileNoticeSheet.resizeRows();
        this.reviewerSheet.importCompareResults(comparer, docNames);
        this.reviewerSheet.resizeRows();
    }

    @Override
    public void clear() {
        this.documentSheet.clear();
        this.creatorSheet.clear();
        this.packageSheet.clear();
        this.extractedLicenseSheet.clear();
        this.fileChecksumSheet.clear();
        this.fileConcludedSheet.clear();
        this.fileLicenseInfoSheet.clear();
        this.fileLicenseCommentsSheet.clear();
        this.fileArtifactOfSheet.clear();
        this.reviewerSheet.clear();
        this.verificationSheet.clear();
        this.fileCommentSheet.clear();
        this.fileContributorsSheet.clear();
        this.fileDependenciesSheet.clear();
        this.fileNoticeSheet.clear();
    }

    @Override
    public String verifyWorkbook() {
        StringBuilder sb = new StringBuilder();
        String sheetVerify = this.documentSheet.verify();
        if (sheetVerify != null && !sheetVerify.isEmpty()) {
            sb.append(sheetVerify);
        }
        if ((sheetVerify = this.creatorSheet.verify()) != null && !sheetVerify.isEmpty()) {
            sb.append("; ");
            sb.append(sheetVerify);
        }
        if ((sheetVerify = this.packageSheet.verify()) != null && !sheetVerify.isEmpty()) {
            sb.append("; ");
            sb.append(sheetVerify);
        }
        if ((sheetVerify = this.extractedLicenseSheet.verify()) != null && !sheetVerify.isEmpty()) {
            sb.append("; ");
            sb.append(sheetVerify);
        }
        if ((sheetVerify = this.fileChecksumSheet.verify()) != null && !sheetVerify.isEmpty()) {
            sb.append("; ");
            sb.append(sheetVerify);
        }
        if ((sheetVerify = this.fileConcludedSheet.verify()) != null && !sheetVerify.isEmpty()) {
            sb.append("; ");
            sb.append(sheetVerify);
        }
        if ((sheetVerify = this.fileLicenseInfoSheet.verify()) != null && !sheetVerify.isEmpty()) {
            sb.append("; ");
            sb.append(sheetVerify);
        }
        if ((sheetVerify = this.fileCommentSheet.verify()) != null && !sheetVerify.isEmpty()) {
            sb.append("; ");
            sb.append(sheetVerify);
        }
        if ((sheetVerify = this.fileLicenseCommentsSheet.verify()) != null && !sheetVerify.isEmpty()) {
            sb.append("; ");
            sb.append(sheetVerify);
        }
        if ((sheetVerify = this.fileArtifactOfSheet.verify()) != null && !sheetVerify.isEmpty()) {
            sb.append("; ");
            sb.append(sheetVerify);
        }
        if ((sheetVerify = this.reviewerSheet.verify()) != null && !sheetVerify.isEmpty()) {
            sb.append("; ");
            sb.append(sheetVerify);
        }
        if ((sheetVerify = this.fileContributorsSheet.verify()) != null && !sheetVerify.isEmpty()) {
            sb.append("; ");
            sb.append(sheetVerify);
        }
        if ((sheetVerify = this.fileDependenciesSheet.verify()) != null && !sheetVerify.isEmpty()) {
            sb.append("; ");
            sb.append(sheetVerify);
        }
        if ((sheetVerify = this.fileNoticeSheet.verify()) != null && !sheetVerify.isEmpty()) {
            sb.append("; ");
            sb.append(sheetVerify);
        }
        this.verificationSheet.verify();
        if (sheetVerify != null && !sheetVerify.isEmpty()) {
            sb.append("; ");
            sb.append(sheetVerify);
        }
        if (sb.length() > 0) {
            return sb.toString();
        }
        return null;
    }

    public void importVerificationErrors(ArrayList<String>[] verificationErrors, String[] docNames) throws SpreadsheetException {
        this.verificationSheet.importVerificationErrors(verificationErrors, docNames);
        this.verificationSheet.resizeRows();
    }

    class SpdxFileComparator
    implements Comparator<SPDXFile> {
        private NormalizedFileNameComparator normalizedFileNameComparator = new NormalizedFileNameComparator();

        SpdxFileComparator() {
        }

        @Override
        public int compare(SPDXFile arg0, SPDXFile arg1) {
            return this.normalizedFileNameComparator.compare(arg0.getName(), arg1.getName());
        }
    }
}

