/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.compare;

import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.spdx.compare.SpdxCompareException;
import org.spdx.compare.SpdxComparer;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.SPDXDocument;
import org.spdx.rdfparser.SPDXLicenseInfo;
import org.spdx.spdxspreadsheet.AbstractSheet;

public class PackageSheet
extends AbstractSheet {
    private static final int COL_WIDTH = 60;
    protected static final int FIELD_COL = 0;
    protected static final int EQUALS_COL = 1;
    protected static final int FIRST_DOC_COL = 2;
    private static final int FIELD_COL_WIDTH = 20;
    private static final int EQUALS_COL_WIDTH = 6;
    protected static final String FIELD_HEADER_TEXT = "Package Property";
    protected static final String EQUALS_HEADER_TEXT = "Equals";
    protected static final String DESCRIPTION_FIELD_TEXT = "Description";
    protected static final String SUMMARY_FIELD_TEXT = "Summary";
    protected static final String COPYRIGHT_FIELD_TEXT = "Copyright";
    protected static final String LICENSE_COMMENT_FIELD_TEXT = "License Comment";
    protected static final String DECLARED_LICENSE_FIELD_TEXT = "Declared License";
    protected static final String LICENSE_INFOS_FROM_FILES_FIELD_TEXT = "License From Files";
    protected static final String CONCLUDED_LICENSE_FIELD_TEXT = "Concluded License";
    protected static final String SOURCEINFO_FIELD_TEXT = "Source Info";
    protected static final String CHECKSUM_FIELD_TEXT = "Checksum";
    protected static final String VERIFICATION_EXCLUDED_FIELD_TEXT = "Verification Excluded";
    protected static final String VERIFICATION_FIELD_TEXT = "Verification Value";
    protected static final String DOWNLOAD_FIELD_TEXT = "Dowload Location";
    protected static final String ORIGINATOR_FIELD_TEXT = "Originator";
    protected static final String SUPPLIER_FIELD_TEXT = "Supplier";
    protected static final String FILE_NAME_FIELD_TEXT = "File Name";
    protected static final String VERSION_FIELD_TEXT = "Version";
    protected static final String PACKAGE_NAME_FIELD_TEXT = "Package Name";
    protected static final String DIFFERENT_STRING = "Diff";
    protected static final String EQUAL_STRING = "Equal";
    protected static final String HOMEPAGE_FIELD_TEXT = "Home Page";

    public PackageSheet(Workbook workbook, String sheetName) {
        super(workbook, sheetName);
    }

    @Override
    public String verify() {
        return null;
    }

    public static void create(Workbook wb, String sheetName) {
        int sheetNum = wb.getSheetIndex(sheetName);
        if (sheetNum >= 0) {
            wb.removeSheetAt(sheetNum);
        }
        Sheet sheet = wb.createSheet(sheetName);
        CellStyle headerStyle = AbstractSheet.createHeaderStyle(wb);
        CellStyle defaultStyle = AbstractSheet.createLeftWrapStyle(wb);
        Row headerRow = sheet.createRow(0);
        sheet.setColumnWidth(0, 5120);
        sheet.setDefaultColumnStyle(0, defaultStyle);
        Cell fieldCell = headerRow.createCell(0);
        fieldCell.setCellStyle(headerStyle);
        fieldCell.setCellValue(FIELD_HEADER_TEXT);
        sheet.setColumnWidth(1, 1536);
        sheet.setDefaultColumnStyle(1, defaultStyle);
        Cell equalsCell = headerRow.createCell(1);
        equalsCell.setCellStyle(headerStyle);
        equalsCell.setCellValue(EQUALS_HEADER_TEXT);
        for (int i = 2; i < 27; ++i) {
            sheet.setColumnWidth(i, 15360);
            sheet.setDefaultColumnStyle(i, defaultStyle);
            Cell cell = headerRow.createCell(i);
            cell.setCellStyle(headerStyle);
        }
    }

    public void importCompareResults(SpdxComparer comparer, String[] docNames) throws SpdxCompareException, InvalidSPDXAnalysisException {
        if (comparer.getNumSpdxDocs() != docNames.length) {
            throw new SpdxCompareException("Number of document names does not match the number of SPDX documents");
        }
        this.clear();
        Row header = this.sheet.getRow(0);
        Row packageNameRow = this.addRow();
        packageNameRow.createCell(0).setCellValue(PACKAGE_NAME_FIELD_TEXT);
        if (comparer.isPackageNamesEqual()) {
            this.setCellEqualValue(packageNameRow.createCell(1));
        } else {
            this.setCellDifferentValue(packageNameRow.createCell(1));
        }
        Row versionRow = this.addRow();
        versionRow.createCell(0).setCellValue(VERSION_FIELD_TEXT);
        if (comparer.isPackageVersionsEqual()) {
            this.setCellEqualValue(versionRow.createCell(1));
        } else {
            this.setCellDifferentValue(versionRow.createCell(1));
        }
        Row fileNameRow = this.addRow();
        fileNameRow.createCell(0).setCellValue(FILE_NAME_FIELD_TEXT);
        if (comparer.isPackageFileNamesEqual()) {
            this.setCellEqualValue(fileNameRow.createCell(1));
        } else {
            this.setCellDifferentValue(fileNameRow.createCell(1));
        }
        Row supplierRow = this.addRow();
        supplierRow.createCell(0).setCellValue(SUPPLIER_FIELD_TEXT);
        if (comparer.isPackageSuppliersEqual()) {
            this.setCellEqualValue(supplierRow.createCell(1));
        } else {
            this.setCellDifferentValue(supplierRow.createCell(1));
        }
        Row originatorRow = this.addRow();
        originatorRow.createCell(0).setCellValue(ORIGINATOR_FIELD_TEXT);
        if (comparer.isPackageOriginatorsEqual()) {
            this.setCellEqualValue(originatorRow.createCell(1));
        } else {
            this.setCellDifferentValue(originatorRow.createCell(1));
        }
        Row homePageRow = this.addRow();
        homePageRow.createCell(0).setCellValue(HOMEPAGE_FIELD_TEXT);
        if (comparer.ispackageHomePagesEqual()) {
            this.setCellEqualValue(homePageRow.createCell(1));
        } else {
            this.setCellDifferentValue(homePageRow.createCell(1));
        }
        Row downloadRow = this.addRow();
        downloadRow.createCell(0).setCellValue(DOWNLOAD_FIELD_TEXT);
        if (comparer.isPackageDownloadLocationsEqual()) {
            this.setCellEqualValue(downloadRow.createCell(1));
        } else {
            this.setCellDifferentValue(downloadRow.createCell(1));
        }
        Row verificationRow = this.addRow();
        verificationRow.createCell(0).setCellValue(VERIFICATION_FIELD_TEXT);
        if (comparer.isPackageVerificationCodesEqual()) {
            this.setCellEqualValue(verificationRow.createCell(1));
        } else {
            this.setCellDifferentValue(verificationRow.createCell(1));
        }
        Row verificationExcludedRow = this.addRow();
        verificationExcludedRow.createCell(0).setCellValue(VERIFICATION_EXCLUDED_FIELD_TEXT);
        if (comparer.isPackageVerificationCodesEqual()) {
            this.setCellEqualValue(verificationExcludedRow.createCell(1));
        } else {
            this.setCellDifferentValue(verificationExcludedRow.createCell(1));
        }
        Row checksumRow = this.addRow();
        checksumRow.createCell(0).setCellValue(CHECKSUM_FIELD_TEXT);
        if (comparer.isPackageChecksumsEqual()) {
            this.setCellEqualValue(checksumRow.createCell(1));
        } else {
            this.setCellDifferentValue(checksumRow.createCell(1));
        }
        Row sourceInfoRow = this.addRow();
        sourceInfoRow.createCell(0).setCellValue(SOURCEINFO_FIELD_TEXT);
        if (comparer.isSourceInformationEqual()) {
            this.setCellEqualValue(sourceInfoRow.createCell(1));
        } else {
            this.setCellDifferentValue(sourceInfoRow.createCell(1));
        }
        Row concludedLicenseRow = this.addRow();
        concludedLicenseRow.createCell(0).setCellValue(CONCLUDED_LICENSE_FIELD_TEXT);
        if (comparer.isPackageConcludedLicensesEqual()) {
            this.setCellEqualValue(concludedLicenseRow.createCell(1));
        } else {
            this.setCellDifferentValue(concludedLicenseRow.createCell(1));
        }
        Row licenseInfosFromFilesRow = this.addRow();
        licenseInfosFromFilesRow.createCell(0).setCellValue(LICENSE_INFOS_FROM_FILES_FIELD_TEXT);
        if (comparer.isPackageLicenseInfoFromFilesEqual()) {
            this.setCellEqualValue(licenseInfosFromFilesRow.createCell(1));
        } else {
            this.setCellDifferentValue(licenseInfosFromFilesRow.createCell(1));
        }
        Row declaredLicenseRow = this.addRow();
        declaredLicenseRow.createCell(0).setCellValue(DECLARED_LICENSE_FIELD_TEXT);
        if (comparer.isPackageDeclaredLicensesEqual()) {
            this.setCellEqualValue(declaredLicenseRow.createCell(1));
        } else {
            this.setCellDifferentValue(declaredLicenseRow.createCell(1));
        }
        Row licenseCommentRow = this.addRow();
        licenseCommentRow.createCell(0).setCellValue(LICENSE_COMMENT_FIELD_TEXT);
        if (comparer.isLicenseCommentsEqual()) {
            this.setCellEqualValue(licenseCommentRow.createCell(1));
        } else {
            this.setCellDifferentValue(licenseCommentRow.createCell(1));
        }
        Row copyrightRow = this.addRow();
        copyrightRow.createCell(0).setCellValue(COPYRIGHT_FIELD_TEXT);
        if (comparer.isCopyrightTextsEqual()) {
            this.setCellEqualValue(copyrightRow.createCell(1));
        } else {
            this.setCellDifferentValue(copyrightRow.createCell(1));
        }
        Row summaryRow = this.addRow();
        summaryRow.createCell(0).setCellValue(SUMMARY_FIELD_TEXT);
        if (comparer.isPackageSummariesEqual()) {
            this.setCellEqualValue(summaryRow.createCell(1));
        } else {
            this.setCellDifferentValue(summaryRow.createCell(1));
        }
        Row descriptionRow = this.addRow();
        descriptionRow.createCell(0).setCellValue(DESCRIPTION_FIELD_TEXT);
        if (comparer.isPackageDescriptionsEqual()) {
            this.setCellEqualValue(descriptionRow.createCell(1));
        } else {
            this.setCellDifferentValue(descriptionRow.createCell(1));
        }
        for (int i = 0; i < docNames.length; ++i) {
            Cell headerCell = header.getCell(2 + i);
            headerCell.setCellValue(docNames[i]);
            SPDXDocument.SPDXPackage pkg = comparer.getSpdxDoc(i).getSpdxPackage();
            packageNameRow.createCell(2 + i).setCellValue(pkg.getDeclaredName());
            versionRow.createCell(2 + i).setCellValue(pkg.getVersionInfo());
            fileNameRow.createCell(2 + i).setCellValue(pkg.getFileName());
            supplierRow.createCell(2 + i).setCellValue(pkg.getSupplier());
            originatorRow.createCell(2 + i).setCellValue(pkg.getOriginator());
            homePageRow.createCell(2 + i).setCellValue(pkg.getHomePage());
            downloadRow.createCell(2 + i).setCellValue(pkg.getDownloadUrl());
            verificationRow.createCell(2 + i).setCellValue(pkg.getVerificationCode().getValue());
            verificationExcludedRow.createCell(2 + i).setCellValue(this.exludeFilesToString(pkg.getVerificationCode().getExcludedFileNames()));
            checksumRow.createCell(2 + i).setCellValue(pkg.getSha1());
            sourceInfoRow.createCell(2 + i).setCellValue(pkg.getSourceInfo());
            concludedLicenseRow.createCell(2 + i).setCellValue(pkg.getConcludedLicenses().toString());
            licenseInfosFromFilesRow.createCell(2 + i).setCellValue(this.licenseInfosToString(pkg.getLicenseInfoFromFiles()));
            declaredLicenseRow.createCell(2 + i).setCellValue(pkg.getDeclaredLicense().toString());
            licenseCommentRow.createCell(2 + i).setCellValue(pkg.getLicenseComment());
            copyrightRow.createCell(2 + i).setCellValue(pkg.getDeclaredCopyright());
            summaryRow.createCell(2 + i).setCellValue(pkg.getShortDescription());
            descriptionRow.createCell(2 + i).setCellValue(pkg.getDescription());
        }
    }

    protected String licenseInfosToString(SPDXLicenseInfo[] licenseInfoFromFiles) {
        if (licenseInfoFromFiles == null || licenseInfoFromFiles.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(licenseInfoFromFiles[0].toString());
        for (int i = 1; i < licenseInfoFromFiles.length; ++i) {
            sb.append(", ");
            sb.append(licenseInfoFromFiles[i].toString());
        }
        return sb.toString();
    }

    protected String exludeFilesToString(String[] excludedFileNames) {
        if (excludedFileNames == null || excludedFileNames.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(excludedFileNames[0]);
        for (int i = 1; i < excludedFileNames.length; ++i) {
            sb.append(", ");
            sb.append(excludedFileNames[i]);
        }
        return sb.toString();
    }

    private void setCellDifferentValue(Cell cell) {
        cell.setCellValue(DIFFERENT_STRING);
        cell.setCellStyle(this.yellowWrapped);
    }

    private void setCellEqualValue(Cell cell) {
        cell.setCellValue(EQUAL_STRING);
        cell.setCellStyle(this.greenWrapped);
    }
}

