/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.compare;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.spdx.compare.LicenseCompareHelper;
import org.spdx.compare.SpdxCompareException;
import org.spdx.compare.SpdxFileComparer;
import org.spdx.compare.SpdxFileDifference;
import org.spdx.compare.SpdxLicenseDifference;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.SPDXCreatorInformation;
import org.spdx.rdfparser.SPDXDocument;
import org.spdx.rdfparser.SPDXFile;
import org.spdx.rdfparser.SPDXLicenseInfo;
import org.spdx.rdfparser.SPDXNonStandardLicense;
import org.spdx.rdfparser.SPDXReview;
import org.spdx.rdfparser.SPDXStandardLicense;
import org.spdx.rdfparser.SpdxPackageVerificationCode;

public class SpdxComparer {
    private SPDXDocument[] spdxDocs = null;
    private boolean differenceFound = false;
    private boolean compareInProgress = false;
    private boolean spdxVersionsEqual = true;
    private boolean documentCommentsEqual = true;
    private boolean dataLicenseEqual = true;
    private HashMap<SPDXDocument, HashMap<SPDXDocument, SPDXReview[]>> uniqueReviews = new HashMap();
    private HashMap<SPDXDocument, HashMap<SPDXDocument, SPDXReviewDifference[]>> reviewerDifferences = new HashMap();
    private HashMap<SPDXDocument, HashMap<SPDXDocument, SPDXNonStandardLicense[]>> uniqueExtractedLicenses = new HashMap();
    private HashMap<SPDXDocument, HashMap<SPDXDocument, SpdxLicenseDifference[]>> licenseDifferences = new HashMap();
    private HashMap<SPDXDocument, HashMap<SPDXDocument, HashMap<String, String>>> extractedLicenseIdMap = new HashMap();
    private boolean packagesEquals;
    private boolean packageNamesEquals;
    private boolean packageVersionsEquals;
    private boolean packageFilenamesEquals;
    private boolean packageSuppliersEquals;
    private boolean packageDownloadLocationsEquals;
    private boolean packageVerificationCodeesEquals;
    private boolean packageChecksumsEquals;
    private boolean packageSourceInfosEquals;
    private boolean concludedLicennsesEquals;
    private boolean licenseInfoFromFilesEquals;
    private boolean declaredLicennsesEquals;
    private boolean licenseCommentsEquals;
    private boolean packageCopyrightsEquals;
    private boolean packageSummaryEquals;
    private boolean packageDescriptionsEquals;
    private boolean packageOriginatorsEqual;
    private boolean creatorInformationEquals;
    private HashMap<SPDXDocument, HashMap<SPDXDocument, String[]>> uniqueCreators = new HashMap();
    private HashMap<SPDXDocument, HashMap<SPDXDocument, SPDXFile[]>> uniqueFiles = new HashMap();
    private HashMap<SPDXDocument, HashMap<SPDXDocument, SpdxFileDifference[]>> fileDifferences = new HashMap();
    private Comparator<SPDXFile> fileSortByNameComaprator = new FileByNameComparator();
    private SpdxFileComparer fileComparer = new SpdxFileComparer();
    private boolean packageHomePagesEquals;
    private boolean licenseListVersionEquals;

    public synchronized void compare(SPDXDocument doc1, SPDXDocument doc2) throws InvalidSPDXAnalysisException, SpdxCompareException {
        this.compare(new SPDXDocument[]{doc1, doc2});
    }

    public void compare(SPDXDocument[] compareDocs) throws InvalidSPDXAnalysisException, SpdxCompareException {
        this.clearCompareResults();
        this.spdxDocs = compareDocs;
        this.differenceFound = false;
        this.performCompare();
    }

    private void performCompare() throws InvalidSPDXAnalysisException, SpdxCompareException {
        this.compareInProgress = true;
        this.differenceFound = false;
        this.compareExtractedLicenseInfos();
        this.compareDocumentFields();
        this.compareFiles();
        this.comparePackages();
        this.compareReviewers();
        this.compareCreators();
        this.compareInProgress = false;
    }

    private void compareFiles() throws InvalidSPDXAnalysisException, SpdxCompareException {
        this.uniqueFiles.clear();
        this.fileDifferences.clear();
        for (int i = 0; i < this.spdxDocs.length; ++i) {
            HashMap<SPDXDocument, Object> diffMap;
            SPDXFile[] filesA = this.spdxDocs[i].getSpdxPackage().getFiles();
            Arrays.sort(filesA, this.fileSortByNameComaprator);
            HashMap<SPDXDocument, Object> uniqueAMap = this.uniqueFiles.get(this.spdxDocs[i]);
            if (uniqueAMap == null) {
                uniqueAMap = new HashMap();
            }
            if ((diffMap = this.fileDifferences.get(this.spdxDocs[i])) == null) {
                diffMap = new HashMap();
            }
            for (int j = 0; j < this.spdxDocs.length; ++j) {
                HashMap<String, String> licenseIdMap;
                SpdxFileDifference[] differences;
                if (j == i) continue;
                SPDXFile[] filesB = this.spdxDocs[j].getSpdxPackage().getFiles();
                Arrays.sort(filesB, this.fileSortByNameComaprator);
                SPDXFile[] uniqueAB = this.findUniqueFiles(filesA, filesB);
                if (uniqueAB != null && uniqueAB.length > 0) {
                    uniqueAMap.put(this.spdxDocs[j], uniqueAB);
                }
                if ((differences = this.findFileDifferences(filesA, filesB, licenseIdMap = this.extractedLicenseIdMap.get(this.spdxDocs[i]).get(this.spdxDocs[j]))) == null || differences.length <= 0) continue;
                diffMap.put(this.spdxDocs[j], differences);
            }
            if (!uniqueAMap.isEmpty()) {
                this.uniqueFiles.put(this.spdxDocs[i], uniqueAMap);
            }
            if (diffMap.isEmpty()) continue;
            this.fileDifferences.put(this.spdxDocs[i], diffMap);
        }
        if (!this._isFilesEqualsNoCheck()) {
            this.differenceFound = true;
        }
    }

    private SpdxFileDifference[] findFileDifferences(SPDXFile[] filesA, SPDXFile[] filesB, HashMap<String, String> licenseIdXlationMap) throws SpdxCompareException {
        ArrayList<SpdxFileDifference> alRetval = new ArrayList<SpdxFileDifference>();
        int aIndex = 0;
        int bIndex = 0;
        while (aIndex < filesA.length && bIndex < filesB.length) {
            int compare = filesA[aIndex].getName().compareTo(filesB[bIndex].getName());
            if (compare == 0) {
                this.fileComparer.compare(filesA[aIndex], filesB[bIndex], licenseIdXlationMap);
                if (this.fileComparer.isDifferenceFound()) {
                    alRetval.add(this.fileComparer.getFileDifference());
                }
                ++aIndex;
                ++bIndex;
                continue;
            }
            if (compare > 0) {
                ++bIndex;
                continue;
            }
            ++aIndex;
        }
        SpdxFileDifference[] retval = alRetval.toArray(new SpdxFileDifference[alRetval.size()]);
        return retval;
    }

    private SPDXFile[] findUniqueFiles(SPDXFile[] filesA, SPDXFile[] filesB) {
        int bIndex = 0;
        int aIndex = 0;
        ArrayList<SPDXFile> alRetval = new ArrayList<SPDXFile>();
        while (aIndex < filesA.length) {
            if (bIndex >= filesB.length) {
                alRetval.add(filesA[aIndex]);
                ++aIndex;
                continue;
            }
            int compareVal = filesA[aIndex].getName().compareTo(filesB[bIndex].getName());
            if (compareVal == 0) {
                ++aIndex;
                ++bIndex;
                continue;
            }
            if (compareVal > 0) {
                ++bIndex;
                continue;
            }
            alRetval.add(filesA[aIndex]);
            ++aIndex;
        }
        SPDXFile[] retval = alRetval.toArray(new SPDXFile[alRetval.size()]);
        return retval;
    }

    private void compareCreators() throws InvalidSPDXAnalysisException {
        this.creatorInformationEquals = true;
        this.licenseListVersionEquals = true;
        for (int i = 0; i < this.spdxDocs.length; ++i) {
            SPDXCreatorInformation creatorInfoA = this.spdxDocs[i].getCreatorInfo();
            String[] creatorsA = creatorInfoA.getCreators();
            HashMap<SPDXDocument, Object> uniqueAMap = this.uniqueCreators.get(this.spdxDocs[i]);
            if (uniqueAMap == null) {
                uniqueAMap = new HashMap();
            }
            for (int j = 0; j < this.spdxDocs.length; ++j) {
                if (j == i) continue;
                SPDXCreatorInformation creatorInfoB = this.spdxDocs[j].getCreatorInfo();
                String[] creatorsB = creatorInfoB.getCreators();
                String[] uniqueA = this.findUniqueString(creatorsA, creatorsB);
                if (uniqueA != null && uniqueA.length > 0) {
                    uniqueAMap.put(this.spdxDocs[j], uniqueA);
                }
                if (!SpdxComparer.stringsEqual(creatorInfoA.getComment(), creatorInfoB.getComment())) {
                    this.creatorInformationEquals = false;
                }
                if (!SpdxComparer.stringsEqual(creatorInfoA.getCreated(), creatorInfoB.getCreated())) {
                    this.creatorInformationEquals = false;
                }
                if (SpdxComparer.stringsEqual(creatorInfoA.getLicenseListVersion(), creatorInfoB.getLicenseListVersion())) continue;
                this.creatorInformationEquals = false;
                this.licenseListVersionEquals = false;
            }
            if (uniqueAMap.keySet().size() <= 0) continue;
            this.uniqueCreators.put(this.spdxDocs[i], uniqueAMap);
            this.creatorInformationEquals = false;
        }
        if (!this.creatorInformationEquals) {
            this.differenceFound = true;
        }
    }

    private String[] findUniqueString(String[] stringsA, String[] stringsB) {
        if (stringsA == null) {
            return new String[0];
        }
        if (stringsB == null) {
            return Arrays.copyOf(stringsA, stringsA.length);
        }
        ArrayList<String> al = new ArrayList<String>();
        for (int i = 0; i < stringsA.length; ++i) {
            boolean found = false;
            for (int j = 0; j < stringsB.length; ++j) {
                if (!stringsA[i].trim().equals(stringsB[j].trim())) continue;
                found = true;
                break;
            }
            if (found) continue;
            al.add(stringsA[i]);
        }
        return al.toArray(new String[al.size()]);
    }

    private void comparePackages() throws SpdxCompareException {
        this.packagesEquals = true;
        this.packageNamesEquals = true;
        this.packageVersionsEquals = true;
        this.packageFilenamesEquals = true;
        this.packageSuppliersEquals = true;
        this.packageOriginatorsEqual = true;
        this.packageDownloadLocationsEquals = true;
        this.packageVerificationCodeesEquals = true;
        this.packageChecksumsEquals = true;
        this.packageSourceInfosEquals = true;
        this.concludedLicennsesEquals = true;
        this.licenseInfoFromFilesEquals = true;
        this.declaredLicennsesEquals = true;
        this.licenseCommentsEquals = true;
        this.packageCopyrightsEquals = true;
        this.packageSummaryEquals = true;
        this.packageDescriptionsEquals = true;
        this.packageHomePagesEquals = true;
        if (this.spdxDocs == null || this.spdxDocs.length < 1) {
            return;
        }
        SPDXDocument.SPDXPackage pkg1 = null;
        SPDXDocument doc1 = this.spdxDocs[0];
        try {
            pkg1 = doc1.getSpdxPackage();
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new SpdxCompareException("Error getting SPDX package: " + e.getMessage(), e);
        }
        if (pkg1 == null) {
            throw new SpdxCompareException("Invalid SPDX Document - no SPDX package");
        }
        for (int i = 1; i < this.spdxDocs.length; ++i) {
            SPDXDocument doc2 = this.spdxDocs[i];
            SPDXDocument.SPDXPackage pkg2 = null;
            try {
                pkg2 = doc2.getSpdxPackage();
            }
            catch (InvalidSPDXAnalysisException e) {
                throw new SpdxCompareException("Invalid SPDX Document - no SPDX package");
            }
            if (pkg2 == null) {
                throw new SpdxCompareException("Invalid SPDX Document - no SPDX package");
            }
            try {
                if (!SpdxComparer.stringsEqual(pkg1.getDeclaredName(), pkg2.getDeclaredName())) {
                    this.packageNamesEquals = false;
                    this.packagesEquals = false;
                    this.differenceFound = true;
                }
            }
            catch (InvalidSPDXAnalysisException e) {
                throw new SpdxCompareException("SPDX error getting package names: " + e.getMessage(), e);
            }
            try {
                if (!SpdxComparer.stringsEqual(pkg1.getVersionInfo(), pkg2.getVersionInfo())) {
                    this.packageVersionsEquals = false;
                    this.packagesEquals = false;
                    this.differenceFound = true;
                }
            }
            catch (InvalidSPDXAnalysisException e) {
                throw new SpdxCompareException("SPDX error getting package versions: " + e.getMessage(), e);
            }
            try {
                if (!SpdxComparer.stringsEqual(pkg1.getFileName(), pkg2.getFileName())) {
                    this.packageFilenamesEquals = false;
                    this.packagesEquals = false;
                    this.differenceFound = true;
                }
            }
            catch (InvalidSPDXAnalysisException e) {
                throw new SpdxCompareException("SPDX error getting package file names: " + e.getMessage(), e);
            }
            try {
                if (!SpdxComparer.stringsEqual(pkg1.getSupplier(), pkg2.getSupplier())) {
                    this.packageSuppliersEquals = false;
                    this.packagesEquals = false;
                    this.differenceFound = true;
                }
            }
            catch (InvalidSPDXAnalysisException e) {
                throw new SpdxCompareException("SPDX error getting package suppliers: " + e.getMessage(), e);
            }
            try {
                if (!SpdxComparer.stringsEqual(pkg1.getOriginator(), pkg2.getOriginator())) {
                    this.packageOriginatorsEqual = false;
                    this.packagesEquals = false;
                    this.differenceFound = true;
                }
            }
            catch (InvalidSPDXAnalysisException e) {
                throw new SpdxCompareException("SPDX error getting package originators: " + e.getMessage(), e);
            }
            try {
                if (!SpdxComparer.stringsEqual(pkg1.getDownloadUrl(), pkg2.getDownloadUrl())) {
                    this.packageDownloadLocationsEquals = false;
                    this.packagesEquals = false;
                    this.differenceFound = true;
                }
            }
            catch (InvalidSPDXAnalysisException e) {
                throw new SpdxCompareException("SPDX error getting package download locations: " + e.getMessage(), e);
            }
            try {
                if (!SpdxComparer.stringsEqual(pkg1.getHomePage(), pkg2.getHomePage())) {
                    this.packageHomePagesEquals = false;
                    this.packagesEquals = false;
                    this.differenceFound = true;
                }
            }
            catch (InvalidSPDXAnalysisException e) {
                throw new SpdxCompareException("SPDX error getting package home page: " + e.getMessage(), e);
            }
            try {
                if (!this.compareVerificationCodes(pkg1.getVerificationCode(), pkg2.getVerificationCode())) {
                    this.packageVerificationCodeesEquals = false;
                    this.packagesEquals = false;
                    this.differenceFound = true;
                }
            }
            catch (InvalidSPDXAnalysisException e) {
                throw new SpdxCompareException("SPDX error getting package verification codes: " + e.getMessage(), e);
            }
            try {
                if (!SpdxComparer.stringsEqual(pkg1.getSha1(), pkg2.getSha1())) {
                    this.packageChecksumsEquals = false;
                    this.packagesEquals = false;
                    this.differenceFound = true;
                }
            }
            catch (InvalidSPDXAnalysisException e) {
                throw new SpdxCompareException("SPDX error getting package checksums: " + e.getMessage(), e);
            }
            try {
                if (!SpdxComparer.stringsEqual(pkg1.getSourceInfo(), pkg2.getSourceInfo())) {
                    this.packageSourceInfosEquals = false;
                    this.packagesEquals = false;
                    this.differenceFound = true;
                }
            }
            catch (InvalidSPDXAnalysisException e) {
                throw new SpdxCompareException("SPDX error getting package source information: " + e.getMessage(), e);
            }
            try {
                if (!this.compareLicense(0, pkg1.getConcludedLicenses(), i, pkg2.getConcludedLicenses())) {
                    this.concludedLicennsesEquals = false;
                    this.packagesEquals = false;
                    this.differenceFound = true;
                }
            }
            catch (InvalidSPDXAnalysisException e) {
                throw new SpdxCompareException("SPDX error getting concluded license: " + e.getMessage(), e);
            }
            try {
                if (!this.compareLicenseInfoFromFiles(0, pkg1.getLicenseInfoFromFiles(), i, pkg2.getLicenseInfoFromFiles())) {
                    this.licenseInfoFromFilesEquals = false;
                    this.packagesEquals = false;
                    this.differenceFound = true;
                }
            }
            catch (InvalidSPDXAnalysisException e) {
                throw new SpdxCompareException("SPDX error getting license info from files: " + e.getMessage(), e);
            }
            try {
                if (!this.compareLicense(0, pkg1.getDeclaredLicense(), i, pkg2.getDeclaredLicense())) {
                    this.declaredLicennsesEquals = false;
                    this.packagesEquals = false;
                    this.differenceFound = true;
                }
            }
            catch (InvalidSPDXAnalysisException e) {
                throw new SpdxCompareException("SPDX error getting declared license: " + e.getMessage(), e);
            }
            try {
                if (!SpdxComparer.stringsEqual(pkg1.getLicenseComment(), pkg2.getLicenseComment())) {
                    this.licenseCommentsEquals = false;
                    this.packagesEquals = false;
                    this.differenceFound = true;
                }
            }
            catch (InvalidSPDXAnalysisException e) {
                throw new SpdxCompareException("SPDX error getting license comments: " + e.getMessage(), e);
            }
            try {
                if (!SpdxComparer.stringsEqual(pkg1.getDeclaredCopyright(), pkg2.getDeclaredCopyright())) {
                    this.packageCopyrightsEquals = false;
                    this.packagesEquals = false;
                    this.differenceFound = true;
                }
            }
            catch (InvalidSPDXAnalysisException e) {
                throw new SpdxCompareException("SPDX error getting package copyrights: " + e.getMessage(), e);
            }
            try {
                if (!SpdxComparer.stringsEqual(pkg1.getShortDescription(), pkg2.getShortDescription())) {
                    this.packageSummaryEquals = false;
                    this.packagesEquals = false;
                    this.differenceFound = true;
                }
            }
            catch (InvalidSPDXAnalysisException e) {
                throw new SpdxCompareException("SPDX error getting package summary descriptions: " + e.getMessage(), e);
            }
            try {
                if (SpdxComparer.stringsEqual(pkg1.getDescription(), pkg2.getDescription())) continue;
                this.packageDescriptionsEquals = false;
                this.packagesEquals = false;
                this.differenceFound = true;
                continue;
            }
            catch (InvalidSPDXAnalysisException e) {
                throw new SpdxCompareException("SPDX error getting package descriptions: " + e.getMessage(), e);
            }
        }
    }

    private boolean compareLicenseInfoFromFiles(int doc1, SPDXLicenseInfo[] licenseInfoFromFiles, int doc2, SPDXLicenseInfo[] licenseInfoFromFiles2) throws SpdxCompareException {
        this.checkDocsIndex(doc1);
        this.checkDocsIndex(doc2);
        if (licenseInfoFromFiles.length != licenseInfoFromFiles2.length) {
            return false;
        }
        HashMap<SPDXDocument, HashMap<String, String>> hm = this.extractedLicenseIdMap.get(this.spdxDocs[doc1]);
        if (hm == null) {
            throw new SpdxCompareException("Compare License Error - Extracted license id map has not been initialized.");
        }
        HashMap<String, String> xlationMap = hm.get(this.spdxDocs[doc2]);
        if (xlationMap == null) {
            throw new SpdxCompareException("Compare License Exception - Extracted license id map has not been initialized.");
        }
        for (int i = 0; i < licenseInfoFromFiles.length; ++i) {
            boolean found = false;
            for (int j = 0; j < licenseInfoFromFiles2.length; ++j) {
                if (!LicenseCompareHelper.isLicenseEqual(licenseInfoFromFiles[i], licenseInfoFromFiles2[j], xlationMap)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public boolean compareLicense(int doc1, SPDXLicenseInfo license1, int doc2, SPDXLicenseInfo license2) throws SpdxCompareException {
        this.checkDocsIndex(doc1);
        this.checkDocsIndex(doc2);
        HashMap<SPDXDocument, HashMap<String, String>> hm = this.extractedLicenseIdMap.get(this.spdxDocs[doc1]);
        if (hm == null) {
            throw new SpdxCompareException("Compare License Error - Extracted license id map has not been initialized.");
        }
        HashMap<String, String> xlationMap = hm.get(this.spdxDocs[doc2]);
        if (xlationMap == null) {
            throw new SpdxCompareException("Compare License Exception - Extracted license id map has not been initialized.");
        }
        return LicenseCompareHelper.isLicenseEqual(license1, license2, xlationMap);
    }

    private boolean compareVerificationCodes(SpdxPackageVerificationCode verificationCode, SpdxPackageVerificationCode verificationCode2) {
        if (!SpdxComparer.stringsEqual(verificationCode.getValue(), verificationCode2.getValue())) {
            return false;
        }
        return SpdxComparer.stringArraysEqual(verificationCode.getExcludedFileNames(), verificationCode2.getExcludedFileNames());
    }

    private void compareDocumentFields() throws SpdxCompareException {
        this.compareDataLicense();
        this.compareDocumentComments();
        this.compareSpdxVerions();
        if (!(this.dataLicenseEqual && this.spdxVersionsEqual && this.documentCommentsEqual)) {
            this.differenceFound = true;
        }
    }

    private void compareSpdxVerions() throws SpdxCompareException {
        String docVer1;
        try {
            docVer1 = this.spdxDocs[0].getSpdxVersion();
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new SpdxCompareException("SPDX analysis error during compare SPDX Version: " + e.getMessage(), e);
        }
        this.spdxVersionsEqual = true;
        for (int i = 1; i < this.spdxDocs.length; ++i) {
            try {
                if (this.spdxDocs[i].getSpdxVersion().equals(docVer1)) continue;
                this.spdxVersionsEqual = false;
                break;
            }
            catch (InvalidSPDXAnalysisException e) {
                throw new SpdxCompareException("SPDX analysis error during compare: " + e.getMessage(), e);
            }
        }
    }

    private void compareDocumentComments() throws SpdxCompareException {
        try {
            String comment1 = this.spdxDocs[0].getDocumentComment();
            this.documentCommentsEqual = true;
            for (int i = 1; i < this.spdxDocs.length; ++i) {
                String comment2 = this.spdxDocs[i].getDocumentComment();
                if (SpdxComparer.stringsEqual(comment1, comment2)) continue;
                this.documentCommentsEqual = false;
                break;
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new SpdxCompareException("SPDX analysis error during compare document comments: " + e.getMessage(), e);
        }
    }

    private void compareDataLicense() throws SpdxCompareException {
        try {
            SPDXStandardLicense lic1 = this.spdxDocs[0].getDataLicense();
            this.dataLicenseEqual = true;
            for (int i = 1; i < this.spdxDocs.length; ++i) {
                if (lic1.equals(this.spdxDocs[i].getDataLicense())) continue;
                this.dataLicenseEqual = false;
                break;
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new SpdxCompareException("SPDX analysis error during compare data license: " + e.getMessage(), e);
        }
    }

    private void compareExtractedLicenseInfos() throws InvalidSPDXAnalysisException, SpdxCompareException {
        for (int i = 0; i < this.spdxDocs.length; ++i) {
            SPDXNonStandardLicense[] extractedLicensesA = this.spdxDocs[i].getExtractedLicenseInfos();
            HashMap<SPDXDocument, SPDXNonStandardLicense[]> uniqueMap = new HashMap<SPDXDocument, SPDXNonStandardLicense[]>();
            HashMap<SPDXDocument, SpdxLicenseDifference[]> differenceMap = new HashMap<SPDXDocument, SpdxLicenseDifference[]>();
            HashMap<SPDXDocument, HashMap<String, String>> licenseIdMap = new HashMap<SPDXDocument, HashMap<String, String>>();
            for (int j = 0; j < this.spdxDocs.length; ++j) {
                if (i == j) continue;
                HashMap<String, String> idMap = new HashMap<String, String>();
                ArrayList<SpdxLicenseDifference> alDifferences = new ArrayList<SpdxLicenseDifference>();
                SPDXNonStandardLicense[] extractedLicensesB = this.spdxDocs[j].getExtractedLicenseInfos();
                ArrayList<SPDXNonStandardLicense> uniqueLicenses = new ArrayList<SPDXNonStandardLicense>();
                this.compareLicenses(extractedLicensesA, extractedLicensesB, idMap, alDifferences, uniqueLicenses);
                if (uniqueLicenses.size() > 0) {
                    uniqueMap.put(this.spdxDocs[j], uniqueLicenses.toArray(new SPDXNonStandardLicense[uniqueLicenses.size()]));
                }
                if (alDifferences.size() > 0) {
                    differenceMap.put(this.spdxDocs[j], alDifferences.toArray(new SpdxLicenseDifference[alDifferences.size()]));
                }
                licenseIdMap.put(this.spdxDocs[j], idMap);
            }
            if (uniqueMap.keySet().size() > 0) {
                this.uniqueExtractedLicenses.put(this.spdxDocs[i], uniqueMap);
            }
            if (differenceMap.keySet().size() > 0) {
                this.licenseDifferences.put(this.spdxDocs[i], differenceMap);
            }
            this.extractedLicenseIdMap.put(this.spdxDocs[i], licenseIdMap);
        }
        if (!this._isExtractedLicensingInfoEqualsNoCheck()) {
            this.differenceFound = true;
        }
    }

    private void compareLicenses(SPDXNonStandardLicense[] extractedLicensesA, SPDXNonStandardLicense[] extractedLicensesB, HashMap<String, String> idMap, ArrayList<SpdxLicenseDifference> alDifferences, ArrayList<SPDXNonStandardLicense> uniqueLicenses) {
        idMap.clear();
        alDifferences.clear();
        uniqueLicenses.clear();
        for (int k = 0; k < extractedLicensesA.length; ++k) {
            boolean foundMatch = false;
            boolean foundTextMatch = false;
            for (int q = 0; q < extractedLicensesB.length; ++q) {
                if (!LicenseCompareHelper.isLicenseTextEquivalent(extractedLicensesA[k].getText(), extractedLicensesB[q].getText())) continue;
                foundTextMatch = true;
                if (!foundMatch) {
                    idMap.put(extractedLicensesA[k].getId(), extractedLicensesB[q].getId());
                }
                if (this.nonTextLicenseFieldsEqual(extractedLicensesA[k], extractedLicensesB[q])) {
                    foundMatch = true;
                    continue;
                }
                alDifferences.add(new SpdxLicenseDifference(extractedLicensesA[k], extractedLicensesB[q]));
            }
            if (foundTextMatch) continue;
            uniqueLicenses.add(extractedLicensesA[k]);
        }
    }

    private boolean nonTextLicenseFieldsEqual(SPDXNonStandardLicense spdxNonStandardLicenseA, SPDXNonStandardLicense spdxNonStandardLicenseB) {
        if (!SpdxComparer.stringsEqual(spdxNonStandardLicenseA.getLicenseName(), spdxNonStandardLicenseB.getLicenseName())) {
            return false;
        }
        if (!SpdxComparer.stringsEqual(spdxNonStandardLicenseA.getComment(), spdxNonStandardLicenseB.getComment())) {
            return false;
        }
        return SpdxComparer.stringArraysEqual(spdxNonStandardLicenseA.getSourceUrls(), spdxNonStandardLicenseB.getSourceUrls());
    }

    static boolean stringArraysEqual(String[] stringsA, String[] stringsB) {
        if (stringsA == null) {
            if (stringsB != null) {
                return false;
            }
        } else {
            if (stringsB == null) {
                return false;
            }
            if (stringsA.length != stringsB.length) {
                return false;
            }
            for (int i = 0; i < stringsA.length; ++i) {
                boolean found = false;
                for (int j = 0; j < stringsB.length; ++j) {
                    if (!SpdxComparer.stringsEqual(stringsA[i], stringsB[j])) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean stringsEqual(String stringA, String stringB) {
        String compA = stringA == null ? "" : stringA.trim();
        String compB = stringB == null ? "" : stringB.trim();
        return compA.equals(compB);
    }

    public static int compareStrings(String stringA, String stringB) {
        if (stringA == null) {
            return -1;
        }
        if (stringB == null) {
            return 1;
        }
        return stringA.trim().compareTo(stringB.trim());
    }

    private void compareReviewers() throws InvalidSPDXAnalysisException, SpdxCompareException {
        for (int i = 0; i < this.spdxDocs.length; ++i) {
            HashMap<SPDXDocument, Object> diffMap;
            SPDXReview[] reviewA = this.spdxDocs[i].getReviewers();
            HashMap<SPDXDocument, Object> uniqueAMap = this.uniqueReviews.get(this.spdxDocs[i]);
            if (uniqueAMap == null) {
                uniqueAMap = new HashMap();
            }
            if ((diffMap = this.reviewerDifferences.get(this.spdxDocs[i])) == null) {
                diffMap = new HashMap();
            }
            for (int j = 0; j < this.spdxDocs.length; ++j) {
                SPDXReviewDifference[] reviewerDifferences;
                if (j == i) continue;
                SPDXReview[] reviewB = this.spdxDocs[j].getReviewers();
                SPDXReview[] uniqueA = this.findUniqueReviewers(reviewA, reviewB);
                if (uniqueA != null && uniqueA.length > 0) {
                    uniqueAMap.put(this.spdxDocs[j], uniqueA);
                }
                if ((reviewerDifferences = this.findReviewerDifferences(reviewA, reviewB)) == null || reviewerDifferences.length <= 0) continue;
                diffMap.put(this.spdxDocs[j], reviewerDifferences);
            }
            if (uniqueAMap.keySet().size() > 0) {
                this.uniqueReviews.put(this.spdxDocs[i], uniqueAMap);
            }
            if (diffMap.keySet().size() <= 0) continue;
            this.reviewerDifferences.put(this.spdxDocs[i], diffMap);
        }
        if (!this._isReviewersEqualNoCheck()) {
            this.differenceFound = true;
        }
    }

    private SPDXReviewDifference[] findReviewerDifferences(SPDXReview[] reviewA, SPDXReview[] reviewB) {
        ArrayList<SPDXReviewDifference> retval = new ArrayList<SPDXReviewDifference>();
        for (int i = 0; i < reviewA.length; ++i) {
            boolean reviewDifferent = false;
            int differentReviewerIndex = -1;
            for (int j = 0; j < reviewB.length; ++j) {
                if (!reviewA[i].getReviewer().trim().equals(reviewB[j].getReviewer().trim())) continue;
                boolean commentsEqual = reviewA[i].getComment().trim().equals(reviewB[j].getComment().trim());
                boolean datesEqual = reviewA[i].getReviewDate().equals(reviewB[j].getReviewDate());
                if (commentsEqual && datesEqual) {
                    reviewDifferent = false;
                    break;
                }
                reviewDifferent = true;
                differentReviewerIndex = j;
            }
            if (!reviewDifferent) continue;
            retval.add(new SPDXReviewDifference(reviewA[i], reviewB[differentReviewerIndex]));
        }
        return retval.toArray(new SPDXReviewDifference[retval.size()]);
    }

    private SPDXReview[] findUniqueReviewers(SPDXReview[] reviewA, SPDXReview[] reviewB) {
        ArrayList<SPDXReview> retval = new ArrayList<SPDXReview>();
        for (int i = 0; i < reviewA.length; ++i) {
            boolean found = false;
            for (int j = 0; j < reviewB.length; ++j) {
                if (!reviewA[i].getReviewer().trim().equals(reviewB[j].getReviewer().trim())) continue;
                found = true;
                break;
            }
            if (found) continue;
            retval.add(reviewA[i]);
        }
        return retval.toArray(new SPDXReview[retval.size()]);
    }

    private void clearCompareResults() {
        this.differenceFound = false;
        this.reviewerDifferences.clear();
        this.uniqueReviews.clear();
        this.licenseDifferences.clear();
        this.uniqueExtractedLicenses.clear();
        this.extractedLicenseIdMap.clear();
        this.uniqueCreators.clear();
    }

    public boolean isDifferenceFound() {
        return this.differenceFound;
    }

    public boolean isSpdxVersionEqual() throws SpdxCompareException {
        this.checkInProgress();
        this.checkDocsField();
        return this.spdxVersionsEqual;
    }

    private void checkInProgress() throws SpdxCompareException {
        if (this.compareInProgress) {
            throw new SpdxCompareException("Compare in progress - can not obtain compare results until compare has completed");
        }
    }

    private void checkDocsField() throws SpdxCompareException {
        if (this.spdxDocs == null) {
            throw new SpdxCompareException("No compare has been performed");
        }
        if (this.spdxDocs.length < 2) {
            throw new SpdxCompareException("Insufficient documents compared - must provide at least 2 SPDX documents");
        }
    }

    private void checkDocsIndex(int index) throws SpdxCompareException {
        if (this.spdxDocs == null) {
            throw new SpdxCompareException("No compare has been performed");
        }
        if (index < 0) {
            throw new SpdxCompareException("Invalid index for SPDX document compare - must be greater than or equal to zero");
        }
        if (index >= this.spdxDocs.length) {
            throw new SpdxCompareException("Invalid index for SPDX document compare - SPDX document index " + String.valueOf(index) + " does not exist.");
        }
    }

    public SPDXDocument getSpdxDoc(int docIndex) throws SpdxCompareException {
        this.checkDocsField();
        if (this.spdxDocs == null) {
            return null;
        }
        if (docIndex < 0) {
            return null;
        }
        if (docIndex > this.spdxDocs.length) {
            return null;
        }
        return this.spdxDocs[docIndex];
    }

    public boolean isDataLicenseEqual() throws SpdxCompareException {
        this.checkInProgress();
        this.checkDocsField();
        return this.dataLicenseEqual;
    }

    public boolean isDocumentCommentsEqual() throws SpdxCompareException {
        this.checkInProgress();
        this.checkDocsField();
        return this.documentCommentsEqual;
    }

    public boolean isReviewersEqual() throws SpdxCompareException {
        this.checkInProgress();
        this.checkDocsField();
        return this._isReviewersEqualNoCheck();
    }

    private boolean _isReviewersEqualNoCheck() {
        Iterator<Map.Entry<SPDXDocument, Object[]>> entryIter;
        for (Map.Entry<SPDXDocument, HashMap<SPDXDocument, SPDXReview[]>> entry : this.uniqueReviews.entrySet()) {
            entryIter = entry.getValue().entrySet().iterator();
            while (entryIter.hasNext()) {
                SPDXReview[] val = entryIter.next().getValue();
                if (val == null || val.length <= 0) continue;
                return false;
            }
        }
        Iterator<Map.Entry<SPDXDocument, HashMap<SPDXDocument, SPDXReviewDifference[]>>> diffIter = this.reviewerDifferences.entrySet().iterator();
        while (diffIter.hasNext()) {
            entryIter = diffIter.next().getValue().entrySet().iterator();
            while (entryIter.hasNext()) {
                SPDXReviewDifference[] reviewDifferences = (SPDXReviewDifference[])entryIter.next().getValue();
                if (reviewDifferences == null || reviewDifferences.length <= 0) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isExtractedLicensingInfosEqual() throws SpdxCompareException {
        this.checkInProgress();
        this.checkDocsField();
        return this._isExtractedLicensingInfoEqualsNoCheck();
    }

    private boolean _isExtractedLicensingInfoEqualsNoCheck() {
        Iterator<Map.Entry<SPDXDocument, Object[]>> entryIter;
        for (Map.Entry<SPDXDocument, HashMap<SPDXDocument, SPDXNonStandardLicense[]>> entry : this.uniqueExtractedLicenses.entrySet()) {
            entryIter = entry.getValue().entrySet().iterator();
            while (entryIter.hasNext()) {
                SPDXNonStandardLicense[] licenses = entryIter.next().getValue();
                if (licenses == null || licenses.length <= 0) continue;
                return false;
            }
        }
        Iterator<Map.Entry<SPDXDocument, HashMap<SPDXDocument, SpdxLicenseDifference[]>>> diffIterator = this.licenseDifferences.entrySet().iterator();
        while (diffIterator.hasNext()) {
            entryIter = diffIterator.next().getValue().entrySet().iterator();
            while (entryIter.hasNext()) {
                SpdxLicenseDifference[] differences = (SpdxLicenseDifference[])entryIter.next().getValue();
                if (differences == null || differences.length <= 0) continue;
                return false;
            }
        }
        return true;
    }

    public SPDXReview[] getUniqueReviewers(int docindex1, int docindex2) throws SpdxCompareException {
        this.checkDocsField();
        this.checkInProgress();
        this.checkDocsIndex(docindex1);
        this.checkDocsIndex(docindex2);
        HashMap<SPDXDocument, SPDXReview[]> uniques = this.uniqueReviews.get(this.spdxDocs[docindex1]);
        if (uniques != null) {
            SPDXReview[] retval = uniques.get(this.spdxDocs[docindex2]);
            if (retval != null) {
                return retval;
            }
            return new SPDXReview[0];
        }
        return new SPDXReview[0];
    }

    public SPDXReviewDifference[] getReviewerDifferences(int docindex1, int docindex2) throws SpdxCompareException {
        this.checkDocsField();
        this.checkInProgress();
        this.checkDocsIndex(docindex1);
        this.checkDocsIndex(docindex2);
        HashMap<SPDXDocument, SPDXReviewDifference[]> doc1Differences = this.reviewerDifferences.get(this.spdxDocs[docindex1]);
        if (doc1Differences == null) {
            return new SPDXReviewDifference[0];
        }
        SPDXReviewDifference[] retval = doc1Differences.get(this.spdxDocs[docindex2]);
        if (retval == null) {
            return new SPDXReviewDifference[0];
        }
        return retval;
    }

    public SPDXNonStandardLicense[] getUniqueExtractedLicenses(int docIndexA, int docIndexB) throws SpdxCompareException {
        this.checkDocsField();
        this.checkInProgress();
        this.checkDocsIndex(docIndexA);
        this.checkDocsIndex(docIndexB);
        HashMap<SPDXDocument, SPDXNonStandardLicense[]> uniques = this.uniqueExtractedLicenses.get(this.spdxDocs[docIndexA]);
        if (uniques != null) {
            SPDXNonStandardLicense[] retval = uniques.get(this.spdxDocs[docIndexB]);
            if (retval != null) {
                return retval;
            }
            return new SPDXNonStandardLicense[0];
        }
        return new SPDXNonStandardLicense[0];
    }

    public SpdxLicenseDifference[] getExtractedLicenseDifferences(int docIndexA, int docIndexB) throws SpdxCompareException {
        this.checkDocsField();
        this.checkInProgress();
        this.checkDocsIndex(docIndexA);
        this.checkDocsIndex(docIndexB);
        HashMap<SPDXDocument, SpdxLicenseDifference[]> differences = this.licenseDifferences.get(this.spdxDocs[docIndexA]);
        if (differences != null) {
            SpdxLicenseDifference[] retval = differences.get(this.spdxDocs[docIndexB]);
            if (retval != null) {
                return retval;
            }
            return new SpdxLicenseDifference[0];
        }
        return new SpdxLicenseDifference[0];
    }

    public boolean isPackageEqual() throws SpdxCompareException {
        this.checkDocsField();
        this.checkInProgress();
        return this.packagesEquals;
    }

    public boolean isPackageNamesEqual() throws SpdxCompareException {
        this.checkDocsField();
        this.checkInProgress();
        return this.packageNamesEquals;
    }

    public boolean isPackageVersionsEqual() throws SpdxCompareException {
        this.checkDocsField();
        this.checkInProgress();
        return this.packageVersionsEquals;
    }

    public boolean isPackageLicenseInfoFromFilesEqual() throws SpdxCompareException {
        this.checkDocsField();
        this.checkInProgress();
        return this.licenseInfoFromFilesEquals;
    }

    public boolean isPackageFileNamesEqual() throws SpdxCompareException {
        this.checkDocsField();
        this.checkInProgress();
        return this.packageFilenamesEquals;
    }

    public boolean isPackageSuppliersEqual() throws SpdxCompareException {
        this.checkDocsField();
        this.checkInProgress();
        return this.packageSuppliersEquals;
    }

    public boolean isPackageOriginatorsEqual() throws SpdxCompareException {
        this.checkDocsField();
        this.checkInProgress();
        return this.packageOriginatorsEqual;
    }

    public boolean isPackageDownloadLocationsEqual() throws SpdxCompareException {
        this.checkDocsField();
        this.checkInProgress();
        return this.packageDownloadLocationsEquals;
    }

    public boolean isPackageVerificationCodesEqual() throws SpdxCompareException {
        this.checkDocsField();
        this.checkInProgress();
        return this.packageVerificationCodeesEquals;
    }

    public boolean isPackageChecksumsEqual() throws SpdxCompareException {
        this.checkDocsField();
        this.checkInProgress();
        return this.packageChecksumsEquals;
    }

    public boolean isSourceInformationEqual() throws SpdxCompareException {
        this.checkDocsField();
        this.checkInProgress();
        return this.packageSourceInfosEquals;
    }

    public boolean isPackageDeclaredLicensesEqual() throws SpdxCompareException {
        this.checkDocsField();
        this.checkInProgress();
        return this.declaredLicennsesEquals;
    }

    public boolean isPackageConcludedLicensesEqual() throws SpdxCompareException {
        this.checkDocsField();
        this.checkInProgress();
        return this.concludedLicennsesEquals;
    }

    public boolean isLicenseCommentsEqual() throws SpdxCompareException {
        this.checkDocsField();
        this.checkInProgress();
        return this.licenseCommentsEquals;
    }

    public boolean isCopyrightTextsEqual() throws SpdxCompareException {
        this.checkDocsField();
        this.checkInProgress();
        return this.packageCopyrightsEquals;
    }

    public boolean isPackageSummariesEqual() throws SpdxCompareException {
        this.checkDocsField();
        this.checkInProgress();
        return this.packageSummaryEquals;
    }

    public boolean isPackageDescriptionsEqual() throws SpdxCompareException {
        this.checkDocsField();
        this.checkInProgress();
        return this.packageDescriptionsEquals;
    }

    public boolean isCreatorInformationEqual() throws SpdxCompareException {
        this.checkDocsField();
        this.checkInProgress();
        return this.creatorInformationEquals;
    }

    public String[] getUniqueCreators(int doc1index, int doc2index) throws SpdxCompareException {
        this.checkDocsField();
        this.checkInProgress();
        HashMap<SPDXDocument, String[]> uniques = this.uniqueCreators.get(this.getSpdxDoc(doc1index));
        if (uniques == null) {
            return new String[0];
        }
        String[] retval = uniques.get(this.getSpdxDoc(doc2index));
        if (retval == null) {
            return new String[0];
        }
        return retval;
    }

    public boolean isfilesEquals() throws SpdxCompareException {
        this.checkDocsField();
        this.checkInProgress();
        return this._isFilesEqualsNoCheck();
    }

    private boolean _isFilesEqualsNoCheck() {
        if (!this.uniqueFiles.isEmpty()) {
            return false;
        }
        return this.fileDifferences.isEmpty();
    }

    public SPDXFile[] getUniqueFiles(int docindex1, int docindex2) throws SpdxCompareException {
        this.checkDocsField();
        this.checkInProgress();
        this.checkDocsIndex(docindex1);
        this.checkDocsIndex(docindex2);
        HashMap<SPDXDocument, SPDXFile[]> uniqueMap = this.uniqueFiles.get(this.spdxDocs[docindex1]);
        if (uniqueMap == null) {
            return new SPDXFile[0];
        }
        SPDXFile[] retval = uniqueMap.get(this.spdxDocs[docindex2]);
        if (retval == null) {
            return new SPDXFile[0];
        }
        return retval;
    }

    public SpdxFileDifference[] getFileDifferences(int docindex1, int docindex2) throws SpdxCompareException {
        this.checkDocsField();
        this.checkInProgress();
        this.checkDocsIndex(docindex1);
        this.checkDocsIndex(docindex2);
        HashMap<SPDXDocument, SpdxFileDifference[]> uniqueMap = this.fileDifferences.get(this.spdxDocs[docindex1]);
        if (uniqueMap == null) {
            return new SpdxFileDifference[0];
        }
        SpdxFileDifference[] retval = uniqueMap.get(this.spdxDocs[docindex2]);
        if (retval == null) {
            return new SpdxFileDifference[0];
        }
        return retval;
    }

    public int getNumSpdxDocs() {
        return this.spdxDocs.length;
    }

    public boolean ispackageHomePagesEqual() throws SpdxCompareException {
        this.checkDocsField();
        this.checkInProgress();
        return this.packageHomePagesEquals;
    }

    public boolean isLicenseListVersionEqual() throws SpdxCompareException {
        this.checkDocsField();
        this.checkInProgress();
        return this.licenseListVersionEquals;
    }

    class FileByNameComparator
    implements Comparator<SPDXFile> {
        FileByNameComparator() {
        }

        @Override
        public int compare(SPDXFile arg0, SPDXFile arg1) {
            return arg0.getName().compareTo(arg1.getName());
        }
    }

    public class SPDXReviewDifference {
        boolean commentsEqual;
        boolean datesEqual;
        String comment1;
        String comment2;
        String date1;
        String date2;
        String reviewer;

        public SPDXReviewDifference(SPDXReview spdxReview, SPDXReview spdxReview2) {
            this.commentsEqual = spdxReview.getComment().trim().equals(spdxReview2.getComment().trim());
            this.datesEqual = spdxReview.getReviewDate().equals(spdxReview2.getReviewDate());
            this.comment1 = spdxReview.getComment();
            this.comment2 = spdxReview2.getComment();
            this.date1 = spdxReview.getReviewDate();
            this.date2 = spdxReview2.getReviewDate();
            this.reviewer = spdxReview.getReviewer();
        }

        public boolean isDateEqual() {
            return this.datesEqual;
        }

        public String getReviewer() {
            return this.reviewer;
        }

        public String getDate(int i) throws SpdxCompareException {
            if (i == 0) {
                return this.date1;
            }
            if (i == 1) {
                return this.date2;
            }
            throw new SpdxCompareException("Invalid index for get reviewer date");
        }

        public boolean isCommentEqual() {
            return this.commentsEqual;
        }

        public String getComment(int i) throws SpdxCompareException {
            if (i == 0) {
                return this.comment1;
            }
            if (i == 1) {
                return this.comment2;
            }
            throw new SpdxCompareException("Invalid index for get reviewer date");
        }
    }
}

