/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.compare;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import org.spdx.compare.LicenseCompareHelper;
import org.spdx.compare.SpdxCompareException;
import org.spdx.compare.SpdxComparer;
import org.spdx.compare.SpdxFileDifference;
import org.spdx.rdfparser.DOAPProject;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.SPDXFile;
import org.spdx.rdfparser.SPDXLicenseInfo;

public class SpdxFileComparer {
    private boolean inProgress = false;
    private SPDXFile fileA = null;
    private SPDXFile fileB = null;
    private boolean differenceFound = false;
    private boolean concludedLicenseEquals;
    private boolean seenLicenseEquals;
    private boolean artifactOfEquals;
    private boolean fileDependenciesEquals;
    private boolean contributorsEquals;
    private boolean noticeTextEquals;
    private SPDXLicenseInfo[] uniqueSeenLicensesB;
    private SPDXLicenseInfo[] uniqueSeenLicensesA;
    private DOAPProject[] uniqueArtifactOfA;
    private DOAPProject[] uniqueArtifactOfB;
    private Comparator<DOAPProject> doapComparer = new DoapComparator();
    private boolean commentsEquals;
    private boolean copyrightsEquals;
    private boolean licenseCommmentsEquals;
    private boolean namesEquals;
    private boolean checksumsEquals;
    private boolean typesEquals;

    public boolean isFileDependenciesEquals() {
        return this.fileDependenciesEquals;
    }

    public boolean isContributorsEquals() {
        return this.contributorsEquals;
    }

    public boolean isNoticeTextEquals() {
        return this.noticeTextEquals;
    }

    public void compare(SPDXFile fileA, SPDXFile fileB, HashMap<String, String> licenseXlationMap) throws SpdxCompareException {
        this.inProgress = true;
        this.differenceFound = false;
        this.fileA = fileA;
        this.fileB = fileB;
        this.compareArtifactOf(fileA.getArtifactOf(), fileB.getArtifactOf());
        if (SpdxComparer.stringsEqual(fileA.getComment(), fileB.getComment())) {
            this.commentsEquals = true;
        } else {
            this.commentsEquals = false;
            this.differenceFound = true;
        }
        if (LicenseCompareHelper.isLicenseEqual(fileA.getConcludedLicenses(), fileB.getConcludedLicenses(), licenseXlationMap)) {
            this.concludedLicenseEquals = true;
        } else {
            this.concludedLicenseEquals = false;
            this.differenceFound = true;
        }
        if (SpdxComparer.stringsEqual(fileA.getCopyright(), fileB.getCopyright())) {
            this.copyrightsEquals = true;
        } else {
            this.copyrightsEquals = false;
            this.differenceFound = true;
        }
        if (SpdxComparer.stringsEqual(fileA.getLicenseComments(), fileB.getLicenseComments())) {
            this.licenseCommmentsEquals = true;
        } else {
            this.licenseCommmentsEquals = false;
            this.differenceFound = true;
        }
        if (SpdxComparer.stringsEqual(fileA.getName(), fileB.getName())) {
            this.namesEquals = true;
        } else {
            this.namesEquals = false;
            this.differenceFound = true;
        }
        this.compareSeenLicenses(fileA.getSeenLicenses(), fileB.getSeenLicenses(), licenseXlationMap);
        if (SpdxComparer.stringsEqual(fileA.getSha1(), fileB.getSha1())) {
            this.checksumsEquals = true;
        } else {
            this.checksumsEquals = false;
            this.differenceFound = true;
        }
        if (SpdxComparer.stringsEqual(fileA.getType(), fileB.getType())) {
            this.typesEquals = true;
        } else {
            this.typesEquals = false;
            this.differenceFound = true;
        }
        if (SpdxComparer.stringArraysEqual(fileA.getContributors(), fileB.getContributors())) {
            this.contributorsEquals = true;
        } else {
            this.contributorsEquals = false;
            this.differenceFound = true;
        }
        if (SpdxComparer.stringsEqual(fileA.getNoticeText(), fileB.getNoticeText())) {
            this.noticeTextEquals = true;
        } else {
            this.noticeTextEquals = false;
            this.differenceFound = true;
        }
        if (this.fileNamesEquals(fileA.getFileDependencies(), fileB.getFileDependencies())) {
            this.fileDependenciesEquals = true;
        } else {
            this.fileDependenciesEquals = false;
            this.differenceFound = true;
        }
        this.inProgress = false;
    }

    private boolean fileNamesEquals(SPDXFile[] filesA, SPDXFile[] filesB) {
        String[] fileNamesA = SpdxFileComparer.filesToFileNames(filesA);
        String[] fileNamesB = SpdxFileComparer.filesToFileNames(filesB);
        return SpdxComparer.stringArraysEqual(fileNamesA, fileNamesB);
    }

    public static String[] filesToFileNames(SPDXFile[] files) {
        if (files == null) {
            return null;
        }
        String[] retval = new String[files.length];
        for (int i = 0; i < files.length; ++i) {
            retval[i] = files[i].getName();
        }
        return retval;
    }

    private void compareSeenLicenses(SPDXLicenseInfo[] licensesA, SPDXLicenseInfo[] licensesB, HashMap<String, String> licenseXlationMap) throws SpdxCompareException {
        int j;
        boolean found;
        int i;
        ArrayList<SPDXLicenseInfo> alUniqueA = new ArrayList<SPDXLicenseInfo>();
        ArrayList<SPDXLicenseInfo> alUniqueB = new ArrayList<SPDXLicenseInfo>();
        for (i = 0; i < licensesA.length; ++i) {
            found = false;
            for (j = 0; j < licensesB.length; ++j) {
                if (!LicenseCompareHelper.isLicenseEqual(licensesA[i], licensesB[j], licenseXlationMap)) continue;
                found = true;
                break;
            }
            if (found) continue;
            alUniqueA.add(licensesA[i]);
        }
        for (i = 0; i < licensesB.length; ++i) {
            found = false;
            for (j = 0; j < licensesA.length; ++j) {
                if (!LicenseCompareHelper.isLicenseEqual(licensesA[j], licensesB[i], licenseXlationMap)) continue;
                found = true;
                break;
            }
            if (found) continue;
            alUniqueB.add(licensesB[i]);
        }
        this.uniqueSeenLicensesA = alUniqueA.toArray(new SPDXLicenseInfo[alUniqueA.size()]);
        this.uniqueSeenLicensesB = alUniqueB.toArray(new SPDXLicenseInfo[alUniqueB.size()]);
        if (this.uniqueSeenLicensesA.length == 0 && this.uniqueSeenLicensesB.length == 0) {
            this.seenLicenseEquals = true;
        } else {
            this.seenLicenseEquals = false;
            this.differenceFound = true;
        }
    }

    public SPDXFile getFileA() {
        return this.fileA;
    }

    public SPDXFile getFileB() {
        return this.fileB;
    }

    public boolean isConcludedLicenseEquals() {
        return this.concludedLicenseEquals;
    }

    public boolean isSeenLicenseEquals() {
        return this.seenLicenseEquals;
    }

    public boolean isArtifactOfEquals() {
        return this.artifactOfEquals;
    }

    public SPDXLicenseInfo[] getUniqueSeenLicensesB() {
        return this.uniqueSeenLicensesB;
    }

    public SPDXLicenseInfo[] getUniqueSeenLicensesA() {
        return this.uniqueSeenLicensesA;
    }

    public DOAPProject[] getUniqueArtifactOfA() {
        return this.uniqueArtifactOfA;
    }

    public DOAPProject[] getUniqueArtifactOfB() {
        return this.uniqueArtifactOfB;
    }

    public boolean isCommentsEquals() {
        return this.commentsEquals;
    }

    public boolean isCopyrightsEquals() {
        return this.copyrightsEquals;
    }

    public boolean isLicenseCommmentsEquals() {
        return this.licenseCommmentsEquals;
    }

    public boolean isNamesEquals() {
        return this.namesEquals;
    }

    public boolean isChecksumsEquals() {
        return this.checksumsEquals;
    }

    public boolean isTypesEquals() {
        return this.typesEquals;
    }

    private void compareArtifactOf(DOAPProject[] artifactOfA, DOAPProject[] artifactOfB) {
        Arrays.sort(artifactOfA, this.doapComparer);
        Arrays.sort(artifactOfB, this.doapComparer);
        int aIndex = 0;
        int bIndex = 0;
        ArrayList<DOAPProject> alUniqueA = new ArrayList<DOAPProject>();
        ArrayList<DOAPProject> alUniqueB = new ArrayList<DOAPProject>();
        while (aIndex < artifactOfA.length || bIndex < artifactOfB.length) {
            if (aIndex >= artifactOfA.length) {
                alUniqueB.add(artifactOfB[bIndex]);
                ++bIndex;
                continue;
            }
            if (bIndex >= artifactOfB.length) {
                alUniqueA.add(artifactOfA[aIndex]);
                ++aIndex;
                continue;
            }
            int compare = this.doapComparer.compare(artifactOfA[aIndex], artifactOfB[bIndex]);
            if (compare == 0) {
                ++aIndex;
                ++bIndex;
                continue;
            }
            if (compare > 0) {
                alUniqueB.add(artifactOfB[bIndex]);
                ++bIndex;
                continue;
            }
            alUniqueA.add(artifactOfA[aIndex]);
            ++aIndex;
        }
        this.uniqueArtifactOfA = alUniqueA.toArray(new DOAPProject[alUniqueA.size()]);
        this.uniqueArtifactOfB = alUniqueB.toArray(new DOAPProject[alUniqueB.size()]);
        if (this.uniqueArtifactOfA.length > 0 || this.uniqueArtifactOfB.length > 0) {
            this.differenceFound = true;
            this.artifactOfEquals = false;
        } else {
            this.artifactOfEquals = true;
        }
    }

    private void checkInProgress() throws SpdxCompareException {
        if (this.inProgress) {
            throw new SpdxCompareException("File compare in progress - can not obtain compare results until compare has completed");
        }
    }

    private void checkCompareMade() throws SpdxCompareException {
        if (this.fileA == null || this.fileB == null) {
            throw new SpdxCompareException("Trying to obgain results of a file compare before a file compare has been performed");
        }
    }

    public boolean isDifferenceFound() throws SpdxCompareException {
        this.checkInProgress();
        this.checkCompareMade();
        return this.differenceFound;
    }

    public SpdxFileDifference getFileDifference() throws SpdxCompareException {
        this.checkInProgress();
        this.checkCompareMade();
        if (!this.fileA.getName().equals(this.fileB.getName())) {
            throw new SpdxCompareException("Can not create an SPDX file difference for two files with different names");
        }
        try {
            return new SpdxFileDifference(this.fileA, this.fileB, this.concludedLicenseEquals, this.seenLicenseEquals, this.uniqueSeenLicensesA, this.uniqueSeenLicensesB, this.artifactOfEquals, this.uniqueArtifactOfA, this.uniqueArtifactOfB);
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new SpdxCompareException("Error reading SPDX file propoerties: " + e.getMessage(), e);
        }
    }

    class DoapComparator
    implements Comparator<DOAPProject> {
        DoapComparator() {
        }

        @Override
        public int compare(DOAPProject arg0, DOAPProject arg1) {
            int retval = SpdxComparer.compareStrings(arg0.getName(), arg1.getName());
            if (retval == 0) {
                retval = SpdxComparer.compareStrings(arg0.getHomePage(), arg1.getHomePage());
            }
            if (retval == 0) {
                retval = SpdxComparer.compareStrings(arg0.getProjectUri(), arg1.getProjectUri());
            }
            return retval;
        }
    }
}

