/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.compare;

import org.spdx.compare.SpdxComparer;
import org.spdx.compare.SpdxFileComparer;
import org.spdx.rdfparser.DOAPProject;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.SPDXFile;
import org.spdx.rdfparser.SPDXLicenseInfo;

public class SpdxFileDifference {
    private String fileName;
    private String commentA;
    private String commentB;
    private String concludedLicenseA;
    private String concludedLicenseB;
    private boolean concludedLicenseEquals;
    private DOAPProject[] artifactsOfA;
    private DOAPProject[] artifactsOfB;
    private String copyrightA;
    private String copyrightB;
    private String licenseCommentsA;
    private String licenseCommentsB;
    private boolean seenLicensesEqual;
    private SPDXLicenseInfo[] uniqueSeenLicensesA;
    private SPDXLicenseInfo[] uniqueSeenLicensesB;
    private boolean artifactOfsEquals;
    private DOAPProject[] uniqueArtifactOfA;
    private DOAPProject[] uniqueArtifactOfB;
    private String sha1A;
    private String sha1B;
    private String fileTypeA;
    private String fileTypeB;
    private String[] contributorsA;
    private String noticeA;
    private String[] contributorsB;
    private String noticeB;
    private String[] dependantFileNamesA;
    private String[] dependantFileNamesB;

    public String getFileName() {
        return this.fileName;
    }

    public String getCommentA() {
        return this.commentA;
    }

    public String getCommentB() {
        return this.commentB;
    }

    public String getConcludedLicenseA() {
        return this.concludedLicenseA;
    }

    public String getConcludedLicenseB() {
        return this.concludedLicenseB;
    }

    public boolean isConcludedLicenseEquals() {
        return this.concludedLicenseEquals;
    }

    public DOAPProject[] getArtifactsOfA() {
        return this.artifactsOfA;
    }

    public DOAPProject[] getArtifactsOfB() {
        return this.artifactsOfB;
    }

    public String getCopyrightA() {
        return this.copyrightA;
    }

    public String getCopyrightB() {
        return this.copyrightB;
    }

    public String getLicenseCommentsA() {
        return this.licenseCommentsA;
    }

    public String getLicenseCommentsB() {
        return this.licenseCommentsB;
    }

    public boolean isSeenLicensesEqual() {
        return this.seenLicensesEqual;
    }

    public SPDXLicenseInfo[] getUniqueSeenLicensesA() {
        return this.uniqueSeenLicensesA;
    }

    public SPDXLicenseInfo[] getUniqueSeenLicensesB() {
        return this.uniqueSeenLicensesB;
    }

    public boolean isArtifactOfsEquals() {
        return this.artifactOfsEquals;
    }

    public DOAPProject[] getUniqueArtifactOfA() {
        return this.uniqueArtifactOfA;
    }

    public DOAPProject[] getUniqueArtifactOfB() {
        return this.uniqueArtifactOfB;
    }

    public String getSha1A() {
        return this.sha1A;
    }

    public String getSha1B() {
        return this.sha1B;
    }

    public String getFileTypeA() {
        return this.fileTypeA;
    }

    public String getFileTypeB() {
        return this.fileTypeB;
    }

    public SpdxFileDifference(SPDXFile fileA, SPDXFile fileB, boolean concludedLicensesEqual, boolean seenLicensesEqual, SPDXLicenseInfo[] uniqueSeenLicensesA, SPDXLicenseInfo[] uniqueSeenLicensesB, boolean artifactOfsEquals, DOAPProject[] uniqueArtifactOfA, DOAPProject[] uniqueArtifactOfB) throws InvalidSPDXAnalysisException {
        this.fileName = fileA.getName();
        this.artifactsOfA = fileA.getArtifactOf();
        if (this.artifactsOfA == null) {
            this.artifactsOfA = new DOAPProject[0];
        }
        this.artifactsOfB = fileB.getArtifactOf();
        if (this.artifactsOfB == null) {
            this.artifactsOfB = new DOAPProject[0];
        }
        this.commentA = fileA.getComment();
        if (this.commentA == null) {
            this.commentA = "";
        }
        this.commentB = fileB.getComment();
        if (this.commentB == null) {
            this.commentB = "";
        }
        this.concludedLicenseA = fileA.getConcludedLicenses().toString();
        this.concludedLicenseB = fileB.getConcludedLicenses().toString();
        this.concludedLicenseEquals = concludedLicensesEqual;
        this.copyrightA = fileA.getCopyright();
        if (this.copyrightA == null) {
            this.copyrightA = "";
        }
        this.copyrightB = fileB.getCopyright();
        if (this.copyrightB == null) {
            this.copyrightB = "";
        }
        this.licenseCommentsA = fileA.getLicenseComments();
        if (this.licenseCommentsA == null) {
            this.licenseCommentsA = "";
        }
        this.licenseCommentsB = fileB.getLicenseComments();
        if (this.licenseCommentsB == null) {
            this.licenseCommentsB = "";
        }
        this.seenLicensesEqual = seenLicensesEqual;
        this.uniqueSeenLicensesA = uniqueSeenLicensesA;
        this.uniqueSeenLicensesB = uniqueSeenLicensesB;
        this.artifactOfsEquals = artifactOfsEquals;
        this.uniqueArtifactOfA = uniqueArtifactOfA;
        this.uniqueArtifactOfB = uniqueArtifactOfB;
        this.sha1A = fileA.getSha1();
        this.sha1B = fileB.getSha1();
        this.fileTypeA = fileA.getType();
        this.fileTypeB = fileB.getType();
        this.contributorsA = fileA.getContributors();
        this.contributorsB = fileB.getContributors();
        this.noticeA = fileA.getNoticeText();
        this.noticeB = fileB.getNoticeText();
        this.dependantFileNamesA = SpdxFileComparer.filesToFileNames(fileA.getFileDependencies());
        this.dependantFileNamesB = SpdxFileComparer.filesToFileNames(fileB.getFileDependencies());
    }

    public boolean isContributorsEqual() {
        return SpdxComparer.stringArraysEqual(this.contributorsA, this.contributorsB);
    }

    public boolean isNoticeTextsEqual() {
        return SpdxComparer.stringsEqual(this.noticeA, this.noticeB);
    }

    public boolean isFileDependenciesEqual() {
        return SpdxComparer.stringArraysEqual(this.dependantFileNamesA, this.dependantFileNamesB);
    }

    public boolean isCommentsEqual() {
        return SpdxComparer.stringsEqual(this.commentA, this.commentB);
    }

    public boolean isCopyrightsEqual() {
        return SpdxComparer.stringsEqual(this.copyrightA, this.copyrightB);
    }

    public boolean isLicenseCommentsEqual() {
        return SpdxComparer.stringsEqual(this.licenseCommentsA, this.licenseCommentsB);
    }

    public boolean isTypeEqual() {
        return SpdxComparer.stringsEqual(this.fileTypeA, this.fileTypeB);
    }

    public boolean isChecksumsEqual() {
        return SpdxComparer.stringsEqual(this.sha1A, this.sha1B);
    }

    public String getContributorsAAsString() {
        return SpdxFileDifference.stringArrayToString(this.contributorsA);
    }

    public String getContributorsBAsString() {
        return SpdxFileDifference.stringArrayToString(this.contributorsB);
    }

    static String stringArrayToString(String[] s) {
        StringBuilder sb = new StringBuilder();
        if (s != null && s.length > 0) {
            sb.append(s[0]);
        }
        for (int i = 1; i < s.length; ++i) {
            sb.append(", ");
            sb.append(s[i]);
        }
        return sb.toString();
    }

    public String getFileDependenciesAAsString() {
        return SpdxFileDifference.stringArrayToString(this.dependantFileNamesA);
    }

    public String getFileDependenciesBAsString() {
        return SpdxFileDifference.stringArrayToString(this.dependantFileNamesB);
    }
}

