/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.html;

import java.util.ArrayList;
import java.util.List;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.SPDXCreatorInformation;
import org.spdx.rdfparser.SPDXDocument;

public class CreatorInfoContext {
    private SPDXDocument doc;

    public CreatorInfoContext(SPDXDocument doc) {
        this.doc = doc;
    }

    public String created() {
        try {
            return this.doc.getCreatorInfo().getCreated();
        }
        catch (InvalidSPDXAnalysisException e) {
            return "Error getting creator created date: " + e.getMessage();
        }
    }

    public String licenseListVersion() {
        String retval;
        try {
            retval = this.doc.getCreatorInfo().getLicenseListVersion();
        }
        catch (InvalidSPDXAnalysisException e) {
            return "Error getting license list version: " + e.getMessage();
        }
        if (retval == null) {
            retval = "";
        }
        return retval;
    }

    public List<String> creator() {
        ArrayList<String> creators = new ArrayList<String>();
        try {
            SPDXCreatorInformation creatorInfo = this.doc.getCreatorInfo();
            if (creatorInfo != null) {
                String[] creatorArray = creatorInfo.getCreators();
                for (int i = 0; i < creatorArray.length; ++i) {
                    creators.add(creatorArray[i]);
                }
            }
        }
        catch (InvalidSPDXAnalysisException ex) {
            creators.add("Error getting creators: " + ex.getMessage());
        }
        return creators;
    }

    public String comment() {
        try {
            if (this.doc.getCreatorInfo() != null) {
                return this.doc.getCreatorInfo().getComment();
            }
            return null;
        }
        catch (InvalidSPDXAnalysisException e) {
            return "Error getting creator comment: " + e.getMessage();
        }
    }
}

