/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.html;

import java.util.ArrayList;
import java.util.List;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.SPDXNonStandardLicense;

public class ExtractedLicensingInfoContext {
    private Exception error = null;
    private SPDXNonStandardLicense license = null;

    public ExtractedLicensingInfoContext(InvalidSPDXAnalysisException e) {
        this.error = e;
    }

    public ExtractedLicensingInfoContext(SPDXNonStandardLicense spdxNonStandardLicense) {
        this.license = spdxNonStandardLicense;
    }

    public String licenseId() {
        if (this.license == null && this.error != null) {
            return "Error getting non-standard license: " + this.error.getMessage();
        }
        if (this.license != null) {
            return this.license.getId();
        }
        return null;
    }

    public String extractedText() {
        if (this.license == null && this.error != null) {
            return "Error getting non-standard license: " + this.error.getMessage();
        }
        if (this.license != null) {
            return this.license.getText();
        }
        return null;
    }

    public String comment() {
        if (this.license == null && this.error != null) {
            return "Error getting non-standard license: " + this.error.getMessage();
        }
        if (this.license != null) {
            return this.license.getComment();
        }
        return null;
    }

    public String licenseName() {
        if (this.license == null && this.error != null) {
            return "Error getting non-standard license: " + this.error.getMessage();
        }
        if (this.license != null) {
            return this.license.getLicenseName();
        }
        return null;
    }

    public List<String> crossReferenceUrls() {
        ArrayList<String> retval = new ArrayList<String>();
        if (this.license != null) {
            String[] crossRefUrls = this.license.getSourceUrls();
            if (crossRefUrls != null) {
                for (int i = 0; i < crossRefUrls.length; ++i) {
                    retval.add(crossRefUrls[i]);
                }
            }
        } else if (this.error != null) {
            retval.add("Error getting extracted licensing info: " + this.error);
        }
        return retval;
    }
}

