/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.html;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.spdx.html.ProjectContext;
import org.spdx.rdfparser.DOAPProject;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.SPDXFile;
import org.spdx.rdfparser.SPDXLicenseInfo;

public class FileContext {
    SPDXFile spdxFile = null;
    Exception error = null;

    public FileContext(SPDXFile spdxFile) {
        this.spdxFile = spdxFile;
    }

    public FileContext(InvalidSPDXAnalysisException e) {
        this.error = null;
    }

    public String fileName() {
        if (this.spdxFile == null && this.error != null) {
            return "Error getting SPDX file information: " + this.error.getMessage();
        }
        if (this.spdxFile != null) {
            return this.spdxFile.getName();
        }
        return null;
    }

    public String fileType() {
        if (this.spdxFile == null && this.error != null) {
            return "Error getting SPDX file information: " + this.error.getMessage();
        }
        if (this.spdxFile != null) {
            return this.spdxFile.getType();
        }
        return null;
    }

    public String checksum() {
        if (this.spdxFile == null && this.error != null) {
            return "Error getting SPDX file information: " + this.error.getMessage();
        }
        if (this.spdxFile != null) {
            return this.spdxFile.getSha1();
        }
        return null;
    }

    public String licenseConcluded() {
        if (this.spdxFile == null && this.error != null) {
            return "Error getting SPDX file information: " + this.error.getMessage();
        }
        if (this.spdxFile != null) {
            return this.spdxFile.getConcludedLicenses().toString();
        }
        return null;
    }

    public String licenseComments() {
        if (this.spdxFile == null && this.error != null) {
            return "Error getting SPDX file information: " + this.error.getMessage();
        }
        if (this.spdxFile != null) {
            return this.spdxFile.getLicenseComments();
        }
        return null;
    }

    public List<String> licenseInfoInFile() {
        ArrayList<String> retval = new ArrayList<String>();
        if (this.spdxFile == null && this.error != null) {
            retval.add("Error getting SPDX file information: " + this.error.getMessage());
        }
        if (this.spdxFile != null) {
            SPDXLicenseInfo[] licenseInfos = this.spdxFile.getSeenLicenses();
            for (int i = 0; i < licenseInfos.length; ++i) {
                retval.add(licenseInfos[i].toString());
            }
        }
        return retval;
    }

    public String copyrightText() {
        if (this.spdxFile == null && this.error != null) {
            return "Error getting SPDX file information: " + this.error.getMessage();
        }
        if (this.spdxFile != null) {
            return this.spdxFile.getCopyright();
        }
        return null;
    }

    public List<ProjectContext> artifactOf() {
        DOAPProject[] projects;
        ArrayList<ProjectContext> retval = new ArrayList<ProjectContext>();
        if (this.spdxFile == null && this.error != null) {
            retval.add(new ProjectContext(this.error));
        }
        if (this.spdxFile != null && (projects = this.spdxFile.getArtifactOf()) != null) {
            for (int i = 0; i < projects.length; ++i) {
                retval.add(new ProjectContext(projects[i]));
            }
        }
        return retval;
    }

    public String comment() {
        if (this.spdxFile != null) {
            return this.spdxFile.getComment();
        }
        return null;
    }

    public String noticeText() {
        if (this.spdxFile != null) {
            return this.spdxFile.getNoticeText();
        }
        return null;
    }

    public List<String> contributors() {
        if (this.spdxFile == null || this.spdxFile.getContributors() == null) {
            return null;
        }
        return Arrays.asList(this.spdxFile.getContributors());
    }

    public List<String> fileDependencies() {
        if (this.spdxFile == null || this.spdxFile.getFileDependencies() == null) {
            return null;
        }
        ArrayList<String> retval = new ArrayList<String>();
        SPDXFile[] dep = this.spdxFile.getFileDependencies();
        for (int i = 0; i < dep.length; ++i) {
            retval.add(dep[i].getName());
        }
        return retval;
    }
}

