/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.html;

import java.util.ArrayList;
import java.util.HashMap;
import org.spdx.html.CreatorInfoContext;
import org.spdx.html.ExtractedLicensingInfoContext;
import org.spdx.html.PackageContext;
import org.spdx.html.ReviewerContext;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.SPDXDocument;
import org.spdx.rdfparser.SPDXNonStandardLicense;
import org.spdx.rdfparser.SPDXReview;
import org.spdx.rdfparser.SPDXStandardLicense;

public class MustacheMap {
    public static HashMap<String, Object> buildMustachMap(SPDXDocument doc) throws InvalidSPDXAnalysisException {
        HashMap<String, Object> retval = new HashMap<String, Object>();
        retval.put("specVersion", doc.getSpdxVersion());
        retval.put("dataLicense", MustacheMap.getDataLicenseName(doc));
        retval.put("creationInfo", new CreatorInfoContext(doc));
        retval.put("docComment", doc.getDocumentComment());
        retval.put("reviewed", MustacheMap.getReviewers(doc));
        retval.put("describesPackage", new PackageContext(doc));
        retval.put("hasExtractedLicensingInfo", MustacheMap.getExtractedLicensingInfo(doc));
        return retval;
    }

    private static ArrayList<ExtractedLicensingInfoContext> getExtractedLicensingInfo(SPDXDocument doc) {
        ArrayList<ExtractedLicensingInfoContext> retval = new ArrayList<ExtractedLicensingInfoContext>();
        try {
            SPDXNonStandardLicense[] extractedLicenseInfos = doc.getExtractedLicenseInfos();
            for (int i = 0; i < extractedLicenseInfos.length; ++i) {
                retval.add(new ExtractedLicensingInfoContext(extractedLicenseInfos[i]));
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add(new ExtractedLicensingInfoContext(e));
        }
        return retval;
    }

    private static ArrayList<ReviewerContext> getReviewers(SPDXDocument doc) {
        ArrayList<ReviewerContext> retval = new ArrayList<ReviewerContext>();
        try {
            SPDXReview[] reviewers = doc.getReviewers();
            if (reviewers != null) {
                for (int i = 0; i < reviewers.length; ++i) {
                    retval.add(new ReviewerContext(reviewers[i]));
                }
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add(new ReviewerContext(e));
        }
        return retval;
    }

    private static Object getDataLicenseName(SPDXDocument doc) throws InvalidSPDXAnalysisException {
        SPDXStandardLicense dataLicense = doc.getDataLicense();
        if (dataLicense != null) {
            return dataLicense.getName();
        }
        return "NONE";
    }
}

