/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.html;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.spdx.html.FileContext;
import org.spdx.html.VerificationCodeContext;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.SPDXDocument;
import org.spdx.rdfparser.SPDXFile;
import org.spdx.rdfparser.SPDXLicenseInfo;
import org.spdx.rdfparser.SpdxPackageVerificationCode;

public class PackageContext {
    private SPDXDocument.SPDXPackage pkg = null;

    public PackageContext(SPDXDocument doc) throws InvalidSPDXAnalysisException {
        this.pkg = doc.getSpdxPackage();
    }

    public String name() {
        if (this.pkg != null) {
            try {
                return this.pkg.getDeclaredName();
            }
            catch (InvalidSPDXAnalysisException e) {
                return "Error getting SPDX Package name: " + e.getMessage();
            }
        }
        return null;
    }

    public String versionInfo() {
        if (this.pkg != null) {
            try {
                return this.pkg.getVersionInfo();
            }
            catch (InvalidSPDXAnalysisException e) {
                return "Error getting SPDX Package version: " + e.getMessage();
            }
        }
        return null;
    }

    public String downloadLocation() {
        if (this.pkg != null) {
            try {
                return this.pkg.getDownloadUrl();
            }
            catch (InvalidSPDXAnalysisException e) {
                return "Error getting SPDX Package download URL: " + e.getMessage();
            }
        }
        return null;
    }

    public String summary() {
        if (this.pkg != null) {
            try {
                return this.pkg.getShortDescription();
            }
            catch (InvalidSPDXAnalysisException e) {
                return "Error getting SPDX Package summary: " + e.getMessage();
            }
        }
        return null;
    }

    public String sourceInfo() {
        if (this.pkg != null) {
            try {
                return this.pkg.getSourceInfo();
            }
            catch (InvalidSPDXAnalysisException e) {
                return "Error getting SPDX Package source info: " + e.getMessage();
            }
        }
        return null;
    }

    public String packageFileName() {
        if (this.pkg != null) {
            try {
                return this.pkg.getFileName();
            }
            catch (InvalidSPDXAnalysisException e) {
                return "Error getting SPDX Package file name: " + e.getMessage();
            }
        }
        return null;
    }

    public String supplier() {
        if (this.pkg != null) {
            try {
                return this.pkg.getSupplier();
            }
            catch (InvalidSPDXAnalysisException e) {
                return "Error getting SPDX Package supplier: " + e.getMessage();
            }
        }
        return null;
    }

    public String originator() {
        if (this.pkg != null) {
            try {
                return this.pkg.getOriginator();
            }
            catch (InvalidSPDXAnalysisException e) {
                return "Error getting SPDX Package originator: " + e.getMessage();
            }
        }
        return null;
    }

    public String description() {
        if (this.pkg != null) {
            try {
                return this.pkg.getDescription();
            }
            catch (InvalidSPDXAnalysisException e) {
                return "Error getting SPDX Package description: " + e.getMessage();
            }
        }
        return null;
    }

    public VerificationCodeContext packageVerificationCode() {
        if (this.pkg == null) {
            return null;
        }
        try {
            SpdxPackageVerificationCode verificationCode = this.pkg.getVerificationCode();
            if (verificationCode == null) {
                return null;
            }
            return new VerificationCodeContext(verificationCode);
        }
        catch (InvalidSPDXAnalysisException e) {
            return new VerificationCodeContext(e);
        }
    }

    public String checksum() {
        if (this.pkg != null) {
            try {
                return "SHA1: " + this.pkg.getSha1();
            }
            catch (InvalidSPDXAnalysisException e) {
                return "Error getting SPDX Package checksum: " + e.getMessage();
            }
        }
        return null;
    }

    public String copyrightText() {
        if (this.pkg != null) {
            try {
                return this.pkg.getDeclaredCopyright();
            }
            catch (InvalidSPDXAnalysisException e) {
                return "Error getting SPDX Package copyright: " + e.getMessage();
            }
        }
        return null;
    }

    public String licenseDeclared() {
        if (this.pkg != null) {
            try {
                SPDXLicenseInfo info = this.pkg.getDeclaredLicense();
                if (info != null) {
                    return info.toString();
                }
                return null;
            }
            catch (InvalidSPDXAnalysisException e) {
                return "Error getting SPDX Package copyright: " + e.getMessage();
            }
        }
        return null;
    }

    public String licenseConcluded() {
        if (this.pkg != null) {
            try {
                SPDXLicenseInfo info = this.pkg.getConcludedLicenses();
                if (info != null) {
                    return info.toString();
                }
                return null;
            }
            catch (InvalidSPDXAnalysisException e) {
                return "Error getting SPDX Package concluded license: " + e.getMessage();
            }
        }
        return null;
    }

    public String licenseComments() {
        if (this.pkg != null) {
            try {
                return this.pkg.getLicenseComment();
            }
            catch (InvalidSPDXAnalysisException e) {
                return "Error getting SPDX Package license comments: " + e.getMessage();
            }
        }
        return null;
    }

    public String homePage() {
        if (this.pkg != null) {
            try {
                return this.pkg.getHomePage();
            }
            catch (InvalidSPDXAnalysisException e) {
                return "Error getting SPDX Package hone page: " + e.getMessage();
            }
        }
        return null;
    }

    public List<String> licenseInfoFromFiles() {
        ArrayList<String> retval = new ArrayList<String>();
        if (this.pkg != null) {
            SPDXLicenseInfo[] licenseInfos = null;
            try {
                licenseInfos = this.pkg.getLicenseInfoFromFiles();
            }
            catch (InvalidSPDXAnalysisException e) {
                retval.add("Error geting license information from files: " + e.getMessage());
            }
            if (licenseInfos != null) {
                for (int i = 0; i < licenseInfos.length; ++i) {
                    retval.add(licenseInfos[i].toString());
                }
            }
        }
        Collections.sort(retval);
        return retval;
    }

    public List<FileContext> hasFile() {
        ArrayList<FileContext> retval = new ArrayList<FileContext>();
        if (this.pkg != null) {
            try {
                SPDXFile[] files = this.pkg.getFiles();
                if (files != null) {
                    for (int i = 0; i < files.length; ++i) {
                        retval.add(new FileContext(files[i]));
                    }
                }
            }
            catch (InvalidSPDXAnalysisException e) {
                retval.add(new FileContext(e));
            }
        }
        Collections.sort(retval, new Comparator<FileContext>(){

            @Override
            public int compare(FileContext o1, FileContext o2) {
                return o1.fileName().compareToIgnoreCase(o2.fileName());
            }
        });
        return retval;
    }
}

