/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.licenseTemplate;

import org.spdx.licenseTemplate.ILicenseTemplateOutputHandler;
import org.spdx.licenseTemplate.LicenseTemplateRule;
import org.spdx.licenseTemplate.SpdxLicenseTemplateHelper;

public class HtmlTemplateOutputHandler
implements ILicenseTemplateOutputHandler {
    public static final String REPLACEABLE_LICENSE_TEXT_CLASS = "replacable-license-text";
    public static final String OPTIONAL_LICENSE_TEXT_CLASS = "optional-license-text";
    private static final String STARTS_WITH_LETTER_REGEX = "[A-Za-z].*";
    StringBuilder htmlString = new StringBuilder();

    @Override
    public void optionalText(String text) {
        this.htmlString.append(text);
    }

    @Override
    public void normalText(String text) {
        this.htmlString.append(SpdxLicenseTemplateHelper.escapeHTML(text));
    }

    @Override
    public void variableRule(LicenseTemplateRule rule) {
        this.htmlString.append(HtmlTemplateOutputHandler.formatReplaceabledHTML(rule.getOriginal(), rule.getName()));
    }

    public static String formatReplaceabledHTML(String text, String id) {
        StringBuilder sb = new StringBuilder();
        sb.append("\n<div ");
        if (id != null && !id.trim().isEmpty()) {
            sb.append("id=\"");
            sb.append(HtmlTemplateOutputHandler.escapeIdString(id));
            sb.append("\" ");
        }
        sb.append("class=\"");
        sb.append(REPLACEABLE_LICENSE_TEXT_CLASS);
        sb.append("\">");
        sb.append(SpdxLicenseTemplateHelper.escapeHTML(text));
        sb.append("</div>\n");
        return sb.toString();
    }

    public static String escapeIdString(String id) {
        String retval = id;
        if (!retval.matches(STARTS_WITH_LETTER_REGEX)) {
            retval = "X" + retval;
        }
        for (int i = 0; i < retval.length(); ++i) {
            char c = retval.charAt(i);
            if (HtmlTemplateOutputHandler.validIdChar(c)) continue;
            retval = retval.replace(c, '_');
        }
        return retval;
    }

    private static boolean validIdChar(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '-' || c == '_' || c == '.';
    }

    public String getHtml() {
        return this.htmlString.toString();
    }

    @Override
    public void beginOptional(LicenseTemplateRule rule) {
        this.htmlString.append(HtmlTemplateOutputHandler.formatStartOptionalHTML(rule.getName()));
    }

    public static String formatStartOptionalHTML(String id) {
        StringBuilder sb = new StringBuilder();
        sb.append("\n<div ");
        if (id != null && !id.trim().isEmpty()) {
            sb.append("id=\"");
            sb.append(HtmlTemplateOutputHandler.escapeIdString(id));
            sb.append("\" ");
        }
        sb.append("class=\"");
        sb.append(OPTIONAL_LICENSE_TEXT_CLASS);
        sb.append("\">\n");
        return sb.toString();
    }

    public static String formatEndOptionalHTML() {
        return "</div>\n";
    }

    @Override
    public void endOptional(LicenseTemplateRule rule) {
        this.htmlString.append(HtmlTemplateOutputHandler.formatEndOptionalHTML());
    }
}

