/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.licenseTemplate;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringEscapeUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.spdx.licenseTemplate.HtmlTemplateOutputHandler;
import org.spdx.licenseTemplate.ILicenseTemplateOutputHandler;
import org.spdx.licenseTemplate.LicenseTemplateRule;
import org.spdx.licenseTemplate.LicenseTemplateRuleException;
import org.spdx.licenseTemplate.TextTemplateOutputHandler;

public class SpdxLicenseTemplateHelper {
    static final String START_RULE = "<<";
    static final String END_RULE = ">>";
    public static final Pattern RULE_PATTERN = Pattern.compile("<<\\s*(.+?)\\s*>>");
    private static final String FIVE_SPACES = "     ";

    public static void parseTemplate(String licenseTemplate, ILicenseTemplateOutputHandler templateOutputHandler) throws LicenseTemplateRuleException {
        Matcher ruleMatcher = RULE_PATTERN.matcher(licenseTemplate);
        int end = 0;
        boolean inOptional = false;
        while (ruleMatcher.find()) {
            String upToTheFind = licenseTemplate.substring(end, ruleMatcher.start());
            if (!upToTheFind.isEmpty()) {
                if (inOptional) {
                    templateOutputHandler.optionalText(upToTheFind);
                } else {
                    templateOutputHandler.normalText(upToTheFind);
                }
            }
            end = ruleMatcher.end();
            String ruleString = ruleMatcher.group(1);
            LicenseTemplateRule rule = new LicenseTemplateRule(ruleString);
            if (rule.getType() == LicenseTemplateRule.RuleType.VARIABLE) {
                templateOutputHandler.variableRule(rule);
                continue;
            }
            if (rule.getType() == LicenseTemplateRule.RuleType.BEGIN_OPTIONAL) {
                if (inOptional) {
                    throw new LicenseTemplateRuleException("Invalid nested optional rule found");
                }
                inOptional = true;
                templateOutputHandler.beginOptional(rule);
                continue;
            }
            if (rule.getType() == LicenseTemplateRule.RuleType.END_OPTIONAL) {
                if (inOptional) {
                    inOptional = false;
                    templateOutputHandler.endOptional(rule);
                    continue;
                }
                throw new LicenseTemplateRuleException("End optional rule found without a matching begin optional rule");
            }
            throw new LicenseTemplateRuleException("Unrecognized rule: " + rule.getType().toString());
        }
        if (inOptional) {
            throw new LicenseTemplateRuleException("Missing EndOptional rule");
        }
        String restOfTemplate = licenseTemplate.substring(end);
        if (!restOfTemplate.isEmpty()) {
            templateOutputHandler.normalText(restOfTemplate);
        }
    }

    public static String templateTextToHtml(String licenseTemplate) throws LicenseTemplateRuleException {
        HtmlTemplateOutputHandler htmlOutput = new HtmlTemplateOutputHandler();
        SpdxLicenseTemplateHelper.parseTemplate(licenseTemplate, htmlOutput);
        return htmlOutput.getHtml();
    }

    public static String templateToText(String template) throws LicenseTemplateRuleException {
        TextTemplateOutputHandler textOutput = new TextTemplateOutputHandler();
        SpdxLicenseTemplateHelper.parseTemplate(template, textOutput);
        return textOutput.getText();
    }

    public static String escapeHTML(String text) {
        String retval = StringEscapeUtils.escapeXml((String)text);
        return SpdxLicenseTemplateHelper.addHtmlFormatting(retval);
    }

    public static String addHtmlFormatting(String text) {
        String[] lines = text.split("\n");
        StringBuilder result = new StringBuilder();
        result.append(lines[0]);
        boolean inParagraph = false;
        int i = 1;
        while (i < lines.length) {
            if (lines[i].trim().isEmpty()) {
                if (inParagraph) {
                    result.append("</p>");
                }
                result.append("\n");
                if (++i < lines.length) {
                    if (lines[i].startsWith(FIVE_SPACES)) {
                        result.append("<p style=\"margin-left: 20px;\">");
                    } else {
                        result.append("<p>");
                    }
                    result.append(lines[i++]);
                } else {
                    result.append("<p>");
                }
                inParagraph = true;
                continue;
            }
            result.append("<br/>");
            result.append("\n");
            result.append(lines[i++]);
        }
        if (inParagraph) {
            result.append("</p>");
        } else if (text.endsWith("\n")) {
            result.append("<br/>\n");
        }
        return result.toString();
    }

    public static String HtmlToText(String html) {
        String newlineString = "NeWLineGoesHere";
        String replaceBrs = html.replaceAll("(?i)<br[^>]*>", newlineString);
        String replaceBrsAndPs = replaceBrs.replaceAll("(?i)<p[^>]*>", newlineString);
        Document doc = Jsoup.parse((String)replaceBrsAndPs);
        String retval = doc.text();
        retval = retval.replace(newlineString, "\n");
        return retval;
    }
}

