/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.rdfparser;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.spdx.licenseTemplate.LicenseTemplateRuleException;
import org.spdx.licenseTemplate.SpdxLicenseTemplateHelper;
import org.spdx.rdfparser.SPDXStandardLicense;

public class LicenseHTMLFile {
    static final boolean USE_SITE = false;
    static final String TITLE = "[TITLE]";
    static final String NAME = "[NAME]";
    static final String ID = "[LICENSEID]";
    static final String WEBURL = "[WEBURL]";
    static final String SITE = "[SITE]";
    static final String NOTES = "[NOTES]";
    static final String OTHERWEBPAGE = "[OTHERWEBPAGE]";
    static final String OTHER_WEB_PAGE_ROW = "\t\t\t\t<li><a href=\"[WEBURL]\" rel=\"rdfs:seeAlso\">[SITE]</a></li>\n";
    static final String LICENSE_TEXT = "[LICENSE_TEXT]";
    static final String TEMPLATE = "[LICENSE_TEMPLATE]";
    static final String HEADER = "[LICENSE_HEADER]";
    static final String OSI_APPROVED = "[OSI_APPROVED]";
    static final Pattern SITE_PATTERN = Pattern.compile("http://(.*)\\.(.*)(\\.org|\\.com|\\.net|\\.info)");
    private String template;
    private SPDXStandardLicense license;

    public LicenseHTMLFile(String template, SPDXStandardLicense license) {
        this.template = template;
        this.license = license;
    }

    public LicenseHTMLFile(String template) {
        this.template = template;
        this.license = null;
    }

    public SPDXStandardLicense getLicense() {
        return this.license;
    }

    public void setLicense(SPDXStandardLicense license) {
        this.license = license;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public String getTemplate() {
        return this.template;
    }

    public void writeToFile(File htmlFile, String tableOfContentsReference) throws IOException, LicenseTemplateRuleException {
        FileOutputStream stream = null;
        OutputStreamWriter writer = null;
        if (!htmlFile.exists() && !htmlFile.createNewFile()) {
            throw new IOException("Can not create new file " + htmlFile.getName());
        }
        try {
            String otherWebPages;
            String htmlText = this.template.replace(ID, SpdxLicenseTemplateHelper.escapeHTML(this.license.getId()));
            String licenseTextHtml = null;
            String licenseTemplateHtml = "";
            String templateText = this.license.getTemplate();
            if (templateText != null && !templateText.trim().isEmpty()) {
                licenseTextHtml = this.formatTemplateText(templateText);
                licenseTemplateHtml = SpdxLicenseTemplateHelper.escapeHTML(templateText);
            } else {
                licenseTextHtml = SpdxLicenseTemplateHelper.escapeHTML(this.license.getText());
            }
            htmlText = htmlText.replace(LICENSE_TEXT, licenseTextHtml);
            htmlText = htmlText.replace(TEMPLATE, licenseTemplateHtml);
            htmlText = htmlText.replace(NAME, SpdxLicenseTemplateHelper.escapeHTML(this.license.getName()));
            String notes = this.license.getComment() != null && !this.license.getComment().isEmpty() ? SpdxLicenseTemplateHelper.escapeHTML(this.license.getComment()) : "None";
            htmlText = htmlText.replace(NOTES, notes);
            String osiApproved = "false";
            if (this.license.isOsiApproved()) {
                osiApproved = "true";
            }
            htmlText = htmlText.replace(OSI_APPROVED, osiApproved);
            if (this.license.getSourceUrl() != null && this.license.getSourceUrl().length > 0) {
                StringBuilder sb = new StringBuilder();
                String[] sourceUrls = this.license.getSourceUrl();
                for (int i = 0; i < sourceUrls.length; ++i) {
                    String url = sourceUrls[i].trim();
                    if (url.isEmpty()) continue;
                    String site = this.getSiteFromUrl(url);
                    String urlRow = OTHER_WEB_PAGE_ROW.replace(WEBURL, url);
                    urlRow = urlRow.replace(SITE, site);
                    sb.append(urlRow);
                    sb.append('\n');
                }
                otherWebPages = sb.toString();
            } else {
                otherWebPages = "None";
            }
            htmlText = htmlText.replace(OTHERWEBPAGE, otherWebPages);
            htmlText = htmlText.replace(TITLE, SpdxLicenseTemplateHelper.escapeHTML(this.license.getName()));
            htmlText = htmlText.replace(HEADER, SpdxLicenseTemplateHelper.escapeHTML(this.license.getStandardLicenseHeader()));
            stream = new FileOutputStream(htmlFile);
            writer = new OutputStreamWriter((OutputStream)stream, "UTF-8");
            writer.write(htmlText);
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        finally {
            if (writer != null) {
                writer.close();
            }
            if (stream != null) {
                stream.close();
            }
        }
    }

    private String formatTemplateText(String licenseTemplate) throws LicenseTemplateRuleException {
        return SpdxLicenseTemplateHelper.templateTextToHtml(licenseTemplate);
    }

    private String getSiteFromUrl(String url) {
        Matcher matcher = SITE_PATTERN.matcher(url);
        if (matcher.find()) {
            // empty if block
        }
        return url;
    }
}

