/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.rdfparser;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import org.apache.commons.lang3.StringEscapeUtils;
import org.spdx.rdfparser.SPDXStandardLicense;

public class LicenseTOCHTMLFile {
    static final String TABLE_ROW = "[TABLEROW]";
    static final String REFERENCE = "[REFERENCE]";
    static final String REFNUMBER = "[REFERENCE_NUMBER]";
    static final String LICENSEID = "[LICENSEID]";
    static final String LICENSE_NAME = "[LICENSE_NAME]";
    static final String OSI_APPROVED = "[OSI_APPROVED]";
    static final String VERSION_STRING = "[VERSION]";
    static final String ROW_TEMPLATE = "    <tr>\n      <td><a href=\"[REFERENCE]\" rel=\"rdf:_[REFERENCE_NUMBER]\">[LICENSE_NAME]</a></td>\n      <td about=\"[REFERENCE]\" typeof=\"spdx:License\">\n      <code property=\"spdx:licenseId\">[LICENSEID]</code></td>\n      <td align=\"center\">[OSI_APPROVED]</td>\n      <td><a href=\"[REFERENCE]#licenseText\">License Text</a></td>\n    </tr>\n";
    ArrayList<String> tableRows = new ArrayList();
    private int currentRefNumber = 1;
    String template;
    String version;
    String releaseDate;

    private String generateVersionString(String version, String releaseDate) {
        if (version == null || version.trim().isEmpty()) {
            return "";
        }
        String retval = "<p>SPDX License List version <code property=\"spdx:licenseListVersion\">" + version.trim() + "</code>";
        if (releaseDate != null && !releaseDate.trim().isEmpty()) {
            retval = retval + ", which was released on " + releaseDate.trim();
        }
        retval = retval + ". </p>";
        return retval;
    }

    public LicenseTOCHTMLFile(String template, String version, String releaseDate) {
        this.template = template;
        this.version = version;
        this.releaseDate = releaseDate;
    }

    public void addLicense(SPDXStandardLicense license, String licHTMLReference) {
        String newRow = ROW_TEMPLATE.replace(REFERENCE, licHTMLReference);
        ++this.currentRefNumber;
        newRow = newRow.replace(REFNUMBER, String.valueOf(this.currentRefNumber));
        newRow = newRow.replace(LICENSE_NAME, this.escapeHTML(license.getName()));
        newRow = newRow.replace(LICENSEID, this.escapeHTML(license.getId()));
        newRow = license.isOsiApproved() ? newRow.replace(OSI_APPROVED, "Y") : newRow.replace(OSI_APPROVED, "");
        this.tableRows.add(newRow);
    }

    private String escapeHTML(String s) {
        return StringEscapeUtils.escapeHtml4((String)s);
    }

    public void writeToFile(File htmlFile) throws IOException {
        FileOutputStream stream = null;
        OutputStreamWriter writer = null;
        if (!htmlFile.exists() && !htmlFile.createNewFile()) {
            throw new IOException("Can not create new file " + htmlFile.getName());
        }
        try {
            stream = new FileOutputStream(htmlFile);
            writer = new OutputStreamWriter((OutputStream)stream, "UTF-8");
            int rowLocation = this.template.indexOf(TABLE_ROW);
            String firstPart = this.template.substring(0, rowLocation);
            firstPart = firstPart.replace(VERSION_STRING, this.generateVersionString(this.version, this.releaseDate));
            String lastPart = this.template.substring(rowLocation + TABLE_ROW.length());
            writer.write(firstPart);
            for (int i = 0; i < this.tableRows.size(); ++i) {
                writer.write(this.tableRows.get(i));
            }
            writer.write(lastPart);
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        finally {
            if (writer != null) {
                writer.close();
            }
            if (stream != null) {
                stream.close();
            }
        }
    }
}

